<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS LCR Carrier Class
 * @author Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('object');
safe_require_class('hardware');
safe_module_require_class('fs', 'application');
safe_module_require_class('fs', 'lcr_rate');
class Fs_lcr_carrier_class extends Safe_configurable_object_class
{
    private $_the_app;
    private $_sip_trunks = null;
    private $_distributor_lists = null; //Load Balancing list
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }
    public function configure()
    {
        $this->add_enum_field('enabled', 'Enabled', 'dropdown', '1', array(
            '1' => 'Enabled',
            '2' => 'Disabled'
        ));
        $this->set_field_help('enabled', 'Enable/Disable Carrier from being used for Least Cost Routing.');
        
        $enum_none = array('none' => '(Please Select one)');
        $names = array();
        //check which trunk already bind to carrier

        $names = array_merge($this->sip_trunks() , $this->distributor_lists()) ;
        if($names == null){
            $names = $enum_none;
        }
        
        // SIP trunk section
        $this->add_enum_field('binding_name', 'SIP Trunk/Load Balancing List', 'dropdown', '', $names);
        $this->set_field_help('binding_name', array(
                'Select a SIP Trunk or Load Balancing list to bind to this Least Cost Routing.',
                'Selecting None to not bind to any.'));
        $this->set_field_rules('binding_name', 'callback_check_binding_name[binding_name]');
        // Register aggregate objects
        $this->register_aggregate_object('rate', 
            array(
                'name' => 'Carrier Rates File',
                'dynamic' => true,
                /* Add some extra infos for config_manager create object */
                'controller' => array(
                        'config_manager' => array(
                                'summary_buttons' => 'edit[Edit]|download[Download]|Delete:confirm',
                                'allow_create_button' => 'upload[Upload]'
                        ),
                ),
                'autoname' => true,
                'popup_add_form' => true,
                'file_def' => array(
                    'file_type' => 'csv',
                ),
                'methods' => array(
                        'upload' => array(
                                'name' => 'Upload',
                                'description' => 'Upload a rates file',
                                'request' => 'POST',
                        ),
                        'download' => array(
                                'name' => 'Download',
                                'description' => 'Download a rates file',
                                'request' => 'GET',
                        ),
                        'delete' => array(
                                'name' => 'Delete',
                                'description' => 'Delete a rates file',
                                'request' => 'POST',
                        ),
                ),
            )
        );
        return parent::configure();
    }
    public function check_binding_name($field_name){
        $data_value = $this->get_data_value($field_name,false);
        if($data_value !== 'none'){
            //check if used by other carrier
            $this->_the_app = $this->_node->software()->application();
            $carriers = $this->_the_app->carrier_profiles();
            foreach($carriers as $item){
                if($item->name() == $this->name()) continue;
                if($item->get_data_value($field_name,false) == $data_value){
                    return array('check_binding_name' => $this->get_data_value($field_name) . ' is bound to '. $item->name());
                }
            }
        }else{
            return array('check_binding_name' => $this->get_data_label($field_name) . ' is required.');
        }
        return true;
    }
    
    /**
     * Pulls out all trunk profiles from db
     */
    public function sip_trunks() {
        $trunks = array();
        if ($this->_sip_trunks == null) {
            $module = $this->_node->software()->application()->find_module_by_name('sip');
            $this->_sip_trunks = $module->trunks();
            foreach ( $this->_sip_trunks as $obj ) {
                $trunks ['sip/trunk/' . $obj->name()] = $module->description() . ' -- ' . $obj->name();
            }
        }
        return $trunks;
    }
    /**
     * Pulls out all Load Balancing list from db
     */
    public function distributor_lists() {
        $lists = array();
        if ($this->_distributor_lists == null) {
            $module = $this->_node->software()->application()->find_module_by_name('distributor');
            if ($obj_types = $module->has_aggregate_objects()) {
                $this->_distributor_lists = $module->lists();
                foreach($obj_types as $type => $data) {
                    if($data['configurable']){
                        foreach($module->get_aggregate_objects($type) as $obj) {
                            $lists ['distributor/' . $type . '/' . $obj->name()] = $module->description() . ' -- ' . $obj->name();
                        }    
                    }
                }
            }
        }
        return $lists;
    }
    /**
     * Returns carrier rate profiles in an array
     */
    public function carrier_rate()
    {
        return $this->get_aggregate_objects('rate');
    }
    public function carrier_trunk()
    {
        $this->_trunks = $this->get_aggregate_objects('trunk');
        return $this->_trunks;
    }
    public function can_dispose($carrier_name)
    {
        return true;
    }
    public function dispose()
    {
        //remove the sub obj rates and csv files
        foreach($this->rates() as $rate){
            $rate->dispose();
        }
        $conf = $this->node()->configuration_manager()->directory('configuration');
        $conf = $conf . '/ui-store' . $this->path()  . "/{$this->name()}";
        //delete carrier obj directory
        $os = $this->node()->os();
        $rc = $os->rmdir($conf);
        return parent::dispose();
    }
    public function rates(){
        return $this->get_aggregate_objects('rate');
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_create_rate($name=null, $data = null, &$output = null){
        return $this->api_upload_rate($name, $data, $output);
    }
    public function api_upload_rate($name=null, $data = null, &$output = null){
        $rate = new Fs_lcr_rate_class($this->node(), $this->object_name().'/rate', $name, $this);
        $rate->configure();
        if($data) {
            $rate->set_data_values($data);
        }
        return $rate;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_download_rate($name, $data=null) {
        $rate = $this->api_retrieve_rate($name, $data);
        return $rate->download();
    }
    public function api_retrieve_rate($name, $data=null) {
        return $this->get_aggregate_object('rate', $name);
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_update_rate($name, $data=null, &$output = null) {
        $rate = $this->api_retrieve_rate($name);
        if($rate) {
            if ($rate->validate($data,$output)) {
                if (true == $rate->save()) {
                    return true;
                }
            }
        }
        return false;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_delete_rate($name, $data=null, &$output = null) {
        $rate = $this->api_retrieve_rate($name);
        if($rate) {
            if($rate->can_dispose($output)) {
                return $rate->dispose();
            }
        }
        return false;
    }
    public function new_fields(&$config_manager, $type)
    {
        $config_manager->add_upload_field('ratefile','Rates File','upload','',30,true);
        $config_manager->set_field_rules('ratefile','required');
        $config_manager->add_field('save', 'Save', 'hidden', 'save', 10);
    }
}
?>
