<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

require_once("../../gui/Webconfig.inc.php");
require_once("../../gui/Charts.inc.php");
require_once("../../api/File.class.php");
require_once("../../api/ShellExec.class.php");
require_once(GlobalGetLanguageTemplate(__FILE__));
require_once("../include/SngProduct.class.php");

///////////////////////////////////////////////////////////////////////////////
//
// Variables
//
///////////////////////////////////////////////////////////////////////////////
$new_eth = false;
$new_tdm = false;
$display_eth = false;
$display_tdm = false;
$stop_eth = false;
$stop_tdm = false;
$no_warn = false;
$fail_eth = false;
$fail_tdm = false;
$data = date('Y-m-d-H:m');

///////////////////////////////////////////////////////////////////////////////
//
// Main
//
///////////////////////////////////////////////////////////////////////////////
WebAuthenticate();


find_procs($process, $tdm_process);

if ($_POST['stop_eth_capture']) {
	//Stop the tcpdump service
	shell_exec ('sudo /bin/kill ' . $process);
	sleep(2);
	if (trim($process) != "")
    	shell_exec('sudo /bin/kill -9 tcpdump');

	find_procs($process,$tdm_process);
	$stop_eth = true;
}
elseif ($_POST['stop_tdm_capture']) {
	//Stop Wanpipemon service
	shell_exec ('sudo /bin/kill -2 ' . $tdm_process);
	sleep(2);
	if (trim($tdm_process) != "")
		shell_exec('sudo /bin/kill -9 wanpipemon');
	
	find_procs($process,$tdm_process);
	$stop_tdm = true;
}
elseif ($_POST['stop_both_capture']) {
	//Stop the tcpdump service
	$stop_eth=true;
	shell_exec ('sudo /bin/kill ' . $process);
	sleep(2);
	if (trim($process) != "")
    	shell_exec('sudo /bin/kill -9 ' . $process);

	//Stop wanpipemon service
	$stop_tdm = true;
	shell_exec ('sudo /bin/kill -2 ' . $tdm_process);
	sleep(2);
	if (trim($tdm_process) != "")
		shell_exec('sudo /bin/kill -9 ' . $tdm_process);
	
	find_procs($process, $tdm_process);
	$stop_all = true;
	//Merge PCAPs
	//shell_exec ('sudo /usr/sbin/mergecap -a /tmp/prot-capture.pcap /tmp/prot-tdm-capture.pcap -w prot-merge-capture.pcap');

}
elseif ($_POST['capture-eth']) {
  //Validate filter field for illegal characters
	if (validate('eth') ) {
    //Check if interface running
    if ($_POST['interface'] != "any")
  		system ('sudo /sbin/ifconfig ' . $_POST['interface'] . ' | grep RUNNING >> /dev/null', $retCode);
    else
      $retCode=0;

		if ($retCode == 0) {
			$display_eth=true;
			$new_eth = true;
      shell_exec ("sudo /bin/rm -fr /tmp/prot-capture.pcap");
      //add option -B to increase the buffer size to 4MB
      $cmd = "nice sudo /usr/sbin/tcpdump -B 4096 -w /tmp/prot-capture.pcap -s 0 -ni ".$_POST['interface'];

			if ($_POST['filter'] == ".*" || $_POST['filter'] == "")
				$cmd .= " >> /dev/null &";
			else 
				$cmd .= " " . urldecode($_POST['filter']) . " >> /dev/null &";

      passthru ($cmd, $retCode);
			sleep(4);
		}
		else
			$fail_eth = true;
		
		find_procs($process,$tdm_process);
	}
}
elseif ($_POST['capture-tdm']) {
	//Validate filter field for illegal characters
	if (validate('tdm') ) {
		//Check if interface running
		system ('sudo /sbin/ifconfig ' . $_POST['interface'] . ' | grep RUNNING >> /dev/null', $retCode);
		
		if ($retCode == 0) {
			$display_tdm=true;
			$new_tdm = true;
			shell_exec ("sudo /bin/rm -fr /tmp/prot-tdm-capture.pcap");
			
			$cmd = "nice sudo /usr/sbin/wanpipemon -i " . $_POST['interface'] . " -pcap -pcap_file /tmp/prot-tdm-capture.pcap -prot MTP2" ;
			
			if ($_POST['msu'])
				$cmd.= " -mtp2-msu";

			$cmd.= "  -full -systime -noexit";
			
			if ($_POST['transmit'] == 'tx')
				$cmd.= " -tx";
			if ($_POST['transmit'] == 'rx')
				$cmd.= " -rx";
			if ($_POST['diff'])
				$cmd.= " -diff";

      if ($_POST['raw'])
        $cmd .= ' -c tr >> /dev/null &';
      else
  			$cmd.= " -c trd >> /dev/null &";		
  
			passthru ($cmd, $retCode);
	
			sleep(5);
		}
		else
			$fail_tdm = true;
			
		find_procs($process,$tdm_process);
	}
}
elseif ($_POST['download_eth']) {
	$stop_eth = true;
	$filename = '/tmp/prot-capture.pcap';
	shell_exec ("sudo cp /tmp/prot-capture.pcap .");
	header("Content-Disposition: attachment; filename=\"".basename("prot-capture.pcap")."\";" );
	header("Content-Transfer-Encoding: binary");
	header("Content-Length: ".filesize("prot-capture.pcap"));
	readfile("prot-capture.pcap");	
	
	shell_exec ("sudo rm -fr prot-capture.pcap");	
}
elseif ($_POST['download_tdm']) {
	$stop_tdm = true;
	$filename = '/tmp/prot-tdm-capture.pcap';
	shell_exec ("sudo cp /tmp/prot-tdm-capture.pcap .");
	header("Content-Disposition: attachment; filename=\"".basename("prot-tdm-capture.pcap")."\";" );
	header("Content-Transfer-Encoding: binary");
	header("Content-Length: ".filesize("prot-tdm-capture.pcap"));
	readfile("prot-tdm-capture.pcap");	
	
	shell_exec ("sudo rm -fr prot-tdm-capture.pcap");	
}
elseif ($_POST['download_merge']) {
	$stop_tdm = true;
	$stop_eth = true;
	$filename = '/tmp/prot-capture.tgz';
	//create archive
	shell_exec ('sudo /bin/tar czf /tmp/prot-capture.tgz /tmp/prot-capture.pcap /tmp/prot-tdm-capture.pcap');
	shell_exec ("sudo cp /tmp/prot-capture.tgz .");
	header("Content-Disposition: attachment; filename=\"".basename("prot-capture.tgz")."\";" );
	header("Content-Transfer-Encoding: binary");
	header("Content-Length: ".filesize("prot-capture.tgz"));
	readfile("prot-capture.tgz");	
	
	shell_exec ("sudo rm -fr prot-capture.tgz");	
}

WebHeader(WEB_LANG_PAGE_TITLE);
WebDialogIntro(WEB_LANG_PAGE_TITLE, "/images/icon-diskusage.png", WEB_LANG_PAGE_INTRO);

/*print_r ($_POST);
echo "<br />";
echo "TCPDUMP Process = " . $process . "<br />";
echo "TDM Process = " . $tdm_process . "<br />";*/

unset($tdm);
unset($eth);
unset($all);

if ((trim($process) != "" && $new_eth) || (trim($tdm_process) != "" && $new_tdm)){
	if ($display_eth || $display_tdm) {
		if ($display_eth && $new_eth)
			$eth = '<li>To stop the Ethernet capture, please click <input type="submit" name="stop_eth_capture" value="Stop" class="ui-state-default ui-corner-all" /></li>';
		
		if ($display_tdm && $new_tdm)
			$tdm = '<li>To stop the TDM capture, please click <input type="submit" name="stop_tdm_capture" value="Stop" class="ui-state-default ui-corner-all" /></li>';
		
		if (trim($process) != "" && trim($tdm_process) != "") {
			$all = '<li>To stop both captures, please click <input type="submit" name="stop_both_capture" value="Stop All Captures" class="ui-state-default ui-corner-all" /></li>';
			$no_warn = true;
		}
		echo "<form method='post'>";
		WebDialogInfo('<ul>
						<li>Protocol Capture started. </li>'.
						$eth.
						$tdm.
						$all.
					   '</ul>');	
		echo "</form>";
	}
}

unset($tdm);
unset($eth);
unset($all);

if ((trim($process) != "" && !$new_eth) || (trim($tdm_process) != "" && !$new_tdm)) {
	//Process currently running please stop

	if (trim($process) != "" && !$new_eth) {
		$eth = '<li>Please stop the Ethernet capture by clicking <input type="submit" name="stop_eth_capture" value="Stop" class="ui-state-default ui-corner-all" /></li>';
		$display_eth=true;
	}
	if (trim($tdm_process) != "" && !$new_tdm) {
		$tdm = '<li>Please stop the TDM capture by clicking <input type="submit" name="stop_tdm_capture" value="Stop" class="ui-state-default ui-corner-all" /></li>';
		$display_tdm=true;
	}
	
	if (trim($process) != "" && trim($tdm_process) != "" && !$no_warn) {
		$all = '<li>To stop the TDM and Ethernet captures, click <input type="submit" name="stop_both_capture" value="Stop All Captures" class="ui-state-default ui-corner-all" /></li>';
		$display_tdm=true;
		$display_eth = true;
	}
	echo "<form method='post'>";
	WebDialogWarning('<ul>
						<li>There is already a protocol capture running.</li>'.
						$eth .
						$tdm .
						$all . 
					  '</ul>');
	echo "</form>";
}

if ($fail_eth || $fail_tdm) {
  if ($_POST['interface'] == "any")
    $int = "All Interfaces";
  else
    $int = $_POST['interface'];

	if ($fail_eth) {
    if ($_POST['interface'] == "any")
      $eth_error = "<li>Unable to start protocol capture on <b>ALL</b> Ethernet Devices</li>";
    else
      $eth_error = "<li>Unable to start protocol capture on Ethernet Device <b>" . $int . "</b></li>";
  }
	if ($fail_tdm)
		$tdm_error = "<li>Unable to start protocol capture on TDM Device <b>" . $int . "</b></li>";
		
	WebDialogWarning('<ul>'.
						$eth_error .
						$tdm_error .
						'<li>Device is not currently running</li>'.
					  '</ul>');
}

unset($tdm);
unset($eth);
unset($all);

if ($stop_eth || $stop_tdm || $stop_all) {
	if ($stop_eth) {
		$eth = '<li>To download the Ethernet capture, please click <input type="submit" name="download_eth" value="Download" class="ui-state-default ui-corner-all" /></li>';
		$display_eth = false;
	}
	if ($stop_tdm) {
		$tdm = '<li>To download the TDM capture, please click <input type="submit" name="download_tdm" value="Download" class="ui-state-default ui-corner-all" /></li>';
		$display_tdm = false;
	}
	if ($stop_all) {
		$display_tdm = false;
		$display_eth = false;
		$all = '<li>To download both Ethernet and TDM captures, please click <input type="submit" name="download_merge" value="Download" class="ui-state-default ui-corner-all" /></li>';
	}
	
	echo "<form method='post'>";
	WebDialogInfo('	<ul>
						<li>Protocol Capture stopped successfully.</li>'.
						$eth.
						$tdm.
						$all.
					'</ul>');
	echo "</form>";					
}
capture_info($display_eth);
//capture_wanpipe_info($display_tdm);
WebFooter();	
///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

function capture_info($stop = false) {
	
	$pick = get_last_entry();
	
	echo "<form method='post' enctype='application/x-www-form-urlencoded'>";
	
	WebFormOpen($_SERVER['PHP_SELF']);
	WebTableOpen('Network Packet Capture Parameters');
	echo "<tr>";
	echo "<td width='37%' class='mytablesubheader'>Network Interface</td>";
	echo "<td>";
	
	//Ethernet Interface Drop Down
	$interfaces = get_interfaces();
	
  echo "<select name='interface' id='interface'>";
  echo "<option value='any'>All Interfaces</option>";
	if (!empty($interfaces)) {
		foreach ($interfaces as $k=>$v) {
			echo "<option value='" . $k . "' >" . $v . "</option>";
		}
	}
	echo "</select>";
	echo "</td>";
	echo "</tr>";
	echo "<tr>";
	echo "<td width='37%' class='mytablesubheader' >Filter(s)</td>";
	echo "<td><input type='text' name='filter' value='" . $pick['filter'] . "' /></td>";
	echo "<td></td>";
	echo "</tr>";
	echo "<tr>";
	echo "<td width='37%' class='mytablesubheader'></td>";
	if (!$stop)
		echo "<td><input type='submit' name='capture-eth' value='Capture' class='ui-state-default ui-corner-all' /></td>";
	else
		echo "<td><input type='submit' name='capture-eth' value='Capture' class='ui-state-default ui-corner-all' style=\"color:#C0C0C0\" disabled='disabled' /></td>";
	echo "</tr>";		
	WebTableClose();
	WebFormClose();
	
	echo "</form>";
}

function capture_wanpipe_info($stop = false) {
	
	$pick = get_last_entry();
	exec ("/usr/sbin/wanrouter status | grep -c wanpipe", $output);
	
	if ($output[0] == 0)
		$wanpipe=false;
	else
		$wanpipe=true;
	
	echo "<form method='post'>";
	
	WebFormOpen($_SERVER['PHP_SELF']);
  WebTableOpen('TDM Packet Capture Parameters');
	if ($wanpipe) {
		echo "<tr>";
		echo "<td width='37%' class='mytablesubheader'>TDM Interface</td>";
		echo "<td>";
		
		//Ethernet Interface Drop Down
		$interfaces = get_wanpipe_interfaces();
		
		echo "<select name='interface' id='interface'>";
		if (!empty($interfaces)) {
			foreach ($interfaces as $k=>$v) {
				echo "<option value='" . $k . "' >" . $v . "</option>";
			}
		}
		echo "</select>";
		echo "</td>";
		echo "</tr>";
		echo "<tr>";
		echo "<td width='37%' class='mytablesubheader' >Filter(s)</td>";
		echo "<td>";
		echo "<table>";
		echo "<tr>";
		echo "<td rowspan='2'>";
		echo "<input type='radio' name='transmit' value='tx' />TX Only<br />";
		echo "<input type='radio' name='transmit' value='rx' />RX Only<br />";
		echo "</td>";
		echo "<td>";
		echo "<input type='checkbox' name='diff' />Only capture different frames<br />";
		echo "<input type='checkbox' name='msu' />Capture only SS7 MSU's<br />";
    echo "<input type='checkbox' name='raw' />Capture RAW Trace<br />";
    echo "</td>";
		echo "</tr>";
		echo "</table>";
		echo "<td></td>";
		echo "</tr>";
		echo "<tr>";
		echo "<td width='37%' class='mytablesubheader'></td>";
		if (!$stop)
			echo "<td><input type='submit' name='capture-tdm' value='Capture' class='ui-state-default ui-corner-all' /></td>";
		else
			echo "<td><input type='submit' name='capture-tdm' value='Capture' class='ui-state-default ui-corner-all' style=\"color:#C0C0C0\" disabled='disabled' /></td>";
		echo "</tr>";	
	}
	elseif (!$wanpipe) {
		echo "<tr>";
		echo "<td><b><font color='red'>THERE ARE CURRENTLY NO TDM DEVICES RUNNING. PLEASE START THE GATEWAY TO RUN A TDM CAPTURE</font></b></td>";
		echo "</tr>";
	}
	WebTableClose();
	WebFormClose();
	
	echo "</form>";
}



/**
Returns an array of ethernet interfaces
*/
function get_interfaces() {
	
	$cmd = "sudo /sbin/ifconfig -a | grep 'eth\|sngdsp' | cut -d: -f1 | awk '{ print $1}'";
	exec($cmd,$result);
	
	if (!empty($result)) {
		foreach ($result as $interface) {
			$array[$interface] = $interface;
		}
		
	}
	
	return $array;
}

function get_wanpipe_interfaces() {
	$cmd = "sudo /sbin/ifconfig -a | grep w.g. | cut -d: -f1 | awk '{ print $1}'";
	exec ($cmd,$result);
	
	if (!empty($result)) {
		foreach ($result as $interface) {
			$array[$interface] = $interface;
		}
	}
	
	return $array;
}

function get_last_entry() {
	if ($_POST['filter'] != "")
		$pick['filter'] = $_POST['filter'];
	elseif ($_POST['filter'] == "")
		$pick['filter'] = ".*";
		
	return $pick;
}

function validate($type) {
  if ($type == "any")
    return true;
  elseif ($type == "eth") {
		if ($_POST['filter'] == ".*") {
			return true;
		}
		else {
      //return !preg_match('/[^A-Za-z0-9.#\\-$]/', $_POST['filter']);
      return true;
		}
	}
	if ($type == "tdm") {
		return true;
	}
}

function find_procs(&$process = null, &$tdm_process = null) {
	passthru('pidof tcpdump > /tmp/eth-proc.txt');	
	$process = file_get_contents('/tmp/eth-proc.txt');
	shell_exec ('rm -fr /tmp/eth-proc.txt');
	passthru ('pidof wanpipemon > /tmp/tdm-proc.txt');
	$tdm_process = file_get_contents('/tmp/tdm-proc.txt');
	shell_exec ('rm -fr /tmp/tdm-proc.txt');
}
