<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * Network Config wrapper page
 * @author William Adam <william.adam@sangoma.com>
 *         
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
safe_require_controller('sng','data_manager');
class Sng_log_manager extends Sng_data_manager
{
    public function __construct()
    {
        parent::__construct();
    }
    public function index()
    {
        return $this->logs();
    }
    public function logs()
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Application Logs';
        $data['page_summary'] = 'This page displays Application Log.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-backup-settings.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-backup-settings.png';
        $data['tabs'] = array();
        // Create tab for each log entry with content
        foreach ($this->_services as $service) {
            $data_cfg = $service->get_data_settings();
            if (isset($data_cfg['log'])) {
                // Get content
                $log_content = $this->_data_get($service->name() , 'log');
                $data['tabs'][] = array(
                    'title' => $service->description() ,
                    'mode' => 'table',
                    'content' => $log_content['data'],
                );
            }
        }
        // Display views
        $this->load->view("safe_header", $data);
        $this->load->view("safe_hide_menu");
        $this->load->view("safe_notifications", $data);
        $this->load->view("safe_tabs", $data);
        $this->load->view("safe_footer", $data);
    }
    public function json_get($module_name, $data_name)
    {
        // verify if logged
        //safe_authenticate ();
        echo json_encode($this->_data_get($module_name, $data_name));
    }
    private function _data_get($module_name, $data_name, $max = 1000)
    {
        // Figure out module and log key
        $rc = FALSE;
        $module = NULL;
        $output = array();
        // Get back the module
        $module = $this->_the_app->find_module_by_name($module_name);
        $data_cfg = $module->get_data_settings();
        if (isset($data_cfg[$data_name])) {
            // Get data file by key
            $files = $module->get_data_files($data_name);
            $keys = array_keys($files);
            $file = $keys[0];
            $content =
                htmlentities($module->get_data_file_content_by_key($data_name,
                            $file, $max));

            // explode content
            $output = explode('\n', $content);
            $rc = TRUE;
        }
        return array(
            'module' => $module_name,
            'key' => $data_name,
            'rc' => $rc,
            'data' => $output
        );
    }
    public function rotate($module_name, $data_name)
    {
        // Set the basic data
        $data['page_title'] = 'Application Data Manager';
        $data['page_summary'] = 'This page allows managing Application Data.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-backup-settings.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-backup-settings.png';
        $module = NULL;
        // Get back the module
        $module = $this->_the_app->find_module_by_name($module_name);
        $data_cfg = $module->get_data_settings();
        $data_cfg = $data_cfg[$data_name];
        // Prepare back url
        $post = $this->input->post();
        $back_url = $this->input->get_post('back_url');
        if (!$back_url) $back_url = '/SAFe/' . $this->router->fetch_class() . '/manage/' . $module_name . '/' . $data_name;
        if ($module->data_rotate($data_name)) safe_redirect($back_url);
        // Display error
        $data['notif_error'][] = 'Fail to rotate ' . $module->description() . ' ' . $data_cfg['description'] . safe_form_with_submit_button('', $back_url, 'Back', 'back', 'get', 'float:left;');
        // Display views
        $this->load->view("safe_header", $data);
        $this->load->view("safe_notifications", $data);
        $this->load->view("safe_footer", $data);
    }
}
