<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * SNG misc debug facilities
 *
 * @author William Adam
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('table');
safe_require_class('crud_table');
safe_require_class('form');
class Sng_debug extends Safe_CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if(!file_exists("/usr/local/sng/conf/sng_dev_env")){
            show_404();
        }
    }
    /**
     * @brief Display object data base
     *         
     * @return
     */
    public function db()
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'DEBUG - Object DB';
        $data['page_summary'] = 'DEBUG - Object DB';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        // Populate generation result table
        $data['table_title'] = 'Objects';
        $table = new Safe_crud_table_class();
        $table->set_headings(array(
            'Id',
            'Path',
            'Class',
            'Status',
            ''
        ));
        $table->set_controller_url('/SAFe/' . $this->router->fetch_class());
        $table->set_url_suffix('db');
        $ser = Safe_object_serializer_class::get_serializer();
        $objects = $ser->get_objects();
        foreach ($objects as $obj) {
            $id = $obj['id'];
            unset($obj['data']);
            unset($obj['data_ref']);
            $obj['path'] .= '/' . $obj['name'];
            unset($obj['name']);
            unset($obj['type']);
            unset($obj['modified']);
            unset($obj['modified_date']);
            $table->add_row(array_values($obj) , $id, 'View|Delete', 'obj');
        }
        $table->allow_create(false);
        $data['table'] = $table->generate();
        $data['table_container_class'] = 'safe_datatable';
        $data['table_display_length'] = 50;
        $this->load->view("safe_header", $data);
        $this->load->view("safe_hide_menu");
        $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    public function delete_db($id)
    {
        $ser = Safe_object_serializer_class::get_serializer();
        $ser->remove_object($id);
        Safe_redirect('/SAFe/' . $this->router->fetch_class().'/db');
    }

    public function view_db($id)
    {
        // verify if logged
        //safe_authenticate ();
        if (!isset($id)) exit('Record ID required !');
        // Set the basic data
        $data['page_title'] = 'DEBUG - Object DB';
        $data['page_summary'] = 'DEBUG - Object DB';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        // Retrieve record
        $ser = Safe_object_serializer_class::get_serializer();
        $object = $ser->get_object($id);
        // Populate generation object info table
        $data['table_title'] = 'Object';
        $table = new Safe_table_class();
        $table->apply_data_formatter = false;
        $table->data = array();
        foreach ($object as $k => $v) {
            if ($k == 'data') continue;
            $table->data[] = array(
                $k,
                $v
            );
        }
        $data['table'] = $table->generate();
        // Populate data table
        $obj_data['table_title'] = 'Data';
        unset($table);
        $table = new Safe_table_class();
        $table->apply_data_formatter = false;
        // Decode data to array
        foreach (json_decode($object['data']) as $k => $v) {
            $table->data[] = array(
                $k,
                '<pre>' . htmlspecialchars(print_r($v, true)) . '</pre>'
            );
        }
        $obj_data['table'] = $table->generate();
        $this->load->view("safe_header", $data);
        $this->load->view("safe_hide_menu");
        $this->load->view("safe_table", $data);
        $this->load->view("safe_table", $obj_data);
        $this->load->view("safe_footer", $data);
    }
    public function session()
    {
        $this->load->view("safe_header", $data);
        $this->load->view("safe_hide_menu");
        $data['table_title'] = '_SESSION';
        $table = new Safe_table_class();
        $table->apply_data_formatter = false;
        $table->data = array();
        foreach ($_SESSION as $k => $v) {
            if ($k == 'data') continue;
            if(is_array($v)){
                $table->data[] = array(
                    $k,
                    '<pre>' . htmlspecialchars(print_r($v, true)) . '</pre>'
                );
            }else{
                $table->data[] = array(
                    $k,
                    '<pre>' . htmlspecialchars($v) . '</pre>'
                );
            }
        }
        $data['table'] = $table->generate();
        $this->load->view("safe_table", $data);

        $data['table_title'] = '_SERVER';
        $table = new Safe_table_class();
        $table->apply_data_formatter = false;
        $table->data = array();
        foreach ($_SERVER as $k => $v) {
            if ($k == 'data') continue;
            $table->data[] = array(
                $k,
                '<pre>' . htmlspecialchars($v) . '</pre>'
            );
        }
        $data['table'] = $table->generate();
        $this->load->view("safe_table", $data);

        $data['table_title'] = '_ENV';
        $table = new Safe_table_class();
        $table->apply_data_formatter = false;
        $table->data = array();
        foreach ($_ENV as $k => $v) {
            if ($k == 'data') continue;
            $table->data[] = array(
                $k,
                '<pre>' . htmlspecialchars($v) . '</pre>'
            );
        }
        $data['table'] = $table->generate();

        $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    public function info()
    {
        phpinfo();
    }
}
/* End of file sng_debug.php */
