<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * CodeMirror test page
 *
 * @author William Adam
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('table');
safe_require_class('crud_table');
safe_require_class('form');
class Sng_config_manager_param_class extends Safe_configurable_object_class
{
    private $_name;
    private $_obj_def;
    private $_module;
    private $_type;
    public  $error = false;
    public  $error_message = '';
    public function __construct($module,$type)
    {
        parent::__construct('autofill', 'Sng_config_manager_param_class');
        $this->_obj_def = $module->get_aggregate_object_definition($type);
        $this->_module = $module;
        $this->_type = $type;
    }
    public function configure()
    {
        $this->_module->new_fields($this, $this->_type);
        parent::configure();
        // No synch
        //$this->synch();
    }
}
class Sng_config_manager extends Safe_CI_Controller
{
    // Inidicate if back is allowed when editing/modifying module
    // Can be override by extended class to prevent foing back to list of module
    // using back
    protected $allow_back = true;
    // Indicate if we want to display aggregate child object
    // Useful when something in configuration disable some child being relevant
    // TODO: extend to selectively display/hide some agg_obj type
    protected $display_aggregate_object = true;
    protected $hide_aggregate_object_list = array();
    protected $edit_hide_menu = false;
    protected $modify_hide_menu = false;
    // Custom object type view
    //  List views to use for an object on a specific method
    //  Format:
    //    ['obj_type]['method'] = 'view_name'
    //    method can be: modify, edit
    //
    //  This takes precedence on custom view defined in object definition (if 
    //  any)
    protected $aggregate_object_view = array();
    
    //public $_the_product;
    public $_the_app;
    public $_services;
    public $_cfg_mgr;
    private  $_validation_obj;
    public function __construct()
    {
        parent::__construct();
        //$this->_the_product = Safe_get_product();
        $this->_the_app = $this->_the_product->local_node()->software()->application();
        $this->_services = $this->_the_product->local_node()->software()->services();
        $this->_cfg_mgr = $this->_the_product->local_node()->configuration_manager();
    }
    public function index()
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Configuration Manager';
        $data['page_summary'] = 'This page allows managing System configuration.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        
        // cfg checklist done
        $_checklist = array();
        $this->_the_product->local_node()->checklist($_checklist, false);
        if($_checklist){
            // No, redirect to control panel
            Safe_redirect('/SAFe/sng_control_panel');
        } 
        $configuration_module = $this->_the_app;
        // Check if configuration need to be regenerated
        $modified_list = array();
        $output = array();
        $param['call_from'] = 'view_controller';
        $result = $configuration_module->api_status_configuration(null, $param, $output);
        if($result['modified'] == true){
            if (Safe_service_class::STATUS_RUNNING == $configuration_module->status()){
                //system running
                $data['notif_error'][] = safe_form_with_submit_button('<b>Configuration is out of date and system is running.</b></br></br>' . 'You can apply new configuration and restart system using ', '/SAFe/sng_config_manager/generate/true', // TODO(wadam) - Need to get this url from application
                        'Apply & Restart');
                $modified_list = $result['reloadable'];
                if(is_array($modified_list)){
                    $data['table_size'] = '100%';
                    $table = new Safe_crud_table_class();
                    $data['table_title'] = $table->set_title('Reloadable objects');
                    // Prepare heading
                    $table->set_headings(array(
                            'Module',
                            'Type',
                            'Object(s)',
                    ));
                    $table->set_controller_url('/SAFe/' . $this->router->fetch_class());
                    foreach($modified_list as $mod_name => $value){
                        foreach($value as $type_name => $obj_list){
                            $objs = '';
                            foreach($obj_list as $obj_name => $obj_status){
                                if($objs != ''){
                                    $objs.='<br/>';
                                }
                                $objs .= '(' . $obj_status . ') ';
                                $objs .= $obj_name;
                            }
                            $table->add_row(array(
                                    $mod_name,
                                    $type_name,
                                    $objs,
                            ));
                        }
                    }
                    $table->allow_create(false);
                    $table->footer_button = array(
                            array(
                                    'url' => $this->router->fetch_class() . '/dynamic_reload',
                                    'name' => 'Apply & Reload'
                            )
                    );
                    // Generate table HTML code
                    $data['table'] = $table->generate_table();
                }
            }else{
                //system not running
                // Redirect to generate
                Safe_redirect('/SAFe/' . $this->router->fetch_class() . '/generate');
            }
            
        }else{
            // Configuration is up to date
            $data['notif_warn'][] = 'Configuration is up to date.';
        }
        $this->load->view("safe_header", $data);
        $this->load->view("safe_notifications", $data);
        if($data['table']) {
            $this->load->view("safe_table", $data);
        }
        $this->load->view("safe_footer", $data);
    }
    public function application()
    {
        // Set the basic data
        $data['page_title'] = 'Configuration Manager';
        $data['page_summary'] = 'This page allows managing application configuration.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        //Prepare table structure
        $data['table_size'] = '100%';
        $table = new Safe_crud_table_class();
        $data['table_title'] = $table->set_title('Application configuration');
        // Prepare heading
        $table->set_headings(array(
            'Name',
            'Configuration'
        ));
        // TODO(WADAM) - Figure out why adding safe prefix is required
        $table->set_controller_url('/SAFe/' . $this->router->fetch_class());
        // Check for application and services configurations
        $config = array();
        // Does application has a configuration
        if ($this->_the_app->config()) {
            $app_cfg = $this->_the_app->config();
            $config[$this->_the_app->name() ]['desc'] = $this->_the_app->description();
            $config[$this->_the_app->name() ]['cfg_desc'] = $this->_the_app->config()->description();
        }
        // Loop around services
        foreach ($this->_services as $service) {
            // Service configuration
            if ($service->config()) {
                $config[$service->name() ]['desc'] = $service->description();
                $config[$service->name() ]['cfg_desc'] = $service->config()->description();
            }
            // Check services modules
            foreach ($service->modules() as $k => $v) {
                // check if config present
                if ($v->config()) {
                    $config[$k]['desc'] = $v->description();
                    $config[$k]['cfg_desc'] = $v->config()->description();
                    if ($v->has_aggregate_objects()){
                        $config[$k]['aggregate'] = true;
                    } else {
                        $config[$k]['aggregate'] = false;
                    }
                }else if ($v->has_aggregate_objects()){
                    $config[$k]['desc'] = $v->description();
                    $config[$k]['cfg_desc'] = 'N/A';
                    $config[$k]['aggregate'] = true;
                }
            }
        }
        // Populate table with application confguration rows
        foreach ($config as $k => $v) {
            if (isset($v['aggregate'])) {
                if (!$v['aggregate']) $button_type = "edit";
                elseif ($v['aggregate']) $button_type = "modify";
            } else $button_type = "edit";
            $table->add_row(array(
                $v['desc'],
                $v['cfg_desc'],
            ) , $k, $button_type, '');
        }
        $table->allow_create(false);
        // Generate table HTML code
        $data['table'] = $table->generate_table();
        $this->load->view("safe_header", $data);
        $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Function which shows aggregated config module or service
     * @param string $cfg    
     *                        Product Name
     * @param string $sub_cfg
     *                        Service/Module Name
     */
    public function datatable_fetch($module_name, $obj_type=null, $obj_name=null, $_type=null)
    {
        $data = array();
        $data['async'] = json_decode(trim(file_get_contents('php://input')), true);

        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name($module_name);
        $base_url = $module->name();
        $_id =  $module->name();
        // Get config object
        $cfg_obj = $module->config();
        // Prepare Description
        $description = $module->description();
        $_define = $module->get_aggregate_object_definition($obj_type);
        // Check if we want to work on an object instead of module
        if($obj_type && $obj_name){
            // Locate object
            $_obj = $module->get_aggregate_object($obj_type, $obj_name);
            if($_obj){
                $description = $module->aggregate_object_name($obj_type).' - '.$obj_name;
                $module = $_obj;
                $cfg_obj = $module;
            }
            //$_type = $obj_type;
            $_id .= '_'.$obj_type.'_'.$obj_name;
        }else{
            $_type = $obj_type;
        }

        // Check for custom stuff
        $custom = array();
        $custom = $_definition['controller']['config_manager'];
        $table_heading_array = array();
        $table = new Safe_crud_table_class();
        $table->set_controller_url($this->router->fetch_class());
        $data['table_id'] = str_replace('.', '_', $_id.'_'.$_type);
        if($obj_type && $obj_name){
            $base_url = $base_url . '/' . $obj_type.'/' . $obj_name;
        }

        $this->generate_table_data($table, $data, $module, $_type, $base_url, $custom, $table_heading_array);
        unset($data['data']);
        $_data = array();
        $table->generate($_data);
        foreach($_data as $v){
            $row = array();
            foreach($v as $v1){
                $row[] = array_values($v1);
            }
            $data['data'][] = $row;
        }

        echo json_encode($data);
    }
    public function modify($module_name, $obj_type=null, $obj_name=null)
    {
        if (!isset($module_name)) exit('Service/Module and product name required');
        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name($module_name);
        $base_url = $module->name();
        // Get config object
        $cfg_obj = $module->config();
        // Prepare Description
        $description = $module->description();
        $_define = $module->get_aggregate_object_definition($obj_type);
        
        //handle module actions
        $action_cfg = $module->get_action_settings();
        $module_actions = array();
        if($action_cfg){
            foreach($action_cfg as $action_name => $action_data){
                $module_actions[] = array('id' => $action_name, 'value' => $action_data['name'],   'type' => $action_data['type']);
            }
        }
        $action_buttons = "";
        foreach ($module_actions as $tmp_action) {
            $action_buttons .= safe_form_action_button('', '/SAFe/' . $this->router->fetch_class() . '/' . 'action_form'. '/' . $module_name . '/' . $tmp_action['id'], $tmp_action['value'], $tmp_action['id'], 'POST', 'float:left;');
        }
        if ($action_buttons) {
            $data['notif_warn'][] = safe_form_global_action($description . ' actions ', $action_buttons);
        }
        $_id = $module->name();

        // Check if we want to work on an object instead of module
        if($obj_type && $obj_name){
            // Locate object
            $_obj = $module->get_aggregate_object($obj_type, $obj_name);
            if($_obj){
                $description = $module->aggregate_object_name($obj_type).' - '.$obj_name;
                $module = $_obj;
                $cfg_obj = $module;
            }
            $_type = $obj_type;
            $_id .= '_'.$_type.'_'.$obj_name;
        }

        // Set the basic data
        $data['page_title'] = ucwords($description . ' Configuration');
        $data['page_summary'] = 'This page allows managing ' . $description. ' configuration.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        // Display the views
        $this->load->view("safe_header", $data);
        if($this->modify_hide_menu == true){
            $this->load->view("safe_hide_menu");
        }
        $this->load->view("safe_confirm_dialog", $data);//load confirm dialog js and css
        $this->load->view("safe_notifications", $data);
        //Show first table
        //if obj_type setted and obj name is null do not show module desc table
        if($cfg_obj && !($obj_type != null && $obj_name == null) ) {
            $table = new Safe_crud_table_class();
            $data['table_size'] = '100%';
            $data['table_title'] = $table->set_title(ucwords($description));
            $data['table_id'] = str_replace('.', '_', $_id);
            $table->set_controller_url($this->router->fetch_class());
            if($obj_type && $obj_name){
                $table->primary_key = $module_name.'/'.$obj_type.'/'.$obj_name;
                $parent_key = $module_name;
            }else{
                $table->primary_key = $module_name;
            }
            if (!empty($cfg_obj)) {
                $prof_data = $cfg_obj->summary('vertical', false);
                if($prof_data){
                    foreach ($prof_data['data'] as $k => $v){
                        if($k == 'Name'){
                            continue;
                        }else{
                            $table_line[$k] = $v;
                        }
                    }
                    if(!$_define['readonly']){
                        $table->footer_button[] =
                        array(
                                'url' => base_url($this->router->fetch_class().'/edit/'.$table->primary_key) ,
                                'name' => 'Edit'
                        );
                    }
                    if($parent_key){
                        $table->footer_button[] =
                        array(
                                'url' => base_url($this->router->fetch_class().'/modify/'.$parent_key) ,
                                'name' => 'Cancel'
                        );
                    }   
                    $data['table'] = $table->generate_vertical_line_table('', $table->primary_key, $table_line);
                    $this->load->view("safe_table", $data);
                    unset($table_line);
                }
            }
            unset($table);
        }
        // Aggregate object tables
        if($this->display_aggregate_object){
            $child_base_url = $base_url;
            if($obj_type && $obj_name){
                $child_base_url = $child_base_url . '/' . $obj_type.'/' . $obj_name;
            }
            foreach ($module->has_aggregate_objects(false, true) as $_type => $_definition) {
                if($_definition['configurable'] === false){
                    continue;
                }
                if(isset($this->hide_aggregate_object_list[$_type])){
                    continue;
                }
                if($obj_type!=null && ($obj_name==null || empty($cfg_obj) ) && $obj_type != $_type){
                    continue;
                }
                // Check for custom stuff
                $custom = array();
                $custom = $_definition['controller']['config_manager'];
                // Check if controller has overide obj view
                if($this->aggregate_object_view[$_type]['modify']){
                    $custom['view'] = $this->aggregate_object_view[$_type]['modify'];
                }

                $table = new Safe_crud_table_class();
                $data['table_size'] = '100%';
                $data['table_container_class'] = 'safe_datatable';
                $data['table_title'] = $table->set_title($_definition['name']);
                $data['table_id'] = str_replace('.', '_', $_id.'_'.$_type);
                $table->set_controller_url($this->router->fetch_class());

                $table_heading_array = array();
                $this->generate_table_data($table, $data, $module, $_type, $child_base_url, $custom, $table_heading_array);

                $table->set_headings($table_heading_array);
                if(isset($custom['allow_create_button'])){
                    $allow_create_button = $custom['allow_create_button'];
                }elseif(!$_definition['readonly']){
                    $allow_create_button = 'add';
                }else{
                    $allow_create_button = false;
                }
                if($allow_create_button){
                    if($obj_type && $obj_name){
                        // Adjust url suffix so will invoke add_form_child/..
                        $table->set_url_suffix('child');
                        $table->allow_create(true, $module_name . '/'  . $obj_type.'/'.$obj_name.'/'. $_type, $allow_create_button);
                        if(isset($custom['custom_button'])){
                            foreach ($custom['custom_button'] as $button_item){
                                $button_item['url'] = base_url($this->router->fetch_class()) . '/' . $button_item['id'] . '_child' . '/' .$module_name . '/'  . $obj_type.'/'.$obj_name.'/'. $_type;
                                $table->footer_button[] = $button_item;
                            }
                        }
                    }else{
                        $table->allow_create(true, $module_name . '/' . $_type, $allow_create_button);
                        if(isset($custom['custom_button'])){
                            foreach ($custom['custom_button'] as $button_item){
                                $button_item['url'] = base_url($this->router->fetch_class()) . '/' . $button_item['id'] . '/' .$module_name . '/'  . $obj_type;
                                $table->footer_button[] = $button_item;
                            }
                        }
                    }
                }
                
                // Custom view for this object type ?
                if(!$custom['view']){
                    // No, use regular table view
                    $data['table'] = $table->generate_table();
                    $this->load->view("safe_table", $data);
                }else{
                    // Yes, fetch table data and populate definition and object 
                    // data
                    $custom_data = array();
                    $custom_data['table_data'] = $table->generate_data();
                    $custom_data['table'] = $table->generate();
                    $custom_data['url_base'] = base_url($this->router->fetch_class());
                    $custom_data['type'] = $_type;
                    $custom_data['definition'] = $_definition;
                    $custom_data['objects']['data'] = array();
                    $custom_data['objects']['value'] = array();
                    $custom_data['objects']['name'] = array();

                    $obj_keys = $module->get_aggregate_objects_keys($_type);
                    if (!empty($obj_keys)) {
                        set_time_limit(0);
                        foreach ($obj_keys as $key) {
                            $object = $module->get_aggregate_object($_type, $key);
                            $custom_data['objects']['data'][] = $object->get_data();
                            $custom_data['objects']['value'][] = $object->get_data_values(false);
                            $custom_data['objects']['name'][] = $object->name();
                        }
                    }
                    $this->load->view($custom['view'], $custom_data);
                }
            }
        }
        $this->load->view("safe_footer", $data);
    }

    protected function generate_table_data($table, &$data, $module, $_type, $base_url, $custom, &$table_heading_array)
    {
        $table_head = false;
        $table_heading_array = array();
        // Retrieve the objects keys
        $obj_keys = $module->get_aggregate_objects_keys($_type);
        // Do we have to asynch load the table ?
        // Arbitrary value (100 :)
        $max_count = 100;
        if(count($obj_keys) > $max_count ) {
            $total = count($obj_keys);
            $offset = 0;
            if($data['async']['offset']){
                $offset = $data['async']['offset'];
            }
            $len = min($max_count, $total - $offset);
            $obj_keys = array_splice($obj_keys, $offset, $len);

            $data['async'] = array(
                'url' => site_url($this->router->fetch_class().'/datatable_fetch/' . $base_url.'/'.$_type),
                'id' => $data['table_id'],
                'total' => $total,
                'offset' => $offset,
                'count' => $len,
                );
        }
        if (!empty($obj_keys)) {
            set_time_limit(0);
            foreach ($obj_keys as $key) {
                $object = $module->get_aggregate_object($_type, $key);
                if (isset($object)) {
                    // Check for singleton
                    $has_sub = false;
                    if($_definition['singleton']){
                        $primary_key = $module->name(). '/' . $_type;
                        $fields = array($_definition['name']);
                    }else{
                        $primary_key = $base_url . '/' . $_type . '/' . $object->name();
                        $fields = array();
                        $formatter = array();
                        $summary_desc = $object->summary('horizontal', false);
                        foreach($summary_desc['data'] as $key => $value ){
                            if(!$table_head){
                                //set table headings
                                $table_heading_array[] =  $key;
                            }
                            $fields[] = $value;
                        }
                        $has_sub = $object->has_aggregate_objects();
                    }
                    $table_head = true;
                    
                    // Button override ?
                    if(isset($custom['summary_buttons'])){
                        $line_button = $custom['summary_buttons'];
                    }else{
                        // Has sub object ?
                        if($has_sub) {
                            if(!$_definition['readonly']){
                                $line_button =  'Modify|Delete:confirm';
                            }else{
                                $line_button = 'Modify[Details]';
                            }
                        }else{
                            if(!$_definition['readonly']){
                                $line_button = 'Edit|Delete:confirm';
                            }else{
                                $line_button = 'Edit[Details]';
                            }
                        }
                        // Check if some methods to add as button
                        foreach($_definition['methods'] as $_method => $method_def){
                            // Check if exists in controller class
                            $_method_name = $_method.'_'.$_type;
                            if(method_exists($this, $_method_name)){
                                $line_button .= '|'.$_method_name;
                                // with confirm ?
                                if(method_exists($this, $_method_name.'_confirm')){
                                    $line_button .= ':confirm';
                                }
                            }
                        }
                    }
                    // Add buttons
                    $table->add_row(
                        $fields, 
                        $primary_key, $line_button, '', true);

                }
            }
        }
    }
    /**
     * Function create a json encoded form to Create an aggregated object
     *   using popup dialog in browser
     */
    public function add_form_child($module_name, $obj_type, $obj_name, $sub_type, $reload=false)
    {
        $this->add_form($module_name, $obj_type, $reload, $obj_name, $sub_type);
    }
    public function add_form($module_name, $obj_type,$reload=false, $obj_name=null, $sub_type)
    {
        $profile_exist = false;
        // Check post request
        $post = $this->input->post();
        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name($module_name);
        // Get config object
        $cfg_obj = $module->config();
        $_type = $obj_type;
        // Add a sub object ?
        if($obj_name && $sub_type){
            $_obj = $module->get_aggregate_object($obj_type, $obj_name);
            if($_obj){
                $module = $_obj;
                $_type = $sub_type;
            }
        }
        
        $data_cfg = $module->get_aggregate_object_definition($_type);
        $action_name = 'add';
        if(isset($data_cfg['controller']['config_manager']['allow_create_button'])){
            $tmp_button = safe_format_button($data_cfg['controller']['config_manager']['allow_create_button']);
            if(isset($tmp_button['add'])){
                $action_name = $tmp_button['add']['value'];
            }
        }
        if ($data_cfg['autoname'] && !$data_cfg['popup_add_form']){
            //no confirm dialog
            $this->add($module_name, $obj_type, $obj_name, $sub_type);
            exit();
        }else{
            $param = new Sng_config_manager_param_class($module,$_type);
            $param->configure();
            
            $config = $param->get_data();
            
            // Set the basic data
            $data['page_title'] = ucwords($module->description() . ' Configuration');
            
            if($param->error){
                $data['message'] = $param->error_message;
                $data['message_type'] = 'notice';
                $data['result'] = false;
                echo json_encode($data);
                exit();
            }
            
            $this->load->library("safe_form_class", $config);
            
            
            //Display form with checkboxes
            $data['form_title'] = ucwords($module->description()) . ' : '.ucfirst($action_name).' ' . $module->aggregate_object_name($_type);
            $data['form'] = $this->safe_form_class->form_input_array();
            //pass the copy obj name to save
            if(isset($config['save']) && $config['save']['type'] ==  'hidden'){
                $data['form'][] = '<input type="hidden" name="save" value="Save" />';
            }
            $data['form_cfg'] = $this->safe_form_class->config;
            $data['label'] = $this->safe_form_class->form_label_array();
            $data['form_open'] = $this->safe_form_class->form_open();
            $data['buttons'] = array(
                    array(
                            'name' => 'add',
                            'value' => ucfirst($action_name),
                            'type' => 'submit'
                    ) ,
                    array(
                            'name' => 'cancel',
                            'value' => 'Cancel',
                            'type' => 'submit'
                    ) ,
            );
            //******
            //clear the content in page cache and get the view content
            ob_start();
            ob_clean();
            $this->load->view("safe_form_json", $data);
            $data['content'] = ob_get_contents();
            ob_clean();
            //******
            
            $data['page_title'] = $data['form_title'];
        }
        $data['result'] = true;
        if($reload === true){
            $data['result'] = false; //user sumbit data did not pass the validation, return false and reload the form with error message
        }
        $data['reload'] = $reload;
        if($obj_name && $sub_type){
            $data['action_url'] = base_url($this->router->fetch_class().'/add/'. $module_name. '/' . $obj_type.'/'.$obj_name.'/'.$sub_type);
        }else{
            $data['action_url'] = base_url($this->router->fetch_class().'/add/'. $module_name. '/' . $obj_type);
        }
        $data['action_method'] = 'POST';
        echo json_encode($data);
    }
    /**
     * Uploads the file the server
     * @param string $file_name
     * 							File name of the pem file being uploaded
     * @return string $location
     * 							File location and filename of the server
     */
    public function upload_file(&$name,&$data,&$msg,$seting=null)
    {
        $status = "";
        $msg = "";
        foreach($_FILES as  $key => $tmp_file){
            $file_element_name = $key;
            break;//now only support one file
        }
        
        $data = array();
        $config = array();
    
        $config['upload_path'] = '/tmp/upload-files/';
        if(isset($seting['file_type'])){
            $config['allowed_types'] = $seting['file_type'];
        }else{
            $config['allowed_types'] = '*';
        }

        $config['max_size']  = 1024 * 100;
        $config['encrypt_name'] = FALSE;
        $config['overwrite'] = TRUE;
    
        if (!file_exists($config['upload_path']))
            mkdir ($config['upload_path'],'0755',true);
    
        $this->load->library('upload', $config);
    
        if (!$this->upload->do_upload($file_element_name))
        {
            $status = 'error';
            $msg = $this->upload->error_msg;
            return false;
        }
        $status = "success";
        $msg = "File uploaded successfully.";
    
        $data = $this->upload->data();
        $name =  $data['raw_name'];
    
        $data['content'] = file_get_contents($data['full_path']);
    
        @unlink($data['full_path']);
        return true;
    }
    /**
     * Create an aggregated object
     * @param unknown_type $cfg
     * @param unknown_type $sub_cfg
     */
    public function add($module_name, $obj_type, $obj_name=null, $sub_type=null)
    {
        $profile_exist = false;
        // Check post request
        $post = $this->input->post();
        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name($module_name);
        // Get config object
        $cfg_obj = $module->config();
        $_type = $obj_type;
        //$aggregated_object = $module->get_aggregate_objects($obj_type);

        // Add a sub object ?
        if($obj_name && $sub_type){
            $_obj = $module->get_aggregate_object($obj_type, $obj_name);
            if($_obj){
                $module = $_obj;
                $aggregated_object = $module->get_aggregate_objects($sub_type);
                $_type = $sub_type;
            }
        }

        //$param = new Sng_config_manager_param_class($module->get_aggregate_object_definition($_type));
        $param = new Sng_config_manager_param_class($module, $_type);
        $param->configure();
        
        $data['page_title'] = ucwords($module->description() . ' Configuration');
        
        //check auto
        $data_cfg = $module->get_aggregate_object_definition($_type);
        if (isset($data_cfg['autoname']) && $data_cfg['autoname'] == true){
            //generate name
            $post['profile-name'] = $module->build_unique_name($_type);
            $_POST['profile-name'] = $post['profile-name'];
        }
        $wizard_data = $param->get_data_values();
        $wizard_data['profile-name'] = $post['profile-name'];
        $param->set_data_values($wizard_data);
        // Validate the data
        $config = $param->get_data();
        $this->load->library("safe_form_class", $config);
        //set validation obj (for call back check rule in module)
        $this->safe_form_class->set_validation_obj($module);
        if ($this->safe_form_class->run_validation($validation_errors)) {
            $param->save();
            //if a file uploaded
            if ($_FILES) {
                $file_name = "";
                $file_msg ='';
                $file_data = array();
                $_data = array();
                if($this->upload_file($file_name, $file_data, $file_msg, $data_cfg['file_def'])) {
                    if(!isset($post['profile-name'])){
                        $post['profile-name'] = $file_name;
                    }
                    $_data['base64_encode_contents'] = base64_encode($file_data['content']);
                    $_data['file_name'] = $file_data['file_name'];
                }else{
                    $data['message'] = 'Upload file failed.';
                    $data['reason'] = $file_msg;
                    $data['message_type'] = 'alert';
                    $data['result'] = false;
                    echo json_encode($data);
                    return;
                }
            }
            // Check we can create the object (delegate to module)
            $reason = array();
            if(!$module->can_create_aggregate_object($_type, $post['profile-name'], $reason)){
                // Cannont create object, throw an error
                $data['message'] = 'Create ' .$module->aggregate_object_name($_type)." <b>" . $post['profile-name'] . "</b> failed.";
                $data['reason'] = $reason;
                $data['message_type'] = 'alert';
                $data['result'] = false;
                echo json_encode($data);
                return;
            } else {
                // Ask module to create aggregate object
                // If 'profile-type' is specified in post, then use it instead 
                // of _type - Module MUST then overload create_aggregate_object 
                // to intercept object creation
                $_create_type = $_type;
                if($_POST['profile-type']){
                    $_create_type = $_POST['profile-type'];
                    $post['profile-type'] = $_POST['profile-type'];
                }
                $output = array();
                $new_obj = $module->create_aggregate_object($_create_type, $post['profile-name'], $output);
                if ($new_obj) {
                    //if with a file uploaded
                    if ($_FILES) {
                        if($new_obj->validate($_data, $output)){
                            $post =  $post + $new_obj->get_data_values(false);
                        } else {
                            $data['message'] = "Fail to create <b>" . $post['profile-name'] . "</b> in " . $module->aggregate_object_name($_type);
                            if($output != null){
                                $data['message'] = $data['message'] . '<br>';
                                foreach($output as $topic => $err){
                                    $err_string = "";
                                    if(is_array($err)){
                                        foreach($err as $t2 => $r2){
                                            if(is_array($r2)){
                                                $err_string .= $t2 . ':' . implode(' ', array_values($r2)) . '<br/>';
                                            }else{
                                                $err_string .= $t2 . ':' . $r2 . '<br/>';
                                            }
                                        }
                                    }else{
                                        $err_string =  $topic .'=>'.$err;
                                    }
                                    $data['message'] = $data['message'] . '<br>'.$err_string;
                                }
                            }
                            $data['message_type'] = 'alert';
                            $data['result'] = false;
                            echo json_encode($data);
                            return;
                        }
                    }
                    if($obj_name && $sub_type){
                        $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/edit/' . $module_name . '/' . $obj_type . '/' . $obj_name.'/'.$sub_type.'/'.$post['profile-name']);
                        $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/edit/' . $module_name . '/' . $obj_type . '/' . $obj_name.'/'.$_create_type.'/'.$post['profile-name']);
                    }else{
                        $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/edit/' . $module_name . '/' . $obj_type . '/' . $post['profile-name']);
                    }
                    $data['post_data'] = $post;
                    $data['post_data']['redirect'] = true;
                    $data['redirect_method'] = 'POST';
                    $data['result'] = true;
                    echo json_encode($data);
                } else {
                    $data['message'] = "Fail to create <b>" . $post['profile-name'] . "</b> in " . $module->aggregate_object_name($_type);
                    if($output != null){
                        $data['message'] = $data['message'] . '<br>' . $output['error'];
                    }
                    $data['message_type'] = 'alert';
                    $data['result'] = false;
                    echo json_encode($data);
                }
            }
        }else{
            //return a json encode form with a error message
            if($obj_name && $sub_type){
                $this->add_form_child($module_name, $obj_type, $obj_name, $sub_type, true);
            }else{
                $this->add_form($module_name, $obj_type, true);
            }
        }
    }
    /*
     * Confirm to delete 
     * @param string $cfg
     * @param string $sub_cfg
     * @param string $obj_type
     * @param string $obj_name
     */
    public function delete_confirm($module_name, $obj_type, $obj_name, $sub_type=null, $sub_name=null)
    {
        $data['page_title'] = 'Configuration';
        $profile_exist = false;
        if (!isset($module_name)) {
            $data['message'] = 'Module name required!';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
            exit();
        }
        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name($module_name);
        $aggr_object = $module->get_aggregate_object($obj_type, $obj_name);
        $description = $module->description();
        $_type = $obj_type;
        // Want to delete a child object ?
        if($sub_type && $sub_name){
            $module = $aggr_object;
            $aggr_object = $aggr_object->get_aggregate_object($sub_type, $sub_name);
            $_type = $sub_type;
            $description = $module->description();
        }
        // Check post request
        $post = $this->input->post();
        // Set the basic data
        $data['page_title'] = ucwords($module->description()) . ' : Delete ' . $module->aggregate_object_name($_type);
        if (isset($aggr_object)) {
            //Check to make sure you can delete, then delete the object
            $_definition = $module->get_aggregate_object_definition($_type);
            $reason = array();
            $action_name = 'delete';
            if(isset($_definition['controller']['config_manager']['summary_buttons'])){
                $tmp_button = safe_format_button($_definition['controller']['config_manager']['summary_buttons']);
                if(isset($tmp_button['delete'])){
                    $action_name = $tmp_button['delete']['value'];
                }
            }
            if ($aggr_object->can_dispose($reason)) {
                if(isset($_definition['autoname']) && $_definition['autoname'] == true ){
                    $data['message'] = 'Are you sure you want to '.$action_name.'  this <b>' . $module->aggregate_object_name($_type) . '</b>?';
                }else{
                    $data['message'] = 'Are you sure you want to '.$action_name.' <b>' . $module->aggregate_object_name($_type) . ' - '.$aggr_object->name() . '</b>?';
                }
                
                $data['message_type'] = 'notice';
                $data['result'] = true;
                if($sub_type && $sub_name){
                    $data['action_url'] = base_url($this->router->fetch_class()). '/delete/'. $module_name .'/' . $obj_type . '/' . $obj_name.'/'.$sub_type.'/'.$sub_name;
                }else{
                    $data['action_url'] = base_url($this->router->fetch_class()). '/delete/'. $module_name .'/' . $obj_type . '/' . $obj_name;
                }
                echo json_encode($data);
            }else{
                $reason_msg='';
                if($reason){
                    if(is_array($reason)){
                        if($reason['obj']){
                            $obj_msg = '';
                            foreach($reason['obj'] as $used_obj){
                                $module_obj = $this->_the_app->find_module_by_name($used_obj['name']);
                                if($module_obj){
                                    $desc = $module_obj->get_object_description($used_obj);
                                }
                                if($obj_msg == ''){
                                    $obj_msg = "<li class='safe_dialog_li'>{$reason['msg']}  :</li>";
                                }
                                $obj_desc  = " {$desc['module']}/{$desc['obj_type']}/{$desc['obj_name']}";
                                if(isset($desc['url'])){
                                    if(isset($desc['controller_url'])){
                                        $url = $desc['controller_url'] . '/edit' . $desc['url'];
                                    }else{
                                        $url = $this->router->fetch_class() . '/edit' . $desc['url'];
                                    }
                                    $obj_msg .= "<li class='safe_dialog_li_arrow'><a href='{$url}' tabindex='-1'>" . $obj_desc ."</a></li>";
                                }
                            }
                            if($obj_msg){
                                $obj_msg =  "<ul class='safe_help_ul_top'>{$obj_msg}</ul>";
                            }
                            $reason_msg  .= $obj_msg;
                        }
                    }else{
                        $reason_msg = $reason;
                    }
                }
                $reason_msg = ($reason_msg=='')?'':'<br>'.$reason_msg;
                if(isset($_definition['autoname']) && $_definition['autoname'] == true ){
                    $data['message'] = ucfirst($action_name).' this <b>' . $description. '</b> failed.'.$reason_msg;
                }else{
                    $data['message'] = ucfirst($action_name).' <b>' . $description.' - '.$aggr_object->name() . '</b> failed.'.$reason_msg;
                }
                $data['message_type'] = 'alert';
                $data['result'] = false;
                echo json_encode($data);
            }
        }else{
            $data['message'] = 'Object not found!';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /*
     * delete
    * @param string $cfg
    * @param string $sub_cfg
    * @param string $obj_type
    * @param string $obj_name
    */
    public function delete($module_name, $obj_type, $obj_name, $sub_type=null, $sub_name=null)
    {
        $data['page_title'] = 'Configuration';
        $profile_exist = false;
        if (!isset($module_name)) {
            $data['message'] = 'Module name required!';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
            exit();
        }
        $del_type = $obj_type;
        $del_obj_name = $obj_name;
        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name($module_name);
        $aggr_object = $module->get_aggregate_object($obj_type, $obj_name);
        $description = $module->description();
        // Want to delete a child object ?
        if($sub_type && $sub_name){
            $module = $aggr_object;
            $aggr_object = $aggr_object->get_aggregate_object($sub_type, $sub_name);
            $del_type = $sub_type;
            $del_obj_name = $sub_name;
        }
        // Set the basic data
        $data['page_title'] = ucwords($description . ' Configuration');
        if (isset($aggr_object)) {
            //Dispose aggregated object config
            if($module->has_aggregate_objects(false, true)){
                $module->delete_aggregate_object($del_type, $del_obj_name);
            }else{
                //some obj does not have api_delete_
                $aggr_object->dispose();
            }
            
            //return redirect url
            $data['result'] = true;
            if($sub_type && $sub_name){
                $data['redirect_url'] =  base_url($this->router->fetch_class()). '/modify/' . $module_name.'/'.$obj_type.'/'.$obj_name;
            }else{
                $data['redirect_url'] =  base_url($this->router->fetch_class()). '/modify/' . $module_name;
            }
            echo json_encode($data);
        }else{
            //return error message
            $data['message'] = 'Object not found!';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * @brief Dyanmic reload
     *           
     * @param[in out] $cfg
     * @param[in out] $sub_cfg
     *           
     * @return
     */
    public function dynamic_reload($module_name = null, $obj_type = null, $obj_name = null)
    {
        // From this point we will display something for sure, so display header
        $data['page_title'] = 'Apply & Reload';
        $data['page_summary'] = 'This page allows applying & reloading dynamic objects.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $this->load->view("safe_header", $data);
        // Process to adapter detection
        $data['wait_message'] = '</br><b>Applying & reloading ...</b></br>&nbsp;';
        $this->load->view("safe_confirm_dialog", $data);
        $this->load->view("safe_wait", $data);
        safe_flush_ouput();

        // Default module is the app
        $module_root = $this->_the_app;
        if($module_name) {
            $module_root = $this->_the_app->find_module_by_name($module_name);
        }
        // TODO - Filter obj_type and obj_name
        
        $configuration_module = $this->_the_app;
        $param['call_from'] = 'view_controller';
        $output = array();
        $rc = $configuration_module->api_reload_configuration($module_name, $param, $output);
        if($rc) {
            safe_redirect('/SAFe/' . $this->router->fetch_class());
        }else{
            if(isset($output['cfg_mgr'])){
                // Populate generation result table
                $data['table_title'] = 'Configuration Generation';
                $table = new Safe_table_class();
                $table->data = $output['cfg_mgr_data'];
                $table->footer_button = array(
                        array(
                                'url' => '/SAFe/sng_control_panel',
                                'name' => 'Control Panel'
                        )
                );
                $data['table'] = $table->generate();
                $data['notif_error'][] = $output['cfg_mgr'];
            }else{
                $data['notif_error'] = $output;
            }
        }

        $this->load->view("safe_notifications", $data);
        if (isset($data['table'])) $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * @brief Reload the module configuration
     *           
     * @param[in out] $cfg
     * @param[in out] $sub_cfg
     *           
     * @return
     */
    public function reload($module_name)
    {
        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name($module_name);
        // From this point we will display something for sure, so display header
        $data['page_title'] = ucwords($module->description() . ' Configuration');
        $data['page_summary'] = 'This page allows managing ' . $module->description() . ' configuration.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $this->load->view("safe_header", $data);
        // Process to adapter detection
        $data['wait_message'] = '</br><b>Reloading ' . $module->description() . ' configuration...</b></br>&nbsp;';
        $this->load->view("safe_confirm_dialog", $data);
        $this->load->view("safe_wait", $data);
        safe_flush_ouput();
        // Reload the module
        $rc = $module->reload();
        // Check success
        if ($rc) {
            // Go back to edit
            safe_redirect('/SAFe/' . $this->router->fetch_class() . '/edit/' . $module_name);
        } else {
            $data['notif_error'][] = safe_form_with_submit_button('Reload ' . $module->description() . ' configuration failed.', '/SAFe/' . $this->router->fetch_class() . '/edit/' . $module_name, 'Back');
        }
        $this->load->view("safe_notifications", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * @brief Edit module configuration
     *           
     * @param[in out] $cfg
     * @param[in out] $sub_cfg
     * @param[in out] $obj_type
     * @param[in out] $aggr_edit
     *           
     * @return
     */
    public function edit($module_name, $obj_type = null, $obj_name = null, $sub_type = null, $sub_name = null)
    {
        if(isset($_POST['redirect'])){
            if($_POST['save']){
                unset($_POST['redirect']);
            }else{
                $post_data = $this->input->post();
                unset($_POST);
            }
        }
        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name($module_name);
        // Get config object
        $cfg_obj = $module->config();
        $description = $module->description();
        // Prepare redirect urls
        if($module->has_aggregate_objects()){
            $redirect_url = '/modify/'.$module_name;
        }
        // If no config and no obj_type specified then redirect to modify page 
        // for this module
        if(!$cfg_obj && !$obj_type){
            Safe_redirect('/' . $this->router->fetch_class() . '/modify/'.$module_name);
        }
        
        //gets aggregated object based on the url. If editing aggregated object, set cfg_obj to the aggregated object configuration
        if ($obj_type && $obj_name) {
            $cfg_obj = $module->get_aggregate_object($obj_type, $obj_name);
            $description = $module->aggregate_object_name($obj_type).' - '.$obj_name;
            if($cfg_obj) {
                if($cfg_obj->has_aggregate_objects()){
                    $redirect_url = '/modify/'.$module_name.'/'.$obj_type.'/'.$obj_name;
                }
                $module = $cfg_obj;
                // Same mechanism if editing a sub object
                if($sub_type && $sub_name){
                    $description = $module->aggregate_object_name($sub_type).' - '.$sub_name;
                    $cfg_obj = $module->get_aggregate_object($sub_type, $sub_name);
                }
            }
        }elseif($obj_type){
            // Check if this type of object is a singleton
            $obj_def = $module->get_aggregate_object_definition($obj_type);
            if($obj_def && $obj_def['singleton']){
                $description = $module->aggregate_object_name($obj_type);
                $cfg_obj = $module->get_aggregate_objects($obj_type);
            }
        }
        $new_obj = false;
        if(!$cfg_obj) {
            $_create_type = null;
            if($_POST['profile-type']){
                $_create_type = $_POST['profile-type'];
            }else if($sub_type && $sub_name){
                $_create_type = $sub_type;
            }else{
                $_create_type = $obj_type;
            }
            if($sub_type && $sub_name){
                $cfg_obj = $module->create_aggregate_object($_create_type, $sub_name);
            } else {
                $cfg_obj = $module->create_aggregate_object($_create_type, $obj_name);
            }
            if($cfg_obj->has_aggregate_objects()){
                $redirect_url = '/modify/'.$module_name.'/'.$obj_type.'/'.$obj_name;
                $cancel_redirect_url = '/modify/'.$module_name;
            }
            //$cfg_obj->configure($obj_name);
            $new_obj = true;
            if(isset($post_data['src']) ){
                // Copy from another profile
                $src_obj =  $module->get_aggregate_object($_create_type, $post_data['src']);
                if($src_obj){
                    $cfg_obj->set_data_values($src_obj->get_data_values(false));
                }
            }elseif(isset($_POST['src'])){
                //for copy sub objs in save
                $src_obj =  $module->get_aggregate_object($_create_type, $_POST['src']);
                unset($_POST['src']);
            }
        }
        // Prepare object for edition
        $cfg_obj->prepare_edit();
        // Check post request
        $post = $this->input->post();
        // Retrieve module to work on
        // Handle post
        if (isset($post['cancel'])) {
            if ($redirect_url) {
                if(isset($cancel_redirect_url)){
                    $redirect_url = $cancel_redirect_url;
                }
                redirect('/' . $this->router->fetch_class() . $redirect_url, 'refresh');
            }
        } elseif (isset($post['save'])) {
            // TODO(wadam) - Validate and save
            unset($post['save']);
            // Prepare an array to retreive errors if any
            $validation_errors = array();
            // update the configurable object with posted values
            $cfg_obj->set_data_values($post);
            // Prepare the form for validation with posted data
            // Note that this is the form that will be used by edit code (after this if/else block)
            // if the validation fail
            $this->load->library('safe_form_class', $cfg_obj->get_data());
            // Check new data are valid
            if ($error = $cfg_obj->validate($post, $validation_errors)) {
                // Save
                if ($cfg_obj->save()) {
                    //copy sub obj
                    if($src_obj){
                        // Need to copy sub obj
                        foreach ($src_obj->has_aggregate_objects(false, true) as $src_sub_type => $src_sub_definition){
                            if($src_sub_definition['configurable']){
                                foreach ($src_obj->get_aggregate_objects($src_sub_type) as $src_sub_obj_name => $src_sub_object) {
                                    $new_sub_obj = $cfg_obj->create_aggregate_object($src_sub_type, $src_sub_obj_name);
                                    $new_sub_obj->set_data_values($src_sub_object->get_data_values(false));
                                    $new_sub_obj->save();
                                }    
                            }
                        }
                    }
                    if ($redirect_url && $this->allow_back) {
                        redirect('/' . $this->router->fetch_class() . $redirect_url, 'refresh');
                    }
                    $data['notif_warn'][] = $module->description() . ' configuration saved.';
                    $data['auto_hide'] = 'notif_warn';
                }
            }
            // Data not validated correctly
            // Continue to display errors
        } else {
            $this->load->library('safe_form_class', $cfg_obj->get_data());
        }
        // Set the basic data
        $data['page_title'] = ucwords($description . ' Configuration');
        $data['page_summary'] = 'This page allows managing ' . $description . ' configuration.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        // Display the views
        $this->load->view("safe_header", $data);
        if($this->edit_hide_menu == true){
            $this->load->view("safe_hide_menu");
        }
        $this->load->view("safe_notifications", $data);
        // Display form for configuration
        //$this->load->library('safe_form_class', $cfg_obj->get_data());
        $cfg_data = array();
        $cfg_data['form_title'] = ucwords($description);
        $cfg_data['form'] = $this->safe_form_class->form_input_array();
        //pass the copy obj name to save
        if($src_obj){
            $cfg_data['form'][] = '<input type="hidden" name="src" value="'.$src_obj->name().'" />';
        }
        $form_config = array();
        $form_config = $this->safe_form_class->config;
        $cfg_data['form_cfg'] = $form_config;
        // Get the fields group
        // send the group array in our form view
        $field_group = array();
        $field_group = $cfg_obj->get_group();
        $cfg_data['group'] = $field_group;
        $cfg_data['group_condition'] = $cfg_obj->get_group_condition();
        $cfg_data['label'] = $this->safe_form_class->form_label_array();
        // set the form attributes
        $frm_attributes = array(
            'id' => 'cfg_manager'
        );
        $this->safe_form_class->set_form_attributes($frm_attributes);
        $cfg_data['form_open'] = $this->safe_form_class->form_open();
        //if ($module->has_aggregate_objects() || ($obj_type && $obj_name)) {
        if ($redirect_url && $this->allow_back) {
            $cfg_data['buttons'] = array(
                array(
                    'name' => 'save',
                    'value' => 'Save',
                    'type' => 'submit'
                ) ,
                array(
                    'name' => 'cancel',
                    'value' => 'Cancel',
                    'type' => 'submit'
                ) ,
            );
        } else {
            $cfg_data['buttons'] = array(
                array(
                    'name' => 'save',
                    'value' => 'Save',
                    'type' => 'submit'
                ) ,
            );
        }
        $this->load->view("safe_form", $cfg_data);
        $this->load->view("safe_footer", $data);
    }
    public function generate($restart = false, $force = false)
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Configuration Manager';
        $data['page_summary'] = 'This page allows managing system configuration.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        // From this point we will display something for sure, so display header
        $this->load->view("safe_header", $data);
        // Process to adapter detection
        if ($restart) $data['wait_message'] = '<b>Generating configuration and restarting system...</b>';
        else $data['wait_message'] = '<b>Generating configuration...</b>';
        $this->load->view("safe_confirm_dialog", $data);
        $this->load->view("safe_wait", $data);
        safe_flush_ouput();
        $app_status = $this->_the_app->status();
        $rc_restart = TRUE;
        
        $configuration_module = $this->_the_app;
        if(isset($restart)) $param['restart'] = $restart;
        if(isset($force)) $param['force'] = $force;
        $param['call_from'] = 'view_controller';
        $output = array();
        $result = $configuration_module->api_apply_configuration(null,$param,$output);
        if ($result === false ) {
            if(isset($output['sys_running'])){
                $data['notif_error'][] = $output['sys_running'];
            }elseif(isset($output['message'])){
                $data['notif_error'][] = $output['message'];
                // Populate generation result table
                $data['table_title'] = 'Configuration Generation';
                $table = new Safe_table_class();
                $table->apply_data_formatter = false;
                foreach($output['reason'] as $item){
                    $fix_url = '';
                    if(isset($item['url'])){
                        $fix_url = $item['url'];
                    }
                    $module = $this->_the_app->find_module_by_name($item['module']);
                    if($module){
                        $mod_name = $module->description();
                        $obj_def = $module->get_aggregate_object_definition($item['obj_type']);
                        if($obj_def){
                            $obj_type = $obj_def['name'];
                            if(!$fix_url){
                                $fix_url = $obj_def['controller_url'];
                            }
                        }else{
                            $obj_type = $item['obj_type'];
                        }
                        $obj_name = $item['obj_name'];
                    }else{
                        $mod_name = $item['module'];
                        $obj_type = $item['obj_type'];
                        $obj_name = $item['obj_name'];
                    }
                    if($item['type'] == 'ERROR'){
                        $icon = WEBCONFIG_ICON_XMARK;
                    }else{
                        $icon = '';
                    }
                    $table->data[] = array(
                            $icon,
                            $mod_name,
                            $obj_type,
                            $obj_name,
                            $item['description'],
                            $item['type'],
                    );
                    if($fix_url){
                        $table->line_button[] = array(
                                array(
                                        'url' => $fix_url,
                                        'name' => 'Configure',
                                        'label' => ''
                                )
                        );
                    }
                }
                $table->footer_button = array(
                        array(
                                'url' => '/SAFe/sng_control_panel',
                                'name' => 'Control Panel'
                        )
                );
                $data['table'] = $table->generate();
            }else{
                if($restart){
                    if(isset($output['restart_failed'])){
                        $data['notif_error'][] = 'System apply configuration and restart failed.</br>' . safe_form_with_submit_button('', '/SAFe/sng_control_panel', 'Control Panel', '', 'get', 'float:left;');
                    }    
                }
            }
        }else{
            // All good, redirect to control panel
            Safe_redirect('/SAFe/sng_control_panel');
            if($restart){
                $data['notif_warn'][] = 'System apply configuration and restart succeeded.</br>' . safe_form_with_submit_button('', '/SAFe/sng_control_panel', 'Control Panel', '', 'get', 'float:left;');
            }else{
                $data['notif_warn'][] = 'Apply configuration succeeded.</br>' . safe_form_with_submit_button('', '/SAFe/sng_control_panel', 'Control Panel', '', 'get', 'float:left;');
            }
        }
        // Already done - $this->load->view ( "safe_header", $data );
        $this->load->view("safe_notifications", $data);
        if (isset($data['table'])) $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    public function action_form($module_name, $action_name, $reload)
    {
        // Check post request
        $post = $this->input->post();
        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name($module_name);
        $action_cfg = $module->get_action_settings();
        if(isset($action_cfg[$action_name])){
            $action_cfg = $action_cfg[$action_name];
            if (!isset($action_cfg['param']) && $action_cfg['param'] == null) {
                //no confirm dialog
                $this->action($module_name, $action_name);
                exit();
            }else{
                $param = $action_cfg['param'];
                $config = $param->get_data();
                // Set the basic data
                $data['page_title'] = ucwords($module->description() . ':' . $action_name);
                if($param->error){
                    $data['message'] = $param->error_message;
                    $data['message_type'] = 'notice';
                    $data['result'] = false;
                    echo json_encode($data);
                    exit();
                }
                //Display form
                $this->load->library("safe_form_class", $config);
                $data['form_title'] = ucwords($module->description()) . ' : '  . $action_cfg['name'];
                $data['form'] = $this->safe_form_class->form_input_array();
                $data['form_cfg'] = $this->safe_form_class->config;
                $data['label'] = $this->safe_form_class->form_label_array();
                $data['form_open'] = $this->safe_form_class->form_open();
                $data['buttons'] = array(
                        array(
                                'name' =>  $action_name,
                                'value' => ucfirst($action_cfg['name']),
                                'type' => 'submit'
                        ) ,
                        array(
                                'name' => 'cancel',
                                'value' => 'Cancel',
                                'type' => 'submit'
                        ) ,
                );
                //******
                //clear the content in page cache and get the view content
                ob_start();
                ob_clean();
                $this->load->view("safe_form_json", $data);
                $data['content'] = ob_get_contents();
                ob_clean();
                //******
                $data['page_title'] = $data['form_title'];
            }
        }
        $data['result'] = true;
        if($reload === true){
            $data['result'] = false; //user sumbit data did not pass the validation, return false and reload the form with error message
        }
        if($data['result']){
            $data['setting']['title'] = 'Processing ' . $data['form_title'];
            $data['setting']['sec'] = '60';
            $data['setting']['msg'] = 'Ooops ! Action time out...';
            $data['setting']['label'] = 'Close';
            $data['setting']['url'] = '';
        }
        $data['reload'] = $reload;
        $data['action_url'] = base_url($this->router->fetch_class().'/action/'. $module_name. '/' . $action_name);
        $data['action_method'] = 'POST';
        echo json_encode($data);
    }
    public function action($module_name, $action_name)
    {
        // Check post request
        $post = $this->input->post();
        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name($module_name);
        $action_cfg = $module->get_action_settings();
        $param = null;
        if(isset($action_cfg[$action_name])){
            $action_cfg = $action_cfg[$action_name];
            $param = $action_cfg['param'];
            $data['page_title'] = ucwords($module->description() . ' : ' .$action_name);
        }
        $validation = true;
        // Validate the data
        if($param){
            $validation = false;
            $param->set_data_values($post);
            // Validate the data
            $config = $param->get_data();
            $this->load->library("safe_form_class", $config);
            $this->safe_form_class->set_validation_obj($module);
            if ($this->safe_form_class->run_validation($validation_errors)) {
                $validation = true;
            }else{
                //return a json encode form with a error message
                $this->action_form($module_name, $action_name, true);
            }
        }
        
        if($validation){
            //run real action in module
            $method_name = $action_name;
            $output = array();
            if(method_exists($module,$method_name)){
                $result = call_user_func(array($module, $method_name), $post, &$output);
                if($result){
                    $data['message'] = $output['message'];
                    $data['message_type'] = 'info';
                    $data['result'] = true;
                } else {
                    $data['message'] = $output['message'];
                    $data['reason'] = $output['reason'];
                    $data['message_type'] = 'alert';
                    $data['result'] = false;
                }
            }else{
                $data['message'] = 'Not Implemented.';;
                $data['message_type'] = 'alert';
                $data['result'] = false;
            }
            
            $data['close_dialog'] = true;
            echo json_encode($data);
        }
    }
    public function download($module_name, $obj_type, $obj_name=null, $sub_type=null, $sub_name=null)
    {
        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name($module_name);
        // Get config object
        $cfg_obj = $module->config();
        $_type = $obj_type;
        $obj_keys = $module->get_aggregate_objects_keys($obj_type);
        if($obj_name && $sub_type){
            $_obj =  $module->get_aggregate_object($obj_type, $obj_name);
            if($_obj){
                $module = $_obj;
                $_type = $sub_type;
                $module = $module->get_aggregate_object($sub_type, $sub_name);
            }
        }
        
        if($module){
            $module->download();
        }else{
            header('HTTP/1.0 404 Not Found');
            exit();
        }
    }
}
/* End of file safe_edito.php */
