<?php
define ( 'FILE_WRITE_MODE', 0666 );
define ( 'DB_GROUPNAME', '/var/webconfig/SAFe/application/db/safe.db' );
define ( 'DB_TABLE', 'safe_object' );
define ( 'OBJ_STATUS_MODIFIED', 'M' );
define ( 'OBJ_STATUS_NEW', 'N' );
define ( 'OBJ_STATUS_UP_TO_DATE', 'U' );
define ( 'BASE_PATH', '/NSC/local/software' );
define ( 'COMMON_CORE_DIR', '/var/webconfig' );

function show_msg($msg = null) {
    if(!is_array($msg)){
      $msg = array($msg);
    }
    foreach ($msg as $msg_item){
        echo basename($_SERVER['SCRIPT_NAME']) . ' : ' .$msg_item  . PHP_EOL;
        error_log ( basename($_SERVER['SCRIPT_NAME']) . ' : ' .$msg_item  . PHP_EOL, 0 );
    }
}
function update_obj_class($db, $class = null) {
    if (is_array ( $class )) {
        $sql_update_obj_path = "update OR IGNORE " . DB_TABLE . " set class='{$class['new_name']}',modified=1,status='" . OBJ_STATUS_MODIFIED . "'," .
                "modified_date=datetime('now','localtime') where class = '{$class['old_name']}' ";
        $count = $db->exec ( $sql_update_obj_path );
        if ($count === false) {
            $error = "update  {$class['old_name ']} to  {$class['new_name']}  sql error ";
            show_msg($error . print_r($db->errorInfo(), true));
        }else{
            show_msg("class name changed ({$count}) : [{$class['old_name']}] => [{$class['new_name']}] ");
        }
    }
}
function update_obj_path($db, $objs = null) {
    if (is_array ( $objs )) {
        foreach ( $objs as $obj_data ) {
            $obj_class_name = $obj_data ['class_name'];
            $obj_path = BASE_PATH .'/' . $obj_data ['module'] . '/' . $obj_data ['type'];
            if(isset($obj_data['old_base_path'])){
                $limit_path = $obj_data['old_base_path'];
            }else{
                $limit_path = BASE_PATH;
            }
            $sql_get_obj  = "select path from ". DB_TABLE . " where class = '{$obj_data['class_name']}' and path like '" . $limit_path . "%' and path <> '{$obj_path}' limit 1";
            $get_obj_result = $db->query ( $sql_get_obj );
            $have_obj = false;
            foreach ( $get_obj_result as $row ){
                $obj_old_path = $row ["path"];
                $have_obj = true;
                break;
            }
            if($have_obj){
                // update obj path
                $sql_update_obj_path = "update OR IGNORE " . DB_TABLE . " set path='{$obj_path}',modified=1,status='" . OBJ_STATUS_MODIFIED . "'," .
                "modified_date=datetime('now','localtime') where class = '{$obj_data['class_name']}' and path like '" . $limit_path . "%' and path <> '{$obj_path}'";
                //var_dump($sql_update_obj_path);
                $count_obj_path = $db->exec ( $sql_update_obj_path );
                if ($count_obj_path === false) {
                    $error = "update  {$obj_data['module']} / {$obj_data['type']}  path  sql error ";
                    show_msg($error . print_r($db->errorInfo(), true));
                    return;
                } else {
                    show_msg("{$obj_data['module']} / {$obj_data['type']} {$obj_data['class_name']} path update : ({$count_obj_path}) record(s) updated.");
                    show_msg("path : [{$obj_old_path}] => [{$obj_path}] ");
                
                    if ($count_obj_path > 0 && is_array ( $obj_data ['sub_obj'] )) {
                        $sql = "select * from " . DB_TABLE . " where class = '{$obj_data['class_name']}' and path like '" . $limit_path . "%' ";
                        $result = $db->query ( $sql );
                        if ($result === false) {
                            $error = "get {$obj_data['module']} / {$obj_data['type']}  sql error ";
                            show_msg($error . print_r($db->errorInfo(), true) );
                            return;
                        } else {
                            foreach ( $result as $row ) {
                                foreach ( $obj_data ['sub_obj'] as $sub_obj ) {
                                    $obj_name = $row ["name"];
                                    $sql_get_sub_obj  = "select path from ". DB_TABLE . " where class = '{$sub_obj['class_name']}' and path like '" . $limit_path . "%{$obj_name}/{$sub_obj['type']}'  and path<>'{$sub_obj_path}' limit 1";
                                    $get_sub_obj_result = $db->query ( $sql_get_sub_obj );
                                    $have_sub_obj = false;
                                    foreach ( $get_sub_obj_result as $sub_row ){
                                        $sub_obj_old_path = $sub_row["path"];
                                        $have_sub_obj = true;
                                        break;
                                    }
                                    if($have_sub_obj){
                                        // update sub obj path
                                        $sub_obj_path = "{$obj_path}/{$obj_name}/{$sub_obj['type']}";
                                        $sql_update_sub_obj = "update OR IGNORE " . DB_TABLE . " set path= '{$sub_obj_path}'  " .
                                        ",modified=1,status='" . OBJ_STATUS_MODIFIED . "',modified_date=datetime('now','localtime') " .
                                        "where class = '{$sub_obj['class_name']}' and path like '" . $limit_path . "%{$obj_name}/{$sub_obj['type']}'  and path<>'{$sub_obj_path}'";
                                        $count_sub_obj = $db->exec ( $sql_update_sub_obj );
                                        if ($count_sub_obj === false) {
                                            $error = "update  {$obj_data['module']} / {$obj_data['type']} / {$obj_name} / {$sub_obj['type']} {$sub_obj['class_name']} path  sql error ";
                                            show_msg($error . print_r($db->errorInfo(), true) );
                                        } else {
                                            show_msg("{$obj_data['module']} / {$obj_data['type']} / {$obj_name} / {$sub_obj['type']} {$sub_obj['class_name']} path : ( {$count_sub_obj} ) record(s) updated.");
                                            show_msg("path : [{$sub_obj_old_path}] => [{$sub_obj_path}] ");
                                        }
                                    }
                                }
                            }
                        }
                    }
                }    
            }
        }
    }
}
function update_obj_config_path($db, $obj_config = null) {
    if(is_array($obj_config)){
        $obj_config_path = BASE_PATH ."/{$obj_config['module']}"; 
        if(isset($obj_config['old_base_path'])){
            $limit_path = $obj_config['old_base_path'];
        }else{
            $limit_path = BASE_PATH;
        }
        if(isset($obj_config['old_name'])){
            $limit_name = $obj_config['old_name'];
        }else{
            $limit_name = $obj_config['module'];
        }
        $sql_get_obj  = "select path from ". DB_TABLE . " where class = '{$obj_config['class_name']}' and name = '{$limit_name}' and path like '" . $limit_path . "%' and path<>'{$obj_config_path}' limit 1";
        $get_obj_result = $db->query ( $sql_get_obj );
        $have_obj = false;
        foreach ( $get_obj_result as $row ){
            $obj_old_path = $row["path"];
            $have_obj = true;
            break;
        }
        if($have_obj){
            $sql_obj_config = "update OR IGNORE " . DB_TABLE . " set path= '{$obj_config_path}', name = '{$obj_config['name']}' " .
            ",modified=1,status='" . OBJ_STATUS_MODIFIED . "',modified_date=datetime('now','localtime') " .
            " where class = '{$obj_config['class_name']}' and name = '{$limit_name}' and path like '" . $limit_path . "%' and path<>'{$obj_config_path}' ";
            //echo $sql_obj_config;
            $count_obj_config = $db->exec ( $sql_obj_config );
            if ($count_obj_config === false) {
                $error = "update  {$obj_config['module']} / {$obj_config['name']} path  sql error ";
                show_msg($error . print_r($db->errorInfo(), true));
            } else {
                show_msg("{$obj_config['module']} / {$obj_config['name']} {$obj_config['class_name']} path ({$count_obj_config}) record(s) updated.");
                show_msg("path : [{$obj_old_path}] => [{$obj_config_path}] ");
            }
        }
    }
} 
?>
