<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS Routing Config wrapper page
 * @author William Adam <william.adam@sangoma.com>
 *         
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
safe_require_controller('sng','config_manager');
class Fs_routing_config extends Sng_config_manager
{
    protected $_module = null;
    protected $_module_name = null;
    private $_dialplans=array();
    private $_preferences;
    public function __construct($module_name = 'routing')
    {
        parent::__construct();
        $this->_module_name = $module_name;
        $this->_module = $this->_the_app->find_module_by_name($module_name);
        $this->_dialplans = $this->_module->dialplans();
        $this->_preferences = $this->_the_app->api_retrieve_preferences();
    }
    public function index()
    {
        return $this->modify($this->_module_name);
    }

     public function edit($module_name, $obj_type = null, $obj_name = null, $sub_type = null, $sub_name = null)
     {
         // What type of object ?
         switch($obj_type){
         case 'advanced':
             // Enter in editor mode
             return $this->edit_advanced($obj_name);
             break;
         case 'basic':
             // Are we editing a basic rule object
             if($obj_name && $sub_type){
                 $this->edit_hide_menu = true;
             }
             break;
         }
         // Otherwise let config manager do its job
         return parent::edit($module_name, $obj_type, $obj_name, $sub_type, $sub_name);
     }
    public function modify($module_name, $obj_type=null, $obj_name=null)
    {
        // What type of object ?
        switch($obj_type){
        case 'basic':
            $this->modify_hide_menu = true;
            break;
        }
        // Otherwise let config manager do its job
        return parent::modify($module_name, $obj_type, $obj_name);
    }
    /**
     * Edit a dialplan
     * @param string $dialplan_name
     */
    public function edit_advanced($dialplan_name)
    {
        // Handle redirect
        if (isset($post['cancel']))
            redirect (base_url($this->router->fetch_class()) ,'refresh' );

        $post = $this->input->post();

        $dialplan = $this->_dialplans[$dialplan_name];
        $new_obj = false;
        if(!$dialplan) {
            // Create new one, check if from another dialplan
            if($post['src']){
                $tmp = explode('/',$post['src']);
                $src_type = $tmp[0];
                $src_template = $tmp[1];
            }
            // Create new dialplan
            //$dialplan = $this->_module->create_dialplan($dialplan_name,'advanced',false);
            $dialplan = $this->_module->create_aggregate_object('advanced', $dialplan_name);
            $dialplan->configure();
            $new_obj = true;
            if($src_type && $src_template) {
                $config = $dialplan->get_data_values(false);
                if($src_type == 'templates') {
                    $conf_dir = $this->_the_product->local_node()->configuration_manager()->directory('configuration');
                    if($this->_the_product->local_node()->os()->read_file($conf_dir.'/custom/dialplan/templates/'.$src_template, $content)) {
                        $config['data'] = "<!--\n";
                        $config['data'] .= "\tThis call routing plan has been generated out of a template '$src_template'.\n";
                        $config['data'] .= "\tNote that you need to change some data such as IP addresses, SIP profile names, regular expressions etc,\n";
                        $config['data'] .= "\tin order to make your dialplan work in your specific setup.\n";
                        $config['data'] .= "-->\n";
                        $config['data'] .= $content;
                    }
                } else if($src_type == 'users') {
                    $src_obj = $this->_dialplans[$src_template];
                    if($src_obj) {
                        $config = $src_obj->get_data_values(false);
                    }
                }
                $dialplan->set_data_values($config);
            }
        }
        $config = $dialplan->get_data_values(false);
        $config_form = $dialplan->get_data();
        unset($config_form['data']);

        // Set the basic data
        $data ['page_title'] = 'Dialplan';
        $data ['page_summary'] = 'This page allows managing the Dialplan.';
        $data ['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data ['page_small_icon'] = '/images/icons/16x16/icon-network.png';

        //Prepare table structure
        $data['table_size'] = '100%';
        $data['table_title'] = $dialplan->description(). ' : '.$dialplan_name;
        $data['text_mode'] = "xml";
        //$data['keyboard_mode'] = "emacs";
        //$data['keyboard_mode'] = "vim";
        $data['keyboard_mode'] = "standard";
        if(isset($this->_preferences)){
            $data['keyboard_mode'] = $this->_preferences->get_data_value('keyboard_mode',false);
            //$data['auto_hide'] = 'notif_warn';
            $data['notif_warn'][] = 'Editor mode is '.$this->_preferences->get_data_value('keyboard_mode',true)
                .' click '.safe_hyperlink('/SAFe/sng_settings_config','here').' to change.';
        }

        if(isset($config['data']) && !empty($config['data'])) {
            $data['editor_data'] = htmlspecialchars($config['data']);
        } else {
            $data['editor_data'] = "<extension name=\"main\" continue=\"true\">\n";
            $data['editor_data'] .= "\t<condition field=\"destination_number\" expression=\"(.*)\">\n";
            $data['editor_data'] .= "\t\t<action application=\"\" data=\"\" />\n";
            $data['editor_data'] .= "\t</condition>\n";
            $data['editor_data'] .= "</extension>";
            $data['editor_data'] = htmlspecialchars($data['editor_data']);
        }
        if($config_form){
            $data['form'] = $config_form;
        }
        
        $data['url_save'] = base_url($this->router->fetch_class()).'/save/'.$dialplan_name;
        $data['url_cancel'] = base_url($this->router->fetch_class());

        $this->load->view("safe_header", $data );
        $this->load->view("safe_confirm_dialog", $data);//load confirm dialog js and css
        $this->load->view("safe_hide_menu", $data );

        $this->load->view('safe_notifications',$data);
        if($data['keyboard_mode'] == "standard")
            $this->load->view("safe_texteditor",$data);
        else
            $this->load->view("safe_texteditor_ace",$data);
        $this->load->view("safe_footer", $data );
    }

    /**
     * Validates the XML entered within the textarea and returns true/false based on pass/fail
     * @param unknown_type $xml
     * @return boolean
     */
    private function validate_xml($xml) {
        $xml_doc = simplexml_load_string($xml);

        $result = $xml_doc->xpath('param');
        print_r ($result);
        return true;
    }
    public function save($dialplan_name){
        // verify if logged
        //safe_authenticate();
        // Check post request
        $post = $this->input->post();

        // Default is error
        $response = array(
            'result' => 'ERROR' );
        
        if (isset($post['data'])) {
            $dialplan_data = array(
                'data' => base64_decode($post['data']));
            // Validate XML
            //
            // Reload dialplan object
            if(isset($this->_dialplans[$dialplan_name])){
                $dialplan = $this->_dialplans[$dialplan_name];
            }else{
                //$dialplan = $this->_module->create_dialplan($dialplan_name,'advanced',false);
                $dialplan = $this->_module->create_aggregate_object('advanced', $dialplan_name);
                $dialplan->configure();
            }
            //validate xml
            $error = "";
            if (isset($post['description'])) {
                $dialplan_data['description'] = $post['description'];
            }
            
            if ($dialplan->validate($dialplan_data, $error)) {
                $dialplan->set_data_values($dialplan_data);
                if ($dialplan->save()) {
                    $response['result'] = "OK";
                    $response['redirect'] = base_url($this->router->fetch_class());
                }else{
                    $error = "Fail to save dialplan";
                    $response['message'] = $error;
                }
            }else{
                $response['message'] = $error;
            }

        }

        echo json_encode($response);
    }
}
