<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS Advanced Dialplan Class
 * @author: Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('object');
safe_require_class('hardware');
safe_module_require_class('fs', 'application');
class Fs_advanced_dialplan_class extends Safe_configurable_object_class
{
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }
    public function configure()
    {
        $this->add_field('description', 'Description', 'text', '' , 100);
        $this->add_field('data', 'XML Dialplan', 'text', '');
        parent::configure();
    }
    /**
     * Returns dialplan type
     * @return string
     */
    public function type()
    {
        return 'advanced';
    }
    public function description()
    {
        $desc = $this->get_data_value('description', false);
        if($desc){
            return $desc;
        }
        return parent::description();
    }
    function display_xml_error($xmlstr)
    {
        $xml = explode("\n", $xmlstr);
        $errors = libxml_get_errors();
        $return = array();
        foreach ($errors as $error) {
            /*
            switch ($error->level) {
            case LIBXML_ERR_WARNING:
            $return .= "Warning $error->code: ";
            break;
            case LIBXML_ERR_ERROR:
            $return .= "Error $error->code: ";
            break;
            case LIBXML_ERR_FATAL:
            $return .= "Fatal Error $error->code: ";
            break;
            }
            */
            $return[] = "Line: $error->line " . trim($error->message);
            
        }
        libxml_clear_errors();
        return $return;
    }
    public function validate($data, &$out_message=null)
    {
        // Steps to validate:
        //  1- Valid xml
        //  2- doesn't contain context element
        $xml_obj = null;
        // Disable error output
        libxml_use_internal_errors(true);
        $xml_validation = "<validation_____>" . $data['data'] . "\n</validation_____>";
        // Try to create a xml object
        $xml_obj = simplexml_load_string($xml_validation);
        if (!$xml_obj) {
            $out_message[] = "Invalid XML data.";
            $out_message = array_merge($out_message, $this->display_xml_error($xml_validation));
            return false;
        }
        // Check for context element
        if (false != $xml_obj->xpath("//context")) {
            $out_message[] = "Context element not allowed.";
            return false;
        }
        // Check if root has a value (i.e. text element)
        $root_value = trim((string)$xml_obj[0]);
        if (strlen($root_value)) {
            $out_message[] = "Text value not allowed outside XML elements." ;
            $out_message[] = $root_value;
            return false;
        }
        return parent::validate($data, $out_message);
    }
    public function summary($type = 'horizontal' , $long = false){
        $table_line = parent::summary($type , $long , 1);
        return $table_line;
    }
    public function can_dispose(&$reason = null)
    {
        $usages = $this->node()->software()->application()->check_object_usage('routing','advanced', $this->name());
        //check_object_usage does not inclue slef module
        $path = $this->object_name();
        $module = $this->node()->software()->application()->find_module_by_path($path);
        $usages = array_merge($usages , $module->check_object_usage('routing', 'advanced', $this->name()));
        if($usages){
            $reason['msg'] = "  {$this->name()} is used by ";
            $reason['obj'] = $usages;
            return false;
        }
        return parent::can_dispose($reason);
    }
}
class Fs_advanced_dialplan_hmr_class extends Fs_advanced_dialplan_class
{
    public function save($data, &$error)
    {
        $result = parent::save($data, &$error);
        if($result){
            //sent out modification event
            $receivers = $this->node()->software()->application()->check_object_modified('hmr','basic', $this->name());
        }
        return $result;
    }
    public function can_dispose(&$reason = null)
    {
        $usages = $this->node()->software()->application()->check_object_usage('hmr','advanced', $this->name());
        //check_object_usage does not inclue slef module
        $path = $this->object_name();
        $module = $this->node()->software()->application()->find_module_by_path($path);
        $usages = array_merge($usages , $module->check_object_usage('hmr', 'advanced', $this->name()));
        if($usages){
            $reason['msg'] = "  {$this->name()} is used by ";
            $reason['obj'] = $usages;
            return false;
        }
        return parent::can_dispose($reason);
    }
}
?>
