<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * Network Config wrapper page
 * @author William Adam <william.adam@sangoma.com>
 *         
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
safe_require_controller('sng','config_manager');
class Sng_user_config extends Sng_config_manager
{
    public function __construct()
    {
        parent::__construct();
    }
    public function index()
    {
        $this->check_https();
        return $this->modify('system', 'user');
    }
    public function check_https()
    {
        if(!$_SERVER['HTTPS'] || 'on' != $_SERVER['HTTPS']){
            // Cannot manage user from non secure page
            $data['page_title'] = 'Configuration Manager';
            $data['page_summary'] = 'This page allows managing System configuration.';
            $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
            $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';

            $data['notif_error'][] = 'User Management only allowed on HTTPS !!';

            $this->load->view("safe_header", $data);
            $this->load->view("safe_notifications", $data);
            $this->load->view("safe_footer", $data);
            return false;
        }
        return true;
    }
    // Override some CRUD functions to allow only root to CRUD
    // and restrict user to only edit it's own user
    // ACL so direct url access restricted
    public function add($module_name, $obj_type, $obj_name=null, $sub_type=null)
    {
        if($this->check_https()){
            $user = $_SESSION['user_login'];
            if('root' != $user){
                $this->allow_back = false;
                return parent::edit('system', 'user', $user);
            }
            return parent::add($module_name, $obj_type, $obj_name, $sub_type);
        }
    }

    public function modify($module_name, $obj_type=null, $obj_name=null)
    {
        if($this->check_https()){
            $user = $_SESSION['user_login'];
            if('root' == $user){
                $this->allow_back = true;
                return parent::modify('system', 'user');
            }else{
                $this->allow_back = false;
                // Only allow own user display
                return parent::edit('system', 'user', $user);
            }
        }
    }
    public function edit($module_name, $obj_type = null, $obj_name = null, $sub_type = null, $sub_name = null)
    {
        if($this->check_https()){
            $user = $_SESSION['user_login'];
            if('root' != $user){
                $this->allow_back = false;
                $obj_name = $user;
            }
            return parent::edit($module_name, $obj_type, $obj_name, $sub_type, $sub_name);
        }
    }
    public function delete($module_name, $obj_type, $obj_name, $sub_type=null, $sub_name=null)
    {
        if($this->check_https()){
            $user = $_SESSION['user_login'];
            if('root' != $user){
                $this->allow_back = false;
                return parent::edit('system', 'user', $user);
            }
            return parent::delete($module_name, $obj_type, $obj_name, $sub_type, $sub_name);
        }
    }
}
