<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * Generic license page
 * @author Michel Buczynski <mbucyznski@sangoma.com>
 *         
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('table');
class Sng_about extends Safe_CI_Controller
{
    public function __construct()
    {
        parent::__construct();
    }
    function index()
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_summary'] = 'This page displays detailed information about the product components.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-register.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-register.png';
        //$the_product = Safe_get_product();
        $data['page_title'] = $this->_the_product->name() . ' - About';
        // Get version object
        $version = $this->_the_product->local_node()->software()->version();
        // version_info contains names and version number
        $version_info = $version->info();
        // Prepare table header with full name + version
        $data['table_title'] = $version_info['full_name'] . " - " . $version_info['product_version'] . " (" . $version_info['release_version'] . ")";
        // Prepare table structure
        $table = new Safe_table_class();
        // Set heading
        $table->heading = array(
            'Module',
            'Branch',
            'Reference',
            'Date'
        );
        foreach ($version->components() as $k => $v) {
            $table->data[] = array(
                $k,
                $v['branch'],
                $v['hash'],
                $v['date'],
            );
        }
        // Set data
        // Generate table HTML code
        $data['table'] = $table->generate();
        // Add RPM list
        $data_rpm = array();
        if ($this->_the_product->local_node()->os()->execute("rpm -qa --queryformat='%{NAME}~%{VERSION}~%{SUMMARY}\\n'", $rpm_out, false)) {
            sort($rpm_out, SORT_STRING | SORT_FLAG_CASE);
            $data_rpm['table_title'] = 'System Packages';
            $table = new Safe_table_class();
            // Set heading
            $table->heading = array(
                'Package',
                'Version',
                'Summary'
            );
            foreach ($rpm_out as $rpm) {
                $rpm_detail = explode("~", $rpm);
                $table->data[] = array(
                    $rpm_detail[0],
                    $rpm_detail[1],
                    $rpm_detail[2],
                );
            }
            // Set data
            // Generate table HTML code
            $data_rpm['table'] = $table->generate();
        }
        // Add System info list
        // Used for license generation
        $data_sysinfo = array();
        $data_sysinfo['table_title'] = 'System Information';
        $table = new Safe_table_class();
        // Set heading
        $table->heading = array(
            'Key',
            'Value',
        );
        $sysinfo = $this->_the_app->system_info();
        foreach($sysinfo as $k => $v){
            $table->data[] = array(
                $k,
                $v,
            );
        }
        // Set data
        // Generate table HTML code
        $data_sysinfo['table'] = $table->generate();

        //show it
        $this->load->view("safe_header", $data);
        $this->load->view("safe_error");
        $this->load->view("safe_table", $data);
        if (!empty($data_sysinfo)) $this->load->view("safe_table", $data_sysinfo);
        if (!empty($data_rpm)) $this->load->view("safe_table", $data_rpm);
        $this->load->view("safe_footer", $data);
    }
}
