<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * SNG REST module class
*/
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_module_class');

class Sng_update_module_class extends Safe_module_class
{
    protected $_obj_base_path = '';
    /**
     * @brief
     *           
     * @param[in out] $fs_app
     *           
     * @return
     */
    public function __construct($app)
    {
        parent::__construct($app->node()->software(), "update");
    }
    public function get_data_settings($check_status = true)
    {
        $cfg_manager = $this->node()->configuration_manager();
        $data = array(
                'package' => array(
                        'description' => 'Software Package',
                        'filesystem' => true,
                        'singleton' => true,
                        'pattern' => $cfg_manager->directory('base') . '/rpm-update/*.tgz',
                        'global_capabilities_no_data' => array(
                                'upload'
                        ) ,
                        'capabilities' => array(
                                'install',
                                'delete',
                                'view'
                                ),
                        'methods' => array(
                                'upload' => array(
                                        'name' => 'Upload',
                                        'description' => array( 'Upload a package file.' ),
                                        'request' => 'POST',
                                ),
                                'description' => array(
                                        'name' => 'Get Package desription',
                                        'description' => 'Get Package desription',
                                        'request' => 'GET',
                                ),
                                'install' => array(
                                        'name' => 'Install',
                                        'description' => 'Install the update',
                                        'request' => 'POST',
                                ),
                                'status' => array(
                                        'name' => 'Get update status',
                                        'description' => 'Get update status',
                                        'request' => 'GET',
                                ),
                                'delete' => array(
                                        'name' => 'Delete',
                                        'description' => array( 'Delete a package file.' ),
                                        'request' => 'POST',
                                ),
                                'log' => array(
                                        'name' => 'Log',
                                        'description' => array( 'Get Package install log.' ),
                                        'request' => 'GET',
                                ),
                        ),
                )
        );
        if($check_status && !$this->can_install_data()){
            unset($data['package']['capabilities']);
            $data['package']['capabilities'] = array('delete','view');
        }
        return $data;
    }
    /**
     * @brief
     *         
     * @return
     */
    public function configure()
    {
        // Set the module description
        $this->set_description("Update");
        // Register objects
        /*
        $this->register_aggregate_object('package',
                array(
                        'name' => 'Package',
                        'base_path' => $this->object_name() . '/package',
                        'methods' => array(
                                'description' => array(
                                        'name' => 'Get Package desription',
                                        'description' => 'Get Package desription',
                                        'request' => 'GET',
                                ),
                                'start' => array(
                                        'name' => 'Install',
                                        'description' => 'Install the update',
                                        'request' => 'POST',
                                ),
                                'status' => array(
                                        'name' => 'Get update status',
                                        'description' => 'Get update status',
                                        'request' => 'GET',
                                ),
                                'upload' => array(
                                        'name' => 'Upload a Package',
                                        'description' => 'Upload an update',
                                        'request' => 'POST',
                                ),
                        ),
                )
        );
        */
        return parent::configure();
    }
    /**
     * @brief
     * clear the dir
     *
     * @return
     */
    public function delete_data($data_name, $data_key = null){
        parent::delete_data($data_name, $data_key);
        $data_cfg = $this->get_data_settings();
        $data_cfg = $data_cfg[$data_name];
        $file = $data_cfg['pattern'];
        $ext  = pathinfo($file);
        $os = $this->node()->os();
        $output = array();
        $rc = $os->rmdir($ext['dirname'].'/tmp');
        $rc = $os->mkdir($ext['dirname']);
        return true;
    }
    public function check($data_name = null, $param = null, &$output = null){
        $data_cfg = $this->get_data_settings();
        $data_cfg = $data_cfg[$data_name];
        $file = $data_cfg['pattern'];
        $ext  = pathinfo($file);
        $os = $this->node()->os();
        $file_list = $os->search_files($file);
        if($file_list)
        {
            $os = $this->node()->os();
            $rc = $os->execute($ext['dirname'].'/tmp/update/scripts/update.sh check ', $output, true, true);
            if($rc){
                return true;
            }
        }
        return false;
    }
    public function info($data_name = null, $param = null, &$output){
        // Check if specified update package can be install
        $package_data = array();
        $rs = $this->api_description_package($data_name, $param, $package_data);
        if($rs){
            //make sure all keys are lowercase and no space (replace by '_')
            $tmp = array();
            foreach($package_data as $key => $value){
                $tmp[strtolower(str_replace(' ','_',$key))] = $value;
            }
            $tmp['type'] = 'update';
            $tmp['data_name'] = $data_name;
            $tmp['data'] = $param;
            return $tmp;
        }
        $output[] = 'Fail to get package description !';
        return false;
    }
    public function log(&$output = null){
        $data_cfg = $this->get_data_settings();
        $data_cfg = $data_cfg['package'];
        $file = $data_cfg['pattern'];
        $ext  = pathinfo($file);
        $os = $this->node()->os();
        $file_list = $os->search_files($file);
        if($file_list)
        {
            $rc = $os->execute($ext['dirname'].'/tmp/update/scripts/update.sh logs ', $output, true, true);
            if($rc){
                return true;
            }else{
                $output = null;
            }
        }
        return false;
    }
    public function describe_data($data_name = null, $data_key = null, &$output = null)
    {
        return $this->api_description_package($data_name, null, $output);
    }
    public function install_data($data_name = null, $data_key = null, &$output = null)
    {
        return $this->api_install_package($data_name, $data_key, $output);
    }
    public function can_install_data($info = null, &$output = null)
    {        
        $output_data = array();
        $rs = $this->api_status_package($info['data_name'], $info['data'], $output_data);
        # 0 - Completed success
        # 1 - Running
        # -1 - Not Initialized/Dead
        # -2 - Not started //254
        if($rs == 254){
            return true;
        }
        if(isset($output)){
            $output = $output_data;
        }
        return false;
    }
    public function initialize_data($data_name = null, $data_key = null, &$output = null)
    {
        $data_cfg = $this->get_data_settings();
        $data_cfg = $data_cfg['package'];
        $file = $data_cfg['pattern'];
        $ext  = pathinfo($file);
        $os = $this->node()->os();
        $file_list = $os->search_files($file);
        if($file_list)
        {
            $os->rmdir($ext['dirname'].'/tmp');
            if ($os->mkdir($ext['dirname'].'/tmp')){
                $rc = $os->execute('tar -xzvf ' . $file_list[0].' -C '. $ext['dirname'].'/tmp/', $output, true, true);
                if($rc){
                    // run mkdir again so ownership is changed
                    $os->mkdir($ext['dirname'].'/tmp');
                    //init
                    $rc = $os->execute($ext['dirname'].'/tmp/update/scripts/update.sh initialize ', $output, true, true);
                    if($rc){
                        return true;
                    }
                }
            }
        }
        $this->delete_data($data_name);
        return false;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return
     */
    public function api_description_package($name, $data = null, &$output = null){
        $data_cfg = $this->get_data_settings(true);
        $data_cfg = $data_cfg['package'];
        $file = $data_cfg['pattern'];
        $ext  = pathinfo($file);
        $os = $this->node()->os();
        $file_list = $os->search_files($file);
        if($file_list)
        {
            $rc = $os->execute($ext['dirname'].'/tmp/update/scripts/update.sh version ', $version, true, true);
            if($rc){
                foreach($version as $line){
                    $items = explode('=',$line);
                    $output[$items[0]] = $items[1];
                }
                return true;
            }
        }
        return false;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return
     */
    public function api_install_package($name, $data = null, &$output = null){
        $info = $this->info($name, $data, $output);
        $the_product = Safe_get_product();
        if($info && $the_product->can_install_data($info, $output)){
            $data_cfg = $this->get_data_settings();
            $data_cfg = $data_cfg['package'];
            $file = $data_cfg['pattern'];
            $ext  = pathinfo($file);
            $os = $this->node()->os();
            $file_list = $os->search_files($file);
            if($file_list)
            {
                $rc = $os->execute($ext['dirname'].'/tmp/update/scripts/update.sh start ', $output, true, true);
                if($rc){
                    sleep(1);
                    do {
                        $os->execute($ext['dirname'].'/tmp/update/scripts/update.sh status ', $output, true, true, &$status, false);
                        sleep(0.5);
                    } while(1 == $status);
                    if(0 != $status){
                        error_log('ERROR - Install Package returns error <'.$status.'>');
                        error_log('ERROR - Install Package Output='.print_r($output, true));
                    }
                    // Clear session cache
                    safe_session_clear_cache();
                    return ($status==0)?true:false;
                }
            }
        }
        return false;
    }
    public function api_start_package($name, $data = null, &$output = null){
        $data_cfg = $this->get_data_settings();
        $data_cfg = $data_cfg['package'];
        $file = $data_cfg['pattern'];
        $ext  = pathinfo($file);
        $os = $this->node()->os();
        $file_list = $os->search_files($file);
        if($file_list)
        {
            $rc = $os->execute($ext['dirname'].'/tmp/update/scripts/update.sh start ', $output, true, true);
            if($rc){
                return true;
            }
        }
        return false;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return
     */
    public function api_status_package($name = null, $data = null, &$output = null){
        $data_cfg = $this->get_data_settings(false);
        $data_cfg = $data_cfg['package'];
        $file = $data_cfg['pattern'];
        $ext  = pathinfo($file);
        $os = $this->node()->os();
        $file_list = $os->search_files($file);
        if($file_list)
        {
            $status = null;
            $rc = $os->execute($ext['dirname'].'/tmp/update/scripts/update.sh status ', $output, true, true, &$status, false);
            // Clear session cache (TODO: Check status return code and clear
            // only when update completed)
            safe_session_clear_cache();
            return $status;
        }else{
            return false;
        }
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return
     */
    public function api_upload_package($name, $data = null, &$output = null){
        $data_def = $this->get_data_settings();
        $upload_api_method  = $data_def['package']['methods']['upload']['request'];
        if($upload_api_method){
            //initialize_data called in  upload_data() 
            return $this->upload_data('package', $name , $output , $upload_api_method);
        }else{
            $output['message'] = 'Upload request method error.';
            return false;
        }
    }
    public function api_delete_package($name=null, $data = null, &$output = null){
        return $this->delete_data('package', $name);
    }
    private function log_format($str){
        return '<pre>' .$str . '</pre>';
    }
    public function api_log_package($name = null, $data = null, &$output = null){
        $rs = $this->log($output);
        if(!$output){
            $output[] = '';
        }
        $output = array_map(array($this, 'log_format'), $output);
        return $rs;
    }
    public function get_data_file_content_by_key($data_name = null, $key= null, $line_count = null, $max_size = null)
    {
        $output = array();
        $data_cfg = $this->get_data_settings();
        $data_cfg = $data_cfg['package'];
        $file = $data_cfg['pattern'];
        $ext  = pathinfo($file);
        $os = $this->node()->os();
        $file_list = $os->search_files($file);
        if($file_list)
        {
            $os = $this->node()->os();
            if($this->can_install_data()){
                $rc = $os->execute($ext['dirname'].'/tmp/update/scripts/update.sh check ', $check, true, true);
                $rc2 = $os->execute($ext['dirname'].'/tmp/update/scripts/update.sh changelog ', $changelog, true, true);
                if($rc && $rc2){
                    if($check) {
                        $output[] = 'Packages to be updated:';
                        $output[] = '----------------------';
                        $output = array_merge($output, $check);
                        $output[] = '';
                        $output[] = '';
                    }
                    if($changelog) {
                        $output[] = 'Changelog:';
                        $output[] = '---------';
                        $output = array_merge($output, $changelog);
                    }
                }
            }
        }
        $install_log = array();
        $rs3 = $this->log($install_log);
        if($rs3){
            if($install_log) {
                $output[] = 'Install log:';
                $output[] = '---------';
                $output = array_merge($output, $install_log);
            }
        }
        return implode(PHP_EOL,$output);
    }
}
/* End of file sng_update_module_class.php */
