<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * Node class
*/
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_os_class');
safe_require_class('safe_software_class');
safe_require_class('safe_hardware_class');
safe_require_class('safe_object_class');
class Sng_transcoding_module_class extends Safe_configurable_object_class
{
    public function __construct($node, $path,$name)
    {
            parent::__construct($path, $name, $node);
    }
    public function configure($version = null, $capacity = null, $port = null, $network_cfg = null)
    {
        if (!isset($network_cfg)) {
            $network_cfg = array(
                'ip_address' => '',
                'mask' => '',
                'gateway' => '',
                'udp_begin' => '14000',
                'udp_end' => '16000',
                'ext_ip_address' => '',
                'vlan_id' => '',
                'vqe/acoustic_echo' => '0',
                'vqe/rx_adaptive_noise_reduction' => '0',
                'vqe/rx_automatic_level_control' => '0',
                'vqe/rx_automatic_level_control_target_dbm0' => -21,
                'vqe/tx_automatic_level_control' => '0',
                'vqe/tx_automatic_level_control_target_dbm0' => -21,
            );
        }
        // Create configuratble fields
        $this->add_enum_field('enable', 'Enable', 'dropdown', 'true', $this->enable_disable_enum());
        $this->set_field_help('enable', 'Enable/Disable this particular module.');
        $this->add_field('mac', 'MAC Address', 'string', $this->name());
        $this->set_field_disabled('mac', 'disabled');
        $this->add_field('version', 'Version', 'string', $version);
        $this->set_field_disabled('version', 'disabled');
        $this->add_field('capacity', 'Capacity', 'hidden', $capacity);
        $this->add_field('port', 'Port', 'hidden', $port);
        // Network config
        $this->add_field('ip_address', 'IP address', 'text', $network_cfg['ip_address']);
        $this->set_field_rules('ip_address', 'required[enable]|valid_ip');
        $this->set_field_help('ip_address', 'IP address of this particular module.');
        $this->add_field('ext_ip_address', 'External IP address', 'text', $network_cfg['ext_ip_address']);
        $this->set_field_rules('ext_ip_address', 'valid_ip');
        $this->set_field_help('ext_ip_address', array(
            'Optional parameter.',
            'IP address used by gateway in the SDP offer or answer. ',
            'If not specified, gateway uses the assigned IP address to the media interface(default behavior).',
            'When gateway is behind a firewall (ie: DMZ or port-forwarding) with RTP ports being forwarded to the media interface, it may be desirable to specify this parameter to an IP address that will be mapped by the firewall port-forwarding capabilities to the internal IP address of the media interface, if not set when working under a DMZ or port-forwarding scenario, calls may end up not having audio.'
        ));
        $this->add_field('vlan_id', 'VLAN Identifier', 'string', $network_cfg['vlan_id'], 10);
        $this->set_field_rules('vlan_id', 'greater_than[0]|less_than[4097]');
        $this->set_field_help('vlan_id', array(
            '(Optional) Identifies which VLAN this module is part of.',
            'If the VLAN ID was entered in the Media Interface, it does not need to be entered here unless the VLAN ID is different.',
            'A VLAN ID is not required, and will be ignored, when the Media Interfaces are set to Hidden.'
        ));
        $this->add_field('mask', 'Network Mask', 'text', $network_cfg['mask']);
        $this->set_field_rules('mask', 'required[enable]|valid_ip');
        $this->set_field_help('mask', 'Subnet Mask of this particular module');
        $this->add_field('gateway', 'Gateway', 'text', $network_cfg['gateway']);
        $this->set_field_rules('gateway', 'valid_ip');
        $this->set_field_help('gateway', 'Default gateway of this particular module.');
        $this->add_field('udp_begin', 'First UDP port', 'text', $network_cfg['udp_begin']);
        $this->set_field_rules('udp_begin', 'required|valid_port_number|greater_or_equal[5004]');
        $this->set_field_help('udp_begin', 'Starting UDP port being used by this module');
        $this->add_field('udp_end', 'Last UDP port', 'text', $network_cfg['udp_end']);
        $this->set_field_rules('udp_end', 'required|valid_port_number');
        $this->set_field_help('udp_end', 'Ending UDP port being used by this module.');
        // Hiden stuff for module config
        $this->add_field('max_sessions', 'Maximum number of sessions', 'hidden', '960');
        $this->add_field('session_high_watermark', 'Session High Watermark', 'hidden', '500');
        $this->add_field('session_low_watermark', 'Session Low Watermark', 'hidden', '450');
        // VQE
        $this->add_enum_field('vqe/acoustic_echo', 'Acoustic Echo Cancellation', 'dropdown',  $network_cfg['vqe/acoustic_echo'], $this->enable_disable_enum(false));
        $this->set_field_disabled('vqe/acoustic_echo', 'disabled');
        $this->set_field_help('vqe/acoustic_echo',
            array(
                'Enable acoustic echo cancellation for all media sessions.',
                'This reduces echo on calls but increases the possibility of double-talk clipping.',
                'Use this value for situations where the echo path is highly non-linear.',
                '<font color="red">Note that enabling this feature will reduce your call capacity in about 35%.</font>')
            );

        $this->add_enum_field('vqe/rx_adaptive_noise_reduction', 'Adaptive Noise Reduction', 'dropdown', $network_cfg['vqe/rx_adaptive_noise_reduction'], $this->enable_disable_enum(false));
        $this->set_field_disabled('vqe/rx_adaptive_noise_reduction', 'disabled');
        $this->set_field_help('vqe/rx_adaptive_noise_reduction',
            array(
                'Enable Adaptive Noise Reduction for all media sessions.',
                'This removes the noise present while leaving voice intact.',
                '<font color="red">Note that enabling this feature will reduce your call capacity in about 35%.</font>')
            );

        $this->add_enum_field('vqe/rx_automatic_level_control', 'Automatic Level Control (RX)', 'dropdown', $network_cfg['vqe/rx_automatic_level_control'], $this->enable_disable_enum(false));
        $this->set_field_disabled('vqe/rx_automatic_level_control', 'disabled');
        $this->set_field_help('vqe/rx_automatic_level_control',
            array(
                'Enable RX Automatic Level Control for all media sessions.',
                'Using the level threshold limit specified in Automatic Level Control Target, dBm0 level is being filtered.',
                '<font color="red">Note that enabling this feature will reduce your call capacity in about 15%.</font>')
            );
        $this->add_field('vqe/rx_automatic_level_control_target_dbm0', 'Target', 'integer', $network_cfg['vqe/rx_automatic_level_control_target_dbm0'], 5);
        $this->set_field_rules('vqe/rx_automatic_level_control_target_dbm0', 'required[vqe/rx_automatic_level_control]|integer|greater_or_equal[-42]|less_or_equal[-6]');
        $this->set_field_disabled('vqe/rx_automatic_level_control_target_dbm0', 'disabled');
        $this->composite_layout('vqe/rx_automatic_level_control', array('vqe/rx_automatic_level_control_target_dbm0'));

        $this->add_enum_field('vqe/tx_automatic_level_control', 'Automatic Level Control (TX)', 'dropdown', $network_cfg['vqe/tx_automatic_level_control'], $this->enable_disable_enum(false));
        $this->set_field_help('vqe/tx_automatic_level_control',
            array(
                'Enable TX Automatic Level Control for all media sessions.',
                'Using the level threshold limit specified in Automatic Level Control Target, dBm0 level is being filtered.',
                '<font color="red">Note that enabling this feature will reduce your call capacity in about 15%.</font>')
            );
        $this->set_field_disabled('vqe/tx_automatic_level_control', 'disabled');
        $this->add_field('vqe/tx_automatic_level_control_target_dbm0', 'Target', 'integer',  $network_cfg['vqe/tx_automatic_level_control_target_dbm0'], 5);
        $this->set_field_rules('vqe/tx_automatic_level_control_target_dbm0', 'required[vqe/tx_automatic_level_control]|integer|greater_or_equal[-42]|less_or_equal[-6]');
        $this->set_field_disabled('vqe/tx_automatic_level_control_target_dbm0', 'disabled');
        $this->composite_layout('vqe/tx_automatic_level_control', array('vqe/tx_automatic_level_control_target_dbm0'));

        // Add Conditional Control for module
        // 1. create the group control 'module'
        $this->create_group('module', array(
            'ip_address',
            'ext_ip_address',
            'mask',
            'gateway',
            'udp_begin',
            'udp_end',
            'vlan_id',
        ));
        // 2. tell the field 'global/http' which existing group it can control (http)
        $this->conditional_control('enable', 'module');

        // Set categories
        $this->set_field_category('enable', 'General');
        $this->set_field_category('ip_address', 'Network');
        $this->set_field_category('vqe/acoustic_echo', 'VQE');
        return parent::configure();
    }
    public function mac()
    {
        return $this->get_data_value('mac');
    }
    public function ip_address()
    {
        return $this->get_data_value('ip_address');
    }
    public function vlan_id()
    {
        return $this->get_data_value('vlan_id');
    }
    public function ext_ip_address()
    {
        return $this->get_data_value('ext_ip_address');
    }
    public function mask()
    {
        return $this->get_data_value('mask');
    }
    public function gateway()
    {
        return $this->get_data_value('gateway');
    }
    public function version()
    {
        return $this->get_data_value('version');
    }
    public function capacity()
    {
        return $this->get_data_value('capacity');
    }
    public function port()
    {
        return $this->get_data_value('port');
    }
    public function udp_begin()
    {
        return $this->get_data_value('udp_begin');
    }
    public function udp_end()
    {
        return $this->get_data_value('udp_end');
    }
    public function enable()
    {
        return ('true' == $this->get_data_value('enable', false));
    }
    public function max_sessions()
    {
        return $this->get_data_value('max_sessions');
    }
    public function set_enable($enable)
    {
        $this->_enable = ($enable === true);
    }
    public function vqe()
    {
        $data = $this->get_data_values_exploded(false);

        return $data['vqe'];
    }
    public function validate($data, &$output){
        $validate_result = parent::validate($data, $output);
        $new_data = $this->get_data_values(false);
        if($new_data['enable'] == 'true'){
            $port_begin = intval($new_data['udp_begin']);
            $port_end = intval($new_data['udp_end']);
            $rule_msgs = array('udp_end' => 'Last UDP port must greater than first UDP port');
            if($port_begin >= $port_end ){
                $validate_result = false;
                $this->set_form_error('udp_end',$rule_msgs['udp_end']);
            }    
        }
        return $validate_result;
    }
}
/* End of file safe_transcoding_module_class.php */
