<?php

///////////////////////////////////////////////////////////////////////////////
//
// Copyright 2011 Sangoma Technologies Corp.
//
///////////////////////////////////////////////////////////////////////////////
//
// Author: Jean-Philippe Boily, jr. eng.
// Date: 10/06/2011
// Description:
//
// TODO - This file must be used to create the SngProduct php class that 
// loads its information based on the prod-def.xml file
//
// Currently returns the xml file content and allow the user to retrive a 
// specific parameter for a give product name.
//
///////////////////////////////////////////////////////////////////////////////

// Returns the xml object loaded from the file given in parameter
function parseProdDefXML($in_licenseConfFilePath) {
  $dom = new DOMDocument();
  $dom->load($in_licenseConfFilePath);
  $dom->xinclude();

  $xml = simplexml_import_dom($dom);

  if( $xml == "" ) {
    return null;
  }

  return $xml;
}

// Scans the SNG prod-def xml object to locate a specific item in a product
//
// parameters:
// in_xml: the xml object to be scanned
// in_productName: the name of the product
// in_key: the xml tag we are looking for
// out_value: the value of the xml tag
//
// returns true if product name/key were found; false if not
function getProductValue($in_xml, $in_productName, $in_key, &$out_value)
{
  if( 'product' == $in_xml->getName() ) {
        $out_value = $in_xml->$in_key;
        return true;
  } else {
    foreach( $in_xml->children() as $child ) {
      if( $child['name'] == $in_productName ) {
        $out_value = $child->$in_key;
        return true;
      }
    }
  }
  return false;
}

// Register the product name of the current page in the php session
function registerProduct($in_productName) {
  $_SESSION['product'] = $in_productName;
}

// Return the current product name stored in the php session
function getProductName() {
  if( isset($_SESSION['product']) ) {
    return $_SESSION['product'];
  }

  return "";
}
?>
