<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * NSC Media Monitor Service Class
 * @author William Adam
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_service_class');
safe_require_class('safe_db_class');
safe_module_require_class('nsc', 'product');
safe_module_require_class('nsc', 'application');
safe_module_require_class('fs', 'module');
safe_module_require_class('nsc', 'mediamon_config');
class Nsc_mediamon_service_class extends Safe_service_class
{
    private $_rules;
    function __construct($node, $software)
    {
        parent::__construct($software, 'mediamon');
        $this->_node = $node;
        // Override run_dir for ipd file
        $this->_run_dir = '/usr/local/nsc/run';
    }
    //Information pulled for the object
    public function configure()
    {
        // Create the object
        $cfg = new Nsc_mediamon_config_class($this->_node, $this->object_name(), $this->name());
        // Create the fields
        $cfg->configure();
        // Synchronize with persistent DB (safe_object table)
        $cfg->synch();
        // Register config to service
        $this->set_config($cfg);
        // Set service description
        $this->set_description('Media Firewall');
        return parent::configure();
    }
    /**
     * @brief indicate if user can control service start/stop...
     *         Overloaded from Safe_service_class
     *         
     * @return false
     */
    public function allow_user_ctl()
    {
        // User not allowed to control service
        return false;
    }
    public function can_restore($info, &$reason)
    {
        return true;
    }
    function db()
    {
        $tmp_db_cfg = $this->config()->get_data_values_exploded();
        // Filter out db-cfg
        $cfg_db = $tmp_db_cfg['db-cfg'];
        //will return the array needed to create the db connection (key=>value)
        $db = Safe_database_class::factory($cfg_db);
        return $db;
    }
    /**
     * @brief Generate MEDIAMON configuration
     *           
     * @param[in out] $config_manager
     *           
     * @return true on success
     */
    public function generate_config(&$config_manager)
    {
        //Generates service configuration files
        if (!$this->_generate_service_config($config_manager)) return false;
        //Generates database configuration
        if (!$this->_generate_db_config($config_manager)) return false;
        // Invoke parent generate
        return parent::generate_config($config_manager);
    }
    public function _generate_service_config(&$config_manager)
    {
        // Get our configuration data (unresolved)
        $cfg = $this->config()->get_data_values_exploded(false);
        // Remove global config - Used by service control script (application)
        unset($cfg['global']);
        if (isset($cfg['__all__'])) unset($cfg['__all__']);
        // Create xml document
        $xml_writer = new XMLWriter();
        $xml_writer->openMemory();
        $xml_writer->startDocument('1.0', 'UTF-8');
        // Document container
        $xml_writer->startElement('document');
        $xml_writer->writeAttribute('type', 'mediamon/xml');
        // Process database configuration
        $xml_writer->startElement('database');
        // Create connection-sting
        // <param name="connection-string"
        // value="DRIVER={MySQL};DATABASE=nsc;server=localhost;user=root;pwd=sangoma;port=3306"/>
        $connection_string = 'DRIVER={' . $cfg['db-cfg']['dbdriver'] . '};' . 'DATABASE=' . $cfg['db-cfg']['database'] . ';' . 'server=' . $cfg['db-cfg']['hostname'] . ';' . 'user=' . $cfg['db-cfg']['username'] . ';' . 'pwd=' . $cfg['db-cfg']['password'] . ';' . 'port=' . $cfg['db-cfg']['port'] . ';';
        $xml_writer->startElement('param');
        $xml_writer->writeAttribute('name', 'connection-string');
        $xml_writer->writeAttribute('value', $connection_string);
        $xml_writer->fullEndElement();
        foreach ($cfg['database'] as $k => $v) {
            $xml_writer->startElement('param');
            $xml_writer->writeAttribute('name', $k);
            $xml_writer->writeAttribute('value', $v);
            $xml_writer->fullEndElement();
        }
        // Remove database config entries
        $xml_writer->fullEndElement();
        unset($cfg['database']);
        unset($cfg['db-cfg']);
        // Add all parameters
        foreach ($cfg as $category => $cat_cfg) {
            $xml_writer->startElement($category);
            foreach ($cat_cfg as $k => $v) {
                $xml_writer->startElement('param');
                $xml_writer->writeAttribute('name', $k);
                $xml_writer->writeAttribute('value', $v);
                $xml_writer->fullEndElement();
            }
            $xml_writer->fullEndElement();
        }
        // Close settings
        $xml_writer->fullEndElement();
        $xml_writer->endDocument();
        $xmlstr = Safe_format_xml($xml_writer->outputMemory(true));
        $file = $config_manager->directory('base') . '/etc/' . $this->name() . '.xml';
        $config_manager->add_config(new Safe_configuration_class($file, $xmlstr));
        return true;
    }
    public function _generate_db_config(&$config_manager)
    {
        // First clear all records from db
        $db = $this->db();
        $data['db_class'] = $this->db();
        $config_manager->add_config(new Safe_configuration_class('media_modules', $data, Safe_configuration_class::CFG_EMPTY, Safe_configuration_class::CFG_SQL));
        $transcoding_if = $this->node()->hardware()->adapters();
        // Get mediamon state
        $cfg = $this->config()->get_data_values_exploded(false);
        // Do we need to generate a new modules tables ?
        if ('true' == $cfg['global']['NSC_MEDIAMON_ENABLE']) {
            foreach ($transcoding_if as $if => $obj) {
                foreach ($obj->modules() as $mod) {
                    if ($mod->enable()) {
                        unset($data);
                        $data['db_class'] = $db;
                        unset($value);
                        $value['ip_address'] = $mod->ip_address();
                        $value['access_interface'] = $if;
                        $value['port_range_start'] = $mod->udp_begin();
                        $value['port_range_stop'] = $mod->udp_end();
                        $data['data'] = $value;
                        $config_manager->add_config(new Safe_configuration_class('media_modules', $data, Safe_configuration_class::CFG_CREATE, Safe_configuration_class::CFG_SQL));
                    }
                }
            }
        }
        return true;
    }
    public function get_global_variables()
    {
        $vars = parent::get_global_variables();
        $cfg = $this->config()->get_data_values_exploded(false);
        // Get mediamon state
        $vars['single_ip_media'] = $cfg['global']['NSC_MEDIAMON_ENABLE'];
        return $vars;
    }
    public function category()
    {
        return 'Security';
    }
    /**
     * @brief
     *         
     * @return
     */
    public function get_data_settings()
    {
        $cfg_manager = $this->node()->configuration_manager();
        $data = array(
            'log' => array(
                'description' => 'Log file',
                'filesystem' => true,
                'pattern' => '/var/log/' . $this->name() . '.log*',
                'global_capabilities' => array(
                    'download'
                ) ,
                'capabilities' => array(
                    'download',
                    'view'
                ) ,
                'methods' => array(
                        'download' => array(
                                'name' => 'Download',
                                'description' => array( 'Download log files.' ),
                                'request' => 'GET',
                        )
                )
            )
        );
        return $data;
    }
    public function api_download_log($name=null, $data = null, &$output = null){
        $this->download_data('log', $name);
        exit();
    }
}
