<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * CodeMirror filetree and editor example page
 *
 * @author Michel Buczynski
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('safe_product_class');
class Sng_config_editor extends Safe_CI_Controller
{
    private $_root;
    public function __construct()
    {
        parent::__construct();
        //$the_product = Safe_get_product();
        $this->_root = $this->_the_product->local_node()->configuration_manager()->directory('configuration');
    }
    public function index()
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Advanced settings';
        $data['page_summary'] = 'This page allows to edit configuration files';
        $data['page_large_icon'] = '/images/icons/32x32/icon-register.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-register.png';
        $data['errors'] = array();
        $data["editorFilename"] = "";
        $data['tree_file_loader'] = "sng_config_editor/loader";
        $data['treefile_root'] = $this->_root;
        $this->load->view("safe_header", $data);
        $this->load->view("safe_filetree_editor", $data);
        $this->load->view("safe_footer", $data);
    }
    public function loader()
    {
        //this is the loader script for jqueryFileTree
        $root = $this->_root;
        include "js/jqueryFileTree/connectors/jqueryFileTree.php";
    }
}
