<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/* 
 * Monitoring Event email template 
 *
 * Parameters:
 *     $title      = Title
 *     $product    = Product name
 *     $server_uri = URL of management interface, to display as hyperlink
 *     $image      = URL of image to display in header
 *     $level      = Notification level={Information, Error, Crititcal
 *     $events     = Event array
*/
?>
<?php
if(!isset($image)){
    $image = "http://www.sangoma.com/wp-content/uploads/2012/12/logo.gif";
    // $image = "http://wiki.sangoma.com/files/NSC-Quick-Start-Guide/NSC_logo.png";
}
// Create uri if not specified
if(!isset($server_uri)){
    $server_uri = base_url();
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        
        <!-- Facebook sharing information tags -->
        <meta property="og:title" content="<?php echo $title;?>" />
        
        <title><?php echo $title;?></title>
		<style type="text/css">
			/* Client-specific Styles */
			#outlook a{padding:0;} /* Force Outlook to provide a "view in browser" button. */
			body{width:100% !important;} .ReadMsgBody{width:100%;} .ExternalClass{width:100%;} /* Force Hotmail to display emails at full width */
			body{-webkit-text-size-adjust:none;} /* Prevent Webkit platforms from changing default text sizes. */

			/* Reset Styles */
			body{margin:0; padding:0;}
			img{border:0; height:auto; line-height:100%; outline:none; text-decoration:none;}
			table td{border-collapse:collapse;}
			#backgroundTable{height:100% !important; margin:0; padding:0; width:100% !important;}

			/* Template Styles */

			/* /\/\/\/\/\/\/\/\/\/\ STANDARD STYLING: COMMON PAGE ELEMENTS /\/\/\/\/\/\/\/\/\/\ */

			/**
			* @tab Page
			* @section background color
			* @tip Set the background color for your email. You may want to choose one that matches your company's branding.
			* @theme page
			*/
			body, #backgroundTable{
				/*@editable*/ background-color:#FAFAFA;
			}

			/**
			* @tab Page
			* @section email border
			* @tip Set the border for your email.
			*/
			#templateContainer{
				/*@editable*/ border: 1px solid #DDDDDD;
			}

			/**
			* @tab Page
			* @section heading 1
			* @tip Set the styling for all first-level headings in your emails. These should be the largest of your headings.
			* @style heading 1
			*/
			h1, .h1{
				/*@editable*/ color:#202020;
				display:block;
				/*@editable*/ font-family:Arial;
				/*@editable*/ font-size:34px;
				/*@editable*/ font-weight:bold;
				/*@editable*/ line-height:100%;
				margin-top:0;
				margin-right:0;
				margin-bottom:10px;
				margin-left:0;
				/*@editable*/ text-align:left;
			}

			/**
			* @tab Page
			* @section heading 2
			* @tip Set the styling for all second-level headings in your emails.
			* @style heading 2
			*/
			h2, .h2{
				/*@editable*/ color:#202020;
				display:block;
				/*@editable*/ font-family:Arial;
				/*@editable*/ font-size:30px;
				/*@editable*/ font-weight:bold;
				/*@editable*/ line-height:100%;
				margin-top:0;
				margin-right:0;
				margin-bottom:10px;
				margin-left:0;
				/*@editable*/ text-align:left;
			}

			/**
			* @tab Page
			* @section heading 3
			* @tip Set the styling for all third-level headings in your emails.
			* @style heading 3
			*/
			h3, .h3{
				/*@editable*/ color:#202020;
				display:block;
				/*@editable*/ font-family:Arial;
				/*@editable*/ font-size:26px;
				/*@editable*/ font-weight:bold;
				/*@editable*/ line-height:100%;
				margin-top:0;
				margin-right:0;
				margin-bottom:10px;
				margin-left:0;
				/*@editable*/ text-align:left;
			}

			/**
			* @tab Page
			* @section heading 4
			* @tip Set the styling for all fourth-level headings in your emails. These should be the smallest of your headings.
			* @style heading 4
			*/
			h4, .h4{
				/*@editable*/ color:#202020;
				display:block;
				/*@editable*/ font-family:Arial;
				/*@editable*/ font-size:22px;
				/*@editable*/ font-weight:bold;
				/*@editable*/ line-height:100%;
				margin-top:0;
				margin-right:0;
				margin-bottom:10px;
				margin-left:0;
				/*@editable*/ text-align:left;
			}

			/* /\/\/\/\/\/\/\/\/\/\ STANDARD STYLING: HEADER /\/\/\/\/\/\/\/\/\/\ */

			/**
			* @tab Header
			* @section header style
			* @tip Set the background color and border for your email's header area.
			* @theme header
			*/
			#templateHeader{
 background-color:#FFFFFF; border-bottom:0;
 }

			/**
			* @tab Header
			* @section header text
			* @tip Set the styling for your email's header text. Choose a size and color that is easy to read.
			*/
			.headerContent{
 color:#202020; font-family:Arial; font-size:34px; font-weight:bold; line-height:100%; padding:0; text-align:center; vertical-align:middle;
			}

			/**
			* @tab Header
			* @section header link
			* @tip Set the styling for your email's header links. Choose a color that helps them stand out from your text.
			*/
			.headerContent a:link, .headerContent a:visited, /* Yahoo! Mail Override */ .headerContent a .yshortcuts /* Yahoo! Mail Override */{
				/*@editable*/ color:#336699;
				/*@editable*/ font-weight:normal;
				/*@editable*/ text-decoration:underline;
			}

			#headerImage{
				height:auto;
				max-width:600px !important;
			}

			/* /\/\/\/\/\/\/\/\/\/\ STANDARD STYLING: MAIN BODY /\/\/\/\/\/\/\/\/\/\ */

			/**
			* @tab Body
			* @section body style
			* @tip Set the background color for your email's body area.
			*/
			#templateContainer, .bodyContent{
				/*@editable*/ background-color:#FFFFFF;
			}

			/**
			* @tab Body
			* @section body text
			* @tip Set the styling for your email's main content text. Choose a size and color that is easy to read.
			* @theme main
			*/
			.bodyContent div{
				/*@editable*/ color:#505050;
				/*@editable*/ font-family:Arial;
				/*@editable*/ font-size:14px;
				/*@editable*/ line-height:150%;
				/*@editable*/ text-align:left;
			}

			/**
			* @tab Body
			* @section body link
			* @tip Set the styling for your email's main content links. Choose a color that helps them stand out from your text.
			*/
			.bodyContent div a:link, .bodyContent div a:visited, /* Yahoo! Mail Override */ .bodyContent div a .yshortcuts /* Yahoo! Mail Override */{
				/*@editable*/ color:#336699;
				/*@editable*/ font-weight:normal;
				/*@editable*/ text-decoration:underline;
			}

			/**
			* @tab Body
			* @section data table style
			* @tip Set the background color and border for your email's data table.
			*/
			.templateDataTable{
				/*@editable*/ background-color:#FFFFFF; border:1px solid #DDDDDD;
			}
			
			/**
			* @tab Body
			* @section data table heading text
			* @tip Set the styling for your email's data table text. Choose a size and color that is easy to read.
			*/
			.dataTableHeading{
 background-color:#D8E2EA; color:#336699; font-family:Helvetica; font-size:14px; font-weight:bold; line-height:150%; text-align:left;
			}
		
			/**
			* @tab Body
			* @section data table heading link
			* @tip Set the styling for your email's data table links. Choose a color that helps them stand out from your text.
			*/
			.dataTableHeading a:link, .dataTableHeading a:visited, /* Yahoo! Mail Override */ .dataTableHeading a .yshortcuts /* Yahoo! Mail Override */{
				/*@editable*/ color:#FFFFFF;
				/*@editable*/ font-weight:bold;
				/*@editable*/ text-decoration:underline;
			}
			
			/**
			* @tab Body
			* @section data table text
			* @tip Set the styling for your email's data table text. Choose a size and color that is easy to read.
			*/
			.dataTableContent{
 border-top:1px solid #DDDDDD; border-bottom:0; color:#202020; font-family:Helvetica; font-size:12px; font-weight:bold; line-height:150%; text-align:left;
			}
		
			/**
			* @tab Body
			* @section data table link
			* @tip Set the styling for your email's data table links. Choose a color that helps them stand out from your text.
			*/
			.dataTableContent a:link, .dataTableContent a:visited, /* Yahoo! Mail Override */ .dataTableContent a .yshortcuts /* Yahoo! Mail Override */{
				/*@editable*/ color:#202020;
				/*@editable*/ font-weight:bold;
				/*@editable*/ text-decoration:underline;
			}

			/**
			* @tab Body
			* @section button style
			* @tip Set the styling for your email's button. Choose a style that draws attention.
			*/
			.templateButton{
				-moz-border-radius:3px;
				-webkit-border-radius:3px;
				/*@editable*/ background-color:#336699;
				/*@editable*/ border:0;
				border-collapse:separate !important;
				border-radius:3px;
			}

			/**
			* @tab Body
			* @section button style
			* @tip Set the styling for your email's button. Choose a style that draws attention.
			*/
			.templateButton, .templateButton a:link, .templateButton a:visited, /* Yahoo! Mail Override */ .templateButton a .yshortcuts /* Yahoo! Mail Override */{
				/*@editable*/ color:#FFFFFF;
				/*@editable*/ font-family:Arial;
				/*@editable*/ font-size:15px;
				/*@editable*/ font-weight:bold;
				/*@editable*/ letter-spacing:-.5px;
				/*@editable*/ line-height:100%;
				text-align:center;
				text-decoration:none;
			}

			.bodyContent img{
				display:inline;
				height:auto;
			}

			/* /\/\/\/\/\/\/\/\/\/\ STANDARD STYLING: FOOTER /\/\/\/\/\/\/\/\/\/\ */

			/**
			* @tab Footer
			* @section footer style
			* @tip Set the background color and top border for your email's footer area.
			* @theme footer
			*/
			#templateFooter{
                background-color:#FFFFFF; border-top:0;
			}

			/**
			* @tab Footer
			* @section footer text
			* @tip Set the styling for your email's footer text. Choose a size and color that is easy to read.
			* @theme footer
			*/
			.footerContent div{
                color:#707070; font-family:Arial; font-size:12px; line-height:125%; text-align:center;
			}

			/**
			* @tab Footer
			* @section footer link
			* @tip Set the styling for your email's footer links. Choose a color that helps them stand out from your text.
			*/
			.footerContent div a:link, .footerContent div a:visited, /* Yahoo! Mail Override */ .footerContent div a .yshortcuts /* Yahoo! Mail Override */{
				/*@editable*/ color:#336699;
				/*@editable*/ font-weight:normal;
				/*@editable*/ text-decoration:underline;
			}

			.footerContent img{
				display:inline;
			}

			/**
			* @tab Footer
			* @section utility bar style
			* @tip Set the background color and border for your email's footer utility bar.
			* @theme footer
			*/
			#utility{
				/*@editable*/ background-color:#FFFFFF;
				/*@editable*/ border:0;
			}

			/**
			* @tab Footer
			* @section utility bar style
			* @tip Set the background color and border for your email's footer utility bar.
			*/
			#utility div{
				/*@editable*/ text-align:center;
			}

			#monkeyRewards img{
				max-width:190px;
			}
		</style>
	</head>
    <body leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0">
    	<center>
        	<table border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" id="backgroundTable" style="background-color:#FAFAFA;">
            	<tr>
                	<td align="center" valign="top" style="padding-top:20px;">
                    	<!-- <table border="0" cellpadding="0" cellspacing="0" width="600" id="templateContainer"> -->
                    	<table border="0" cellpadding="0" cellspacing="0" width="80%"id="templateContainer" style="border: 1px solid #DDDDDD; background-color:#FFFFFF;">
                        	<tr>
                            	<td align="center" valign="top">
                                    <!-- // Begin Template Header \\ -->
                                	<!-- <table border="0" cellpadding="0" cellspacing="0" width="600" id="templateHeader"> -->
                                    <table border="0" cellpadding="0" cellspacing="0" id="templateHeader" style=" background-color:#FFFFFF; border-bottom:0; margin-top:10px;" width="90%">
                                        <tr>
                                            <td  width="50%" style=" color:#202020; font-family:Arial; padding:20px;">
                                            
                                            	<!-- // Begin Module: Standard Header Image \\ -->
                                                <img src="<?php echo $image;?>" style="max-width:600px;" id="headerImage campaign-icon" label="header_image" />
                                            	<!-- // End Module: Standard Header Image \\ -->
                                            
                                            </td>
                                            <td  width="50%" style=" color:#202020; font-family:Arial; padding:20px;">
                                                <h2 class="h2">
                                                    <?php echo $product;?>
                                                </h2>
                                            </td>
                                        </tr>
                                    </table>
                                    <!-- // End Template Header \\ -->
                                </td>
                            </tr>
                        	<tr>
                            	<td align="center" valign="top">
                                    <!-- // Begin Template Body \\ -->
                                	<!-- <table border="0" cellpadding="0" cellspacing="0" width="600" id="templateBody"> -->
                                	<table border="0" cellpadding="0" cellspacing="0" id="templateBody" style="background-color:#FFFFFF;" width="90%">
                                    	<tr>
                                            <td valign="top">
                                
                                                <!-- // Begin Module: Standard Content \\ -->
                                                <table border="0" cellpadding="20" cellspacing="0" width="100%">
                                                    <tr>
                                                        <td valign="top" class="bodyContent" style="background-color:#FFFFFF;">
                                                            <div>
                                                            <h2 class="h2"><?php echo $level;?> Notification</h2>
                                                            <p>
                                                            The following event<?php echo (count($events)>1)?"s":"";?> occurred on <a href="<?php echo $server_uri."/SAFe/sng_dashboard";?>"><?php echo $host;?></a>
                                                            </p>
                                                            </div>
														</td>
                                                    </tr>
                                                    <tr>
                                                    	<td valign="top" style="padding-top:0; padding-bottom:0;">
                                                          <table border="0" cellpadding="10" cellspacing="0" width="100%" class="templateDataTable" style="background-color:#FFFFFF; border:1px solid #DDDDDD;">
                                                              <tr>
                                                                  <th scope="col" valign="top" class="dataTableHeading" style=" background-color:#D8E2EA; color:#336699; font-family:Helvetica; font-size:14px; font-weight:bold; line-height:150%; text-align:left;">
                                                                    Service
                                                                  </th>
                                                                  <th scope="col" valign="top" class="dataTableHeading" style=" background-color:#D8E2EA; color:#336699; font-family:Helvetica; font-size:14px; font-weight:bold; line-height:150%; text-align:left;">
                                                                    Event
                                                                  </th>
                                                                  <th scope="col" valign="top" class="dataTableHeading" style=" background-color:#D8E2EA; color:#336699; font-family:Helvetica; font-size:14px; font-weight:bold; line-height:150%; text-align:left;">
                                                                    Status
                                                                  </th>
                                                                  <th scope="col" valign="top" class="dataTableHeading" style=" background-color:#D8E2EA; color:#336699; font-family:Helvetica; font-size:14px; font-weight:bold; line-height:150%; text-align:left;">
                                                                    Data
                                                                  </th>
                                                              </tr>
                                                            <?php foreach($events as $event){ ?>
<?php
    $style ="border-top:1px solid #DDDDDD; border-bottom:0; color:#202020; font-family:Helvetica; font-size:12px; font-weight:bold; line-height:150%; text-align:left;";
    if(($id++) % 2){
        $style .= "background-color:#F8F8F8;";
    }
?>
                                                              <tr>
                                                                  <td valign="top" class="dataTableContent" style="white-space: nowrap; <?php echo $style;?>">
                                                                    <?php echo $event->service_desc(); ?>
                                                                  </td>
                                                                  <td valign="top" class="dataTableContent" style="white-space: nowrap; <?php echo $style;?>">
                                                                    <?php echo $event->event_desc(); ?>
                                                                  </td>
                                                                  <td valign="top" class="dataTableContent" style="white-space: nowrap; <?php echo $style;?>">
                                                                    <?php echo $event->status(); ?>
                                                                  </td>
                                                                  <td valign="top" class="dataTableContent" style="<?php echo $style;?>">
                                                                    <?php
                                                                    foreach($event->data() as $d){
                                                                        $d = trim($d);
                                                                        if($d){
                                                                            echo $d;
                                                                            echo '<br/>';
                                                                        }
                                                                    }
                                                                    ?>
                                                                  </td>
                                                              </tr>
                                                            <?php } ?>
                                                          </table>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="top" class="bodyContent" style="background-color:#FFFFFF;">
														</td>
                                                    </tr>
                                                </table>
                                                <!-- // End Module: Standard Content \\ -->
                                                
                                            </td>
                                        </tr>
                                    </table>
                                    <!-- // End Template Body \\ -->
                                </td>
                            </tr>
                        	<tr>
                            	<td align="center" valign="top">
                                    <!-- // Begin Template Footer \\ -->
                                	<!--<table border="0" cellpadding="10" cellspacing="0" width="600" id="templateFooter">-->
                                	<table border="0" cellpadding="10" cellspacing="0" id="templateFooter" style="background-color:#FFFFFF; border-top:0;">
                                    	<tr>
                                        	<td valign="top" align="center" class="footerContent" style="color:#707070; font-family:Arial; font-size:12px; line-height:125%; text-align:center;">
                                            
                                                <!-- // Begin Module: Transactional Footer \\ -->
                                                <table border="0" cellpadding="10" cellspacing="0" width="100%">
                                                    <tr>
                                                        <td valign="top">
                                                            <div>
																<em>Copyright &copy; 2013 Sangoma Tech., All rights reserved.</em>
                                                            </div>
                                                        </td>
                                                    </tr>
<!--
                                                    <tr>
                                                        <td valign="middle" id="utility">
                                                            <div>
                                                                &nbsp;<a href="*|ARCHIVE|*" target="_blank">view this in your browser</a> | <a href="*|UNSUB|*">unsubscribe from this list</a> | <a href="*|UPDATE_PROFILE|*">update subscription preferences</a>&nbsp;
                                                            </div>
                                                        </td>
                                                    </tr>
-->
                                                </table>
                                                <!-- // End Module: Transactional Footer \\ -->
                                            
                                            </td>
                                        </tr>
                                    </table>
                                    <!-- // End Template Footer \\ -->
                                </td>
                            </tr>
                        </table>
                        <br />
                    </td>
                </tr>
            </table>
        </center>
    </body>
</html>
