# !/bin/sh
#
# Author: Jean-Philippe Boily, jr. eng.
# Date: 06/06/2011
# Description: 	
#
#	This script will modify ClearOS' backup configuration file /etc/backup.conf
# to add a the list of files a Sangoma application needs to be backed up. Those
# are listed in a backup configuration file that is given as a second argument
# to this script.
# 
# Arguments:
# $1 - application name
# $2 - application backup configuration file
#
# Return Code:
#	0 - No error
#	1 - ClearOS' or application's configuration file is missing
#		
# Copyright: Sangoma Technologies Corp. 2011

confFile=/etc/backup.conf
appName=$1
appBackupConf=$2

# Validate backup.conf presence
if [ ! -f $confFile ] ; then
	echo "ERROR - Could not find backup/restore configuration file $confFile"
	exit 1
fi

if [ ! -f $appBackupConf ] ; then
	echo "ERROR - Could not find $appName backup configuration file
  $appBackupConf."
	exit 1
fi

# Check that application backup files are not already listed

isAppBackupConfigured=$(grep -m1 "# $appName" < $confFile)
if [  ${#isAppBackupConfigured} == 0 ] ; then
  echo "# $appName" >> $confFile
fi

while read line
do
  if [ ! `expr substr "$line" 1 1` == "#" ] ; then
    isLineInBackupFile=$(grep -m1 -F "$line" < $confFile)
    if [ ${#isLineInBackupFile} == 0 ]; then
      echo "$line" >> $confFile
    fi
  fi
done < $appBackupConf
