#!/bin/bash

if [ "x$1" = "x" ] || [ "x$2" = "x" ]
then
	echo "USAGE: $0 <license.txt> <pub-key>[,pub-key2[,pub-key3]]"
	exit 1
fi

license=$1
keys=$2
keyfound=NO

while [ ! -z "$3" ];
do
	keys=$keys" $3"
	shift
done

IFS=',';
for key in $keys
do
	echo " "
	echo "Trying key $key"
	tmpfile=$license.tmp
	openssl rsautl -verify -inkey $key -pubin < $license.sig > $tmpfile 2>/dev/null
	if [ $? != 0 ]
	then
		rm $tmpfile
		echo "Failed decrypting signature - License is not valid using key $key"
	else 
		echo "Found matching key"
		keyfound=YES
		break
	fi
done

if [ $keyfound = NO ]; then
	echo "Failed to find a matching key - License is not valid"
	exit 1
fi

cmp -s $license $tmpfile

if [ $? != 0 ]
then
	rm $tmpfile
	echo "License and signature do not match - License is not valid"
	exit 1
fi

echo "License is valid!"

exit 0

