var g_iMgw = 0;
var g_iNumVocTerms = [] ;
var g_iNumVocConfs = [] ;
var g_iNumVidRxTerms = [];
var g_iNumVidTxTerms = [];
var g_iNumVidMixers = [];
var g_iNumRtpSessions = [];
var g_i1010ModulesIndexes = [];
var g_iNum1010Modules = 0;

function Populate_Module(module_index)
{

  //discover all rtp sessions
  var rtp_session_populate =  target[module_index].mgw.octvc1.net.rtp_session._populate();
  g_iNumRtpSessions[module_index] = rtp_session_populate.populate.total;
  
  //discover all voice terminations
  var voc_term_populate =  target[module_index].mgw.octvc1.vspmp_voc.term._populate();
  g_iNumVocTerms[module_index] = voc_term_populate.populate.total;
  
  //discover all voice conferences
  var voc_conf_populate =  target[module_index].mgw.octvc1.vspmp_voc.conference._populate();
  g_iNumVocConfs[module_index] = voc_conf_populate.populate.total;
  
  //discover all video Rx terminations
  var vid_rx_term_populate =  target[module_index].mgw.octvc1.vspmp_vid.rx_term._populate();
  g_iNumVidRxTerms[module_index] = vid_rx_term_populate.populate.total;
  
  //discover all video Tx terminations
  var vid_tx_term_populate =  target[module_index].mgw.octvc1.vspmp_vid.tx_term._populate();
  g_iNumVidTxTerms[module_index] = vid_tx_term_populate.populate.total;
  
  //discover all video Mixers
  var vid_mix_term_populate =  target[module_index].mgw.octvc1.vspmp_vid.mixer._populate();
  g_iNumVidMixers[module_index] = vid_mix_term_populate.populate.total;
	

}

function Populate_All()
{
   //discover all modules
        var mgw_populate = target._populate();
        g_iMgw = mgw_populate.populate.total;

        for( var i=0; i<g_iMgw; i++ ){
          device_info = target[i].mgw.octvc1.main.DEVICE.info();
          if(device_info.ulDeviceType == "OCT1010"){
            g_i1010ModulesIndexes[g_iNum1010Modules] = i;
            g_iNum1010Modules++;
          }
        }

        for( var i=0; i<g_iNum1010Modules; i++ ){
         Populate_Module(g_i1010ModulesIndexes[i]);
        }

	
}

function Print_All_Logs(){

  Populate_All();
  
  print( "Total Number of Modules = " + g_iNum2200Modules + "\n");
  
  for( var i=0; i<g_iNum1010Modules; i++ ){
    Print_Module_Logs(g_i1010ModulesIndexes[i]);
    print("\n");
  }

}

function Print_Module_Logs(module_index){

   var info_gw = target[module_index].info();
   
   print( "==================== MODULE["  + module_index + "] " + info_gw.RemoteMacAddress + " ====================\n");
   
do{
   var module_logs =  target[module_index].mgw.octvc1.main.LOG.entry.read();

   for( var k = 0; k < module_logs.ulNumLogEntry; ++k){
     print( "Log Entry " + k + " Sequence Number: " + module_logs.aLogEntry[k].ulLogSeqNumber + " \n");
     print( "Log Entry " + k + " Time Stamp: " + module_logs.aLogEntry[k].ulLogTimestamp + " \n");
     print( "Log Entry " + k + " Message : " + module_logs.aLogEntry[k].achLogMsg + " \n");
   }
 }while(module_logs.ulNumLogEntry == 5);
}

function Print_All_Eth_Info(){

  Populate_All();
  
  print( "Total Number of Modules = " + g_iNum1010Modules + "\n");
  
  for( var i=0; i<g_iNum1010Modules; i++ ){
    Print_Module_Eth_Info(g_i1010ModulesIndexes[i]);
    print("\n");
  }

}

function Print_Module_Eth_Info(module_index) {
   var info_gw = target[module_index].info();
   print( "==================== MODULE["  + module_index + "] " + info_gw.RemoteMacAddress + " ====================\n");
   var module_eth_link_populate = target[module_index].mgw.octvc1.net.eth_link._populate();
   for (var i = 0; i < module_eth_link_populate.populate.total;++i) {
     var link_info = target[module_index].mgw.octvc1.net.eth_link[i].info();
	 print( " ***** ETH_LINK OBJECT " + link_info.ObjectGet.hObject.aulHandle[0] + "-" +  link_info.ObjectGet.hObject.aulHandle[1] + "-" + link_info.ObjectGet.hObject.aulHandle[2] + " *****\n");
	 print( "ulEthPort=" + link_info.ulEthPort + "\n");
	 print( "ulInternalLoopbackFlag=" + link_info.ulInternalLoopbackFlag + "\n");
	 print( "ulSrtpEventMask=" + link_info.ulSrtpEventMask + "\n");
	 print( "ulMacAddrResolutionEnableFlag=" + link_info.ulMacAddrResolutionEnableFlag + "\n");
	 print( "ulSolicitationReplyEnableFlag=" + link_info.ulSolicitationReplyEnableFlag + "\n");
	 print( "ulIcmpRedirectEnableFlag=" + link_info.ulIcmpRedirectEnableFlag + "\n");
	 print( "ulTxPauseFlag=" + link_info.ulTxPauseFlag + "\n");
	 print( "IPv4.ulEnableFlag=" + link_info.IPv4.ulEnableFlag + "\n");
	 print( "IPv4.ulARPRefreshTimeMs=" + link_info.IPv4.ulARPRefreshTimeMs + "\n");
	 print( "IPv4.ulAddrAutoConfigMode=" + link_info.IPv4.ulAddrAutoConfigMode + "\n");
	 print( "IPv4.ulARPReplyTimeMs=" + link_info.IPv4.ulARPReplyTimeMs + "\n");
	 print( "IPv4.ulARPUnusedTimeMs=" + link_info.IPv4.ulARPUnusedTimeMs + "\n");
	 print( "IPv4.ulARPReqCreateCnt=" + link_info.IPv4.ulARPReqCreateCnt + "\n");
	 print( "IPv4.ulARPUnusedTimeMs=" + link_info.IPv4.ulARPReqRefreshCnt + "\n");
	 print( "IPv4.ulARPReqCreateCnt=" + link_info.IPv4.ulARPReqRefreshBroadcastCnt + "\n");
	 print( "IPv4.ulARPReqDupAddrCnt=" + link_info.IPv4.ulARPReqDupAddrCnt + "\n");
	 print( "IPv4.ulARPDupAddrDefenseTime=" + link_info.IPv4.ulARPDupAddrDefenseTime + "\n");
	 print( "IPv4.ulGARPRequestCnt=" + link_info.IPv4.ulGARPRequestCnt + "\n");
	 for (var j =0; j < link_info.ulNumGateway; ++j) {
	      print( "aGateway[" + j+"].IpAddress=" + link_info.aGateway[j].IpAddress + "\n");
	 }
	 var link_stats = target[module_index].mgw.octvc1.net.eth_link[i].stats();
	 print( "ulRxPktCntARP=" + link_stats.ulRxPktCntARP + "\n");
	 print( "ulRxPktCntICMPv4=" + link_stats.ulRxPktCntICMPv4 + "\n");
	 print( "ulRxPktCntICMPv6=" + link_stats.ulRxPktCntICMPv6 + "\n");
	 print( "ulTxPktCntARP=" + link_stats.ulTxPktCntARP + "\n");
	 print( "ulTxPktCntICMPv4=" + link_stats.ulTxPktCntICMPv4 + "\n");
	 print( "ulTxPktCntICMPv6=" + link_stats.ulTxPktCntICMPv6 + "\n");
	 print( "ulRxErrCntARP=" + link_stats.ulRxErrCntARP + "\n");
	 print( "ulRxErrCntICMPv4=" + link_stats.ulRxErrCntICMPv4 + "\n");
	 print( "ulRxErrCntICMPv6=" + link_stats.ulRxErrCntICMPv6 + "\n");
	 print( "ulRxErrCntUnknown=" + link_stats.ulRxErrCntUnknown + "\n");
	 print( "ulApiEventCnt=" + link_stats.ulApiEventCnt + "\n");
	 var cache_entry_populate = target[module_index].mgw.octvc1.net.eth_link[i].cache_entry._populate();
	 for (var j =0; j < cache_entry_populate.populate.total; ++j) {
	     var cache_entry_info = target[module_index].mgw.octvc1.net.eth_link[i].cache_entry[j].info();
		 for (k =0; k < cache_entry_info.ulNumCacheEntry; ++k) {
		     print( "arpEntry["+j+"]["+k+"].Vlan=" + cache_entry_info.aCacheEntry[k].Vlan + "\n");
			 print( "arpEntry["+j+"]["+k+"].IpAddress=" + cache_entry_info.aCacheEntry[k].IpAddress + "\n");
			 print( "arpEntry["+j+"]["+k+"].MacAddress=" + cache_entry_info.aCacheEntry[k].MacAddress + "\n");
			 print( "arpEntry["+j+"]["+k+"].ulStaticFlag=" + cache_entry_info.aCacheEntry[k].ulStaticFlag + "\n");
			 print( "arpEntry["+j+"]["+k+"].ulReachableFlag=" + cache_entry_info.aCacheEntry[k].ulReachableFlag + "\n");
		 }
	 }
   } 
}

function Print_All_Info(){

  Populate_All();
  
  print( "Total Number of Modules = " + g_iNum1010Modules + "\n");
  
  for( var i=0; i<g_iNum1010Modules; i++ ){
    Print_Module_Info(g_i1010ModulesIndexes[i]);
    print("\n");
  }

}

function Print_Module_Info(module_index){
   var info_gw = target[module_index].info();
   print( "==================== MODULE["  + module_index + "] " + info_gw.RemoteMacAddress + " ====================\n");
   var info_device = target[module_index].mgw.octvc1.main.DEVICE.info();
   print( "Device Type " + info_device.ulDeviceType + "\n");
   var device_info_array = String(info_device.abyDeviceInfo).split(";") 
   for( var k = 0; k < device_info_array.length; ++k){
    print( "" + device_info_array[k] + "\n");
   }
   var device_user_info_array = String(info_device.abyUserInfo).split(";") 
   for( var k = 0; k < device_user_info_array.length; ++k){
    print( "" + device_user_info_array[k] + "\n");
   }
   print( "Number of Active RTP sessions " + g_iNumRtpSessions[module_index] + "\n");
   print( "Number of Active Voice Terminations " + g_iNumVocTerms[module_index] + "\n");
   print( "Number of Active Video RX Terminations " + g_iNumVidRxTerms[module_index] + "\n");
   print( "Number of Active Video TX Terminations " + g_iNumVidTxTerms[module_index] + "\n");
   
   for( var k = 0; k < g_iNumRtpSessions[module_index]; ++k){
     var rtp_info = target[module_index].mgw.octvc1.net.rtp_session[k].info();
	 print( " ***** RTP SESSION OBJECT " + rtp_info.ObjectGet.hObject.aulHandle[0] + "-" +  rtp_info.ObjectGet.hObject.aulHandle[1] + "-" + rtp_info.ObjectGet.hObject.aulHandle[2] + " FIFO ID " + rtp_info.ulFifoId + " *****\n");
	 print( "ulRtpEventMask=" + rtp_info.ulRtpEventMask + "\n");
	 print( "ulRtcpEventMask=" + rtp_info.ulRtcpEventMask + "\n");
	 print( "ulSrtpEventMask=" + rtp_info.ulSrtpEventMask + "\n");
	 print( "ulInitialOperationMode=" + rtp_info.ulInitialOperationMode + "\n");
	 print( "ulRtcpEnableFlag=" + rtp_info.ulRtcpEnableFlag + "\n");
	 
	 var member_populate = target[module_index].mgw.octvc1.net.rtp_session[k].member._populate();
	 var num_members = member_populate.populate.total;
	 for(var j = 0; j < num_members; ++j){
	   var member_info = target[module_index].mgw.octvc1.net.rtp_session[k].member[j].info();
	   print( " --- RTP MEMBER OBJECT " + member_info.SubObjectIdGet.hObject.aulHandle[0] + "-" +  member_info.SubObjectIdGet.hObject.aulHandle[1] + "-" +  member_info.SubObjectIdGet.hObject.aulHandle[2] + " --- \n");
	   print( "| ulOperationMode=" + member_info.ulOperationMode + "\n");
	   print( "| ulTxRtpPauseFlag=" + member_info.ulTxRtpPauseFlag + "\n");
	   print( "| ulTxRtcpPauseFlag=" + member_info.ulTxRtcpPauseFlag + "\n");
	   print( "| hTerm=" + member_info.hTerm + "\n");
	   print( "| hDestObj=" + member_info.hDestObj + "\n");
	   print( "| ulDestObjPort=" + member_info.ulDestObjPort + "\n");
	   print( "| ulRxPktFilter=" + member_info.ulRxPktFilter + "\n");
	   print( "| ulDestObjFifoId=" + member_info.ulDestObjFifoId + "\n");
	   print( "| ulLocalUdpPortRtp=" + member_info.ulLocalUdpPortRtp + "\n");
	   print( "| ulLocalUdpPortRtcp=" + member_info.ulLocalUdpPortRtcp + "\n");
	   print( "| ulLocalUdpPortT38=" + member_info.ulLocalUdpPortRtp + "\n");
	   print( "| ulLocalUdpPortRtp=" + member_info.ulLocalUdpPortRtp + "\n");
	   print( "| RemoteUdpAddressRtp=" + member_info.RemoteUdpAddressRtp + "\n");
	   print( "| RemoteUdpAddressRtcp=" + member_info.RemoteUdpAddressRtcp + "\n");
	   print( "| ulLocalUdpPortT38=" + member_info.ulLocalUdpPortRtp + "\n");
	   print( "| RemoteUdpAddressT38=" + member_info.RemoteUdpAddressT38 + "\n");
	   for (var prof = 0; prof < member_info.ulNumProfEntry; ++prof)
	    print( "| RtpProfileEntry[=" + prof + "]: ulRtpPayloadType="+ member_info.aRtpProfEntry[prof].ulRtpPayloadType 
		+ "ulPktEncodingType=" + member_info.aRtpProfEntry[prof].ulPktEncodingType + 
		+ "ulOverrideRxRtpPayloadType=" + member_info.aRtpProfEntry[prof].ulOverrideRxRtpPayloadType+ "\n");
		
	   print( "| RtpMemberConnInfo: ulConnectionState=" + member_info.RtpMemberConnInfo.ulConnectionState + "\n");
	   print( "| RtpMemberConnInfo: hConnectedRtpSession=" + member_info.RtpMemberConnInfo.hConnectedRtpSession + "\n");
	   print( "| RtpMemberConnInfo: ulConnectedMemberId=" + member_info.RtpMemberConnInfo.ulConnectedMemberId + "\n"); 
	 }
   }
   print("\n");
   
   for( var k = 0; k < g_iNumVocTerms[module_index]; ++k){
      var voc_term_info = target[module_index].mgw.octvc1.vspmp_voc.term[k].info();
	  print( " ***** VOICE TERMINATION OBJECT " + voc_term_info.ObjectGet.hObject.aulHandle[0] + "-" + voc_term_info.ObjectGet.hObject.aulHandle[1] + "-" + voc_term_info.ObjectGet.hObject.aulHandle[2] + " FIFO ID " + voc_term_info.ulFifoId + " *****\n");
	  print( "| ConnInfo.ulConnectionState=" +  voc_term_info.ConnInfo.ulConnectionState + "\n");
	  print( "| ConnInfo.hConnectedObj=" +  voc_term_info.ConnInfo.hConnectedObj + "\n");
	  print( "| hVspMgrProcess=" +  voc_term_info.hVspMgrProcess + "\n");
	  print( "| ulInitialProfileIndex=" +  voc_term_info.ulInitialProfileIndex + "\n");
	  print( "| ulOperState=" +  voc_term_info.ulOperState + "\n");
	  print( "| ulTxVocoderType=" +  voc_term_info.ulTxVocoderType + "\n");
	  print( "| ulTxEncdrRate=" +  voc_term_info.ulTxEncdrRate + "\n");
	  print( "| ulTxOutPktSize=" +  voc_term_info.ulTxOutPktSize + "\n");
	  print( "| ulRxInPktSize=" +  voc_term_info.ulRxInPktSize + "\n");
	  print( "| ulMode=" +  voc_term_info.ulMode + "\n");
	  for (var j = 0; j < 8; ++j)
	   print( "| aulAllowedVocoders[" + j + "]=" + voc_term_info.aulAllowedVocoders[j] + "\n")
	   
	   
	  print( "| ulEventMask=" +  voc_term_info.ulEventMask + "\n");
	  print( "| ulFaxEventMask=" +  voc_term_info.ulFaxEventMask + "\n");
	  print( "| hDestObj=" +  voc_term_info.hDestObj + "\n");
	  print( "| ulDestObjPort=" +  voc_term_info.ulDestObjPort + "\n");
	  print( "| ulDestObjFifoId=" +  voc_term_info.ulDestObjFifoId + "\n");
   }
   print("\n");
   
   for( var k = 0; k < g_iNumVocConfs[module_index]; ++k){
    var voc_coinf_info = target[module_index].mgw.octvc1.vspmp_voc.conference[k].info();
	print( " ***** VOICE CONFERENCE OBJECT " + voc_coinf_info.ObjectGet.hObject.aulHandle[0] + "-" + voc_coinf_info.ObjectGet.hObject.aulHandle[1] + "-" + voc_coinf_info.ObjectGet.hObject.aulHandle[2]  +" FIFO ID " + voc_coinf_info.ulFifoId + " *****\n");
	print("| VspMgrProcess="+ voc_coinf_info.hVspMgrProcess + "\n");
    print("| ConfType="+ voc_coinf_info.ulConfType + "\n");
    print("| BridgePcmLinearType="+ voc_coinf_info.ulBridgePcmLinearType + "\n");
    print("| NumVotingParticipant="+ voc_coinf_info.ulNumVotingParticipant + "\n");
    print("| PrimeAttenuation="+ voc_coinf_info.ulPrimeAttenuation + "\n");
    print("| LowerSpeakerAttenuation="+ voc_coinf_info.ulLowerSpeakerAttenuation + "\n");
    print("| NumActiveParticipant="+ voc_coinf_info.ulNumActiveParticipant + "\n");
    print("| NumActiveBasicParticipant="+ voc_coinf_info.ulNumActiveBasicParticipant + "\n");
    print("| NumActiveSupervisedParticipant="+ voc_coinf_info.ulNumActiveSupervisedParticipant + "\n");
    print("| NumActiveSupervisorParticipant="+ voc_coinf_info.ulNumActiveSupervisorParticipant + "\n");
    print("| PrimeSpeaker="+ voc_coinf_info.hPrimeSpeaker + "\n");
    print("| CallTimerMsec="+ voc_coinf_info.ulCallTimerMsec + "\n");
   }
   print("\n");
   
   for( var k = 0; k < g_iNumVidRxTerms[module_index]; ++k){
      var vid_rx_term_info = target[module_index].mgw.octvc1.vspmp_vid.rx_term[k].info();
	  print( " ***** VIDEO RX TERMINATION OBJECT " + vid_rx_term_info.ObjectGet.hObject.aulHandle[0] + "-" + vid_rx_term_info.ObjectGet.hObject.aulHandle[1] + "-" + vid_rx_term_info.ObjectGet.hObject.aulHandle[2]+ " FIFO ID " + vid_rx_term_info.ulFifoId + " *****\n");
	  print( "| hVspMgrProcess=" + vid_rx_term_info.hVspMgrProcess + "\n");
	  print( "| hGroupTerm=" + vid_rx_term_info.hGroupTerm + "\n");
	  print( "| ulEventMask=" +   vid_rx_term_info.ulEventMask + "\n");
	  print( "| ulProcessingMode=" +   vid_rx_term_info.ulProcessingMode + "\n");
	  for (var j = 0; j < 16; ++j)
	   print( "| aConnInfo[=" + j + "]: ulConnectionState=" +  vid_rx_term_info.aConnInfo[j].ulConnectionState 
	   + " hConnectedObj=" + vid_rx_term_info.aConnInfo[j].hConnectedObj + "\n");
	  
      print("|  JitterMode=" + vid_rx_term_info.JitterBufferConfig.ulJitterMode + "\n");
      print("|  InitialDelayInMs=" + vid_rx_term_info.JitterBufferConfig.ulInitialDelayInMs + "\n");
      print("|  AdaptiveJitterMinDelayInMs=" + vid_rx_term_info.JitterBufferConfig.ulAdaptiveJitterMinDelayInMs + "\n");
      print("|  StaticJitterOverrunBoundaryInMs=" + vid_rx_term_info.JitterBufferConfig.ulStaticJitterOverrunBoundaryInMs + "\n");
      print("|  StaticJitterUnderrunBoundaryInMs=" + vid_rx_term_info.JitterBufferConfig.ulStaticJitterUnderrunBoundaryInMs + "\n");
      print("|  StaticJitterUnderrunAdjustmentInMs=" + vid_rx_term_info.JitterBufferConfig.ulStaticJitterUnderrunAdjustmentInMs + "\n");
      print("|  Decoder Configuration\n");
      print("|  InputFramesPerSecond2x=" + vid_rx_term_info.DecoderConfig.ulInputFramesPerSecond2x + "\n");
      print("|  InputWidth=" + vid_rx_term_info.DecoderConfig.ulInputWidth + "\n");
      print("|  InputHeight=" + vid_rx_term_info.DecoderConfig.ulInputHeight + "\n");
      print("|  MediaCoderType=" + vid_rx_term_info.DecoderConfig.ulMediaCoderType + "\n");
	  
      switch (vid_rx_term_info.DecoderConfig.ulMediaCoderType)
      {
        case "MPEG4":
            print("|  UseDataPartitionedFlag=" + 
			vid_rx_term_info.DecoderConfig.DecoderSpecificConfig.Mpeg4DecoderConfig.ulUseDataPartitionedFlag + "\n");
            print("|  UseReversibleVlcFlag=" +
			vid_rx_term_info.DecoderConfig.DecoderSpecificConfig.Mpeg4DecoderConfig.ulUseReversibleVlcFlag + "\n");
            break;
        case "RAW":
            print("|  PacketType=" + 
			vid_rx_term_info.DecoderConfig.DecoderSpecificConfig.RawDecoderConfig.ulPacketType + "\n");
            break;
        case "H263":
            print("|  PacketType=" + 
			vid_rx_term_info.DecoderConfig.DecoderSpecificConfig.H263DecoderConfig.ulPacketType + "\n");
            break;
        case "H264":
            break;
      };  
   }
   print("\n");
   for( var k = 0; k < g_iNumVidTxTerms[module_index]; ++k){
      var vid_tx_term_info = target[module_index].mgw.octvc1.vspmp_vid.tx_term[k].info();
	  print( " ***** VIDEO TX TERMINATION OBJECT " + vid_tx_term_info.ObjectGet.hObject.aulHandle[0] + "-" + vid_tx_term_info.ObjectGet.hObject.aulHandle[1] + "-" + vid_tx_term_info.ObjectGet.hObject.aulHandle[2]  + " FIFO ID " + vid_tx_term_info.ulFifoId + " *****\n");
	  print( "| hVspMgrProcess=" + vid_tx_term_info.hVspMgrProcess + "\n");
	  print( "| hGroupTerm=" + vid_tx_term_info.hGroupTerm + "\n");
	  print( "| ulEventMask=" +   vid_tx_term_info.ulEventMask + "\n");
	  print( "| ConnInfo: ulConnectionState=" +  vid_tx_term_info.ConnInfo.ulConnectionState 
	  + "hConnectedObj=" + vid_tx_term_info.ConnInfo.hConnectedObj + "\n");
	  
	 print("|  OutputWidth="+ vid_tx_term_info.EncoderConfig.ulOutputWidth + "\n");
	 print("|  OutputHeight="+ vid_tx_term_info.EncoderConfig.ulOutputHeight + "\n");
	 print("|  OutputFramesPerSecond2x="+ vid_tx_term_info.EncoderConfig.ulOutputFramesPerSecond2x + "\n");
	 print("|  MaxVideoPacketSizeInBytes="+ vid_tx_term_info.EncoderConfig.ulMaxVideoPacketSizeInBytes + "\n");
	 print("|  EncodingBitRate="+ vid_tx_term_info.EncoderConfig.ulEncodingBitRate + "\n");
	 print("|  MinQPAllowed="+ vid_tx_term_info.EncoderConfig.ulMinQPAllowed + "\n");
	 print("|  MaxQPAllowed="+ vid_tx_term_info.EncoderConfig.ulMaxQPAllowed + "\n");
	 print("|  IntraFrameRefresh="+ vid_tx_term_info.EncoderConfig.ulIntraFrameRefresh + "\n");
	 print("|  PacketHeaderSize="+ vid_tx_term_info.EncoderConfig.ulPacketHeaderSize + "\n");
	 print("|  IntraRefreshMode="+ vid_tx_term_info.EncoderConfig.ulIntraRefreshMode + "\n");
	 print("|  IntraRefreshWithBitstreamConfigHeaderFlag="+ vid_tx_term_info.EncoderConfig.ulIntraRefreshWithBitstreamConfigHeaderFlag + "\n");
	 print("|  MediaCoderType="+ vid_tx_term_info.EncoderConfig.ulMediaCoderType + "\n");
    switch (vid_tx_term_info.EncoderConfig.ulMediaCoderType)
    {
        case "MPEG4":
            print("|  CodecLevel="+
                    vid_tx_term_info.EncoderConfig.EncoderSpecificConfig.Mpeg4EncoderConfig.ulCodecLevel + "\n");
            break;
        case "H263":
            print("|  PacketType="+
                    vid_tx_term_info.EncoderConfig.EncoderSpecificConfig.H263EncoderConfig.ulPacketType + "\n");
            break;
        case "H264":
            print("|  CodecLevel="+
                    vid_tx_term_info.EncoderConfig.EncoderSpecificConfig.H264EncoderConfig.ulCodecLevel + "\n");
            break;
    };  
   }
   print("\n");
   
   
   
   for( var k = 0; k < g_iNumVidMixers[module_index]; ++k){
      var vid_mixer_info = target[module_index].mgw.octvc1.vspmp_vid.mixer[k].info();
	  print( " ***** VIDEO MIXER OBJECT " + vid_mixer_info.ObjectGet.hObject.aulHandle[0] + "-" +  vid_mixer_info.ObjectGet.hObject.aulHandle[1] + "-" +  vid_mixer_info.ObjectGet.hObject.aulHandle[2] + " FIFO ID " + vid_mixer_info.ulFifoId + " *****\n");
	  print("| VspMgrProcess="+ vid_mixer_info.hVspMgrProcess + "\n");
	  print("| EventMask="+ vid_mixer_info.ulEventMask + "\n");
	  print("| DebugFwdEventMask="+ vid_mixer_info.ulDebugFwdEventMask + "\n");
	  print("| UserEventId="+ vid_mixer_info.ulUserEventId + "\n");
	  print("| Output Connection Information\n");
	  for (var j = 0; j < 16; j++)
	  {
        print("|  ConnectionState="+ vid_mixer_info.aOutputConnInfo[j].ulConnectionState + "\n");
        print("|  ConnectedObj="+vid_mixer_info.aOutputConnInfo[j].hConnectedObj + "\n");
	  }
	  
	  print("| OutputWidth="+ vid_mixer_info.ulOutputWidth + "\n");
	  print("| OutputHeight="+ vid_mixer_info.ulOutputHeight + "\n");
	  print("| FrameRateSyncMask="+ vid_mixer_info.ulFrameRateSyncMask + "\n");
	  print("| Background Layer Configuration\n");
	  print("|  Color\n");
	  print("|   ColorSpaceType="+ vid_mixer_info.BgLayerConfig.Color.ulColorSpaceType + "\n");
	  print("|   Comp1="+ vid_mixer_info.BgLayerConfig.Color.ulComp1 + "\n");
	  print("|   Comp2="+ vid_mixer_info.BgLayerConfig.Color.ulComp2 + "\n");
	  print("|   Comp3="+ vid_mixer_info.BgLayerConfig.Color.ulComp3 + "\n");
	  print("|  Input="+vid_mixer_info.BgLayerConfig.hInput + "\n");
	  print("|  Effect Configuration\n");
    for (var j = 0; j < 1; j++)
    {
        print("|   Effect="+ j + "\n");
        print("|   EffectType="+ vid_mixer_info.BgLayerConfig.aEffectConfig[j].ulEffectType + "\n");
        print("|   EffectEnabledFlag="+ vid_mixer_info.BgLayerConfig.aEffectConfig[j].ulEffectEnabledFlag + "\n");
        switch (vid_mixer_info.BgLayerConfig.aEffectConfig[j].ulEffectType)
        {
            case "LUMA_KEYER":
                print("|    Luma Keyer Configuration\n");
                print("|     LumaKeyThreshold="+
                        vid_mixer_info.BgLayerConfig.aEffectConfig[j].EffectSpecificConfig.EffectLumaKeyerConfig.ulLumaKeyThreshold + "\n");
                print("|     LumaKeyCutoff="+
                        vid_mixer_info.BgLayerConfig.aEffectConfig[j].EffectSpecificConfig.EffectLumaKeyerConfig.ulLumaKeyCutoff + "\n");
                break;
            case "RESIZER":
			    print("|    Resizer Keyer Configuration\n");
                break;
        }
    }
    print("| Display Order\n");
    for (var j = 0; j < 16; j++);
     print("| Layer["+ j + "] display order=" + vid_mixer_info.aulDisplayOrder[j] + "\n");  
   }

}

function List_Modules()
{
  //discover all modules
  var mgw_populate = target._populate();
  g_iMgw = mgw_populate.populate.total;
  print( "Total Number of Modules = " + g_iMgw + "\n");
  for( var i=0; i<g_iMgw; i++ ){
    var info_gw = target[i].info();
	print( "MODULE["  + i + "] " + info_gw.RemoteMacAddress + "\n");
   }

}

function Find_Module_Index(module_mac){

 //discover all modules
 var mgw_populate = target._populate();
 g_iMgw = mgw_populate.populate.total;
 for( var i=0; i<g_iMgw; i++ ){
    var info_gw = target[i].info();
	if(info_gw.RemoteMacAddress == module_mac)
	   return i;
   }
   return -1;
}

function Print_Module_Stats(module_index){


  for( var k = 0; k < g_iNumRtpSessions[module_index]; ++k){
    var member_populate = target[module_index].mgw.octvc1.net.rtp_session[k].member._populate();
	var num_members = member_populate.populate.total;
	for(var j = 0; j < num_members; ++j){
	  var member_stats = target[module_index].mgw.octvc1.net.rtp_session[k].member[j].local.stats();
	  print( " --- LOCAL RTP MEMBER STATS " + member_stats.SubObjectIdGet.hObject.aulHandle[0] + "-" + member_stats.SubObjectIdGet.hObject.aulHandle[1] + "-" + member_stats.SubObjectIdGet.hObject.aulHandle[2]  +" --- \n");
	  print("| ReceivedPktCnt="+ member_stats.aulReceivedPktCnt + "\n");
	  print("| ReceivedByteCnt="+ member_stats.aulReceivedByteCnt + "\n");
	  print("| Sender Statistics\n");
	  print("| SentPktCnt="+ member_stats.SenderStats.aulSentPktCnt + "\n");
	  print("| SentByteCnt="+ member_stats.SenderStats.aulSentByteCnt + "\n");
	  print("| NtpTimestamp="+member_stats.SenderStats.aulNtpTimestamp[1]+ " " +member_stats.SenderStats.aulNtpTimestamp[0] + "\n");
	  print("| RtpTimestamp="+member_stats.SenderStats.ulRtpTimestamp + "\n");
	  print("| SenderSsrc="+member_stats.SenderStats.ulSenderSsrc + "\n");
	  print("| SenderStartTime="+member_stats.SenderStats.ulSenderStartTime + "\n");
	  print("| SenderReportCnt="+member_stats.SenderStats.ulSenderReportCnt + "\n");
	  print("| SenderState="+member_stats.SenderStats.ulSenderState + "\n");
	  print("| LastSenderReportTime="+member_stats.SenderStats.ulLastSenderReportTime + "\n");
	  print("| SsrcChangeCnt="+member_stats.SenderStats.ulSsrcChangeCnt + "\n");
	  print("| Receiver Statistics\n");
	  print("| HighestSeqNumber="+member_stats.ReceiverStats.ulHighestSeqNumber + "\n");
	  print("| CumulativeLostCnt="+member_stats.ReceiverStats.ulCumulativeLostCnt + "\n");
	  print("| FractionLost="+member_stats.ReceiverStats.ulFractionLost + "\n");
	  print("| InterArrivalJitter="+member_stats.ReceiverStats.ulInterArrivalJitter + "\n");
	  print("| MaxFractionLost="+member_stats.ReceiverStats.ulMaxFractionLost + "\n");
	  print("| MaxInterArrivalJitte="+member_stats.ReceiverStats.ulMaxInterArrivalJitter + "\n");
	  print("| AverageFractionLost="+member_stats.ReceiverStats.ulAverageFractionLost + "\n");
	  print("| AverageInterArrivalJitter="+member_stats.ReceiverStats.ulAverageInterArrivalJitter + "\n");
	  print("| ReceiverStartTime(in 10 ms)="+member_stats.ReceiverStats.ulReceiverStartTime + "\n");
	  print("| ReceiverReportCnt"+member_stats.ReceiverStats.ulReceiverReportCnt + "\n");
	  print("| LastReceiverReportTime(in 10 ms)="+member_stats.ReceiverStats.ulLastReceiverReportTime + "\n");
	  print("| RemoteSenderSsrc="+member_stats.ReceiverStats.ulRemoteSenderSsrc + "\n");
	  print("| AlarmRxThreshold="+member_stats.ReceiverStats.ulAlarmRxThreshold + "\n");
	  print("| AlarmRxThresholdCnt="+member_stats.ReceiverStats.ulAlarmRxThresholdCnt + "\n");
	  
	
	  member_stats = target[module_index].mgw.octvc1.net.rtp_session[k].member[j].remote.stats();
	  print( " --- REMOTE RTP MEMBER STATS " + member_stats.SubObjectIdGet.hObject.aulHandle[0] + "-" + member_stats.SubObjectIdGet.hObject.aulHandle[1] + "-" + member_stats.SubObjectIdGet.hObject.aulHandle[2] +" --- \n");
	  print("| RoundTripTime="+ member_stats.ulRoundTripTime + "\n");
	  print("| MaxRoundTripTime="+ member_stats.ulMaxRoundTripTime + "\n");
	  print("| AverageRoundTripTime="+ member_stats.ulAverageRoundTripTime + "\n");
	  print("| Sender Statistics\n");
	  print("| SentPktCnt="+ member_stats.SenderStats.aulSentPktCnt + "\n");
	  print("| SentByteCnt="+ member_stats.SenderStats.aulSentByteCnt + "\n");
	  print("| NtpTimestamp="+member_stats.SenderStats.aulNtpTimestamp[1]+ " "+ member_stats.SenderStats.aulNtpTimestamp[0] + "\n");
	  print("| RtpTimestamp="+ member_stats.SenderStats.ulRtpTimestamp + "\n");
	  print("| SenderSsrc="+ member_stats.SenderStats.ulSenderSsrc + "\n");
	  print("| SenderStartTime="+ member_stats.SenderStats.ulSenderStartTime + "\n");
	  print("| SenderReportCnt="+ member_stats.SenderStats.ulSenderReportCnt + "\n");
	  print("| SenderState="+ member_stats.SenderStats.ulSenderState + "\n");
	  print("| LastSenderReportTime="+ member_stats.SenderStats.ulLastSenderReportTime + "\n");
	  print("| SsrcChangeCnt="+ member_stats.SenderStats.ulSsrcChangeCnt + "\n");
	  print("| Receiver Statistics\n");
	  print("| HighestSeqNumber="+ member_stats.ReceiverStats.ulHighestSeqNumber + "\n");
	  print("| CumulativeLostCnt="+ member_stats.ReceiverStats.ulCumulativeLostCnt + "\n");
	  print("| FractionLost="+ member_stats.ReceiverStats.ulFractionLost + "\n");
	  print("| InterArrivalJitter="+ member_stats.ReceiverStats.ulInterArrivalJitter + "\n");
	  print("| MaxFractionLost="+ member_stats.ReceiverStats.ulMaxFractionLost + "\n");
	  print("| MaxInterArrivalJitter="+ member_stats.ReceiverStats.ulMaxInterArrivalJitter + "\n");
	  print("| AverageFractionLost="+ member_stats.ReceiverStats.ulAverageFractionLost + "\n");
	  print("| AverageInterArrivalJitter="+ member_stats.ReceiverStats.ulAverageInterArrivalJitter + "\n");
	  print("| ReceiverStartTime(in 10 ms)="+ member_stats.ReceiverStats.ulReceiverStartTime + "\n");
	  print("| ReceiverReportCnt="+ member_stats.ReceiverStats.ulReceiverReportCnt + "\n");
	  print("| LastReceiverReportTime(in 10 ms)="+ member_stats.ReceiverStats.ulLastReceiverReportTime + "\n");
	  print("| RemoteSenderSsrc="+ member_stats.ReceiverStats.ulRemoteSenderSsrc + "\n");
	  print("| AlarmRxThreshold="+ member_stats.ReceiverStats.ulAlarmRxThreshold + "\n");
	  print("| AlarmRxThresholdCnt="+ member_stats.ReceiverStats.ulAlarmRxThresholdCnt + "\n");
	}
  }
  
  print("\n");
  
  for( var k = 0; k < g_iNumVocTerms[module_index]; ++k){
   var voc_term_stats = target[module_index].mgw.octvc1.vspmp_voc.term[k].mc.stats();
   print( " ***** VOICE TERMINATION " + voc_term_stats.ObjectGet.hObject.aulHandle[0] + "-" + voc_term_stats.ObjectGet.hObject.aulHandle[1] + "-" + voc_term_stats.ObjectGet.hObject.aulHandle[2] +" STATISTICS *****\n");
   print("| RxInPktCnt="+ voc_term_stats.aulRxInPktCnt + "\n");
   print("| RxInByteCnt="+ voc_term_stats.aulRxInByteCnt + "\n");
   print("| RxOutPktCnt="+ voc_term_stats.ulRxOutPktCnt + "\n");
   print("| RxInSidPktCnt="+ voc_term_stats.ulRxInSidPktCnt + "\n");
   print("| RxNoPktCnt="+ voc_term_stats.ulRxNoPktCnt + "\n");
   print("| RxBadPktTypeCnt="+ voc_term_stats.ulRxBadPktTypeCnt + "\n");
   print("| RxBadRtpPayloadTypeCnt="+ voc_term_stats.ulRxBadRtpPayloadTypeCnt + "\n"); 
   print("| RxBadPktHdrFormatCnt="+ voc_term_stats.ulRxBadPktHdrFormatCnt + "\n");
   print("| RxBadPktLengthCnt="+ voc_term_stats.ulRxBadPktLengthCnt + "\n");
   print("| RxMisorderedPktCnt="+ voc_term_stats.ulRxMisorderedPktCnt + "\n");
   print("| RxLostPktCnt="+ voc_term_stats.ulRxLostPktCnt + "\n");
   print("| RxBadPktChecksumCnt="+ voc_term_stats.ulRxBadPktChecksumCnt + "\n");
   print("| RxUnderrunSlipCnt="+ voc_term_stats.ulRxUnderrunSlipCnt + "\n");
   print("| RxOverrunSlipCnt="+ voc_term_stats.ulRxOverrunSlipCnt + "\n");
   print("| RxLastVocoderType="+ voc_term_stats.ulRxLastVocoderType + "\n");
   print("| RxVocoderChangeCnt="+ voc_term_stats.ulRxVocoderChangeCnt + "\n");
   print("| RxMaxDetectedPdv(in 125 us)="+ voc_term_stats.ulRxMaxDetectedPdv + "\n");
   print("| RxDecdrRate="+ voc_term_stats.ulRxDecdrRate + "\n");
   print("| RxJitterCurrentDelay(in 125 us)="+ voc_term_stats.ulRxJitterCurrentDelay + "\n");
   print("| RxJitterEstimatedDelay(in 125 us)="+ voc_term_stats.ulRxJitterEstimatedDelay + "\n");
   print("| RxJitterEstimatedDelay(in 125 us)="+ voc_term_stats.lRxJitterClkDriftingDelta + "\n");
   print("| RxJitterClkDriftingCorrectionCnt="+ voc_term_stats.ulRxJitterClkDriftingCorrectionCnt + "\n");
   print("| RxJitterInitializationCnt="+ voc_term_stats.ulRxJitterInitializationCnt + "\n");
   print("| RxCircularBufferWriteErrCnt="+ voc_term_stats.ulRxCircularBufferWriteErrCnt + "\n");
   print("| RxApiEventCnt="+ voc_term_stats.ulRxApiEventCnt + "\n");
   print("| TxCurrentVocoderType="+ voc_term_stats.ulTxCurrentVocoderType + "\n");
   print("| TxInPktCnt="+ voc_term_stats.ulTxInPktCnt + "\n");
   print("| TxOutPktCnt="+ voc_term_stats.aulTxOutPktCnt + "\n");
   print("| TxOutByteCnt="+ voc_term_stats.aulTxOutByteCnt + "\n");
   print("| TxInBadPktPayloadCnt="+ voc_term_stats.ulTxInBadPktPayloadCnt + "\n");
   print("| TxTimestampGapCnt="+ voc_term_stats.ulTxTimestampGapCnt + "\n");
   print("| TxTdmWriteErrCnt="+ voc_term_stats.ulTxTdmWriteErrCnt + "\n");
   print("| RxToneDetectedCnt="+ voc_term_stats.ulRxToneDetectedCnt + "\n");
   print("| RxToneRelayEventPktCnt="+ voc_term_stats.ulRxToneRelayEventPktCnt + "\n");
   print("| RxToneRelayUnsupportedCnt="+ voc_term_stats.ulRxToneRelayUnsupportedCnt + "\n");
   print("| TxToneRelayEventPktCnt="+ voc_term_stats.ulTxToneRelayEventPktCnt + "\n");
   print("| TxApiEventCnt="+ voc_term_stats.ulTxApiEventCnt + "\n");
   print("| TxNoRtpEntryPktDropCnt="+ voc_term_stats.ulTxNoRtpEntryPktDropCnt + "\n");
   print("| ConnectionWaitAckFlag="+ voc_term_stats.ulConnectionWaitAckFlag + "\n");
   print("| RxMipsProtectionDropCnt="+ voc_term_stats.ulRxMipsProtectionDropCnt + "\n");
   print("| TxMipsProtectionDropCnt="+ voc_term_stats.ulTxMipsProtectionDropCnt + "\n");
   print("| CallTimerMsec="+ voc_term_stats.ulCallTimerMsec + "\n");
  }
  print("\n");
  
  for( var k = 0; k < g_iNumVidRxTerms[module_index]; ++k){
   var vid_rx_term_stats = target[module_index].mgw.octvc1.vspmp_vid.rx_term[k].stats();
	  print( " ***** VIDEO RX TERMINATION  " + vid_rx_term_stats.ObjectGet.hObject.aulHandle[0]+ "-" + vid_rx_term_stats.ObjectGet.hObject.aulHandle[1] + "-" + vid_rx_term_stats.ObjectGet.hObject.aulHandle[2] + " STATISTICS *****\n");
	  print("| InFrameCnt="+ vid_rx_term_stats.ulInFrameCnt + "\n");
	  print("| InPacketCnt="+ vid_rx_term_stats.ulInPacketCnt + "\n");
	  print("| InByteCnt="+ vid_rx_term_stats.ulInByteCnt + "\n");
	  print("| FrameConcealedCnt="+ vid_rx_term_stats.ulFrameConcealedCnt + "\n");
	  print("| ulFrameDropCnt="+ vid_rx_term_stats.ulFrameDropCnt + "\n");
	  print("| ulFrameLateCnt="+ vid_rx_term_stats.ulFrameLateCnt + "\n");
	  print("| PacketLostCnt="+ vid_rx_term_stats.ulPacketLostCnt + "\n");
	  print("| ProcessingErrorCnt="+ vid_rx_term_stats.ulProcessingErrorCnt + "\n");
	  print("| ulLastProcessingError="+ vid_rx_term_stats.ulLastProcessingError + "\n");
	  print("| FifoOverflowCnt="+ vid_rx_term_stats.ulFifoOverflowCnt + "\n");
	  print("| DestBusyCnt="+ vid_rx_term_stats.ulDestBusyCnt + "\n");
	  print("| CurrentInputWidth="+ vid_rx_term_stats.ulCurrentInputWidth + "\n");
	  print("| CurrentInputHeight="+ vid_rx_term_stats.ulCurrentInputHeight + "\n");
	  print("| DecoderFrameRate2X="+ vid_rx_term_stats.ulDecoderFrameRate2X + "\n");
	  print("| ulMaxDecoderFrameRate2X="+ vid_rx_term_stats.ulMaxDecoderFrameRate2X + "\n");
	  print("| DecoderBitRate="+ vid_rx_term_stats.ulDecoderBitRate + "\n");
	  print("| ulMaxDecoderBitRate="+ vid_rx_term_stats.ulMaxDecoderBitRate + "\n");
	  print("| MaxFrameProcessingDurationUs="+ vid_rx_term_stats.ulMaxFrameProcessingDurationUs + "\n");
	  print("| MaxConsecutiveNonRealTimeFrame="+ vid_rx_term_stats.ulMaxConsecutiveNonRealTimeFrame + "\n");
	  print("| NonRealTimeFrameCnt="+ vid_rx_term_stats.ulNonRealTimeFrameCnt + "\n");
	  print("| JitterResetCnt="+ vid_rx_term_stats.ulJitterResetCnt + "\n");
	  print("| ulLastJitterResetCause="+ vid_rx_term_stats.ulLastJitterResetCause + "\n");
	  print("| JitterCurrentDelay="+ vid_rx_term_stats.ulJitterCurrentDelay + "\n");
	  print("| JitterLevelInPackets="+ vid_rx_term_stats.ulJitterLevelInPackets + "\n");
	  print("| JitterLevelInFrames="+ vid_rx_term_stats.ulJitterLevelInFrames + "\n");
	  print("| JitterLevelInBytes="+ vid_rx_term_stats.ulJitterLevelInBytes + "\n");
	  print("| ulJitterUnderrunSlipCnt="+ vid_rx_term_stats.ulJitterUnderrunSlipCnt + "\n");
	  print("| ulJitterOverrunSlipCnt="+ vid_rx_term_stats.ulJitterOverrunSlipCnt + "\n");
  }
  print("\n");
  
  
  for( var k = 0; k < g_iNumVidTxTerms[module_index]; ++k){
   var vid_tx_term_stats = target[module_index].mgw.octvc1.vspmp_vid.tx_term[k].stats();
   print( " ***** VIDEO TX TERMINATION  " + vid_tx_term_stats.ObjectGet.hObject.aulHandle[0]+ "-" +  vid_tx_term_stats.ObjectGet.hObject.aulHandle[1]+ "-" +vid_tx_term_stats.ObjectGet.hObject.aulHandle[2] +" STATISTICS *****\n");
   print("| OutFrameCnt="+ vid_tx_term_stats.ulOutFrameCnt + "\n");
   print("| OutPacketCnt="+ vid_tx_term_stats.ulOutPacketCnt + "\n");
   print("| OutByteCnt="+ vid_tx_term_stats.ulOutByteCnt + "\n");
   print("| EncoderFrameRate2X="+ vid_tx_term_stats.ulEncoderFrameRate2X + "\n");
   print("| ulMaxEncoderFrameRate2X="+ vid_tx_term_stats.ulMaxEncoderFrameRate2X + "\n");
   print("| EncoderBitRate="+ vid_tx_term_stats.ulEncoderBitRate + "\n");
   print("| ulMaxEncoderBitRate="+ vid_tx_term_stats.ulMaxEncoderBitRate + "\n");
   print("| ProcessingErrorCnt="+ vid_tx_term_stats.ulProcessingErrorCnt + "\n");
   print("| ulLastProcessingError="+ vid_tx_term_stats.ulLastProcessingError + "\n");
   print("| ulFrameProcessingDurationUs="+ vid_tx_term_stats.ulFrameProcessingDurationUs + "\n");
   print("| ulMaxFrameProcessingDurationUs="+ vid_tx_term_stats.ulMaxFrameProcessingDurationUs + "\n");
   print("| ulMaxConsecutiveNonRealTimeFrame="+ vid_tx_term_stats.ulMaxConsecutiveNonRealTimeFrame + "\n");
   print("| ulNonRealTimeFrameCnt="+ vid_tx_term_stats.ulNonRealTimeFrameCnt + "\n");
   print("| ulAccExceedingDelayMs="+ vid_tx_term_stats.ulAccExceedingDelayMs + "\n");
   print("| ulAccExceedingDelayAboveRealTimeCnt="+ vid_tx_term_stats.ulAccExceedingDelayAboveRealTimeCnt + "\n");
   print("| ulLastProcStartTimestamp="+ vid_tx_term_stats.ulLastProcStartTimestamp + "\n");
   print("| ulBitRateCtrlFrameDropCnt="+ vid_tx_term_stats.ulBitRateCtrlFrameDropCnt + "\n");
   print("| ulFrmRateConvFrameDropCnt="+ vid_tx_term_stats.ulFrmRateConvFrameDropCnt + "\n");
  }
  
  for( var k = 0; k < g_iNumVidMixers[module_index]; ++k){
   var vid_mixer_stats = target[module_index].mgw.octvc1.vspmp_vid.mixer[k].stats();
   print( " ***** VIDEO MIXER OBJECT " + vid_mixer_stats.ObjectGet.hObject.aulHandle[0] + "-" +  vid_mixer_stats.ObjectGet.hObject.aulHandle[1] + "-" +  vid_mixer_stats.ObjectGet.hObject.aulHandle[2] + " STATISTICS *****\n");
   print("| ulOutFrameCnt="+ vid_mixer_stats.ulOutFrameCnt+ "\n");
   print("| ulFrameProcessingDurationUs="+ vid_mixer_stats.ulFrameProcessingDurationUs+ "\n");
   print("| ulMaxFrameProcessingDurationUs="+ vid_mixer_stats.ulMaxFrameProcessingDurationUs+ "\n");
   print("| ulMaxConsecutiveNonRealTimeFrame="+ vid_mixer_stats.ulMaxConsecutiveNonRealTimeFrame+ "\n");
   print("| ulNonRealTimeFrameCnt="+ vid_mixer_stats.ulNonRealTimeFrameCnt+ "\n");
   print("| ulAccExceedingDelayMs="+ vid_mixer_stats.ulAccExceedingDelayMs+ "\n");
   print("| ulAccExceedingDelayAboveRealTimeCnt="+ vid_mixer_stats.ulAccExceedingDelayAboveRealTimeCnt+ "\n");
   print("| ulLastProcStartTimestamp="+ vid_mixer_stats.ulLastProcStartTimestamp+ "\n");
  }


}


function Print_All_Stats(){

  Populate_All();
  
  print( "Total Number of Modules = " + g_iNum1010Modules + "\n");

  for( var i=0; i<g_iNum1010Modules; i++ ){
   Print_Module_Stats(g_i1010ModulesIndexes[i]);
   print("\n");
 }
}

function Module_Send_Ping(module_index, remote_address) {
   var info_gw = target[module_index].info();
   print( "==================== MODULE["  + module_index + "] " + info_gw.RemoteMacAddress + " ====================\n");
   var module_local_host_populate = target[module_index].mgw.octvc1.net.local_host._populate();
   for (var i = 0; i < module_local_host_populate.populate.total;++i) {
      target[module_index].mgw.octvc1.net.local_host[i].icmp_ping.send("ulTimeToLive=128 ulTimeout=250 RemoteIpAddress="+remote_address);
	  print("Sent Ping Request from module to remote "+remote_address+"\n");
   }
}

function Module_Validate_ADDR(module_index) {
   var info_gw = target[module_index].info();
   print( "==================== MODULE["  + module_index + "] " + info_gw.RemoteMacAddress + " ====================\n");
   var module_local_host_populate = target[module_index].mgw.octvc1.net.local_host._populate();
   for (var i = 0; i < module_local_host_populate.populate.total;++i) {
      target[module_index].mgw.octvc1.net.local_host[i].addr_validate.start();
	  print("Sent RFC 5227 ARP probes from module\n");
   }
}



try{

  var len = argc;
  var command= argv[0];
  
  if(len >= 1){
    switch (command){
    case "info":
	 Print_All_Info();
	break;
	
	case "stats":
	  Print_All_Stats()
	break;
	
	case "list-modules":
	  List_Modules();
	  break;
	  
	case "logs":
	  Print_All_Logs();
	  break;
	  
	case "net-info":
	  Print_All_Eth_Info();
	  break

    case "mod-info":
	case "mod-stats":
	case "mod-logs":
	case "mod-net-info":
	case "mod-validate-addr":
	case "mod-send-ping":
     if(command != "mod-send-ping" && len != 2){
	   print("Invalid lenght for command" + command);
       print("Usage XXX_INSTDIR_XXX/bin/octconsole -q -r XXX_INSTDIR_XXX/scripts/sangoma_discovery_tool.gs [info, stats, list-modules, mod-info <module-mac-address>, mod-stats <module-mac-address>]\n");
	  } else if (command == "mod-send-ping" && len != 3) {
	   print("Invalid lenght for command" + command);
       print("Usage XXX_INSTDIR_XXX/bin/octconsole -q -r XXX_INSTDIR_XXX/scripts/sangoma_discovery_tool.gs [info, stats, list-modules, mod-info <module-mac-address>, mod-stats <module-mac-address>]\n");
	  }else{
	    var module_mac = argv[1];
	    var mod_index = Find_Module_Index(module_mac);
		if(mod_index >= 0){
		  Populate_Module(mod_index);
		  if( command == "mod-info")
		   Print_Module_Info(mod_index);
		  else if( command == "mod-stats")
           Print_Module_Stats(mod_index);
		  else if (command == "mod-logs")
		    Print_Module_Logs(mod_index);
		  else if (command == "mod-validate-addr")
		    Module_Validate_ADDR(mod_index);
		  else if (command == "mod-send-ping")
		    Module_Send_Ping(mod_index, argv[2])
		  else
		    Print_Module_Eth_Info(mod_index);
        }else{
		  print("Invalid module mac address " + module_mac + "\n");
		}
	  }
    break;
	
	default:
	  print("Unsupported Command " + command + "\n");
	  print("Usage XXX_INSTDIR_XXX/bin/octconsole -q -r XXX_INSTDIR_XXX/scripts/sangoma_discovery_tool.gs [info, stats, list-modules, mod-info <module-mac-address>, mod-stats <module-mac-address>]\n");
	break;
	};

 
 }else{
   print("Invalid Command " + command);
   print("Usage XXX_INSTDIR_XXX/bin/octconsole -q -r XXX_INSTDIR_XXX/scripts/sangoma_discovery_tool.gs [info, stats, list-modules, mod-info <module-mac-address>, mod-stats <module-mac-address>]\n");
 }

} catch(e) {

 
   // Display the error and exit
   throw(e)

}
