<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS Media Profile Class
 * @author Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('object');
safe_require_class('hardware');
safe_module_require_class('fs', 'application');
class Fs_media_profile_class extends Safe_configurable_object_class
{
    private $_hw_codec_enum = array();
    private $_sw_codec_enum = array();
    /**
     * @brief
     *           
     * @param[in out] $parent_name
     * @param[in out] $name
     *           
     * @return
     */
    public function __construct($node, $parent_name, $name)
    {
        parent::__construct($parent_name, $name, $node);
        // HW codecs
        $this->_hw_codec_enum = array(
            'none' => '',
            'PCMU@10i' => 'PCMU 10ms, PT=0',
            'PCMU@20i' => 'PCMU 20ms, PT=0',
            'PCMU@30i' => 'PCMU 30ms, PT=0',
            'PCMA@10i' => 'PCMA 10ms, PT=8',
            'PCMA@20i' => 'PCMA 20ms, PT=8',
            'PCMA@30i' => 'PCMA 30ms, PT=8',
            'G729@20i' => 'G.729 20ms, PT=18',
            'G729@30i' => 'G.729 30ms, PT=18',
            'AMR@4750b@20i' => 'AMR 4.75Kbps 20ms, PT=96',
            'AMR@4750b@40i' => 'AMR 4.75Kbps 40ms, PT=96',
            'AMR@12200b@20i' => 'AMR 12.20Kbps 20ms, PT=96',
            'AMR@12200b@40i' => 'AMR 12.20Kbps 40ms, PT=96',
            'AMR-WB@23850b@20i' => 'AMR-WB 23.85Kbps 20ms, PT=103',
            'iLBC@15200b@20i' => 'iLBC 15.20Kbps 20ms, PT=98',
            'iLBC@13330b@30i' => 'iLBC 13.33Kbps 30ms, PT=97',
            'GSM@20i' => 'GSM, PT=3',
            'G722@20i' => 'G.722 20ms, PT=9',
            'G722@30i' => 'G.722 30ms, PT=9',
            'G7221@16000h@32000b@20i' => 'G.722.1 32Kbps 20ms, PT=107',
            'G7221@16000h@24000b@20i' => 'G.722.1 24Kbps 20ms, PT=107',
            'G723@30i' => 'G.723.1 30ms, PT=4',
            'G726-16@20i' => 'G.726 16Kbps 20ms, PT=124',
            'G726-24@20i' => 'G.726 24Kbps 20ms, PT=123',
            'G726-32@20i' => 'G.726 32Kbps 20ms, PT=122',
            'G726-40@20i' => 'G.726 40Kbps 20ms, PT=121',
            'G726-16@30i' => 'G.726 16Kbps 30ms, PT=124',
            'G726-24@30i' => 'G.726 24Kbps 30ms, PT=123',
            'G726-32@30i' => 'G.726 32Kbps 30ms, PT=122',
            'G726-40@30i' => 'G.726 40Kbps 30ms, PT=121',
        );
        $this->_sw_codec_enum = array(
            'none' => '',
            'PCMU@20i' => 'PCMU 20ms, PT=0',
            'PCMU@30i' => 'PCMU 30ms, PT=0',
            'PCMA@20i' => 'PCMA 20ms, PT=8',
            'PCMA@30i' => 'PCMA 30ms, PT=8',
        );
    }
    /**
     * @brief
     *         
     * @return
     */
    public function configure()
    {
        // Create object fields
        if ($this->get_transcoder_status()) {
            $this->add_enum_field('codec-1', 'Codec #1', 'dropdown', 'PCMU@20i', $this->hw_codec_enum());
            $this->add_enum_field('codec-2', 'Codec #2', 'dropdown', 'PCMA@20i', $this->hw_codec_enum());
            $this->add_enum_field('codec-3', 'Codec #3', 'dropdown', 'G729@30i', $this->hw_codec_enum());
            $this->add_enum_field('codec-4', 'Codec #4', 'dropdown', 'iLBC@13330b@30i', $this->hw_codec_enum());
            $this->add_enum_field('codec-5', 'Codec #5', 'dropdown', 'AMR@12200b@40i', $this->hw_codec_enum());
        } else {
            $this->add_enum_field('codec-1', 'Codec #1', 'dropdown', 'PCMU@20i', $this->sw_codec_enum());
            $this->add_enum_field('codec-2', 'Codec #2', 'dropdown', 'PCMA@20i', $this->sw_codec_enum());
            $this->add_enum_field('codec-3', 'Codec #3', 'dropdown', 'PCMU@30i', $this->sw_codec_enum());
            $this->add_enum_field('codec-4', 'Codec #4', 'dropdown', 'PCMA@30i', $this->sw_codec_enum());
            $this->add_enum_field('codec-5', 'Codec #5', 'dropdown', 'none', $this->sw_codec_enum());
        }
        $this->set_field_help('codec-1', array(
            'Order in which media codecs will be used. Please select codecs in order of priority.',
            '1 is the highest priority and 5 is the lowest priority'
        ));
        // Set the codec uniqueness validation rules
        $this->set_field_rules('codec-1', 'not_matches[codec-2]|not_matches[codec-3]|not_matches[codec-4]|not_matches[codec-5]');
        $this->set_field_rules('codec-2', 'not_matches[codec-1]|not_matches[codec-3]|not_matches[codec-4]|not_matches[codec-5]');
        $this->set_field_rules('codec-3', 'not_matches[codec-1]|not_matches[codec-2]|not_matches[codec-4]|not_matches[codec-5]');
        $this->set_field_rules('codec-4', 'not_matches[codec-1]|not_matches[codec-2]|not_matches[codec-3]|not_matches[codec-5]');
        $this->set_field_rules('codec-5', 'not_matches[codec-1]|not_matches[codec-2]|not_matches[codec-3]|not_matches[codec-4]');
        // For RC1, only 5 codecs will be available
        //$this->add_enum_field('codec-6', 'Codec #6', 'dropdown', 'none', $codec_enum);
        $this->add_enum_field('negotiation', 'Codec Negotiation Mode', 'dropdown', 'generous', array(
            'generous' => 'Prefer-Remote',
            'greedy' => 'Prefer-Local'
        ));
        $this->set_field_help('negotiation', 'When determining which codec to use, whether to prefer the remote or local list of codecs to generate an SDP response');
        $this->add_enum_field('silence-supp', 'Enable Silence Suppression', 'dropdown', 'false', $this->enable_disable_enum());
        $this->set_field_help('silence-supp', 
            array(
                'Enable/Disable Silence Suppression.',
                'When working in media server mode (hardware transcoding), this enables both silence suppression and VAD.',
                'When working in software transcoding mode, this only enables VAD. Software transcoding does not support silence suppression transmission.',
            )
        );
        /*
        * Removed as per Task#2563 description
        $this->add_field('cn-pt', 'Default Comfort Noise Payload Type', 'text', 13);
        $this->add_field('rfc2833-pt', 'RFC 2833 Payload Type', 'text', 101);
        $this->add_enum_field('enable-rtcp', 'RTCP', 'dropdown', 'true', $this->enable_disable_enum());
        */
        $this->add_enum_field('dtmf-type', 'DTMF Mode', 'dropdown', 'rfc2833', array(
            'none' => 'Inband',
            'rfc2833' => 'RFC 2833',
            //'info'  => 'SIP INFO' // SIP Info not supported in RC1
            
        ));
        $this->set_field_help('dtmf-type', 'DTMF Type that will be used. DTMF modes available are RFC2833 and Inband');
        return parent::configure();
    }
    public function get_transcoder_status()
    {
        $transcoding_cfg = new Sng_transcoding_config_class($this->_node);
        $transcoding_cfg->configure();
        return ('true' == $transcoding_cfg->get_data_value('enable_media_interface', false));
    }

    /**
        * @brief Return HW codec list (legacy)
        *
        * @return 
     */
    public function codec_enum()
    {
        return $this->hw_codec_enum;
    }

    /**
        * @brief Return HW codec list
        *
        * @return 
     */
    public function hw_codec_enum()
    {
        return $this->_hw_codec_enum;
    }

    /**
        * @brief Return SW codec list
        *
        * @return 
     */
    public function sw_codec_enum()
    {
        return $this->_sw_codec_enum;
    }
    public function summary($type = 'horizontal' , $long = false){
        if($type == 'horizontal'){
            $codec_list = array();
            for($i=1;$i<=5;$i++){
                $tmp = $this->get_data_value('codec-'.$i);
                if($tmp){
                    $codec_list[] = $tmp;
                }
            }
            $table_line = array("Name" => $this->name(),
                    "Codec List" => $codec_list
            );
            return array('data' => $table_line);
        }else{
            return parent::summary($type , $long);
        }
    }
    /**
     * Checks to see if object can be deleted
     * @see Safe_serializable_object_class::can_dispose()
     */
    public function can_dispose(&$reason=null)
    {
        $usages = $this->node()->software()->application()->check_object_usage('media','profile', $this->name());
        if($usages){
            $reason['msg'] = "  {$this->name()} is used by ";
            $reason['obj'] = $usages;
            return false;
        }
        return parent::can_dispose($reason);
    }
    /**
     * @brief Save method - Override to send obj modified event
     *
     * @return 
     */
    public function save()
    {
        $result = parent::save();
        if($this->is_modified()){
            //send media profile modification event out
            $receivers = $this->node()->software()->application()->check_object_modified('media','profile', $this->name());
        }
        return $result;
    }
}
?>
