<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS SIP Profile Class
 *
 * author: Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('object');
safe_require_class('hardware');
safe_module_require_class('fs', 'application');
class Fs_gateway_class extends Safe_configurable_object_class
{
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }
    public function configure()
    {
        $this->configure_general();
        $this->configure_registration();
        // Parent configure
        return parent::configure();
    }

    public function configure_general()
    {
        //$this->add_field('user-agent-string', 'User Agent', 'string', '', 50);
        //$this->add_enum_field($name, $label, $type, $default, $enum_array)
        $this->add_field('realm', 'Domain', 'string', '', 50);
        $this->set_field_rules('realm', 'required|valid_ip_or_domain rule');
        $this->set_field_help('realm', 'Domain Name (if DNS is supported) or IP address provided by the ITSP');
        $this->add_field('username', 'User Name', 'string', '', 25);
        $this->set_field_rules('username', "required[password]|regex_match[/^([a-z0-9-_.!~*'()&=+$,;?\/])+$/i]");
        $this->set_field_help('username', 'The authentication username to be used in all outgoing INVITE and REGISTER messages in this trunk.');
        $this->add_field('password', 'Password', 'password', '', 25);
        $this->set_field_rules('password', "required[username]|regex_match[/^([a-z0-9-_.!~*'()&=+$,])+$/i]");
        $this->set_field_help('password', 'The SIP trunk authentication password.');
        $this->add_field('from-user', 'From User', 'string', '', 50);
        $this->set_field_rules('from-user', 'min_length[1]|max_length[254]');
        $this->set_field_help('from-user', 'User Name that will be used in the SIP "FROM" header. If not provided, the authentication username will be used.');
        $this->add_field('from-domain', 'From Domain', 'string', '', 50);
        $this->set_field_help('from-domain', 'Domain name that will be used in the SIP "FROM" header. If not provided, the Domain provided will be used');
        $this->add_enum_field('caller-id-in-from', 'Transparent CallerID', 'dropdown', 'true',
            array('true'=>'Enabled', 'false'=>'Disabled')
        );
        $this->set_field_help('caller-id-in-from','For outbound calls, whether
                to use the From user caller id as received from the inbound leg.
                If disabled, the From user configured for this SIP trunk is
                used.');

        $this->add_field('proxy', 'Proxy Address', 'string', '', 50);
        $this->set_field_rules('proxy', 'valid_ip_port_domain');
        $this->set_field_help('proxy', array(
            'Domain name or IP address to use as the SIP proxy. If not provided, the Domain provided will be used.',
            '',
            'Proxy address can also be in IP:PORT notation (i.e. 10.10.0.1:8888).'
        ));
        $this->add_field('outbound-proxy', 'Outbound Proxy Address', 'string', '', 50);
        $this->set_field_rules('outbound-proxy', 'valid_ip_port_domain');
        $this->set_field_help('outbound-proxy', array(
            'Domain name or IP address to use as the SIP outbound proxy. If not provided, the Domain provided will be used.',
            '',
            'Outbound Proxy address can also be in IP:PORT notation (i.e. 10.10.0.1:8888).'
        ));
        $this->add_enum_field('register-transport', 'Transport', 'dropdown', 'udp', array(
            'udp' => 'UDP',
            'tcp' => 'TCP',
            'tls' => 'TLS',
        ));
        $this->set_field_help('register-transport', 'SIP Transport used for calls in this SIP Trunk.');

        $this->add_field('contact-host', 'Contact Host', 'string', '', 25);
        $this->set_field_help('contact-host',
        array(
        'Optional custom contact host (@host) in the Contact header of the SIP messages exchanged with this SIP Trunk.',
        'Note this value must be an IP of FQDN routable back to the SBC in order to receive calls.'
        ));

        $this->add_field('contact-params', 'Contact Parameters', 'string', '', 50);
        $this->set_field_help('contact-params', 'Extra SIP parameters to send in the "Contact" header of the SIP messages exchanged with this SIP Trunk.');

        /* we may expose this in the future */
        $this->add_field('extension-in-contact','extension-in-contact', 'hidden','true');

        $this->add_field('ping','OPTIONS Ping Frequency','string','',10);
        $this->set_field_rules('ping','greater_than[4]');
        $this->set_field_help('ping',
        array(
        'How many seconds to wait between SIP OPTIONS ping messages to see if the SIP host is responsive (minimum is 5 seconds).',
        '',
        'If left empty no OPTIONS Ping requests will be sent to determine trunk',
        ));

        $this->add_field('ping-max','OPTIONS Max Ping','string','',10);
        $this->set_field_rules('ping-max','greater_than[0]|greater_or_equal[ping-min]');
        $this->set_field_help('ping-max',
        array(
        'Each successful ping is counted and tracked up to this value. It must be bigger than 0.',
        'This is useful to control the number of successful and failed pings before declaring a SIP trunk available or unavailable.',
        'Each successful ping will increase the counter, when the counter reaches \'OPTIONS Min Ping\' the SIP trunk will be declared available',
        'Each failed ping will decrease the counter, when the counter goes below \'OPTIONS Min Ping\' the SIP trunk will be declared unavailable',
        '',
        'If left empty it will default to 1',
        ));

        $this->add_field('ping-min','OPTIONS Min Ping','string','',10);
        $this->set_field_rules('ping-min','greater_than[0]');
        $this->set_field_help('ping-min',
        array(
        'The minimum value of ping counts to reach before declaring a SIP trunk available. It must be bigger than 0.',
        'This is useful to control the number of successful and failed pings before declaring a SIP trunk available or unavailable.',
        'Each successful ping will increase the counter, when the counter reaches \'OPTIONS Min Ping\' the SIP trunk will be declared available',
        'Each failed ping will decrease the counter, when the counter goes below \'OPTIONS Min Ping\' the SIP trunk will be declared unavailable',
        '',
        'If left empty it will default to 1',
        ));

        // Set categories
        $this->set_field_category('realm', 'General');
    }

    public function configure_registration()
    {
        //$this->add_multiple_field('register','Register','checkbox','',array(0=>true,1=>false));
        $this->add_enum_field('register', 'Registration', 'dropdown', 'false', $this->enable_disable_enum());
        $this->set_field_help('register', 'Indicates whether or not to register to the trunk.');
        $this->add_field('register-proxy', 'Registrar Proxy Address', 'string', '', 50);
        $this->set_field_rules('register-proxy', 'valid_ip_port_domain');
        $this->set_field_help('register-proxy', array(
            'Domain name or IP address to use as the Registrar proxy. If not provided, the Proxy address will be used.',
            '',
            'Registrar Proxy address can also be in IP:PORT notation (i.e. 10.10.0.1:8888).'
        ));

        $this->add_enum_field('distinct-to', 'Register To: Header', 'dropdown', 'false',
        array (
        'false' => 'From User',
        'true' => 'User Name',
        ));
        $this->set_field_help('distinct-to',
        array(
        'This affects how the REGISTER To: header is created.',
        '',
        'If \'From User\' is selected, the REGISTER To: header will be the same as the user in the From: header. This is normal RFC3261 behavior.',
        '',
        'If \'Username\' is selected, the REGISTER To: header will be created using the specified \'User Name\' for this sip trunk.',
        ));

        $this->add_field('expire-seconds', 'Register Expire Seconds', 'string', 3600, 10);
        $this->set_field_rules('expire-seconds', 'required[register]|greater_than[10]');
        $this->set_field_help('expire-seconds', 'Time until SIP registration expires. In seconds.');

        $this->add_field('retry-seconds', 'Register Retry Seconds', 'string', 30, 10);
        $this->set_field_rules('retry-seconds', 'required[register]|greater_than[4]');
        $this->set_field_help('retry-seconds',
        array(
        'Number of seconds to wait until retrying registration after a timeout or a failure.',
        '',
        'For 503 (service unavailable) errors or timeout, the retry period remains constant (always the value specified here)',
        '',
        'For other registration errors (ie, 403 Forbidden), the retry period will increase linearly multiplied by the number of failures.',
        ));

        $this->add_field('timeout-seconds', 'Register Timeout Seconds', 'string', 60, 10);
        $this->set_field_rules('timeout-seconds', 'required[register]|greater_or_equal[5]');
        $this->set_field_help('timeout-seconds', 'Number of seconds to wait before declaring a REGISTER request unsuccessful if no reply');


        // After all fields created, we can now create conditionnal group
        //
        // Add Conditional Control for SIP Registration
        // 1. create the group control 'register'
        $this->create_group('register', array(
            'register-proxy',
            'distinct-to',
            'expire-seconds',
            'retry-seconds',
            'timeout-seconds',
        ));
        // 2. tell the field 'register' which existing group it can control (register)
        $this->conditional_control('register', 'register');
        // Set categories
        $this->set_field_category('register', 'Registration');
    } 
    public function get_transport($text=false){
        return $this->get_data_value('register-transport', $text);
    }
    public function summary($type = 'horizontal' , $long = false){
        $desc_custom = array('realm', 'sip_profile');
        $table_line = array("Name" => $this->name());
        foreach ($desc_custom as $desc_key){
            $table_line[$this->get_data_label($desc_key)] = $this->get_data_value($desc_key);
        }
        return array('data' => $table_line);
    }
    public function can_dispose(&$reason = null)
    {
        $usages = $this->node()->software()->application()->check_object_usage('sip','trunk', $this->name());
        if($usages){
            $reason['msg'] = "  {$this->name()} is used by ";
            $reason['obj'] = $usages;
            return false;
        }
        return parent::can_dispose($reason);
    }
    public function get_prefix_string(){
        return 'sofia/gateway/'.$this->name().'/';
    }
}
?>
