<?php

///////////////////////////////////////////////////////////////////////////////
// Menu handling
///////////////////////////////////////////////////////////////////////////////

// Build menu
//-----------

$menu_pages = WebMenuFetch();
$highlight = array();

// Pick out the current pages section and subsection for menu highlighting
foreach ($menu_pages as $pageinfo) {
	// FIXME: branding hack
	$pageinfo['section'] = preg_replace("/ClearCenter/", "Sangoma", $pageinfo['section']);
  
  // wadam - Find longest url match in request_uri to catch MVC url
  if(!strncmp($pageinfo['url'], $_SERVER['REQUEST_URI'], strlen($pageinfo['url']))) {
    // Check already matched ?
    if(empty($highlight) || strlen($pageinfo['url'])>$highlight['match']){
      $highlight['page'] = $pageinfo['url'];
      $highlight['section'] = $pageinfo['section'];
      $highlight['subsection'] = $pageinfo['section'] . $pageinfo['subsection'];
      $highlight['match'] = strlen($pageinfo['url']);
    }
  }
}

$section = array();

$topmenu = "";
$leftmenu = "";
$current_section = "";
$current_subsection = "";
$section_count = 0;
$active_section_number = 0;
$sections = array();

foreach ($menu_pages as $page) {
	// section + sub-section
	$sss = $page['section'] . $page['subsection'];
	if (isset($sections[$sss])) {
		$sections[$sss]++;
	} else {
		$sections[$sss] = 1;
	}
}

foreach ($menu_pages as $page) {
	// FIXME: branding hack
	$page['section'] = preg_replace("/ClearCenter/", "Sangoma", $page['section']);
	$page['subsection'] = preg_replace("/Clear(OS|SDN)/", "SS7", $page['subsection']);

	// section + sub-section
	$sss = $page['section'] . $page['subsection'];
	
	if ($page['section'] != $current_section) {
		// Don't close top menu section on first run
		if (! empty($topmenu)) {
			$topmenu .= "    </ul>\n";
			$topmenu .= "</li>\n";

			$leftmenu .= "        </ul>\n";
			$leftmenu .= "    </div>\n";
		}

		// Top menu block
		if ($page['section'] == $highlight['section']) {
			$active_section_number = $section_count;
			$topmenu .= "<li class='sfCurrent'>\n";
			$topmenu .= "    <a class='sf-with-url sfCurrent' href='#' onclick=\"$('#clearos_left_menu').accordion('activate', $section_count);\">" . $page['section'] . "<span class='sf-sub-indicator'> &#187;</span></a>\n";
		} else {
			$topmenu .= "<li>\n";
			$topmenu .= "    <a class='sf-with-url' href='#' onclick=\"$('#clearos_left_menu').accordion('activate', $section_count);\">" . $page['section'] . "<span class='sf-sub-indicator'> &#187;</span></a>\n";
		}
		$topmenu .= "    <ul>\n";

		// Left menu block
		$leftmenu .= "    <h3 class='left-menu-header'><a href='#'>{$page['section']}</a></h3>\n";
		$leftmenu .= "    <div>\n";
		$leftmenu .= "        <ul class='ui-accordion-menu-list'>\n";

		$current_section = $page['section'];
		$section_count++;
	}
	
	$activeClass = ($page['url'] == $highlight['page']) ? 'menu-item-active' : '';

  // Check if url is an http link ?
  $extra = "";
  if(1 == preg_match('/^http/', $page['url'])) {
    $extra = " target='_blank' ";
  }
	if ($current_subsection != $page['subsection']) {
		$current_subsection = $page['subsection'];
		$leftmenu .= "            <li class='clearos_left_menu_subsection'>{$page['subsection']}</li>\n";
		$topmenu .= "                <li class='clearos_top_menu_subsection'>{$page['subsection']}</li>\n";
	}

	if ($sections[$sss] == 1) {
		$topmenu .= "                <li><a class='{$activeClass}' href='{$page['url']}' {$extra} >{$page['title']}</a></li>\n";
		$leftmenu .= "            <li class='ui-accordion-menu-list-item'><a class='{$activeClass}' href='{$page['url']}' {$extra}>{$page['title']}</a></li>\n";
	} else {
		$topmenu .= "                <li><a class='{$activeClass}' href='{$page['url']}' {$extra}>{$page['title']}</a></li>\n";
		$leftmenu .= "            <li class='ui-accordion-menu-list-item'><a class='{$activeClass}' href='{$page['url']}' {$extra}>{$page['title']}</a></li>\n";
	}
}

$topmenu .= "        </ul>\n";
$topmenu .= "    </li>\n";

$leftmenu .= "        </ul>\n";
$leftmenu .= "    </div>\n";

///////////////////////////////////////////////////////////////////////////////
// Main
///////////////////////////////////////////////////////////////////////////////
$user_name =
  isset($_SESSION['user_name'])?$_SESSION['user_name']:$_SESSION['user_login'];

echo "
<!-- Body -->
<body>


<!-- Page Container -->
<div id='clearos_container'>
<div class='content-bg'>
    <div id='content_wrapper'>
<!-- Header -->
<div id='clearos_header'>
  <div id='clearos_logo'></div>".
  /*
	<div id='clearos_fullname'>" . LOCALE_LANG_WELCOME . " " . $_SESSION['system_fullname'] . "</div>
   */
"

  <!-- Top Menu -->
  <div id='clearos_top_menu2' class='' >
          <ul class='sf-menu' id='clearos_top_menu_list'>
                  $topmenu
        </ul>        
  </div>
  <div id='clearos_organization' class='login_menu'>
    <div class='inline_div'>
      Logged in as
    </div>
    <div class='inline_div' style='min-width:100px; text-align:center;'>
      <span class='display_name ellipsis'>".$user_name."</span>
      <ul>
      <li>
        <a href='/SAFe/sng_user_config/edit/system/user/".$_SESSION['user_login']."'> 
          <span style='margin-top: 10px; margin-left: 10px;'>Settings</span>
        </a>
      </li>
      <li>
        <a href='?reserved_logout=y'>
          <span style='margin-top: 10px; margin-left: 10px;'>" . WEBCONFIG_LANG_LOGOUT . "</span> 
        </a>
      </li>
      </ul>
      </li>
    </div>
</div>
</div>

<!-- Left Menu -->
<script type='text/javascript'> 
    $(document).ready(function() { 
        $('#clearos_top_menu_list').superfish({
			delay: 800,
			pathLevels: 0
		});
    });

    $(document).ready(function(){
        $('#clearos_left_menu').accordion({ autoHeight: false, active: $active_section_number });
    });
</script>

<div id='clearos_left_menu_wrapper'>
<div id='left-nav-top'></div>	<div id='clearos_left_menu'>
		$leftmenu
	</div>
	<div id='left-nav-bottom'></div>
	<div style='height:50px'>&nbsp;</div>
</div>

<!-- Content -->
<div id='clearos_content'>

";

?>
