<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * NTG Transcoder Statistics Library
 *
 * @author Shaunt Libarian
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
class Fs_sngms_statistics_lib extends Safe_table_class
{
    //Class Variables
    public $table_title = "Statistics";
    public $summary_table_title = "Usage Summary";
    public $summary_table_title2 = "Duration Summary";
    public $v_table_line = array();
    public $IS = 0;
    public $OOS = 0;
    var $heading = array();
    var $line_button = array();
    var $footer_button = array();
    var $primary_key = array();
    public $_statistics;
    //Generates statistics table
    public function information()
    {
        unset($this->data);
        $this->data = array();
        $stat = null;
        $dur = null;
        $statistics = array();
        try {
            $this->_statistics->stats_usage($stat);
            $this->_statistics->stats_duration($dur);
            $this->apply_data_formatter = false;
            $this->heading = array(
                '',
                'IP',
                'MAC Address',
                /*'Status',*/
                'Sessions',
                /*'Usage',*/
                'Max Sessions',
                /*'Max Usage',*/
                'Average Duration',
                'Min Duration',
                'Max Duration'
            );
            $i = 0;
            foreach ($stat['usage'] as $stats) {
                foreach ($stats['module'] as $key => $value) {
                    //echo $key . " => " . $value . "<br />";
                    //var_dump ($value);
                    $statistic_full[$i] = array(
                        'IP' => $value['IP'],
                        'MAC' => $value['MAC'],
                        'Status' => $value['Status'],
                        'active_sessions' => $value['active_sessions'],
                        'usage_in_percent' => $value['usage_in_percent'],
                        'max_active_sessions' => $value['max_active_sessions'],
                        'max_usage_in_percent' => $value['max_usage_in_percent'],
                        'avg' => '',
                        'min' => '',
                        'max' => ''
                    );
                    $i++;
                }
            }
            $l = 0;
            //var_dump ($dur);
            foreach ($dur['duration'] as $duration) {
                foreach ($duration['module'] as $durations) {
                    $statistic_full[$l]['avg'] = $durations['avg'];
                    $statistic_full[$l]['min'] = $durations['min'];
                    $statistic_full[$l]['max'] = $durations['max'];
                    $l++;
                }
            }
            //echo "Counter = $i";
            //var_dump ($statistic_full);
            //Display data
            //foreach($statistic_full as $statistics)
            //echo count($statistic_full);
            //var_dump ($statistic_full);
            for ($a = 0; $a < $i; $a++) {
                $statistics = $statistic_full[$a];
                //echo "\n";
                //var_dump ($statistics);
                if ($statistics['Status'] == "IS") {
                    array_push($this->line_button, array(
                        array(
                            'url' => 'fs_sngms_status/OOS_confirm',
                            'name' => 'Disable',
                            'label' => '',
                            'type' => 'confirm'
                        )
                    ));
                } elseif ($statistics['Status'] == "OOS") {
                    array_push($this->line_button, array(
                        array(
                            'url' => 'fs_sngms_status/IS',
                            'name' => 'Enable',
                            'label' => ''
                        )
                    ));
                }
                array_push($this->primary_key, $statistics['MAC']);
                array_push($this->data, array(
                    ('IS' == $statistics['Status']) ? WEBCONFIG_ICON_ENABLED : (('OS' == $statistics['Status']) ? WEBCONFIG_ICON_DISABLED : WEBCONFIG_ICON_WARNING) ,
                    $statistics['IP'],
                    $statistics['MAC'],
                    $statistics['active_sessions'],
                    /*($statistics['usage_in_percent'],*/
                    $statistics['max_active_sessions'],
                    /*$statistics['max_usage_in_percent'],*/
                    $statistics['avg'],
                    $statistics['min'],
                    $statistics['max']
                ));
            }
            $this->footer_button[] = array(
                'url' => 'fs_sngms_status/drop_sessions_confirm',
                'name' => 'Drop All Sessions',
                'type' => 'confirm'
            );
            //$this->footer_button[] = array ('url' => base_url('fs_sngms_status'),'name'=> 'Refresh');
            
        }
        catch(exception $e) {
        }
    }
    //Generates summary table
    public function summary_table()
    {
        //$this->heading = array('IP','MAC','Status');
        $stat = null;
        $dur = null;
        $this->_statistics->stats_usage($stat, true);
        $this->_statistics->stats_duration($dur, true);
        //var_dump($stat);
        foreach ($stat['usage'] as $summary) {
            //var_dump ($summary);
            $this->v_table_line = array(
                'Active Sessions' => $summary['active_sessions'],
                'Module Usage in Percent' => $summary['usage_in_percent'],
                'Maximum Active Sessions' => $summary['max_active_sessions'],
                'Maximum Usage in Percent' => $summary['max_usage_in_percent'],
                'Minimum Duration' => '',
                'Maximum Duration' => '',
                'Average Duration' => '',
                'Total In Service' => '',
                'Total Out of Service' => ''
            );
        }
        foreach ($dur['duration'] as $duration) {
            $this->v_table_line['Minimum Duration'] = $duration['min'];
            $this->v_table_line['Maximum Duration'] = $duration['max'];
            $this->v_table_line['Average Duration'] = $duration['avg'];
        }
        //Count how many modules IS an OOS
        $this->_statistics->stats_usage($stat);
        foreach ($stat['usage'] as $stats) {
            foreach ($stats['module'] as $statistics) {
                if ($statistics['Status'] == "IS") {
                    $this->IS++;
                } elseif ($statistics['Status'] == "OOS") {
                    $this->OOS++;
                }
            }
        }
        $this->v_table_line['Total In Service'] = $this->IS;
        $this->v_table_line['Total Out of Service'] = $this->OOS;
    }
    public function generate_vertical_table1()
    {
        $table = null;
        //generates table
        //$table = parent::generate_vertical_line_table('','',$this->v_table_line);
        $this->heading = array(
            '',
            'Current',
            'Maximum'
        );
        $this->data[] = array(
            'Active Sessions',
            $this->v_table_line['Active Sessions'],
            $this->v_table_line['Maximum Active Sessions'],
        );
        /*$this->data[] = array ('Module Usage',
        $this->v_table_line['Maximum Usage in Percent'],
        $this->v_table_line['Module Usage in Percent']);*/
        $table = parent::generate();
        return $table;
    }
    public function generate_vertical_table2()
    {
        $table = null;
        unset($this->data);
        $this->heading = array(
            '',
            'Average',
            'Maximum',
            'Minimum'
        );
        $this->data[] = array(
            'Session Duration',
            $this->v_table_line['Average Duration'],
            $this->v_table_line['Maximum Duration'],
            $this->v_table_line['Minimum Duration']
        );
        $table = parent::generate();
        return $table;
    }
    //Generates statistics table
    public function generate_table()
    {
        $table = null;
        //generates table
        $table = parent::generate();
        return $table;
    }
    //Generates warnings if modules are out of service
    public function warnings(&$warning)
    {
        if ($this->OOS > 0) {
            if ($this->OOS == 1) {
                $warning[] = $this->OOS . " Module is Out of Service";
            } else {
                $warning[] = $this->OOS . " Modules are Out of Service";
            }
        }
    }
    public function info(&$information)
    {
        $information[] = safe_form_with_submit_button('To refresh the statistics, please click . ', base_url('fs_sngms_status') , 'Refresh', '');
    }
}
?>
