<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS User Call Admission Control Class
 * @author Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('object');
safe_require_class('hardware');
safe_module_require_class('fs', 'cac_rule');
class Fs_ipaddr_cac_condition_class extends Safe_configurable_object_class
{
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }
    public function configure()
    {
        $this->add_field('condition_type', 'CAC Rule condition type', 'hidden', 'ipaddr', 60);
        $this->add_field('sip_received_ip', 'IP Address', 'string', '', 60);
        $this->set_field_rules('sip_received_ip', 'required|valid_ip');
        $this->set_field_help('sip_received_ip', 'IP Address to which the Call Admission Control rule will apply to. Must enter a valid IPv4 IP Address.');
        $this->add_field('max', 'Maximum Concurrent Sessions', 'string', '', 10);
        $this->set_field_rules('max', 'greater_than[-1]|less_than[65536]|is_natural');
        $this->set_field_help('max', 'Number of concurrent calls the resource can make.');
        $this->add_field('rate1', 'Session Rate Limit', 'string', '', 10);
        $this->set_field_rules('rate1', 'greater_than[-1]|less_than[65536]|is_natural');
        $this->set_field_help('rate1', 'First part of the call rate. It is the number of calls a user can make over a fraction of time.');
        $this->add_field('rate2', 'Session Rate Period', 'string', '', 10);
        $this->set_field_help('rate2', 'Second part of the call rate. It is the amount of time in secornds  a user can make concurrent calls.');
        $this->set_field_rules('rate2', 'greater_than[0]|less_than[65536]|is_natural_no_zero');
        return parent::configure();
    }
    /**
     * @brief Overloaded safe_object::validate to check for duplicate names
     *
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return 
     */
    public function validate($data, &$out_message = null){
        // Turn back to module to validate name
        // $mod->validate_condition(...)
        return parent::validate($data, $out_message);
    }
    public function summary($type = 'horizontal' , $long = false){
        $rs = parent::summary($type , $long);
        unset($rs['data']['Name']);
        return $rs;
    }
}
?>
