<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS Directory Domain configuration class
 * @author: William Adam
 */
class Fs_domain_class extends Safe_configurable_object_class
{
    protected $_node = null;
    private $_users = array();
    /**
     * @brief
     *           
     * @param[in out] $node
     * @param[in out] $parent_name
     * @param[in out] $name
     *           
     * @return
     */
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name);
        $this->_node = $node;
    }
    public function node(){
        return $this->_node;
    }
    /**
     * @brief
     *         
     * @return
     */
    public function configure()
    {
        parent::configure();
        // Register objects
        $this->register_aggregate_object('user', 
            array(
                'name' => 'User',
                'dynamic' => true,
                'base_path' => $this->object_name() . '/user',
                'methods' => array(
                        'create' => array(
                                'name' => 'Create',
                                'description' => 'Create a domain user',
                                'request' => 'POST',
                        ),
                        'retrieve' => array(
                                'name' => 'Retrieve',
                                'description' => 'Retrieve a domain user',
                                'request' => 'GET',
                        ),
                        'update' => array(
                                'name' => 'Update',
                                'description' => 'Update a domain user',
                                'request' => 'POST',
                        ),
                        'delete' => array(
                                'name' => 'Delete',
                                'description' => 'Delete a domain user',
                                'request' => 'POST',
                        ),
                )
            )
        );
    }
    /**
     * Returns domain users in an array
     */
    public function users()
    {
        $this->_users = $this->get_aggregate_objects('user');
        return $this->_users;
    }
    public function create_user($user_name)
    {
        return new Fs_domain_user_class($this->node() , $this->object_name() . '/user', $user_name);
    }
    
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_create_user($name, $data=null) {
        $user = new Fs_domain_user_class($this->node() , $this->object_name() . '/user', $name);
        $user->configure();
        if($data) {
            $user->set_data_values($data);
        }
        return $user;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_retrieve_user($name, $data=null) {
        $users = $this->users();
        return $users[$name];
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_update_user($name, $data=null, &$output = null) {
        $user = $this->api_retrieve_user($name);
        if($user) {
            if ($user->validate($data,$output)) {
                if (true == $user->save()) {
                    return true;
                }
            }
        }
        return false;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_delete_user($name, $data=null, &$output = null) {
        $users = $this->users();
        if($users[$name]) {
            if($users[$name]->can_dispose($output)) {
                return $users[$name]->dispose();
            }
        }
        return false;
    }
    public function summary($type = 'horizontal' , $long = false){
        $table_line = array("Domain Name" => $this->name(),
                            "Forward" => $this->get_data_value('forward-registration'),
                            "Registrar Server" => $this->get_data_value('registrar-server'),
                            "Registrar Port" => $this->get_data_value('registrar-port'));
        return array('data' => $table_line);
        
    }
}
?>
