<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * Base class for dialplan action
 * @author: William Adam
 */
abstract class Fs_basic_dialplan_action_class  extends Safe_configurable_object_class
{
    protected $_type = 'generic';
    protected $_type_str = 'Generic';
    /**
     * @brief
     *           
     * @param[in out] $node
     * @param[in out] $parent_name
     * @param[in out] $name
     *           
     * @return
     */
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }
    public function configure()
    {
        return parent::configure();
    }
    public function field_conditional_group($groupname, $condition_field, $condition)
    {
        $this->_set_field_param($condition_field, 'group', $groupname);
    }
    public function pre_validate(&$obj , &$data){
    
    }
    public function get_action_params()
    {
        $params = array();
        return $params;
    }
    public function action_summary_array($v, $v_raw)
    {
        $action_param = '';
        foreach($v_raw as $sub_k => $sub_v){
            if(strlen($sub_v) && $sub_v != '__none__'){
                if(strlen($action_param)){
                    $action_param .= ',';
                }
                $action_param .= $v[$sub_k];
            }
        }
        return $action_param;
    }
    public function action_summary()
    {
        $actions = array();
        $settings = $this->get_data_values_exploded();
        $settings_raw = $this->get_data_values_exploded(false);
        if(isset($settings[$this->_on_match])){
            $actions = $this->action_summary_array($settings[$this->_on_match], $settings_raw[$this->_on_match]);
        }
        return $actions;
    }
}

class Fs_basic_dialplan_action_header_class extends Fs_basic_dialplan_action_class
{
    protected $_max_action = 5;
    protected $_action_def = null;
    public  $_on_match = 'action';
    protected function _type(){
        return 'header';
    }
    protected function _type_help(){
        return 'header help';
    }
    protected function _action_def()
    {
        if(!$this->_action_def){
            $module = $this->_node->software ()->application ()->find_module_by_name ( 'sip' );
            $field_def = $module->sip_fields_enums(array('invite_header', 'custom_header', 'variable'));
            // Prepare action array configuration
            $this->_action_def = array(
                'manipulate_invite' => array(
                    'label' => 'Manipulate INVITE', 
                    'enum'  => $field_def['invite_header']['enum'],
                    'has_value' => true,
                    'value_rules' => 'required',
                    'application' => 'export',
                ),
                'header_add' => array(
                    'label' => 'Add Header',
                    'pattern' => $field_def['custom_header']['pattern'],
                    'has_value' => true,
                    'value_rules' => 'required',
                    'application' => 'export',
                ),
                'header_remove' => array(
                    'label' => 'Remove Header', 
                    'pattern' => $field_def['custom_header']['pattern'],
                    'has_value' => false,
                    'application' => 'unset',
                ),
                'header_modify' => array(
                    'label' => 'Modify Header',
                    'pattern' => $field_def['custom_header']['pattern'],
                    'has_value' => true,
                    'value_rules' => 'required',
                    'application' => 'export',
                ),
                'set_variable' => array(
                    'label' => 'Set Variable',
                    'pattern' => $field_def['variable']['pattern'],
                    'has_value' => true,
                    'value_rules' => 'required',
                    'application' => 'set',
                ),
                'unset_variable' => array(
                        'label' => 'Unset Variable',
                        'pattern' => $field_def['variable']['pattern'],
                        'has_value' => false,
                        'application' => 'unset',
                ),
                'log' => array(
                        'label' => 'Log',
                        'enum'  => $module->sip_log_level(),
                        'has_value' => true,
                        'value_rules' => 'required',
                        'application' => 'log',
                        'name_label' => 'Level',
                        'value_label' => 'Message'
                ),
            );
        }
        return $this->_action_def;
    }

    public function configure()
    {
        $action_def = $this->_action_def();
        $action_enum = array();
        foreach($action_def as $k => $v){
            $action_enum[$k] = $v['label'];
        }
        $action_enum = safe_create_enum_list($action_enum, ADD_NONE_ALWAYS, true, '( Please Select One )');
        $on_match = $this->_on_match;
        $always_group = array();
        $always_condition_data = array();
        for($i=1; $i<=$this->_max_action; $i++){
            $this->add_enum_field($on_match .'/'.$i.'/type', 'Action', 'dropdown', '__none__', $action_enum);
            $this->set_field_attributes($on_match .'/'.$i.'/type', array('style' => 'width:157px;'));
            if($i == 1){
                if($on_match == 'action'){
                    $this->set_field_rules($on_match .'/'.$i.'/type', 'callback_check_actions');
                }
            }
            $always_group[] = $on_match .'/'.$i.'/type';
            $condition_data = array();
            
            foreach($action_def as $k => $v){
                // Create name field
                $name_label  = 'Name';
                $value_label  = 'Value';
                if(isset($v['name_label'])) $name_label = $v['name_label'];
                if(isset($v['value_label'])) $value_label = $v['value_label'];
                if(isset($v['enum'])){
                    $this->add_enum_field($on_match .'/'.$i.'/'.$k.'/name', $name_label, 'dropdown', '', $v['enum']);
                    $this->set_field_attributes($on_match .'/'.$i.'/'.$k.'/name', array('style' => 'width:190px;', 
                                                                                        'label_style' => 'width:60px;', 
                                                                                        'composite_style' => 'display: none;'));
                    $this->set_field_rules($on_match .'/'.$i.'/'.$k.'/name', 'required[,in,__selectone__]');
                }
                if(isset($v['pattern'])){
                    $this->add_field($on_match .'/'.$i.'/'.$k.'/name', $name_label, 'text', '', 30);
                    $this->set_field_attributes($on_match .'/'.$i.'/'.$k.'/name', array('style' => 'width:186px;', 
                                                                                        'label_style' => 'width:60px;', 
                                                                                        'composite_style' => 'display: none;'));
                    if(isset($v['name_rules'])){
                        $this->set_field_rules($on_match .'/'.$i.'/'.$k.'/name', $v['name_rules']);
                    }else{
                        $this->set_field_rules($on_match .'/'.$i.'/'.$k.'/name', 'required');
                    }
                }
                if($v['help']){
                    $this->set_field_help($on_match .'/'.$i.'/'.$k.'/name',$v['help']);
                }
                // Create value field
                if($v['has_value']){
                    $this->add_field($on_match .'/'.$i.'/'.$k.'/value', $value_label, 'text', '',40);
                    $this->set_field_attributes($on_match .'/'.$i.'/'.$k.'/value', array('style' => 'width:206px;', 
                                                                                         'label_style' => 'width:65px;', 
                                                                                         'composite_style' => 'display: none;'));
                    if(isset($v['value_rules'])){
                        $this->set_field_rules($on_match .'/'.$i.'/'.$k.'/value', $v['value_rules']);
                    }
                }
                // Build condition array
                $enum_keys = array_keys($action_def);
                foreach($enum_keys as $group_key){
                    // Show group fields
                    if($group_key == $k){
                        $condition_data[$k][] =
                            array('field_name' =>$on_match .'/'.$i.'/'.$group_key.'/name', 'status' => 'enable', 'display' => 'yes');
                        $condition_data[$k][] =
                            array('field_name' =>$on_match .'/'.$i.'/'.$group_key.'/value', 'status' => 'enable', 'display' => 'yes');
                    }else{
                        // Hide all others
                        $condition_data[$k][] = 
                            array('field_name' =>$on_match .'/'.$i.'/'.$group_key.'/name', 'status' => 'disable', 'display' => 'no');
                        $condition_data[$k][] = 
                            array('field_name' =>$on_match .'/'.$i.'/'.$group_key.'/value', 'status' => 'disable', 'display' => 'no');
                    }
                }
            }
            // Populate the '__none__' group
            $enum_keys = array_keys($action_def);
            $group = array();
            foreach($enum_keys as $group_key){
                $condition_data['__none__'][] =
                    array('field_name' =>$on_match .'/'.$i.'/'.$group_key.'/name', 'status' => 'disable', 'display' => 'no');
                $condition_data['__none__'][] =
                    array('field_name' =>$on_match .'/'.$i.'/'.$group_key.'/value', 'status' => 'disable', 'display' => 'no');
                $group[] = $on_match .'/'.$i.'/'.$group_key.'/name';
                $group[] = $on_match .'/'.$i.'/'.$group_key.'/value';
            }
            $this->create_group(
                $on_match .'/'.$i.'/type', 
                $group,
                array('default' => array( 'value' => '', 'status' => 'enable'),
                'condition' => $condition_data
                ));
            $this->conditional_control($on_match .'/'.$i.'/type', $on_match .'/'.$i.'/type');
            $this->composite_layout($on_match .'/'.$i.'/type', $group);
        }
        $this->create_group($on_match.'/always',
                $always_group,
                array('default' => array( 'value' => 'always', 'status' => 'disable'),
                        'condition' => $always_condition_data
                ));
        
        return parent::configure();
    }
    public function pre_validate(&$obj, &$data){
        $action_def = $this->_action_def();
        $sub_field_names = array_keys($action_def);
        $on_match = $this->_on_match;
        for($i=1; $i<=$this->_max_action; $i++){
            $field_name = $on_match .'/'.$i.'/type';
            foreach($sub_field_names as $tmp){
                if(!preg_match('/^'.$tmp.'/', $data[$field_name])){
                    unset($obj->_fields[$on_match .'/'.$i.'/'.$tmp.'/name']);
                    unset($obj->_fields[$on_match .'/'.$i.'/'.$tmp.'/value']);
                    unset($data[$on_match .'/'.$i.'/'.$tmp.'/name']);
                    unset($data[$on_match .'/'.$i.'/'.$tmp.'/value']);
                }
            }
        }
        $fields = $this->get_data(true);
        if(isset($data['condition/matching']) && $data['condition/matching'] == 'always'){
            foreach($fields as $key => $tmp_data){
                $pieces = explode("/", $key);
                if($pieces[0] == 'anti-action'){
                    unset($obj->_fields[$key]);
                    unset($data[$key]);
                }
            }
        }
        $error_message = array();
        $action_data = $this->get_data_values_exploded(false);
        if(isset($action_data[$on_match])){
            $final = false;
            foreach($action_data[$on_match] as $key => $value ){
                if($action_data[$on_match][$key]['type'] != '__none__'){
                    if($final){
                        $error_message[$on_match.'/'.$key.'/type'] = "This action will not be executed after a final action.";
                    }else{
                        if($action_def[$action_data[$on_match][$key]['type']]['final'] == true){
                            $final = true;
                        }
                    }  
                }
            }
        }
        return $error_message;
    }
    public function get_action_params()
    {
        $action_def = $this->_action_def();
        $params = array();
        $data = $this->get_data_values_exploded(false);
        $on_match = $this->_on_match;
        for($i=1; $i<=$this->_max_action; $i++){
            $type = $data[$on_match][$i]['type'];
            if(isset($data[$on_match][$i][$type])){
                // Get field values
                $values = $data[$on_match][$i][$type];

                // Check if pattern in enum def
                if(isset($action_def[$type]['pattern'])){
                    $values['name'] = str_replace('xxx', $values['name'], $action_def[$type]['pattern']);
                }
                // Adjust to application
                $app = $action_def[$type]['application'];
                switch($app){
                case 'export':
                    // Clean up ${} notation when using _nolocal_
                    $values['name'] = str_replace('${', '', $values['name']);
                    $values['name'] = str_replace('}', '', $values['name']);
                    $params[] = array(
                            'application' => $app,
                            '_nolocal_'.$values['name'] => $values['value'],
                            'raw_format' => '_nolocal_'.$values['name'],
                    );
                    break;
                case 'unset':
                    $values['name'] = str_replace('${', '', $values['name']);
                    $values['name'] = str_replace('}', '', $values['name']);
                    $params[] = array(
                            'application' => $app,
                            'inline' => 'true',
                            'data' => $values['name'],
                    );
                    break;
                case 'set':
                    $values['name'] = str_replace('${', '', $values['name']);
                    $values['name'] = str_replace('}', '', $values['name']);
                    if(!$values['value']){
                        $app = 'unset';
                        $data_value = $values['name'];
                    }else{
                        $data_value = $values['name'].'='.$values['value'];
                    }
                    $params[] = array(
                            'application' => $app,
                            'inline' => 'true',
                            'data' => $data_value,
                    );
                    break;
                case 'log':
                    $params[] = array(
                            'application' => 'log',
                            'data' => $values['name'] .' '. $values['value'],
                    );
                    break;
                }
            }
        }
        return $params;
    }

    public function action_summary_array($v, $v_raw)
    {
        $actions = array();
        $on_match = $this->_on_match;
        foreach($v_raw as $sub_key => $sub_v){
            if(strlen($sub_v['type']) && $sub_v['type'] != '__none__'){
                $action = '';
                $action .= $v[$sub_key]['type'];
                if(isset($v[$sub_key][$v_raw[$sub_key]['type']]['name'])){
                    $action .= '['.$v[$sub_key][$v_raw[$sub_key]['type']]['name'] .']';
                }
        
                if(strlen($v[$sub_key][$v_raw[$sub_key]['type']]['value'])){
                    $action .= '='.$v[$sub_key][$v_raw[$sub_key]['type']]['value'];
                }
                $actions[] = $action;
            }
        }   
        return $actions;
    }
    
    public function get_action_object_usage($src_module_name, $obj_type, $obj_name, $sub_type = null, $sub_name = null)
    {
        return false;
    }
}
class Fs_basic_dialplan_action_rule_class extends Fs_basic_dialplan_action_header_class
{
    protected function _type(){
        return 'rule';
    }
    protected function _type_help(){
        return 'rule help';
    }
    protected  function _action_def()
    {
        if(!$this->_action_def){
            $module = $this->_node->software()->application()->find_module_by_name('sip');
            $field_def = $module->sip_fields_enums(array('variable'));
            
            $enum_resource = array();
            $enum_resource['bridge_profile'] = array('type' => 'profile', 'module' => $module);
            $enum_resource['bridge_trunk']   = array('type' => 'trunk', 'module' => $module);
            $enum_resource['bridge_user']    = array('type' => 'domain_user', 'module' => $this->_node->software()->application()->find_module_by_name('directory'));
            $enum_resource['bridge_distributor'] = array('type' => 'lists', 'module' =>  $this->_node->software()->application()->find_module_by_name('distributor'));
            $enum_resource['transfer_dialplan']  = array('type' => 'dialplans', 'module' =>  $this->_node->software()->application()->find_module_by_name('routing'));
            
            foreach($enum_resource as $rs_key => $rs_value){
                $enum_resource[$rs_key]['data'] = $rs_value['module']->object_enum($rs_value['type'], ADD_NONE_IF_EMPTY);
            }

            // Prepare action array configuration
            $this->_action_def = array(
                    'respond' => array(
                            'label' => 'Respond',
                            'enum'  => $module->sip_response_enum(),
                            'has_value' => true,
                            'application' => 'respond',
                            'name_label' => 'Code',
                            'value_label' => 'Data',
                            'final' => true
                            
                    ),
                    'hangup' => array(
                            'label' => 'Hangup',
                            'enum' => $module->sip_hangup_enum(),
                            'has_value' => false,
                            'application' => 'hangup',
                            'name_label' => 'Cause',
                            'final' => true 
                    ),
                    'challenge' => array(
                            'label' => 'Challenge',
                            'has_value' => false,
                            'application' => 'challenge',
                            'final' => true
                    ),
                    'bridge_profile' => array(
                            'label' => 'Bridge',
                            'enum'  => $enum_resource['bridge_profile']['data'],
                            'has_value' => true,
                            'application' => 'bridge_profile',
                            'name_label' => 'Profile',
                            'value_label' => 'Destination',
                            'final' => true
                    ),
                    'bridge_trunk' => array(
                            'label' => 'Bridge to Trunk',
                            'enum'  => $enum_resource['bridge_trunk']['data'],
                            'has_value' => true,
                            'application' => 'bridge_trunk',
                            'name_label' => 'Trunk',
                            'value_label' => 'Destination',
                            'final' => true
                                    
                    ),
                    'bridge_user' => array(
                            'label' => 'Bridge to User',
                            'enum'  => $enum_resource['bridge_user']['data'],
                            'has_value' => false,
                            'application' => 'bridge_user',
                            'name_label' => 'User',
                            'final' => true
                    ),
                    'bridge_distributor' => array(
                            'label' => 'Bridge to Distributor',
                            'enum'  => $enum_resource['bridge_distributor']['data'],
                            'has_value' => true,
                            'application' => 'bridge_distributor',
                            'name_label' => 'List',
                            'value_label' => 'Destination',
                            'final' => true
                    ),
                    'transfer_dialplan' => array(
                            'label' => 'Transfer to Dialplan',
                            'enum'  => $enum_resource['transfer_dialplan']['data'],
                            'has_value' => true,
                            'application' => 'transfer_dialplan',
                            'name_label' => 'Dialplan',
                            'value_label' => 'Destination',
                            'final' => true
                    ),
                    'set_variable' => array(
                            'label' => 'Set Variable',
                            'pattern' => $field_def['variable']['pattern'],
                            'has_value' => true,
                            'value_rules' => 'required',
                            'application' => 'set_variable',
                    ),
                    'unset_variable' => array(
                            'label' => 'Unset Variable',
                            'pattern' => $field_def['variable']['pattern'],
                            'has_value' => false,
                            'application' => 'unset_variable',
                    ),
                    'log' => array(
                            'label' => 'Log',
                            'enum'  => $module->sip_log_level(),
                            'has_value' => true,
                            'value_rules' => 'required',
                            'application' => 'log',
                            'name_label' => 'Level',
                            'value_label' => 'Message'
                    ),
                    'export' => array(
                            'label' => 'Export Variable',
                            'pattern' => $field_def['variable']['pattern'],
                            'has_value' => true,
                            'value_rules' => 'required',
                            'application' => 'export',
                    ),
                    'custom' => array(
                            'label' => 'Custom',
                            'pattern' => $field_def['variable']['pattern'],
                            'name_rules' => 'required|alpha_dash',
                            'has_value' => true,
                            'value_rules' => 'required',
                            'application' => 'custom',
                            'name_label' => 'Application',
                            'value_label' => 'Data',
                    ),
                    'inline_custom' => array(
                            'label' => 'Custom(inline)',
                            'pattern' => $field_def['variable']['pattern'],
                            'name_rules' => 'required|alpha_dash',
                            'has_value' => true,
                            'value_rules' => 'required',
                            'application' => 'inline_custom',
                            'name_label' => 'Application',
                            'value_label' => 'Data',
                    ),
                    'trace_call' => array(
                            'label' => 'Trace Call',
                            'has_value' => false,
                            'application' => 'trace_call',
                    )
            );
        }
        return $this->_action_def;
    }
    
    public function get_action_params()
    {
        $action_def = $this->_action_def();
        $params = array();
        $data = $this->get_data_values_exploded(false);
        $on_match = $this->_on_match;
        for($i=1; $i<=$this->_max_action; $i++){
            $type = $data[$on_match][$i]['type'];
            if(isset($data[$on_match][$i][$type]) || $type == 'challenge' || $type == 'trace_call'){
                // Get field values
                $values = $data[$on_match][$i][$type];
    
                // Check if pattern in enum def
                if(isset($action_def[$type]['pattern'])){
                    $values['name'] = str_replace('xxx', $values['name'], $action_def[$type]['pattern']);
                }
                // Adjust to application
                $app = $action_def[$type]['application'];
                switch($app){
                    case 'respond':
                        if(isset($action_def[$type]['data'])){
                            $action_data = $action_def[$type]['data'];
                        }else{
                            if(strlen($values['value'])) {
                                $action_data = $values['name']   . ' ' . $values['value'];
                            }else{
                                $action_data = $values['name'];
                            } 
                        }
                        $params[] = array(
                                'application' => $app,
                                'data' => $action_data,
                        );
                        break;
                    case 'hangup':
                        $params[] = array(
                                'application' => $app,
                                'data' => $values['name'],
                        );
                        break;
                    case 'challenge':
                        $params[] = array(
                                 'application' => 'respond',
                                 'data' => '407'
                        );
                        break;
                    case 'bridge_profile':
                        if(strlen($values['value'])) {
                            $action_data =  $values['value'];
                        }else{
                            $action_data =  '${sip_req_uri}';
                        }
                        $params[] = array(
                                'application' => 'set',
                                'data' => 'sangoma_routing_destination='.$action_data
                        );
                        $params[] = array(
                                'application' => 'transfer',
                                'data' => '${sangoma_routing_destination} XML profile.'.$values['name'].'.egress'
                        );
                        break;
                    case 'bridge_trunk':
                        if(strlen($values['value'])) {
                            $action_data = $values['value']   . ' XML trunk.' . $values['name']. '.egress';
                            $params[] = array(
                                    'application' => 'set',
                                    'data' => 'sangoma_routing_destination='.$values['value']
                            );
                        }else{
                            $action_data = '${destination_number} XML trunk.'. $values['name'] . '.egress';
                        }
                        $params[] = array(
                                'application' => 'transfer',
                                'data' => $action_data
                        );
                        break;
                    case 'bridge_user':
                        $action_data = 'user/'.$values['name'];
                        $params[] = array(
                                'application' => 'bridge',
                                'data' => $action_data
                        );
                        break;
                    case 'bridge_distributor':
                        $module = $this->_node->software()->application()->find_module_by_name('distributor');
                        $lists = $module->lists();
                        $list = $values['name'];
                        // Get distributor object
                        $obj = $lists[$list];
                        if($obj){
                            // Check destination overide
                            if(!empty($values['value'])) {
                                $dest = $values['value'];
                                $params[] = array(
                                        'application' => 'set',
                                        'data' => 'sangoma_routing_destination='.$dest
                                );
                            }else{
                                $dest = '${destination_number}';
                            }
                            // Has a resource prefix ?
                            if('trunk' == $obj->get_resource_type()){
                                $params[] = array(
                                        'application' => 'transfer',
                                        'data' => $dest . ' XML ' . 'trunk.${distributor('.$list.' ${sofia gwlist down})}.egress'
                                );
                            }else{
                                $params[] = array(
                                        'application' => 'bridge',
                                        'data' => '${distributor('.$list.')}/'.$dest
                                );
                            }
                        }
                        break;
                    case 'transfer_dialplan':
                        if(strlen($values['value'])) {
                            $action_data = $values['value']  . ' XML routing.' . $values['name'];
                        }else{
                            $action_data = '${destination_number} XML routing.' . $values['name'];
                        }
                        $params[] = array(
                                'application' => 'transfer',
                                'data' => $action_data
                        );
                        break;
                    case 'set_variable':
                        $values['name'] = str_replace('${', '', $values['name']);
                        $values['name'] = str_replace('}', '', $values['name']);
                        $application = 'set';
                        $params[] = array(
                                'application' => $application,
                                'inline' => 'true',
                                $values['name'] => $values['value'],
                                'raw_format' => $values['name'],
                        );
                        break;
                    case 'unset_variable':
                        $values['name'] = str_replace('${', '', $values['name']);
                        $values['name'] = str_replace('}', '', $values['name']);
                        $params[] = array(
                                'application' => 'unset',
                                'inline' => 'true',
                                'data' => $values['name'],
                        );
                        break;
                    case 'log':
                        $params[] = array(
                                'application' => 'log',
                                'data' => $values['name'] .' '. $values['value'],
                        );
                        break;
                    case 'export':
                        $values['name'] = str_replace('${', '', $values['name']);
                        $values['name'] = str_replace('}', '', $values['name']);
                        $action_data = $values['name'].'=' . $values['value'];
                        $params[] = array(
                                'application' => 'export',
                                'data' => $action_data,
                        );
                        break;
                    case 'custom':
                        $values['name'] = str_replace('${', '', $values['name']);
                        $values['name'] = str_replace('}', '', $values['name']);
                        $params[] = array(
                                'application' => $values['name'],
                                '__custom__' => $values['value'],
                                'raw_format' => '__custom__',
                        );
                        break;
                    case 'inline_custom':
                        $values['name'] = str_replace('${', '', $values['name']);
                        $values['name'] = str_replace('}', '', $values['name']);
                        $params[] = array(
                                'application' => $values['name'],
                                'inline' => 'true',
                                '__custom__' => $values['value'],
                                'raw_format' => '__custom__',
                        );
                        break;
                    case 'trace_call':
                        $params[] = array(
                                'application' => 'export',
                                'data' => 'nolocal:inherit_session_loglevel=true'
                        );
                        $params[] = array(
                                'application' => 'session_loglevel',
                                'data' => 'debug'
                        );
                        $params[] = array(
                             'application' => 'info'
                        );
                        break;
                }
            }
        }
        
        return $params;
    }
    public function get_action_object_usage($src_module_name, $obj_type, $obj_name, $sub_type = null, $sub_name = null)
    {
        $action_def = $this->_action_def();
        $data = $this->get_data_values_exploded(false);
        $on_match = $this->_on_match;
        for($i=1; $i<=$this->_max_action; $i++){
            $type = $data[$on_match][$i]['type'];
            if(isset($data[$on_match][$i][$type])){
                // Get field values
                $values = $data[$on_match][$i][$type];
                switch($type){
                    case 'respond':
                        break;
                    case 'hangup':
                        break;
                    case 'challenge':
                    case 'bridge_profile':
                        
                        if ($values['name'] == $obj_name && $src_module_name == 'sip' && $obj_type == 'profile') {
                            return true;
                        }
                        break;
                    case 'bridge_trunk':
                        if ($values['name'] == $obj_name && $src_module_name == 'sip' && $obj_type == 'trunk') {
                            return true;
                        }
                        break;
                    case 'bridge_user':
                        list($user_name,$domain_name) =  explode('@', $values['name']);
                        if ($domain_name == $obj_name && $src_module_name == 'directory' && $obj_type == 'domain') {
                            if(isset($sub_type) && isset($sub_name)){
                                if ($user_name == $sub_name && $sub_type == 'user') {
                                    return true;
                                }
                            }else{
                                return true;
                            }
                        }
                        break;
                    case 'bridge_distributor':
                        if ($values['name'] == $obj_name && $src_module_name == 'distributor' && $obj_type == 'generic') {
                            return true;
                        }
                        if ($values['name'] == $obj_name && $src_module_name == 'distributor' && $obj_type == 'trunk') {
                            return true;
                        }
                        break;
                    case 'transfer_dialplan':
                        if ($values['name'] == $obj_name && $src_module_name == 'routing' && $obj_type == 'basic') {
                            return true;
                        }
                        if ($values['name'] == $obj_name && $src_module_name == 'routing' && $obj_type == 'advanced') {
                            return true;
                        }
                        break;
                    case 'set_variable':
                        break;
                    case 'unset_variable':
                        break;
                }
            }
        }
        return false;
    }
}
?>
