<?php

///////////////////////////////////////////////////////////////////////////////
//
// Copyright 2006-2009 Point Clark Networks.
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
///////////////////////////////////////////////////////////////////////////////

require_once("../../gui/Webconfig.inc.php");
require_once("../../api/PosixUser.class.php");
require_once(GlobalGetLanguageTemplate("pwd.php"));

// In the future, we might implement a more flexible system for managing
// which fields are user-editable.

$acl = array('password', 'verify');

///////////////////////////////////////////////////////////////////////////////
//
// DisplayAdminPassword()
//
///////////////////////////////////////////////////////////////////////////////

function DisplayAdminPassword($password, $verify)
{
	WebFormOpen();
	WebTableOpen(WEB_LANG_ROOT_PASSWORD_CHANGE);
	echo "
		<tr>
			<td class='mytablesubheader' nowrap>" . LOCALE_LANG_PASSWORD . "</td>
			<td><input size='30' type='password' name='password' value='$password' /></td>
		</tr>
		<tr>
			<td class='mytablesubheader' nowrap>" . LOCALE_LANG_VERIFY . "</td>
			<td><input size='30' type='password' name='verify' value='$verify' /></td>
		</tr>
	";

	if (! WebIsSetup()) {
		echo "
			<tr>
				<td class='mytablesubheader' nowrap>&#160;</td>
				<td>" . WebButtonUpdate("UpdateAdminPassword") . "</td>
			</tr>
		";
	}

	WebTableClose();

	if (! WebIsSetup())
		WebFormClose();
}
// vim: syntax=php ts=4
?>
