<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
if (!defined('BASEPATH')) exit('No direct script access allowed');
/**
 * Config Form Generator
 * Using CodeIgniter form_validation labraries
 * http://codeigniter.com/user_guide/libraries/form_validation.html
 *
 * @author Michel Buczynski <mbuczynski@sangoma.com>
 * @link http://sangoma.com
 */
class Safe_form_class
{
    /**
     * Action attribute of the <form> tab
     * default to same address
     *
     * @var string
     */
    private $action = '';
    /**
     * Additional attributes of the <form> tab
     *
     * @var array of string, string indexed
     */
    private $form_attributes = null;
    /**
     * Additional attributes of the <label> tab
     *
     * @var array of string, string indexed
     */
    private $label_attributes = array();
    /**
     * Additional attributes of the <input> tab
     *
     * @var array of string, string indexed
     */
    private $input_attributes = array();
    /**
     * Concatenate radio and check box <input> tag on 1 line.
     *
     * @var boolean
     */
    private $concat_multichoice = false;
    /**
     * Set action attribute of the <form> tab
     *
     * @param $action string
     */
    public function set_action($action)
    {
        $this->action = $action;
    }
    /**
     * Set additional attributes of the <form> tab
     *
     * @param $form_attributes array
     *                               (string keys, string values)
     */
    public function set_form_attributes($form_attributes)
    {
        $this->form_attributes = $form_attributes;
    }
    /**
     * Set Additional attributes of the <label> tab
     *
     * @param $label_attributes array
     *                                (string keys, string values)
     */
    public function set_label_attributes($label_attributes)
    {
        $this->label_attributes = $label_attributes;
    }
    /**
     * Set additional attributes of the <input> tab
     *
     * @param $input_attributes array
     *                                (string keys, string values)
     */
    public function set_input_attributes($input_attributes)
    {
        $this->input_attributes = $input_attributes;
    }
    /**
     * Set if radio and check box <input> tag will be concatenated on 1 line
     *
     * @param $concat_multichoice boolean
     */
    public function set_concat_multichoice($concat_multichoice = true)
    {
        $this->concat_multichoice = $concat_multichoice;
    }
    /**
     * hiddens <input>s
     *
     * @var array (strinf $name => string $value)
     */
    private $hiddens = array();
    private $privates = array();
    /**
     * Configuration of each <input>s
     * Feild infos, validation infos and <input> attributes
     *
     * @example array(
     *          array(
     *          'field' => 'username',
     *          'label' => 'Username',
     *          'rules' => 'required|min_length[5]|max_length[12]',
     *          'type' => 'text',
     *          'size' => '14'
     *          'disabled' => 'disabled'
     *          ), .... )
     * @var array (int keys) of array (string keys, string values)
     */
    public $config = array();
    /**
     * Flag true if rules are setted
     *
     * @var boolean
     */
    private $rules_setted = false;
    /**
     * Flag true if helps are setted
     *
     * @var boolean
     */
    public $help_setted = false;
    /**
     * Flag true if events are setted
     *
     * @var boolean
     */
    public $events_setted = false;
    /**
     * Flag true if enable_conditional_control is setted
     *
     * @var booolean
     */
    public $enable_cc_setted = false;
    /**
     * Flag true if conditional_control is setted
     *
     * @var booolean
     */
    public $cc_setted = false;
    /**
     * Codeigniter Controller reference
     *
     * @var CI
     */
    private $CI;
    /**
     * iterator for $config
     *
     * @var int
     */
    private $current_field = - 1;
    // le constructeur demande d'avoir un variable $config...
    // peut etre a repancer...
    
    /**
     * Constructer
     * Load CodeIgniter library and helper
     * Set $config passed in parameter
     *
     * @param $c array
     */
    public function __construct($c = array())
    {
        $this->CI = & get_instance();
        $this->CI->load->library('form_validation');
        $this->CI->load->helper('form', 'html');
        $this->set_config($c);
    }
    // / je demande si on doit la laisser private....
    
    /**
     * Set rules of Codeignter formvalidation
     *
     * @return boolean true if rules setted
     */
    private function set_rules()
    {
        if (!$this->rules_setted) {
            // send only feild configured
            $c = $this->config;
            foreach ($c as $k => & $v) if (!isset($v['rules'])) $v['rules'] = '';
            //unset ( $c [$k] );
            $this->CI->form_validation->set_rules($c);
            $this->rules_setted = true;
            return true;
        }
        return false;
    }
    public function clear_rules(){
        $this->CI->form_validation->clear_rules($c);
        $this->rules_setted = false;
    }
    /**
     * Set rules of Codeignter formvalidation
     *
     * @return boolean true if rules setted
     */
    private function set_help()
    {
        if (!$this->help_setted) {
            // send only feild configured
            $c = $this->config;
            foreach ($c as $k => & $v) if (!isset($v['help'])) $v['help'] = '';
            //unset ( $c [$k] );
            //$this->CI->form_validation->set_rules ( $c );
            $this->help_setted = true;
            return true;
        }
        return false;
    }
    /**
     * Set event for a field
     *
     * @return boolean true if event setted
     */
    private function set_events()
    {
        if (!$this->events_setted) {
            // send only feild configured
            $c = $this->config;
            foreach ($c as $k => & $v) if (!isset($v['events'])) $v['events'] = '';
            //unset ( $c [$k] );
            //$this->CI->form_validation->set_rules ( $c );
            $this->events_setted = true;
            return true;
        }
        return false;
    }
    /**
     * Set conditional_control on enum enable field
     *
     * @return boolean true if conditional control is setted
     */
    private function enable_conditional_control()
    {
        if (!$this->enable_cc_setted) {
            $c = $this->config;
            foreach ($c as $k => $v) {
                if (!isset($v['enable_cc'])) {
                    $v['enable_cc'] = '';
                }
            }
            $this->enable_cc_setted = true;
            return true;
        }
        return false;
    }
    /**
     * Set conditional_control on enum enable field
     *
     * @return boolean true if conditional control is setted
     */
    private function conditional_control()
    {
        if (!$this->cc_setted) {
            $c = $this->config;
            foreach ($c as $k => $v) {
                if (!isset($v['group']) || !isset($v['group_condition']) ) {
                    $v['group'] = '';
                }
            }
            $this->cc_setted = true;
            return true;
        }
        return false;
    }
    /**
     * Verify if minimum attributes is setted in $config
     * remove the hiddens feild from the $config
     * recreate a new $config
     */
    private function fix_config()
    {
        $c = array();
        foreach ($this->config as $k => & $v) {
            // this have to be replace by a exception
            // do a more verifcation like radio must have a value
            // checkbox feild name must in "zhename[]" forme
            // etc....
            if (!isset($v['type']) || !isset($v['field'])) {
                echo "<pre>", print_r($v, false) , "is not set correctely </pre>\n";
            } else {
                if ($v['type'] == 'hidden') {
                    isset($v['value']) && $this->hiddens[$v['field']] = $v['value'];
                    unset($this->config[$k]); // not necessary
                }elseif($v['type'] == 'private' || $v['type'] == 'base64'){
                    isset($v['value']) && $this->privates[$v['field']] = $v['value'];
                    unset($this->config[$k]); // not necessary
                }else {
                    array_push($c, $v);
                }
            }
        }
        // print_r($c);
        $this->config = $c;
    }
    /**
     * Set $config
     *
     * @param $c array
     *                 (int keys) of array (string keys, string values)
     */
    public function set_config($c)
    {
        // Adjust $_POST (if set)
        if($_POST){
            foreach($c as $k => $v){
                if(!$_POST[$k]){
                    $_POST[$k] = $v['default'];
                }
            }
        }
        $this->config = $c;
        $this->fix_config();
        $this->clear_rules();
        $this->set_rules();
    }
    /**
     * generate the <form> open tag
     *
     * @return string
     */
    public function form_open()
    {
        // return
        // form_open($this->action,$this->form_attributes,$this->hiddens)."\n";
        // i trust the user so the uri is not rewritten by codigniter...
        $_attr = $this->form_attributes;
        if(!array_key_exists("enctype", $attr)){
            $_attr["enctype"] = "multipart/form-data";
        }
        $html = form_open('__://__', $_attr, $this->hiddens + $this->privates) . "\n";
        $html = preg_replace('#__://__#', $this->action, $html);
        return $html;
    }
    /**
     * generate the <form> open tag
     *
     * @return string
     */
    public function form_open_multipart()
    {
        // return
        // form_open($this->action,$this->form_attributes,$this->hiddens)."\n";
        // i trust the user so the uri is not rewritten by codigniter...
        $html = form_open_multipart('__://__', array(
            "enctype" => "multipart/form-data"
        ) , $this->hiddens + $this->privates) . "\n";
        $html = preg_replace('#__://__#', $this->action, $html);
        return $html;
    }
    /*
     * for testing.... public function basic_form(){ $s=""; foreach
     * ($this->config as $c) {
     * $s.=form_label($c['label'],$c['field'],$this->label_attributes); $s.= ' :
     * '; $s.=
     * form_input($c['field'],set_value($c['field']),$this->input_attributes);
     * $s.= br()."\n"; } return $s; }
    */
    /**
     * Set the iterator to the next feild
     *
     * @return array of the current feild
     * @return null  if no next feild
     */
    public function get_next_current_field()
    {
        if (isset($this->config[++$this->current_field])) {
            return ($c = $this->config[$this->current_field]);
        }
        --$this->current_field;
        return null;
    }
    /**
     * Reset the current feild iterator
     */
    public function reset_current_field()
    {
        $this->current_field = 0;
    }
    /**
     * Generate <input> tag for the current feild
     *
     * @param curr_confprefix string
     * @param curr_confsuffix string
     * @return string         
     */
    public function form_input($prefix = '', $suffix = "\n")
    {
        if (!empty($this->config)) {
            $curr_conf = $this->config[$this->current_field]; // current config
            $temp_conf = $curr_conf; // data send to the input
            $temp_conf = array_merge($temp_conf, $this->input_attributes);
            $temp_conf['name'] = $curr_conf['field'];
            $temp_conf['id'] = $curr_conf['field'];
            unset($temp_conf['field']);
            unset($temp_conf['label']);
            unset($temp_conf['rules']);
            unset($temp_conf['help']);
            unset($temp_conf['events']);
            unset($temp_conf['default']);
            unset($temp_conf['checked']);
            unset($temp_conf['disabled']);
            // setting values (default or post
            switch ($curr_conf['type']) {
            case 'submit':
            case 'reset':
            case 'dropdown': // theis is done bellow
                break;

            case 'radio':
                if (set_radio($curr_conf['field'], $curr_conf['value'], (isset($curr_conf['default'])) ? $curr_conf['default'] : false)) {
                    $temp_conf['checked'] = "checked";
                }
                break;

            case 'checkbox':
                //hum it seem have some bug on the repopoulate
                // need to have the feild like "name[]" not only "name"
                if (is_array($curr_conf['value'])) {
                    if (is_array($curr_conf['default'])) {
                        //Case where default and value is an array
                        //multiple values with multiple selections
                        foreach ($curr_conf['value'] as $key => $value) {
                            foreach ($curr_conf['default'] as $default) {
                                if ($key == $default) {
                                    $def = true;
                                    break;
                                } else {
                                    $def = false;
                                }
                            }
                            if (set_checkbox($curr_conf['field'], $key, $def)) {
                                $temp_conf['checked'][$key] = "checked";
                            }
                        }
                    } else {
                        foreach ($curr_conf['value'] as $key => $value) {
                            //$curr_conf['default'] not array. single selection on multiple values
                            if (set_checkbox($curr_conf['field'], $value, (isset($curr_conf['default'])) ? $curr_conf['default'] : false)) {
                                $temp_conf['checked'] = "checked";
                            }
                        }
                    }
                } else {
                    if (set_checkbox($curr_conf['field'], $curr_conf['value'], (isset($curr_conf['default'])) ? $curr_conf['default'] : false)) {
                        $temp_conf['checked'] = "checked";
                    }
                }
                break;

            case 'hidden':
            case 'private':
            case 'base64': // base64 are not meant to be displayed
                break;

            default:
                $temp_conf['value'] = set_value($curr_conf['field'], (isset($curr_conf['default'])) ? $curr_conf['default'] : null);
                break;
            }
            switch ($curr_conf['type']) {
            case 'upload':
                if ($curr_conf['no_box']) return $prefix . form_upload($curr_conf['field'], $curr_conf['default'], '') . $suffix;
                else return $prefix . form_input($temp_conf, '', 'disabled') . form_upload($curr_conf['field'], $curr_conf['default'], '') . $suffix;
                break;

            case "radio":
            case "checkbox":
                if ($this->concat_multichoice) {
                    $this->concat_multichoice = false;
                    $s = $prefix . form_checkbox($temp_conf['value'], $temp_conf['value'], '', '') . ' ' . htmlspecialchars($temp_conf['value']);
                    $i = $this->current_field;
                    while (isset($this->config[++$i]) && $curr_conf['type'] == $this->config[$i]['type']) {
                        if ($curr_conf['field'] == $this->config[$i]['field']) {
                            $this->current_field = $i;
                            $s.= $this->form_input('', " ");
                        }
                    }
                    // $this->current_field=$i1;
                    $s.= $suffix;
                    // echo "<code> $s </code>";
                    $this->concat_multichoice = true;
                    return $s;
                }
                $checkboxes = array();
                if (is_array($temp_conf['value'])) {
                    foreach ($temp_conf['value'] as $key => $value) {
                        if (isset($temp_conf['checked']) && isset($temp_conf['checked'][$key])) {
                            $checkboxes[] = $prefix . form_checkbox($temp_conf['name'], $key, $temp_conf['checked'][$key], '') . ' ' . htmlspecialchars($value) . $suffix;
                        } else {
                            $checkboxes[] = $prefix . form_checkbox($temp_conf['name'], $key, '', '') . ' ' . htmlspecialchars($value) . $suffix;
                        }
                    }
                }
                return $checkboxes;
            case "dropdown":
                $selected = array();
                if (!empty($temp_conf['selected'])) {
                    $selected = $temp_conf['selected'];
                    unset($temp_conf['selected']);
                }
                if (!empty($_POST[$curr_conf['field']])) $selected = $_POST[$curr_conf['field']];
                // TODO: remove after the tests
                // if enable conditional control add the onchange event to the field
                // WARNING: safe_disable_field must exist in the js lib. This function only works for a two state dropdown (ENABLE: true, DISABLE: false)
                $_conditional_control = '';
                if (!empty($temp_conf['enable_cc'])) {
                    $_conditional_control = 'onchange="safe_disable_field(this.name,this.value);"';
                }
                $conditional_control = '';
                if (!empty($temp_conf['group'])) {
                    // onchange call the js function safe_disabled using the group name and its current value
                    $conditional_control = 'onchange="safe_disabled(\'' . $temp_conf['group'] . '\',this.value);"';
                }
                if (!empty($temp_conf['group_condition'])) {
                    // onchange call the js function safe_condition_disabled using  its name and its current value
                    $conditional_control = 'onchange="safe_condition_disabled(this.name,this.value);"';
                }
                if (isset($curr_conf['disabled'])){
                    $conditional_control.= ' disabled="' . $curr_conf['disabled'] . '"';
                    $conditional_control.= ' class="field_'.$curr_conf['disabled'].'"';
                }
                if (isset($temp_conf['style'])) $conditional_control.= ' style="' . $temp_conf['style'] . '"';
                unset($temp_conf['style']);
                unset($temp_conf['name']);
                unset($temp_conf['value']);
                unset($temp_conf['type']);
                $extra = '';
                foreach ($temp_conf as $k => $v) $extra.= $k . '="' . htmlentities($v) . ' ';
                //var_dump($temp_conf);
                /*
                $_options = array();
                foreach($curr_conf['value'] as $opt){
                    $_options[] = htmlentities($opt);
                }
                 */
                $_options = $curr_conf['value'];
                $_selected = $curr_conf['default'];
                $_option_error = false;
                // Check if default specified and exists in the possible values
                
                if ($curr_conf['default']) {
                    if (!isset($curr_conf['value'][$_selected])) {
                        $_options[$_selected] = 'INVALID';
                        $_option_error = true;
                    }
                }
                // TODO(wadam) - DEBUG return $prefix . form_dropdown ( $curr_conf ['field'], $curr_conf ['value'], $selected ) . $suffix;
                $_select_html = $prefix . form_dropdown($curr_conf['field'], $_options, $_selected, $conditional_control) . $suffix;
                // Add some extra style to invalid enum if exists
                if ($_option_error) {
                    $_select_html = str_replace('value="' . $_selected . '"', 'value="' . $_selected . '" style="color:red; font-weight:bolder"', $_select_html);
                    $_select_html = '<span class="field_error"><p>The field contains an invalid option.</p></span>' . $_select_html;
                }
                return $_select_html;
            case 'hidden':
            case 'private':
            case 'base64':
                break;

            case 'date':
            case 'datetime':
                // Add safe_date or safe_datetime class
                if (isset($temp_conf['class'])) $temp_conf['class'].= ' safe_' . $curr_conf['type'];
                else $temp_conf['class'] = ' safe_' . $curr_conf['type'];
                $temp_conf['type'] = 'text';
            default:
                $_extra = '';
                // Disabled ?
                if (isset($curr_conf['disabled'])){
                    $_extra .= ' disabled="'.$curr_conf['disabled'].'"';
                    $_extra .= ' class="field_'.$curr_conf['disabled'].'"';
                }
                // Password ?
                if('password' == $curr_conf['type']){
                    $_extra .= ' autocomplete="off"';
                }
                $_input_type = array(
                    "button",
                    "checkbox",
                    "color",
                    "date",
                    "datetime",
                    "datetime-local",
                    "email",
                    "file",
                    "hidden",
                    "image",
                    "month",
                    "number",
                    "password",
                    "radio",
                    "range",
                    "reset",
                    "search",
                    "submit",
                    "tel",
                    "text",
                    "time",
                    "url",
                    "week",
                    );   
                // Remove type from conf if not known input type (like string, 
                // integer...)
                if(!in_array($temp_conf['type'], $_input_type)){
                    unset($temp_conf['type']);
                }
                return $prefix . form_input($temp_conf, '', $_extra) . $suffix;
            } // end of switch
            
        }
    }
    /**
     * Generate <label> tag for the current feild
     *
     * @param $prefix string
     * @param $suffix string
     * @return string 
     */
    public function form_label($prefix = '', $suffix = ' ')
    {
        if (!empty($this->config)) {
            $c = $this->config[$this->current_field]; // current config
            
            $d['name'] = $c['field'];
            switch ($c['type']) {
            case "radio":
            case "checkbox":
                if ($this->concat_multichoice) {
                    $i = $this->current_field;
                    while (isset($this->config[++$i]) && $c['type'] == $this->config[$i]['type']) {
                        if ($c['field'] == $this->config[$i]['field']) {
                            $this->current_field = $i;
                        }
                    }
                }
            }
            if (isset($c['label']) && $c['label']) {
                if(isset($c['label_style'])){
                    $this->label_attributes['style'] = 'display:inline-block;' . $c['label_style'];
                    $this->label_attributes['align'] = 'right';
                } 
                $tmp = $prefix . form_label($c['label'], $c['field'], $this->label_attributes) . $suffix;
                if(isset($c['label_style'])){
                    unset($this->label_attributes['style']);
                    unset($this->label_attributes['align']);
                }
                return $tmp;
            }
            else return $prefix . " " . $suffix;
        }
    }
    //  private $empty_array = array ();
    //  private function &_get_config_by_field($field) {
    //    foreach ( $this->hiddens as &$config_line )
    //      if ($config_line ['field'])
    //        return $config_line;
    //    foreach ( $this->config as &$config_line )
    //      if ($config_line ['field'])
    //        return $config_line;
    //    return $this->empty_array;
    //  }
    //  public function set_value_by_field($field, $value) {
    //    if (empty ( $field ))
    //      return;
    //    $c = &$this->_get_config_by_field ( $field );
    //    if (empty ( $c ))
    //      return;
    //    switch ($c ['type']) {
    //      case 'submit' :
    //      case 'reset' :
    //      case 'dropdown' :
    //        if (empty ( $value )) {
    //          if (! empty ( $c ['default'] ))
    //            $c ['selected'] = $c ['default'];
    //        } else {
    //          $c ['default'] = $value;
    //        }
    //        break;
    //      case 'radio' :
    //        if (empty ( $value )) {
    //          if (set_radio ( $c ['field'], $c ['value'], (isset ( $c ['default'] )) ? $c ['default'] : false ))
    //            $c ['checked'] = "checked";
    //        } else {
    //          to_index_array ( $value );
    //          foreach ( $value as $v ) {
    //            if ($c ['value'] == $v)
    //              $c ['checked'] = "checked";
    //          }
    //        }
    //        break;
    //      case 'checkbox' :
    //        // hum it seem have some bug on the
    //        // repopoulate
    //        // need to have the feild like "name[]"
    //        // not only "name"
    //        if (empty ( $value )) {
    //          if (set_checkbox ( $c ['field'], $c ['value'], (isset ( $c ['default'] )) ? $c ['default'] : false ))
    //            $d ['checked'] = "checked";
    //        } else {
    //          to_index_array ( $value );
    //          foreach ( $value as $v ) {
    //            if ($c ['value'] == $v)
    //              $c ['checked'] = "checked";
    //          }
    //        }
    //        break;
    //      default :
    //        $c ['value'] = set_value ( $c ['field'], (isset ( $c ['default'] )) ? $c ['default'] : null );
    //    }
    //  }
    //  public function set_values() {
    //    $post = $this->CI->input->post ();
    //    if (! empty ( $post ))
    //      ;
    //  }
    public function set_message($msg_array){
        foreach($msg_array as $key => $message){
            $this->CI->form_validation->set_message($key, $message);
        }
    }
    
    public function set_validation_obj($obj){
         $this->CI->form_validation->set_validation_obj($obj);
    }
    public function set_error($field ='', $message =''){
        $this->CI->form_validation->set_error($field , $message);
    }
    /**
     * excute the Codeignter form_validation->run();
     */
    public function run_validation(&$errors = null, $user_rule_msgs = null)
    {
        if (isset($user_rule_msgs)) {
            foreach ($user_rule_msgs as $k => $v) {
                $this->CI->form_validation->set_message($k, $v);
            }
        }
        $run = $this->CI->form_validation->run();
        if (!$run && isset($errors)) {
            foreach ($this->form_input_array() as $k => $v)
            {
                $tmp_field_error = form_error($this->config[$k]['field']);
                if (isset($this->config[$k]['field']) && $tmp_field_error != '')
                {
                    $errors[$this->config[$k]['field']] = str_replace(array('<p>','</p>'), array('',''), $tmp_field_error) ;
                }
            }
        }
        return $run;
    }
    /**
     * Execute the CodeIgniter
     * form_validation->error_string();
     *
     * @param $prefix string
     * @param $suffix string
     */
    public function validation_errors()
    {
        return array_filter(explode('|', $this->CI->form_validation->error_string('', '|')));
    }
    /**
     * Generate a array of all <input> tag
     *
     * @param $prefix string
     * @param $suffix string
     * @return array   of string
     */
    public function form_input_array($prefix = '', $suffix = "\n")
    {
        $f = array();
        $this->reset_current_field();
        do {
            array_push($f, $this->form_input($prefix, $suffix));
        } while ($this->get_next_current_field() != null);
        return $f;
    }
    /**
     * Generate a array of all <label> tag
     *
     * @param $prefix string
     * @param $suffix string
     * @return array   of string
     */
    public function form_label_array($prefix = '', $suffix = "\n")
    {
        $f = array();
        $this->reset_current_field();
        do {
            array_push($f, $this->form_label($prefix, $suffix));
        } while ($this->get_next_current_field() != null);
        return $f;
    }
}
/* End of file safe_form_class.php */
