<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * SAFe Database Class
 * @author Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
class Safe_database_class
{
    private $db = null; // the codeigniter db object
    private $_config = null;
    private $_data = null;
    public function __construct()
    {
    }
    /**
     * Determines which type of database is being used
     * @param array $config
     *                      				Configuration array to initialize database connection preferences
     */
    static function factory($config)
    {
        // Create the right db class according to config array
        switch ($config['dbdriver']) {
        case 'mysql':
            $db = new Safe_mysql_database_class();
            break;

        default:
            break;
        }
        // Configure the db object
        $db->configure($config);
        // Return the db object to user
        return $db;
    }
    public function configure($config)
    {
        // ... do some generic db configuration
        $this->_config = $config;
        return true;
    }
    /**
     * Opens database connection
     * @param array $config
     *                      				Configuration array to initialize database connection preferences
     */
    public function connect()
    {
        //Attempt to connect to database
        try {
            $CI = & get_instance();
            $_data = $CI;
            if ($CI->load->database($this->_config, true)) {
                $this->db = $CI->load->database($this->_config, true);
                //Check if the database exists
                //$util = $CI->load->dbutil();
                //if ($util->database_exists($this->_config['database'])){
                //	echo "database found";
                return true;
                //}
                
            }
        }
        catch(Exception $e) {
            //Error connecting to database
            show_error(__FUNCTION__ . ": can't open databases");
        }
        return false;
    }
    /**
     * Closes database connection
     */
    public function disconnect()
    {
        if (isset($this->db)) $this->db->close();
    }
    public function _error_message()
    {
        if (isset($this->db)) return "(" . $this->db->_error_number() . ") = " . $this->db->_error_message();
        return "";
    }
    /**
     * SQL Select statement
     * @param string $table   
     *                          				Table name where query will take place
     * @param array  $where   
     *                          				array for the where clause in a select statement
     * @param string $limit   
     *                          				sql limit option to limit number of results
     * @param string $offset  
     *                          				sql offset option
     * @param string $order_by
     *                          				sql order_by option
     * @param array  $join    
     *                          				array of join requirements for select statement
     * @param string $select  
     *                          				can use specific select query returns instead of *
     * @return array  $result
     *                				Returns an array of query results
     */
    public function select($table, $where = null, $limit = null, $offset = null, $order_by = null, $join = null, $select = null, $having = null)
    {
        $result = array();
        //Adds the orderby clause to the select statement
        if (isset($order_by) && $order_by != "") $this->db->order_by($order_by);
        if (isset($limit) && $limit != "") {
            if (isset($offset) && $offset != ""){
                $this->db->limit($limit,$offset);
            }else{
                $this->db->limit($limit);
            }
        }
        if (isset($where) && $where != "") $this->db->where($where);
        if (isset($having) && $having != "") $this->db->having($having);
        if (isset($join) && is_array($join) && count($join) > 0) {
            if (isset($join[2])) $this->db->join($join[0], $join[1], $join[2]);
            else $this->db->join($join[0], $join[1]);
        }
        if (isset($select) && $select != "") $this->db->select($select);
        $query = $this->db->get($table);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) $result[] = $row;
        }
        return $result;
    }
    public function get_select_count($table, $where = null, $join = null, $select = null, $having = null)
    {
        if (isset($where) && $where != "") $this->db->where($where);
        if (isset($having) && $having != "") $this->db->having($having);
        if (isset($join) && is_array($join) && count($join) > 0) {
            if (isset($join[2])) $this->db->join($join[0], $join[1], $join[2]);
            else $this->db->join($join[0], $join[1]);
        }
        if (isset($select) && $select != "") $this->db->select($select);
        if (isset($table) && $table != "") $this->db->from($table);
        
        $sql = '';
        if (count($this->db->ar_select) > 0) {
            $sql.= " SELECT ";
            $sql.= implode(', ', $this->db->ar_select);
            $this->db->ar_select = array();
        }
        if (count($this->db->ar_from) > 0) {
            $sql.= "\nFROM ";
            $sql.= $this->db->_from_tables($this->db->ar_from);
            $this->db->ar_from = array();
        }
        if (count($this->db->ar_join) > 0) {
            $sql.= "\n";
            $sql.= implode("\n", $this->db->ar_join);
            $this->db->ar_select = array();
        }
        if (count($this->db->ar_where) > 0 ) {
            $sql.= "\nWHERE ";
            $sql.= implode("\n", $this->db->ar_where);
            $this->db->ar_where = array();
        }
        if (count($this->db->ar_having) > 0) {
            $sql.= "\nHAVING ";
            $sql.= implode("\n", $this->db->ar_having);
            $this->db->ar_having = array();
        }
        if ($sql =='') return 0;
        $query = $this->db->query('select count(*) as numrows FROM (' . $sql .') as select_data_set ');
        if ($query->num_rows() == 0) {
            return 0;
        }
        $row = $query->row();
        return (int)$row->numrows;
    }
    /**
     * Inserts in a SQL table
     * @param string  $table
     *                        			Table information being inserted into
     * @param array   $data 
     *                        			associative array of data being inserted
     * @return boolean
     */
    public function insert($table, $data)
    {
        //Checks to see if the command ran successfully
        if ($this->db->insert($table, $data)) {
            if ($this->db->affected_rows() > 0) return true;
            else return false;
        }
        else return false;
    }
    /**
     * Deletes from a SQL table
     * @param string       $table
     *                             			Table information being deleted from
     * @param array        $pk   
     *                             			array of where clauses for delete
     * @param unknown_type $data 
     *                             			associative array of data for that table
     * @return boolean     
     */
    public function delete($table, $pk, $data)
    {
        foreach ($pk as $key){
            $this->db->where($key, $data[$key]);
        }
        //Checks to see if the command ran successfully
        if ($this->db->delete($table)) return true;
        else return false;
    }
    public function empty_table($table)
    {
        //Checks to see if the command ran successfully
        if ($this->db->empty_table($table)) return true;
        else return false;
    }
    /**
     * Updates a SQL table
     * @param string  $table
     *                        			Table name being updated
     * @param array   $pk   
     *                        			array of where clauses
     * @param array   $data 
     *                        			associative array of data being updated
     * @return boolean
     */
    public function update($table, $pk = array() , $data = array())
    {
        foreach ($pk as $key) $this->db->where($key, $data[$key]);
        //Checks to see if the command ran successfully
        if ($this->db->update($table, $data)) return true;
        else return false;
    }

    public function load_data($table, $data = array())
    {
        // Get temp file
        $tmpfname = $data['file_name'];
        $keys = $data['keys'];

        // make sure mysql can read it
        chmod($tmpfname, 0644);
        $query_str = 
            "LOAD DATA INFILE '" . $tmpfname . "' INTO TABLE " . $table ." FIELDS TERMINATED BY ',' ".
            " (".implode(",", $keys) . ");";
        $query = $this->db->query($query_str);

        if($query){
            $rc = true;
        }else{
            $rc = false;
        }
        @unlink($tmpfname);
        return $rc;
    }
    public function query($query_str)
    {
        $query = $this->db->query($query_str);

        if($query){
            $rc = true;
        }else{
            $rc = false;
        }
        return $rc;
    }
}
class Safe_mysql_database_class extends Safe_database_class
{
    public function configure($config)
    {
        //Sets codeignitor active record
        if ($config['active-record']){
            $active_record = true;
        }else{
            $active_record = false;
        }
        // Force disabling db_debug
        $config['db_debug'] = false;
        // Configure
        return parent::configure($config);
    }
}
?>
