<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * SNG Self Test
 *   Only includes the transcoding card self test for now
 *
 * @author Shaunt Libarian
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('service');
safe_require_class('table');
class Sng_self_test extends Safe_CI_Controller
{
    public $_status;
    public $_hardware;
    public $_transcoding_if;
    public function __construct()
    {
        parent::__construct();
        //Construct application SNGMS and Determine Status of NTG
        $this->_status = $this->_the_product->local_node()->software()->application()->status();
        //Construct Transcoding Adapters
        $this->_hardware = $this->_the_product->local_node()->hardware();
        $this->_transcoding_if = $this->_hardware->adapters(Safe_hardware_adapter_class::TRANSCODING_ADAPTER);
    }
    public function transcoding()
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Transcoding Hardware Self Test';
        $data['page_summary'] = 'This page tests all transcoding hardware installed in the system.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-register.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-register.png';
        $data['errors'] = array();
        //Initialize safe_table_class
        $table = new Safe_table_class();
        if ($this->_status == 1 || $this->_status == 3) {
            //Application not running or in error state
            $if_enum = array();
            //$if_enum['all'] = "All Interfaces";
            if (empty($this->_transcoding_if)) {
                $data['notif_error'] = 'No Transcoding Interface found !';
                $this->load->view("safe_header", $data);
                $this->load->view("safe_error");
                $this->load->view("safe_notifications", $data);
                $this->load->view("safe_footer", $data);
                return;
            } else {
                // Prepare Media If tables
                foreach ($this->_transcoding_if as $if) {
                    $if_enum[$if->name() ] = $if->name();
                    // Prepare heading
                    $table->heading = array(
                        'MAC Address',
                        'Version',
                        'IP address'
                    );
                    $i = 0;
                    // Prepare rows
                    $table->data = array();
                    $table->line_button = array();
                    foreach ($if->modules() as $mod) {
                        //var_dump ($mod);
                        $table->data[] = array(
                            strtoupper($mod->mac()) ,
                            $mod->version() ,
                            $mod->ip_address() ,
                            //$mod->capacity()
                            
                        );
                        $i++;
                    }
                    array_push($table->primary_key, $if->name());
                    $interfaces[] = $if->name();
                    // Generate table HTML code
                    $data['tables'][] = array(
                        'table_title' => 'Media interface ' . $if->name() . ' IP Address - ' . $if->ip_address() ,
                        'table' => $table->generate()
                    );
                }
                //Loads the HTML Data
                $this->load->view("safe_header", $data);
                $this->load->view("safe_error");
                //$this->load->view ("safe_expand_panel",$data);
                $this->load->view("safe_notifications", $data);
                $this->load->view("safe_multitable", $data);
                $test = new Safe_configurable_object_class('', '');
                $test->add_enum_field('interface_test', 'Interface to test', 'dropdown', 'all', $if_enum);
                $config = $test->get_data();
                $this->load->library("safe_form_class", $config);
                $data['form_title'] = 'Transcoding Self Test';
                //$data['action'] = 'ntg_self_test/test';
                $data['form'] = $this->safe_form_class->form_input_array();
                $this->safe_form_class->set_action('sng_self_test/test_transcoding');
                $data['label'] = $this->safe_form_class->form_label_array();
                $data['form_open'] = $this->safe_form_class->form_open();
                $data['buttons'] = array(
                    array(
                        'name' => 'start',
                        'value' => 'Start Test',
                        'type' => 'submit'
                    ) ,
                );
                //$this->load->view ( "safe_table_with_sizing", $data);
                $this->load->view("safe_form", $data);
                $this->load->view("safe_footer", $data);
            }
        } elseif ($this->_status == - 1) {
            //Unrecognized state
            $data['notif_error'][] = $this->_the_app->name() . ' is currently unrecognized.';
            //Loads the HTML Data
            $this->load->view("safe_header", $data);
            $this->load->view("safe_error");
            //$this->load->view ("safe_expand_panel",$data);
            $this->load->view("safe_notifications", $data);
            $this->load->view("safe_footer", $data);
        } else {
            //NTG is started
            $data['notif_error'][] = $this->_the_app->name() . ' is currently started. Please proceed to the ' . $table->button(array(
                'url' => 'sng_control_panel',
                'name' => 'Control Panel'
            )) . ' to stop the NTG Service';
            $this->load->view("safe_header", $data);
            $this->load->view("safe_error");
            //$this->load->view ("safe_expand_panel",$data);
            $this->load->view("safe_notifications", $data);
            $this->load->view("safe_footer", $data);
        }
    }
    //Runs the self test
    //$interface is the device to run the self test on.
    function test_transcoding($interface = null)
    {
        // Check if interface come from post or parameter
        $post = $this->input->post();
        if (isset($post['interface_test'])) $interface = $post['interface_test'];
        // Capacity limited to 50 channels
        $capacity = 50;
        // Set the basic data
        $data['page_title'] = 'Transcoding hardware Self Test';
        $data['page_summary'] = 'This page tests all transcoding hardware installed in the system.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-register.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-register.png';
        $data['errors'] = array();
        $table = new Safe_table_class();
        // From this point we will display something for sure, so display header
        $this->load->view("safe_header", $data);
        // Process displays wait message
        $data['wait_message'] = '</br><b>Running Self Test...</b></br>&nbsp;';
        $this->load->view("safe_wait", $data);
        safe_flush_ouput();
        // TODO(wadam) - No HTML code allowed in controller, must be in the view
        echo "
      <div id='tid-4dcf1432'class='ui-widget' style='width:100%; display:inline-block; margin-top: 6px; margin-bottom: 6px;'>
      <div id='tid-4dcf1432'class='widget-content-header ui-state-active ui-corner-top' style='padding: 5px; '>Running Self test on " . $interface . " </div>
      <div id='tid-4dcf1432'class='widget-content-body ui-state-active ui-corner-bottom' style='padding: 1px; '>
      <table cellspacing='0' cellpadding='3px' width='100%' border='0' class='mytable' id='table-tid-4dcf1432'>
      ";
        echo "<tr><td>Starting Self Test on <b>" . $interface . "</b></td></tr>";
        // TODO(wadam) - get binary path from product/application
        $cmd = "sudo /usr/local/sng/bin/sng-self-test-transcoding -d " . $interface . " -c " . $capacity;
        $desciptorspec = array(
            0 => array(
                "pipe",
                "r"
            ) ,
            1 => array(
                "pipe",
                "w"
            ) ,
            //2 => array("pipe","w"),
            //2 => array("file","/tmp/error_output.txt", "w")
            
        );
        $cwd = '/usr/local/sng/bin';
        $process = proc_open('/bin/bash', $desciptorspec, $pipes, $cwd);
        if (is_resource($process)) {
            // anatomy of $pipes: 0 => stdin, 1 => stdout, 2 => error log
            fwrite($pipes[0], $cmd);
            fclose($pipes[0]);
            //var_dump ($pipes[1]);
            //print pipe output
            while ($s = fgets($pipes[1], 1024)) {
                ob_implicit_flush(true);
                ob_start();
                if ($s != null && strlen(trim($s))) echo "<tr><td>$s</td></tr>";
                ob_end_flush();
            }
            //close pipe
            fclose($pipes[1]);
            //fclose($pipes[2]);
            $return_value = proc_close($process);
            //Checks the return code
            // TODO(wadam) - No HTML code allowed in controller, must be in the view
            if ($return_value == 0) {
                echo "<tr><td><font color='green'>Self Test: <b>PASSED</b></font></td></tr>";
            } else {
                //Displays the error Log if there is an error
                echo "<tr><td><font color='red'>Self Test: <b>FAILED</b></font></td></tr>";
            }
        }
        // TODO(wadam) - No HTML code allowed in controller, must be in the view
        echo "
      <table width='100%' class='mytable'><tr><td class='mytablelegend'  colspan='%s' align='center'><span id='' style='display: inline-block; '>
      <form action=" . base_url('sng_self_test') . "/transcoding method='post' enctype='multipart/form-data'>
      <input  value='Back' type='submit' class='ui-state-default ui-corner-all'>
      </form>
      </span>
      </td>
      </tr>
      </table>
      </table>
      </div>
      </div>
      ";
        //$table->footer_button = array(array ('url' => base_url('ntg_self_test'), 'name'=> 'Return to Self Test Page'));
        //$data['table'] = $table->generate();
        $this->load->view("safe_error");
        //$this->load->view ("safe_expand_panel",$data);
        $this->load->view("safe_notifications", $data);
        //$this->load->view ( "safe_table", $data );
        $this->load->view("safe_footer", $data);
    }
}
?>
