<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
//safe_var_dump($objects);
/* Multiple column lists using one <ul>
 * http://csswizardry.com/2010/02/mutiple-column-lists-using-one-ul/
 */
echo '
<style>
/*------------------------------------*\
    LISTS
\*------------------------------------*/
ul.safe_list {
    width:100%;
    #margin-bottom:20px;
    overflow:hidden;
    #border-top:1px solid #ccc;
    margin:0;
    margin-left:10px;
    padding:0;
}
ul.safe_list li{
    line-height:1.5em;
    #border-bottom:1px solid #ccc;
    float:left;
    display:inline;
}
li.safe_list_label { width:15%;}
li.safe_list_value { width:85%; align:left;}
</style>
';
// Build change type to handle
$_changes = array(
    'device-remove' => array(
        'type' => 'warning',
        'description' => '<b>HDD Removed</b>, please shutdown appliance and insert a new HDD.',
    ),
    'device-recovery' => array(
        'type' => 'warning',
        'description' => '<b>HDD Recovery in progress</b>',
    ),
    'device-fail' => array(
        'type' => 'warning',
        'description' => '<b>HDD Failure</b>, please shutdown appliance and replace following disk:',
    ),
    'device-spare' => array(
        'type' => 'info',
        'description' => 'New HDD detected:',
        'button' => array(
            'recover_change' => array(
                'label' => 'Recover',
                'description' => 'Start Recovery Process',
            ),
        ),
    ),
);
//safe_var_dump($table_data);
$_change_count = 0;
// Iterate on objects
foreach($objects['name'] as $_id => $_name){
    // Prepare dialog
    $_dialog_content = array();
    // Check if this change type need to be displayed ?
    $_type = $objects['value'][$_id]['type'];
    if(in_array($_type, array_keys($_changes))){
        // Populate dialog content
        $_dialog_content[] = $_changes[$_type]['description'];
        $_details = '<ul class="safe_list ">';
        $_details .= '<li class="safe_list_label"><b>Name:</b></li><li class="safe_list_value">'.$_name.'</li>';
        foreach($objects['data'][$_id] as $_k => $_v){
            // Skip type
            if('type' !== $_k){
                // Ensure value
                $_value = $objects['value'][$_id][$_k];
                if(!$_value){
                    $_value = '&nbsp;';
                }
                $_details .= '<li class="safe_list_label"><b>'.$_v['label'].':</b></li><li class="safe_list_value">'.$_value.'</li>';
            }
        }
        $_dialog_content[] = $_details.'</ul>';

        // Buttons ?
        foreach($_changes[$_type]['button'] as $_button_name => $_button){
            // Locate in table_data definition if exists
            foreach($table_data['row']['button'][$_id] as $_button_def){
                if(!strcasecmp($_button_name, $_button_def['name'])){
                    $_dialog_content[] = $_button['description'] . safe_button_click($_button_def['name'],$_button['label'],$_button_def['url'].'/'.$table_data['row']['key'][$_id]); 
                }
            }
        }
        // Add the Details button
        $_dialog_content[] = 'RAID Status '.safe_button_click('details', 'Details', $url_base.'/details');
        // Build dialog type method name
        $_dialog = 'safe_webdialog'.$_changes[$_type]['type'];
        // Display dialog
        echo '<br/>'.$_dialog($_dialog_content);
        $_change_count++;
    }
}
// Display all good if no change displayed
if(!$_change_count){
    $_dialog_content = array();
    $_dialog_content[] = 'RAID in Active, Clean and Sync State.'.
            safe_button_click('details', 'Details', $url_base.'/details');
    echo safe_webdialoginfo(
        $_dialog_content);
}

