#!/usr/bin/env python2.7
# vim: tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab
"""
* Copyright (C) 2011   Sangoma Technologies Corp.
* All Rights Reserved.
*
* Author(s)
* William Adam <william.adam@sangoma.com>
*
* This code is Sangoma Technologies Confidential Property.
* Use of and access to this code is covered by a previously executed
* non-disclosure agreement between Sangoma Technologies and the Recipient.
* This code is being supplied for evaluation purposes only and is not to be
* used for any other purpose.
"""
import sys
from .server import Server
from .module import Module
from .collection import Collection

class Application(Server):

    def __init__(self, name, version, description=None, logger=None):
        self._version = version
        super(Application, self).__init__(name, description, logger)

    @property
    def module(self):
        return self._children

    def __getitem__(self, name):
        return self._get_child(name)

    def _add_module(self, module):
        self._add_child(module)

    @property
    def version(self):
        return self._version

    def config(self):
        return self.delegate('GET', None, None, None, 'config')
