<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
if (!defined('BASEPATH')) exit('No direct script access allowed');
/**
 * Safe upload class
 *
 * @author Michel Buczynski
 * @version
 */
class Safe_upload_class
{
    //I use "upload_" nomemclature since this library can may be extend other class.
    
    /**
     * Preferences array of File uploading lib of Codeigneter
     * http://codeigniter.com/user_guide/libraries/file_uploading.html
     * @var array (string => string)
     */
    public $upload_config = array(
        'upload_path' => '/tmp/SAFeUPLOADs/',
        'allowed_types' => '*',
        'max_size' => '1024'
    );
    /**
     * $this->upload->data() ofFile uploading lib of Codeigneter
     * http://codeigniter.com/user_guide/libraries/file_uploading.html
     * @var array (string => string)
     */
    public $upload_data = array();
    /**
     * The full path and filename of the uploaded file.
     * @var string
     */
    public $upload_full_path = '';
    public $_errors = array();
    function __construct()
    {
        // Call the Model constructor
        //parent::__construct ();
        
    }
    // We give Getter and Setter only for the form. Since the properties are public.
    
    /**
     * @return the $upload_config
     */
    public function get_config()
    {
        return $this->upload_config;
    }
    /**
     * @return the $upload_data
     */
    public function get_data()
    {
        return $this->upload_data;
    }
    /**
     * @return the $upload_full_path
     */
    public function get_full_path()
    {
        return $this->upload_full_path;
    }
    /**
     * @param string $upload_config
     */
    public function set_config($upload_config)
    {
        $this->upload_config = $upload_config;
    }
    public function get_errors()
    {
        return $this->_errors;
    }
    /**
     * The path to the folder where the upload should be placed. The folder must be writable and the path can be absolute or
     * relative.
     * @param string $upload_path
     */
    public function set_upload_path($upload_path)
    {
        $this->upload_config['upload_path'] = $upload_path;
    }
    /**
     * The mime types corresponding to the types of files you allow to be uploaded. Usually the file extension can be used as the
     * mime type. Separate multiple types with a pipe.
     * @param string $file_extension
     */
    public function set_allowed_types($file_extension)
    {
        $this->upload_config['allowed_types'] = $file_extension;
    }
    /**
     * The maximum size (in kilobytes) that the file can be. Set to zero for no limit. Note: Most PHP installations have their own
     * limit, as specified in the php.ini file. Usually 2 MB (or 2048 KB) by default.
     * @param string $size_in_kilobytes
     */
    public function set_max_size($size_in_kilobytes)
    {
        $this->upload_config['max_size'] = $size_in_kilobytes;
    }
    /**
     * @brief Check if currently in an upload request
     *         
     * @return boolean
     */
    public function is_uploading()
    {
        $CI = & get_instance();
        return $CI->input->post('Upload');
    }
    /**
     * Performs the upload based on the preferences you've set. The form must be a "multipart type.
     * @param string $field    The field name of <input type="file">, Default='archive'
     * @param string $filename If set CodeIgniter will rename the uploaded file to this name. It will overwrite if exist.
     * @return string The fullpath and filename of the uploaded file or false
     */
    public function upload($field = 'archive', $filename = '')
    {
        $CI = & get_instance();
        $this->_error = array();
        if ($CI->input->post('Upload')) {
            //verify the destination
            $this->upload_config['upload_path'] = safe_verify_tmp($this->upload_config['upload_path']);
            // if you specify a filename, you normally want to overwrite it.
            //  unlink ( $this->upload_config ['upload_path'] . '/' . $filename );
            if ($filename) {
                $this->upload_config['overwrite'] = true;
                $this->upload_config['file_name'] = $filename;
            }
            // DO-it
            $CI->load->library('upload', $this->upload_config, 'safe_upload_lib');
            $upload = $CI->safe_upload_lib;
            if ($upload->do_upload($field)) {
                // we have it
                $this->upload_data = $upload->data();
                $this->upload_full_path = $this->upload_data['full_path'];
                if (file_exists($this->upload_full_path)) { // Just to be sure
                    return $this->upload_full_path;
                }
                $this->_errors[] = 'ERROR: ' . $this->upload_full_path . "doesn't exist!";
            }
            // we don't have it.
            $this->_errors = $upload->error_msg;
        }
        return false;
    }
    /**
     * Remove (delete) the uploaded file.
     */
    public function remove_upload_file()
    {
        try {
            if (file_exists($this->upload_full_path)) unlink($this->upload_full_path);
        }
        catch(Exception $e) {
            safe_add_error("{$this->upload_full_path}: " . $e->getMessage());
        }
    }
}
/* End of file safe_upload_class.php */
