<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * Safe CRUD Table Class
 *
 * @author Shaunt Libarian
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
safe_require_class('safe_table_class');
class Safe_crud_table_class extends Safe_table_class
{
    private $_controller_url = "";
    private $_url_suffix = "";
    private $line_button_counter = 0;
    //add add a confirm button type to the template
    //'confirm' => '<input  value="%s" type="button" onclick="safe_handle_confirm_button(this);" class="ui-state-default ui-corner-all" >',
    //'button'  => '<input  value="%s" type="submit" class="ui-state-default ui-corner-all">'
    var $template_crud = array(
         'confirm' => 'type="button" onclick="safe_handle_confirm_button(this);"'
     );
    
    /**
     * Sets table headings
     *
     * @param Array   $table_heading:
     *                                 					Contains an array of table headings
     *                                 
     * @return Nothing
     */
    public function set_headings($table_heading = "")
    {
        $this->heading = $table_heading;
    }
    public function set_controller_url($controller_url = "")
    {
        $this->_controller_url = $controller_url;
    }
    /**
     * Adds a suffix to the URL. I.e. ntg_sip_profiles/edit_XXX/profile_internal
     *
     * @param String $url_suffix:
     *                            					Contains the Prefix string to place before the post variables
     */
    public function set_url_suffix($url_suffix = "")
    {
        if (strlen($url_suffix)) $this->_url_suffix = '_' . $url_suffix;
        else $this->_url_suffix = "";
    }
    /**
     * Generate Standard HTML Table
     *
     * @return HTML table to controller
     */
    public function generate_table()
    {
        return $this->generate();
    }
    /**
     * Generate Add button at the bottom of a table
     *
     * @param Boolean $add_new:
     *                           				Contains a true/false value if there is a need for a Add button at the bottom of the table.
     * @return nothing
     */
    public function allow_create($add_new = false, $primary_key = null, $button='add')
    {
        $tmp_button = array_shift(safe_format_button($button));
        if ($add_new) {
            if (isset($primary_key)) {
                $this->footer_button = array(
                    array(
                        'url' => base_url($this->_controller_url) . '/' . $tmp_button['id'] .'_form' . $this->_url_suffix . '/' . $primary_key,
                        'name' => ucfirst($tmp_button['value']),
                        'type' => 'create'
                    )
                );
            } else {
                $this->footer_button = array(
                    array(
                        'url' => base_url($this->_controller_url) . '/' .  $tmp_button['id']. '_form' . $this->_url_suffix,
                        'name' => ucfirst($tmp_button['value']),
                        'type' => 'create'
                    )
                );
            }
        }
    }
    /**
     * Creates a custom footer button
     *
     * @param string $label      
     * @param string $primary_key
     */
    public function custom_footer_button($label, $primary_key = null, $type='button')
    {
        $tmp_button = array_shift(safe_format_button($label));
        $actions = array(
                    "button" => "",
                    "create" => "_form",
                    "confirm" => "_confirm"
                );
        if (isset($actions[$type])){
            $action_name = $actions[$type];
        }else{
            $action_name = '';
        }
            
        if (isset($primary_key)) {
            $this->footer_button = array(
                array(
                    'url' => base_url($this->_controller_url) . '/' . $tmp_button['id'] . $action_name . $this->_url_suffix . '/' . $primary_key,
                    'name' => ucfirst($tmp_button['value']),
                    'type' => $type
                )
            );
        } else {
            $this->footer_button = array(
                array(
                    'url' => base_url($this->_controller_url) . '/' . $tmp_button['id'] . $action_name . $this->_url_suffix,
                    'name' => ucfirst($tmp_button['value']),
                    'type' => $type
                )
            );
        }
    }
    /**
     * Generate a view footer button
     * @param boolean $show_view  
     * @param string  $primary_key
     */
    public function show_view($show_view = false, $primary_key = null)
    {
        if ($show_view) {
            if (isset($primary_key)) {
                $this->footer_button = array(
                    array(
                        'url' => base_url($this->_controller_url) . '/' . 'view' . $this->_url_suffix . '/' . $primary_key,
                        'name' => 'View'
                    )
                );
            } else {
                $this->footer_button = array(
                    array(
                        'url' => base_url($this->_controller_url) . '/' . 'view' . $this->_url_suffix,
                        'name' => 'View'
                    )
                );
            }
        }
    }
    /**
     * Generate multiple footer buttons.
     *
     * @param array $button_names
     */
    public function multiple_footer_buttons($button_names = array())
    {
        if (!empty($button_names)) {
            foreach ($button_names as $buttons) {
                if ($this->primary_key) $button_array[] = array(
                    'url' => base_url($this->_controller_url) . '/' . strtolower($buttons) . '/' . $this->primary_key,
                    'name' => ucfirst($buttons) ,
                    'extra_arguements' => 'id="' . strtolower($buttons) . '"'
                );
                else $button_array[] = array(
                    'url' => base_url($this->_controller_url) . '/' . strtolower($buttons) ,
                    'name' => ucfirst($buttons) ,
                    'extra_arguements' => 'id=' . strtolower($buttons) . '"'
                );
            }
            $this->footer_button = $button_array;
        }
    }
    /**
     * Generate Edit button at the bottom of a table
     *
     * @param Boolean $add_edit:
     *                            				Contains a true/false value if there is a need for a Add button at the bottom of the table.
     * @return nothing
     */
    public function allow_edit($add_edit = false)
    {
        if ($add_edit) {
            if ($this->primary_key) {
                $this->footer_button = array(
                    array(
                        'url' => base_url($this->_controller_url) . '/' . 'edit' . $this->_url_suffix . '/' . $this->primary_key,
                        'name' => 'Edit'
                    )
                );
            } else {
                $this->footer_button = array(
                    array(
                        'url' => base_url($this->_controller_url) . '/' . 'edit' . $this->_url_suffix,
                        'name' => 'Edit'
                    )
                );
            }
        }
    }
    /**
     * Generate Cancel button at the bottom of a table
     *
     * @param Boolean $allow_cancel:
     *                                				Contains a true/false value if there is a need for a Cancel button at the bottom of the table.
     * @param String  $button_label:
     *                                Contains button label (for example Back)
     * @return nothing
     */
    public function allow_cancel($allow_cancel = false, $button_label = 'Cancel')
    {
        if ($allow_cancel) {
            $this->footer_button = array(
                array(
                    'url' => base_url($this->_controller_url) ,
                    'name' => $button_label
                )
            );
        }
    }
    /**
     *
     * Generate HTML Button Anywhere
     * @param String  $button_name:     
     *                                   				Name to appear in the HTML Button
     * @param String  $primary_key:     
     *                                   				Contains the primary key of the table row which will be passed in the url when a button is clicked.
     * @param String  $button_css_class:
     *                                   				Contains a css class that needs to applied to all buttons on the given table row. The CSS Class name MUST be given.
     * @param Boolean $base_url:        
     *                                   				If set to true, the base url of the site will be used in the button link.
     *                                   				I.e. $base_url = false, url = nsc_sip_profiles/edit
     *                                   					 $base_url = true, url = http://shaunt-nsc-devel.sangoma.local:81/SAFe/nsc_sip_profiles/modify/internal
     *                                   
     */
    public function create_button($base_url = false, $button_name, $button_css_class = '', $primary_key = null, $button_value = null, $skip_filter=false)
    {
        if (isset($button_value)){
            $line_button = strtolower($button_value);
        }
        else{
            $line_button = strtolower($button_name);
        }
        
        //check if have confirm tag like "modify:confirm"
        if(strpos($button_name, ":") === false){
            //no confirm tag found
            $button_type = 'button';
        }else{
            list($button_name,$button_type) = explode(':', $button_name);
            $button_type = ($button_type == 'confirm') ? 'confirm' : '';
        }
        
        //if modify:confirm tag, the url become modify_confirm
        $line_button_sub_url = ($button_type == 'button') ? strtolower($line_button) : strtolower($button_name).'_'.$button_type;
        
        $button_name = ucfirst($button_name);
        $this->primary_key = $primary_key;
        if (isset($primary_key)){
            $suffix = '/' . $primary_key;
        }
        else{
            $suffix = '';
        }
        if ($base_url){
            if (!$skip_filter && ((strtolower($button_name) == strtolower('Cancel')) || (strtolower($button_name) == strtolower('Back')))){
                $url = base_url($this->_controller_url);
            }
            else{
                $url = base_url($this->_controller_url) . '/' . $line_button_sub_url . $this->_url_suffix . $suffix;
            }
        }
        else{
            if (!$skip_filter && ((strtolower($button_name) == strtolower('Cancel')) || (strtolower($button_name) == strtolower('Back')))){
                $url = $this->_controller_url;
            }
            else {
                $url = $this->_controller_url . '/' . $line_button_sub_url . $this->_url_suffix . $suffix;
            }
        }
        $this->line_button[$this->line_button_counter][] = array(
            'url' => $url,
            'name' => $button_name,
            'label' => '',
            'extra_class' => $button_css_class,
            'extra_arguements' => '',
            //add button property:type
            'type'        => $button_type
        );
        $this->line_button_counter++;
    }
    /**
     * Generate Add button at the bottom of a table
     *
     * @param Array   $data:            
     *                                    				Contains table row elements to be displayed.
     * @param String  $primary_key:     
     *                                    				Contains the primary key of the table row which will be passed in the url when a button is clicked.
     * @param String  $buttons:         
     *                                    				Contains contents of the line buttons. Given with pipes (i.e. Modify|Delete).
     * @param String  $button_css_class:
     *                                    				Contains a css class that needs to applied to all buttons on the given table row. The CSS Class name MUST be given.
     * @param Boolean $base_url:        
     *                                    				If set to true, the base url of the site will be used in the button link.
     *                                    				I.e. $base_url = false, url = nsc_sip_profiles/edit
     *                                    					 $base_url = true, url = http://shaunt-nsc-devel.sangoma.local:81/SAFe/nsc_sip_profiles/modify/internal
     * @param String  $button_args:     
     *                                    				Contains any extra html arguements that would need to be applied to buttons on the table row. HTML arguements must be provided (i.e. disabled="disabled")
     *                                    
     * @return nothing
     */
    public function add_row($data, $primary_key, $buttons, $button_css_class = '', $base_url = false, $button_args = '')
    {
        $line_elements = array();
        $line_buttons = array();
        $url = "";
        array_push($this->data, $data);
        if (isset($buttons) && $buttons != "") {
            //$line_buttons = explode('|', $buttons);
            $line_buttons = safe_format_button($buttons);
            $this->primary_key[$this->line_button_counter] = $primary_key;
            foreach ($line_buttons as $button_element) {
                $button_type = $button_element['type'];
                $line_button = $button_element['id'];
                $button_name = ucfirst($button_element['value']);
                //if detete:confirm tag, the url become delete_confirm 
                $line_button_sub_url = ($button_type == 'button') ? strtolower($line_button) : strtolower($line_button).'_'.$button_type;
                
                if ($base_url) $url = base_url($this->_controller_url) . '/' . $line_button_sub_url . $this->_url_suffix;
                else $url = $this->_controller_url . '/' . $line_button_sub_url . $this->_url_suffix;
                $this->line_button[$this->line_button_counter][] = array(
                    'url' => $url,
                    'name' => $button_name,
                    'label' => '',
                    'extra_class' => $button_css_class,
                    'extra_arguements' => $button_args,
                    //add button property:type
                    'type'        => $button_type
                );
            }
            $this->line_button_counter++;
        }
    }
}
?>
