<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * NSC Directory module
 * @author: William Adam
 *          
 */
require_once ('application/helpers/safe_helper.php');
safe_module_require_class('fs', 'directory_module');
class Nsc_directory_module_class extends Fs_directory_module_class
{
    // Just overload the create domain function
    public function create_domain($domain_name)
    {
        return new Nsc_domain_class($this->node() , $this->object_name() . '/domain', $domain_name);
    }
    public function api_create_domain($name, $data=null) {
        $domain = new Nsc_domain_class($this->node(), $this->object_name().'/domain', $name);
        $domain->configure();
        if($data) {
            $domain->set_data_values($data);
        }
        return $domain;
    }
    public function check_object_usage($src_module_name, $obj_type, $obj_name, $sub_type = null, $sub_name = null)
    {
        $usages = array();
        $domains = $this->domains();
        foreach($domains as $domain){
            if ($domain->sip_profile_check($obj_name)  && $src_module_name == 'sip' && $obj_type == 'profile' ) {
                $usages[] = array (
                        'name' => $this->name(),
                        'obj_type' => 'domain',
                        'obj_name' => $domain->name()
                );
            }
        }
        return array_merge($usages , parent::check_object_usage($src_module_name, $obj_type, $obj_name, $sub_type, $sub_name));
    }
}
?>
