<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS SIP Profile Status Page
 *
 * @author Shaunt Libarian
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('object');
safe_require_class('crud_table');
safe_require_class('form');
class Fs_sip_trunk_status extends Safe_CI_Controller
{
    public $_sip_profiles;
    public $_status;
    public $_sip_trunks;
    private $_sip_module = null;
    public function __construct()
    {
        parent::__construct();
        $this->_sip_profiles = $this->_the_app->sip_profiles(); //Holds all SIP Profiles
        $this->_sip_trunks = $this->_the_app->sip_trunks();
        $this->_status = $this->_the_product->local_node()->software()->application()->status();
        $this->_sip_module = $this->_the_app->module("sip");
    }
    public function index()
    {
        // Set the basic data
        $data['page_title'] = 'SIP Trunks Status';
        $data['page_summary'] = 'This page allows viewing the SIP Trunks Status.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $this->load->view("safe_header", $data);

        if (Safe_service_class::STATUS_RUNNING != $this->_status) {
            $data['errors'] = array();
            $table = new Safe_table_class();
            $data['notif_error'][] = $this->_the_app->description() . ' is currently stopped.'; 
            $data['notif_error'][] = safe_form_with_submit_button('Click here to ', '/SAFe/sng_control_panel', 'Start the Service', '');
            //Loads the HTML Data
            $this->load->view("safe_error");
            $this->load->view("safe_notifications", $data);
            $this->load->view("safe_footer", $data);
            return;
        }
        //Print SIP Trunk Status
        $table = new Safe_crud_table_class();
        $data['table_size'] = '100%';
        $data['table_container_class'] = 'safe_datatable';
        $data['table_display_length'] = 50;
        $data['table_title'] = $table->set_title('SIP Trunk Status');
        $data['table_id'] = 'sip_trunk_status';
        $table->set_controller_url(base_url($this->router->fetch_class()));
        $table->set_form_method('get');
        $table->data_formatter = array(null, 'none', 'none');
        $table->set_headings(array(
            'Name',
            'Status',
            'State',
            'SIP Profile',
            'IN Calls',
            'OUT Calls',
            'Failed IN Calls',
            'Failed OUT Calls',
        ));
        if (!empty($this->_sip_trunks)) {
            foreach ($this->_sip_trunks as $profile) {
                if (isset($profile)) {
                    $prof_data = $profile->get_data_values();
                    $xml_trunk = $this->_sip_module->api_gateway_status_profile($profile->name());
                    if($xml_trunk){
                        if ($xml_trunk['state'] == "REGISTER" || $xml_trunk['state'] == "REGED") $state = '<font color="green"><b>' . $xml_trunk['state'] . '</b></font>';
                        elseif ($xml_trunk['state'] == "FAILED" || $xml_trunk['state'] == "FAIL_WAIT") $state = '<font color="red"><b>' . $xml_trunk['state'] . '</b></font>';
                        else $state = '<font color="orange"><b>' . $xml_trunk['state'] . '</b></font>';
                        if ($xml_trunk['status'] == "UP") $status = '<font color="green"><b>' . $xml_trunk['status'] . '</b></font>';
                        else $status = '<font color="red"><b>' . $xml_trunk['status'] . '</b></font>';
                        $calls_in = $xml_trunk['calls-in'];
                        $calls_out = $xml_trunk['calls-out'];
                        $calls_in_fail = $xml_trunk['failed-calls-in'];
                        $calls_out_fail = $xml_trunk['failed-calls-out'];
                    }else{
                        $state = '<font color="orange"><b>Not Applied</b></font>';
                        $status = '<font color="red"><b>Not Activated</b></font>';
                        $calls_in = 'N/A';
                        $calls_out = 'N/A';
                        $calls_in_failed = 'N/A';
                        $calls_out_failed = 'N/A';
                    }
                    $table->add_row(array(
                        $profile->name() ,
                        $status,
                        $state,
                        $prof_data['sip_profile'],
                        $calls_in,
                        $calls_out,
                        $calls_in_fail,
                        $calls_out_fail,
                    ) , '', '', '');
                }
            }
        }
        $table->footer_button = array(
            array(
                'url' =>  base_url($this->router->fetch_class()),
                'name' => 'Refresh'
            )
        );
        $data['table'] = $table->generate_table();
        $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
}
?>
