<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/

if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
safe_require_controller('sng','config_manager');
class fs_carrier_config extends Sng_config_manager
{
    public function __construct()
    {
        parent::__construct();
    }
    public function index()
    {
        return $this->modify('lcr');
    }
    /**
     * Function create a json encoded form to Create an aggregated object
     *   using popup dialog in browser
     */
    public function upload_form_child($module_name, $obj_type, $obj_name, $sub_type, $reload=false)
    {
        $this->upload_form($module_name, $obj_type, $reload, $obj_name, $sub_type);
    }
    public function upload_form($module_name, $obj_type,$reload=false, $obj_name=null, $sub_type)
    {
        $profile_exist = false;
        // Check post request
        $post = $this->input->post();
        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name($module_name);
        // Get config object
        $cfg_obj = $module->config();
        $_type = $obj_type;
        // Add a sub object ?
        if($obj_name && $sub_type){
            $aggregated_object = $module->get_aggregate_objects($obj_type);
            if($aggregated_object[$obj_name]){
                $module = $aggregated_object[$obj_name];
                $_type = $sub_type;
            }
        }
    
        $data_cfg = $module->get_aggregate_object_definition($_type);
        $action_name = 'upload';
        if(isset($data_cfg['controller']['config_manager']['allow_create_button'])){
            $tmp_button = safe_format_button($data_cfg['controller']['config_manager']['allow_create_button']);
            if(isset($tmp_button['add'])){
                $action_name = $tmp_button['add']['value'];
            }
        }
        $data_cfg['popup_add_form'] = true;
        if ($data_cfg['autoname'] && !$data_cfg['popup_add_form']){
            //no confirm dialog
            $this->add($module_name, $obj_type, $obj_name, $sub_type);
            exit();
        }else{
            $param = new Sng_config_manager_param_class($module,$_type);
            $param->configure();
            
            $param->add_field('profile-name', 'Profile Name', 'hidden', $name, 50);
            $param->add_upload_field('archive','Rate file','upload','',30,true);
            $param->set_field_rules('archive','required');
            $config = $param->get_data();
            $this->load->library("safe_form_class", $config);
    
            // Set the basic data
            $data['page_title'] = $module->description() . ' Configuration';
            //Display form with checkboxes
            $data['form_title'] = $module->description() . ' : '.ucfirst($action_name).' ' . $module->aggregate_object_name($_type);
            $data['form'] = $this->safe_form_class->form_input_array();
            //pass the copy obj name to save
            if(isset($config['save']) && $config['save']['type'] ==  'hidden'){
                $data['form'][] = '<input type="hidden" name="save" value="Save" />';
            }
            $data['form'][] = '<input type="hidden" name="Upload" value="Upload" />';
            $data['form_cfg'] = $this->safe_form_class->config;
            $data['label'] = $this->safe_form_class->form_label_array();
            $data['form_open'] = $this->safe_form_class->form_open();
            $data['buttons'] = array(
                    array(
                            'name' => 'add',
                            'value' => ucfirst($action_name),
                            'type' => 'submit'
                    ) ,
                    array(
                            'name' => 'cancel',
                            'value' => 'Cancel',
                            'type' => 'submit'
                    ) ,
            );
            //******
            //clear the content in page cache and get the view content
            ob_start();
            ob_clean();
            $this->load->view("safe_form_json", $data);
            $data['content'] = ob_get_contents();
            $data['content'] = '<b>All old rates will be deleted after upload this file.</b> '.$data['content'] ;
            ob_clean();
            //******
    
            $data['page_title'] = $data['form_title'];
        }
        $data['result'] = true;
        if($reload === true){
            $data['result'] = false; //user sumbit data did not pass the validation, return false and reload the form with error message
        }
        $data['reload'] = $reload;
        if($obj_name && $sub_type){
            $data['action_url'] = base_url($this->router->fetch_class().'/'.$action_name.'/'. $module_name. '/' . $obj_type.'/'.$obj_name.'/'.$sub_type);
        }else{
            $data['action_url'] = base_url($this->router->fetch_class().'/'.$action_name.'/'. $module_name. '/' . $obj_type);
        }
        $data['action_method'] = 'POST';
        echo json_encode($data);
    }
    /**
     * upload an csv file
     * @param unknown_type $cfg
     * @param unknown_type $sub_cfg
     */
    public function upload($module_name, $obj_type, $obj_name=null, $sub_type=null)
    {
        $profile_exist = false;
        // Check post request
        $post = $this->input->post();
        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name($module_name);
        
        // Get config object
        $cfg_obj = $module->config();
        $_type = $obj_type;
        $action_name = 'upload';
        $aggregated_object = $module->get_aggregate_objects($obj_type);
        if($obj_name && $aggregated_object[$obj_name]){
            $obj = $aggregated_object[$obj_name];
            $data['page_title'] = $obj->description() . ' : Upload Carrier Rate';
            if($aggregated_object[$obj_name]){
                $output = array();
                if($module->api_upload_ratefile($obj_name, null, $output)){
                    $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/modify/' . $module_name . '/' . $obj_type . '/' . $obj_name);
                    $data['redirect_method'] = 'GET';
                    $data['result'] = true;
                    echo json_encode($data);
                    exit();
                }else{
                    $data['message'] = $output['message'];
                    if(isset($output['reason'])){
                        $data['reason'] = $output['reason'];
                    }
                    $data['message_type'] = 'alert';
                    $data['result'] = false;
                    echo json_encode($data);
                    exit();
                }
            }
        }
    }
    public function download_child($module_name, $obj_type, $obj_name=null, $sub_type=null){
        $this->download($module_name, $obj_type, $obj_name, $sub_type);
    }
    public function download($module_name, $obj_type, $obj_name=null, $sub_type=null)
    {
        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name($module_name);
        // Get config object
        $cfg_obj = $module->config();
        $_type = $obj_type;
        $aggregated_object = $module->get_aggregate_objects($obj_type);
        if($obj_name && $sub_type){
            if($aggregated_object[$obj_name]){
                $module = $aggregated_object[$obj_name];
                $aggregated_object = $module->get_aggregate_objects($sub_type);
                $_type = $sub_type;
            }
        }
        $tmp_data = array();
        
        if($aggregated_object != null){
            //hostname-carrier name
            $name = php_uname('n') . '-' . $obj_name . '-' . date('Y-m-d-H-i-s') . '.csv';
            $fp = fopen('/tmp/'.$name, 'w');
            foreach ($aggregated_object as $obj_item){
                if($keys == null){
                    $keys = $obj_item->get_data_keys();
                    fputcsv($fp, $keys);
                }
                $tmp_data = $obj_item->get_data_values();
                fputcsv($fp, $tmp_data);
            }
            fclose($fp);
            safe_download('/tmp/'.$name,null,$name,'text/csv');
        }else{
            header('HTTP/1.0 404 Not Found');
            exit();
        }
    }
}