<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS Dialplan Module Class
 * @author Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_service_class');
safe_module_require_class('fs', 'dialplan');
safe_module_require_class('fs', 'application');
safe_module_require_class('fs', 'advanced_dialplan');
class Fs_hmr_module_class extends Fs_dialplan_module_class
{
    private $_dialplans = array();
    public function __construct($fs_app)
    {
        parent::__construct($fs_app, "hmr");
        $this->_desc_str = 'Header Manipulation';
    }
    public function checklist(&$list)
    {
        // Prevent calling parent (routing)
    }
    public function _rule_types()
    {
        return array(
            //'domain' =>'Known Domain',
            //'user' =>'Known User',
            //'auth' =>'Authorized User',
            //'from_trunk' =>'From SIP Trunk',
            //'to_trunk' =>'To SIP Trunk',
            'regex' =>'Regular Expression',
            //'unconditional' =>'Always',
            );
    }
    protected function _action_types()
    {
        return array(
            'header' => 'Header Manipulation',
            );

    }
    protected function _create_basic_dialplan($name)
    {
        return new Fs_basic_dialplan_hmr_class($this->node() , $this->object_name().'/basic', $name);
    }
    protected function _create_advanced_dialplan($name)
    {
        return new Fs_advanced_dialplan_hmr_class($this->node() , $this->object_name().'/advanced', $name);
    }
    protected function _write_advanced_dialplan($data, $dialplan)
    {
        $xml_str = '<include>'.PHP_EOL.'<context name="'.$this->name().'.' . $dialplan->name() . '">'.PHP_EOL;
        $xml_str.= $data['data'];
        $xml_str.= '
        <extension name="sangoma_default_hmr">
             <condition field="destination_number" expression="(.*)">
                <action application="transfer" data="$1 XML ${sangoma_post_hmr_context}"/>
             </condition>
        </extension>'.PHP_EOL;
        $xml_str.= '</context>'.PHP_EOL.'</include>'.PHP_EOL;
        return $xml_str;
    }
    protected function _write_basic_default (&$xml_writer)
    {
        $xml_writer->startElement('condition');
        $xml_writer->writeAttribute('field', 'destination_number');
        $xml_writer->writeAttribute('expression', '(.*)');
            $xml_writer->StartElement('action');
            $xml_writer->writeAttribute('application', 'transfer');
            $xml_writer->writeAttribute('data', '$1 XML ${sangoma_post_hmr_context}');
            $xml_writer->endElement();
        $xml_writer->endElement();//condition
    }
    public function get_templates($type)
    {
        return array();
    }

}
?>
