<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * SNG modulde data manager
 *
 * @author William Adam
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('table');
safe_require_class('crud_table');
safe_require_class('form');
safe_require_class('upload');
class Sng_data_manager extends Safe_CI_Controller
{
    public function __construct()
    {
        parent::__construct();
    }
    protected function _get_module($module_name)
    {
        return $this->_the_app->find_module_by_name($module_name);
    }
    private function _build_data_array($mod, &$data_cfg)
    {
        $app_data = $mod->get_data_settings();
        if (count($app_data)) {
            foreach ($app_data as $data_name => $data) {
                // Prepare buttons
                $buttons = "";
                // Prepare key
                // module name / data name
                $key = $mod->name() . '/';
                $key.= $data_name;
                foreach ($data['capabilities'] as $cap) {
                    if (strlen($buttons)) $buttons.= '|';
                    $buttons.= $cap;
                }
                // Get data count
                $count = $mod->get_data_count($data_name);
                $data_cfg[] = array(
                    'module' => $mod->description() ,
                    'desc' => $data['description'],
                    'name' => $data_name,
                    'count' => $count,
                    'buttons' => $buttons,
                    'key' => $key,
                );
            }
        }
    }
    public function index()
    {
        // verify if logged
        //safe_authenticate ();
        safe_redirect('/SAFe/' . $this->router->fetch_class() . '/data');
    }
    public function data($module_name = NULL)
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Application Data Manager';
        $data['page_summary'] = 'This page allows managing Application Data.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-backup-settings.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-backup-settings.png';
        //Prepare table structure
        $table = new Safe_crud_table_class();
        // Prepare heading
        $table->set_headings(array(
            'Module',
            'Type',
            'Count'
        ));
        // TODO(WADAM) - Figure out why adding safe prefix is required
        $table->set_controller_url('/SAFe/' . $this->router->fetch_class());
        $table->set_form_method('get');
        if (isset($_SERVER['HTTP_REFERER'])) $table->footer_button = array(
            array(
                'name' => 'Back',
                'url' => $_SERVER['HTTP_REFERER'],
                'label' => ''
            )
        );
        // Check for application and services data settings
        $data_cfg = array();
        if (isset($module_name)) {
            // Get back the module
            $module = $this->_get_module($module_name);
            if (isset($module)) {
                $this->_build_data_array($module, $data_cfg);
            }
        } else {
            // Does application has a data ?
            $this->_build_data_array($this->_the_app, $data_cfg);
            // Loop around services
            foreach ($this->_services as $service) {
                // Skip application
                if (!is_subclass_of($service, 'Safe_application_class')) $this->_build_data_array($service, $data_cfg);
                // Check services modules
                foreach ($service->modules() as $mod) {
                    $this->_build_data_array($mod, $data_cfg);
                }
            }
        }
        // Populate table with application data rows
        foreach ($data_cfg as $cfg) {
            $table->add_row(array(
                $cfg['module'],
                $cfg['desc'],
                $cfg['count'],
            ) , $cfg['key'], 'manage');
        }
        // Check some data available
        if (count($data_cfg)) {
            // Yes, create table
            $data['table_size'] = '100%';
            $data['table_title'] = $table->set_title('Application Data');
            $table->allow_create(false);
            $table->set_footer('&nbsp;');
            // Generate table HTML code
            $data['table'] = $table->generate_table();
        } else {
            // No data available :(
            $data['notif_warn'][] = 'No module data available.';
        }
        // Display views
        $this->load->view("safe_header", $data);
        $this->load->view("safe_notifications", $data);
        if (isset($data['table'])) $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    public function manage($module_name, $data_name, $offset = NULL)
    {
        // verify if logged
        //safe_authenticate ();
        $module = NULL;
        $data_cfg = array();
        // Get back the module
        $module = $this->_get_module($module_name);
        // Get service data config
        $data_cfg = $module->get_data_settings();
        // Grab only the data we're interested in
        if (isset($data_cfg[$data_name])) $data_cfg = $data_cfg[$data_name];
        // Set the basic data
        $data['page_title'] = 'Application Data Manager';
        $data['page_summary'] = 'This page allows managing '.$module->description().' '.$data_cfg['description'].'.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-backup-settings.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-backup-settings.png';
        // Get data count
        $data_cnt = $module->get_data_count($data_name);
        // Check if global capabilities defined
        $glob_caps = array();
        if ($data_cfg['global_capabilities_no_data']) $glob_caps = array_merge($glob_caps, $data_cfg['global_capabilities_no_data']);
        if ($data_cnt && $data_cfg['global_capabilities']) $glob_caps = array_merge($glob_caps, $data_cfg['global_capabilities']);
        $global_opt = "";
        foreach ($glob_caps as $glob_cap) {
            if($glob_cap == 'upload'){
                $tmp_button = str_replace('type="submit"','type="button" onclick="safe_handle_create_button(this);"',safe_form_with_submit_button('', '/SAFe/' . $this->router->fetch_class() . '/' . $glob_cap .'_form'. '/' . $module_name . '/' . $data_name, ucfirst($glob_cap), $glob_cap, 'POST', 'float:left;'));
                $global_opt.= '<div>'.$tmp_button.'</div>'; 
            }elseif($glob_cap == 'backup'){
                $tmp_button = str_replace('type="submit"','type="button" onclick="safe_handle_create_button(this);"',safe_form_with_submit_button('', '/SAFe/' . $this->router->fetch_class() . '/' . $glob_cap .'_form'. '/' . $module_name . '/' . $data_name, ucfirst($glob_cap), $glob_cap, 'POST', 'float:left;'));
                $global_opt.= '<div>'.$tmp_button.'</div>';
            }else{
                $tmp_button_array = array_pop(safe_format_button($glob_cap));
                $global_opt.= '<div style="float:left">'.safe_button_click($tmp_button_array['id'], ucfirst($tmp_button_array['value']) , '/SAFe/' . $this->router->fetch_class() . '/' . $tmp_button_array['id'] . '/' . $module_name . '/' . $data_name, array(
                        'float:right;'
                )).'</div>';
            }
        }
        if ($global_opt) {
            $data['notif_warn'][] = '<div style="float:left;height:22px;line-height:22px;">Global Options for ' . $data_cfg['description'] . ':&nbsp;&nbsp;</div>' . $global_opt;
        }
        // Prepare the list view with data
        $table = new Safe_crud_table_class();
        $table->set_controller_url('/SAFe/' . $this->router->fetch_class());
        $table->set_form_method('get');
        $data_files = $module->data_summary($data_name);
        
        if($data_cfg['singleton'] && 0 != count($data_files)){
            $output = array();
            $keys = array_keys($data_files);
            $data_key = $data_files[0]['Name'];
            $desc_data = $module->describe_data($data_name, $key, $output);
            $table = new Safe_crud_table_class();
            $data['table_size'] = '100%';
            $data['table_title'] = $table->set_title($data_cfg['description']);
            $table_line = array();
            if($output){
                foreach($output as $k => $v){
                    $k= ucfirst($k);
                    $table_line[$k] = $v;
                }
                foreach ($data_cfg['capabilities'] as $key => $capabilities_value) {
                    if(strtolower($capabilities_value)=='delete' || strtolower($capabilities_value)=='restore' || strtolower($capabilities_value)=='install'){
                        $tmp_tutton['type'] = 'confirm';
                        $tmp_tutton['url'] = base_url($this->router->fetch_class().'/'.$capabilities_value.'_confirm/' . $module_name.'/'.$data_name.'/'.$data_key) ;
                    }else{
                        $tmp_tutton['type'] = 'button';
                        $tmp_tutton['url'] = base_url($this->router->fetch_class().'/'.$capabilities_value.'/' . $module_name.'/'.$data_name.'/'.$data_key) ;
                    }
                    $tmp_tutton['name'] =  ucfirst($capabilities_value);
                    
                    $table->footer_button[] = $tmp_tutton;
                }
            }else{
                $table_line[''] = " No ".$data_cfg['description'] ." available.";
            }
            $data['table'] = $table->generate_vertical_line_table('', '', $table_line);
            unset($table);
        }else{
            //add confirm tag to delete and restore
            foreach ($data_cfg['capabilities'] as $key => $capabilities_value) {
                if(strtolower($capabilities_value)=='delete' || strtolower($capabilities_value)=='restore'){
                    $data_cfg['capabilities'][$key] = $capabilities_value.':confirm';
                }
            }
            $data_headings = array();
            foreach ($data_files as $data_item) {
                if($data_headings == null ){
                    $data_headings = array_keys($data_item);
                }
                $table->add_row(array_values($data_item) , $module_name . '/' . $data_name . '/' . $data_item['Name'], implode('|', $data_cfg['capabilities']) , '');
            }
            // Yes, create table
            $data['table_size'] = '100%';
            $data['table_container_class'] = 'safe_datatable';
            $data['table_title'] = $table->set_title($module->description() . ' - ' . $data_cfg['description']);
            $table->set_headings($data_headings);
            $table->allow_create(false);
            // Add pagination
            if (isset($pagination_config)) $table->set_footer($this->pagination->create_links());
            else $table->set_footer('&nbsp;');
            // Generate table HTML code
            $data['table'] = $table->generate_table();
        }
        
        $this->load->view("safe_header", $data);
        $this->load->view("safe_confirm_dialog", $data);//load confirm dialog js and css
        $this->load->view("safe_notifications", $data);
        if (isset($data['table'])) $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    public function download($module_name, $data_name, $data_key = NULL)
    {
        // verify if logged
        //safe_authenticate ();
        $module = NULL;
        // Get back the module
        $module = $this->_get_module($module_name);
        $rc = $module->download_data($data_name, $data_key);
        // Redirect on success
        if ($rc)
        // Redirect to referrer
        safe_back();
        // Somethig bad happens, dsplay error
        // Set the basic data
        $data['page_title'] = 'Application Data Manager';
        $data['page_summary'] = 'This page allows managing Application Data.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-backup-settings.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-backup-settings.png';
        // Prepare back url
        $post = $this->input->post();
        if (isset($post['back_url'])) $back_url = $post['back_url'];
        else $back_url = '/SAFe/' . $this->router->fetch_class();
        $data['notif_error'][] = 'Fail to download ' . $data_cfg['description'] . '.<br/>' . safe_form_with_submit_button('', $back_url, 'Back', 'back', 'get', 'float:left;');
        // Display views
        $this->load->view("safe_header", $data);
        $this->load->view("safe_notifications", $data);
        $this->load->view("safe_footer", $data);
    }
    public function view($module_name, $data_name, $data_key)
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Application Data Manager';
        $data['page_summary'] = 'This page allows managing Application Data.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-backup-settings.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-backup-settings.png';
        $module = NULL;
        // Get back the module
        $module = $this->_get_module($module_name);
        // Get service data config
        $data_cfg = $module->get_data_settings();
        // Grab only the data we're interested in
        if (isset($data_cfg[$data_name])) $data_cfg = $data_cfg[$data_name];
        $data['table_size'] = '100%';
        $data['table_title'] = $data_cfg['description'] . ' : ' . $data_key;
        $data['text_mode'] = "xml";
        $ext = pathinfo($data_cfg['pattern']);
        $data['text_mode'] = $ext['extension'];
        // TODO(wadam) - get those values from somewhere (not hard coded)
        $data['width'] = "930px";
        $data['height'] = "600px";
        $data['min_height'] = "0px";
        $data['url_back'] = $_SERVER['HTTP_REFERER'];
        $data['editor_data'] = $module->get_data_file_content_by_key($data_name, $data_key, NULL);
        if (empty($data['editor_data'])) {
            $data['notif_error'][] = $data_cfg['description'] . ' ' . $data_key . ' not found.<br/>' . safe_button_click('cancel', 'Back', $data['url_back']);
        }
        // Display views
        $this->load->view("safe_header", $data);
        $this->load->view("safe_hide_menu");
        $this->load->view("safe_notifications", $data);
        if (!empty($data['editor_data'])) $this->load->view("safe_texteditor", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Confirm to Delete backup
     *
     * @param string $module_name being deleted
     * @param string $data_name   being deleted
     * @param string $data_key    being deleted
     *
     */
    public function delete_confirm($module_name, $data_name, $data_key = null)
    {
        // Set the basic data
        $data['page_title'] = 'Application Data Manager';
        $module = NULL;
        // Get back the module
        $module = $this->_get_module($module_name);
        // Get service data config
        $data_cfg = $module->get_data_settings();
        // Grab only the data we're interested in
        if (isset($data_cfg[$data_name])){
            $data_cfg = $data_cfg[$data_name];
            $data['message'] = 'Are you sure you would like to delete the <b>' . $data_cfg['description']  . ' '.$data_key. '</b>?';
            $data['message_type'] = 'notice';
            $data['result'] = true;
            $data['action_url'] = base_url($this->router->fetch_class()). '/delete/'.$module_name.'/'.$data_name;
            if($data_key !== NULL){
                $data['action_url'] = $data['action_url'] .'/'.$data_key;
            }
            echo json_encode($data);
        }else{
            $data['message'] = 'No data found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * Confirm to Delete backup
     *
     * @param string $module_name being deleted
     * @param string $data_name   being deleted
     * @param string $data_key    being deleted
     *
     */
    public function delete($module_name, $data_name, $data_key = NULL)
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Application Data Manager Delete Data';
        $module = NULL;
        // Get back the module
        $module = $this->_get_module($module_name);
        // Get service data config
        $data_cfg = $module->get_data_settings();
        // Grab only the data we're interested in
        if (isset($data_cfg[$data_name])) {
            $data_cfg = $data_cfg[$data_name];
            $post = $this->input->post();
            $back_url = $this->input->get_post('back_url');
            if (!$back_url) $back_url = '/SAFe/' . $this->router->fetch_class() . '/manage/' . $module_name . '/' . $data_name;
            // Proceed to delete
            if ($module->delete_data($data_name, $data_key)) {
                //return redirect url
                $data['result'] = true;
                //safe_back url HTTP_REFERER  window.history.go('-1');
                $data['redirect_url'] = $back_url;
                echo json_encode($data);
            } else {
                $data['message'] = 'Fail to delete ' . $data_cfg['description'] ;
                $data['message_type'] = 'alert';
                $data['result'] = false;
                echo json_encode($data);
            }
        }else{
            //return error message
            $data['message'] = 'No Data found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * @brief Upload data for a specific module/service
     *
     * @param[in out] $module_name
     * @param[in out] $data_name
     *
     * @return
     */
    public function upload_form($module_name, $data_name)
    {
        // Set the basic data
        $data['page_title'] = 'Application Data Manager';
        $module = NULL;
        // Get back the module
        $module = $this->_get_module($module_name);
        $data_cfg = $module->get_data_settings();
        $data_cfg = $data_cfg[$data_name];
        // Prepare back url
        $post = $this->input->post();

        //clear the content in page cache and get the view content
        ob_start();
        ob_clean();
        $upload_data['file_label'] = $data_cfg['description'].' File:';
        $this->load->view("safe_upload_ajax", $upload_data);
        $data['content'] = ob_get_contents();
        ob_clean();
        //******
        $data['buttons'] = array(
                array(
                        'name' => 'upload',
                        'value' => 'Upload',
                        'type' => 'button'
                ) 
        );
        $data['page_title'] = 'Upload ' . $data_cfg['description'];
        $data['result'] = true;
        $data['action_url'] = base_url($this->router->fetch_class().'/upload_save/'.$module_name.'/'.$data_name);
        $data['action_method'] = 'POST';
        echo json_encode($data);
    }
    /**
     * @brief Upload data for a specific module/service
     *
     * @param[in out] $module_name
     * @param[in out] $data_name
     *
     * @return
     */
    public function upload_save($module_name, $data_name)
    {
        $module = NULL;
        // Get back the module
        $module = $this->_get_module($module_name);
        $data_cfg = $module->get_data_settings();
        $data_cfg = $data_cfg[$data_name];
        // Prepare back url
        $post = $this->input->post();
        $back_url = $this->input->get_post('back_url');
        if (!$back_url) $back_url = '/SAFe/' . $this->router->fetch_class() . '/manage/' . $module_name . '/' . $data_name;
        
        $data = array();
        $data['notif_error'] = null;
        $output = array();
        if($module->upload_data($data_name, NULL, $output, 'POST')){
            $data['message_type'] = 'notice';
            $data['message'] ='File Uploaded Successfully.';
            $data['result'] = true;
            $data['redirect_url'] = $back_url;
        }else{
            $data['page_title'] = 'Upload ' .$data_cfg['description']; 
            $data['message_type'] = 'alert';
            $data['message'] = $output['message'];
            if(isset($output['reason'])){
                $data['reason'] = $output['reason'];
            }
            $data['result'] = false;
        }
        echo json_encode($data);
    }
}
/* End of file sng_data_manager.php */

