<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * Network Config wrapper page
 * @author William Adam <william.adam@sangoma.com>
 *         
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');


class Sng_dashboard extends Safe_CI_Controller
{
    private $_httpd = null;
    private $_auditor = null;
    private $_monitor = null;
    private $_audit_points = array();
    private $_notifier = null;
    private $_notify_cfg = null;

    public function __construct()
    {
        parent::__construct();
        // Retrieve audit points
        $this->_auditor = $this->_the_app->find_module_by_name('auditor');
        $this->_monitor = $this->_the_app->find_module_by_name('monitor');
        $this->_audit_points = $this->_auditor->audit_points();
        $this->_notifier = $this->_the_app->find_module_by_name('notifier');
        $this->_system = $this->_the_app->find_module_by_name('system');
        $this->_notify_cfg = $this->_notifier->config();
    }
    public function index()
    {
        $this->dashboard();
    }
    public function test_view()
    {
        $data = array();
        $xml = "
            <monit>
  <event>
    <collected_sec>1378283114</collected_sec>
    <collected_usec>92095</collected_usec>
    <service>sipsecmon/log/error</service>
    <type>2</type>
    <id>32768</id>
    <state>2</state>
    <action>1</action>
    <message>
      <![CDATA[content match:
      Log 2013-09-06 14:47:26.305635 [ERR] vocallomediaserverconnection.cc:1226 MediaServerConnection[MAC=00-0c-90-1b-67-06]:Execute command 140030 failed:cOCTVC1_GENERIC_RC_API_INVALID_CMD_LENGTH
      Log 2013-09-06 14:47:26.305635 [ERR] vocallomediaserverconnection.cc:1623 MediaServerConnection[MAC=00-0c-90-1b-67-06]:failed to open Vocallo Ethernet link        Log 2013-09-06 14:47:27.571371 [ERR] vocallomediaserverconnection.cc:1226 MediaServerConnection[MAC=00-0c-90-1b-67-06]:Execute command 140030 failed:cOCTVC1_GENERIC_RC_API_INVALID_CMD_LENGTH
      ...   
      ]]>   
    </message>
  </event>
  </monit>
";
        $result = $this->_auditor->collector($xml);
        foreach($result['events'] as $level => $events_cat){
            $data['title'] = $this->_the_app->description().' - '.$level.' Notification';
            $data['product'] = $this->_the_app->description();
            $data['level'] = $level;
            $data['events'] = $events_cat;
            $data['host'] = $this->_the_app->node()->hostname();
            $httpd = $this->_the_app->find_module_by_name('webconfig');
            $data['server_uri'] = $httpd->server_uri($data['host']);
            safe_var_dump($data['host']);
            safe_var_dump($data['server_uri']);
            $this->load->view('sng_notifier_email', $data);
            $this->_monitor->add_events($level, $events_cat);
        }
        //$this->_notifier->notify($level, $data['events']);
    }
    public function system_stats_json()
    {
        echo $this->_system_stats();
    }
    public function system_events_json()
    {
        echo $this->_system_events();
    }
    private function _system_events()
    {
        $system_stats = array();
        // Get event time summary
        $hour_range = 24;
        $events_time_summary = $this->_monitor->events_time_summary($hour_range);
        $system_stats['current_date'] = date('Y/m/d H:i:s');
        $system_stats['hour_range'] = $hour_range;
        if($events_time_summary['info']){
            $system_stats['events'][] =
                array('label'=>'Info', 'data'=>$events_time_summary['info'], 'color' => '#6699FF');
        }else{
            $system_stats['events'][] =
                array('label'=>'Info', 'data'=>array(), 'color' => '#6699FF');
        }
        if($events_time_summary['error']){
            $system_stats['events'][] = 
                array('label'=>'Error', 'data'=>$events_time_summary['error'], 'color' => '#FF9900');
        }else{
            $system_stats['events'][] = 
                array('label'=>'Error', 'data'=>array(), 'color' => '#FF9900');
        }
        if($events_time_summary['critical']){
            $system_stats['events'][] =
                array('label'=>'Critical', 'data' => $events_time_summary['critical'], 'color' => '#CC0000');
        }else{
            $system_stats['events'][] =
                array('label'=>'Critical', 'data'=>array(), 'color' => '#CC0000');
        }
        $service_events = array();
        $services = $this->_the_product->local_node()->software()->services();

        foreach($services as $service){
            //if($service->allow_user_ctl() === 'hide') continue;
            $service_events[$service->name()]['events'] = $this->_monitor->events_count($service->name());
        }
        return json_encode( 
            array('summary' => $system_stats, 'services' => $service_events));
    }
    private function _system_stats()
    {
        $system_stats = array();
        // Get Memory
        $system = $this->_system->statistics();
        $memory_usage = $system['memory']['percent']['used'];
        $memory_free = $system['memory']['percent']['free'];

        $mem_data = array(
            array('label' => 'Free', 'data' => $memory_free, 'color' => '#6699FF'),
            array('label' => 'Used', 'data' => $memory_usage, 'color' => '#FFC266'),
        );
        $system_stats['memory'] = $mem_data;

        // Get Cpu
        $cpu_user = $system['cpu']['percent']['user'];
        $cpu_system = $system['cpu']['percent']['system'];
        $cpu_wait = $system['cpu']['percent']['wait'];
        $cpu_idle = $system['cpu']['percent']['idle'];
        $cpu_idle = 100.0 - $cpu_user - $cpu_system - $cpu_wait;

        $cpu_data = array(
            array('label' => 'User', 'data' => $cpu_user, 'color' => '#FFC266'),
            array('label' => 'System', 'data' => $cpu_system, 'color' => '#DBB84D'),
            array('label' => 'Wait', 'data' => $cpu_wait, 'color' => '#D65C33'),
            array('label' => 'Idle', 'data' => $cpu_idle, 'color' => '#6699FF'),
        );
        $system_stats['cpu'] = $cpu_data;

        return json_encode($system_stats);
    }
    private function _service_stats()
    {
        $service_stats = array();
        $services = $this->_the_product->local_node()->software()->services();
        // Get statistics from monitor
        $monitor_stats = array();
        $_stats = $this->_monitor->get_status('service');
        foreach($_stats as $_s){
            $monitor_stats[$_s['module']] = json_decode($_s['data'], true);
        }

        foreach($services as $service){
            if($service->allow_dashboard()){
                $service_stats[$service->name()] = $service->api_status_service();
                if($service_stats[$service->name()]['status_text'] == 'UNRECOGNIZED'){
                    $service_stats[$service->name()]['status_text'] = 'ERROR';
                }
                $service_stats[$service->name()]['description'] = $service->description();
                $events = $this->_monitor->events_count($service->name());
                $service_stats[$service->name()]['events'] = $events[$service->name()];
                // Check if monitor has stats for this service
                // See redmine #9954 - CPU metric in the dashboard is in function of total running time of the process
                // Use monitor stats instead of ps ones if present
                if(Safe_service_class::STATUS_RUNNING == $service->status()
                    && $monitor_stats[$service->name()]){
                    $_cpu = $monitor_stats[$service->name()]['cpu'];
                    // cpu stats ?
                    if($_cpu['percenttotal']){
                       $service_stats[$service->name()]['cpu']['percent'] = (float)$_cpu['percenttotal'];
                    }
                }
                // Ensure no N/A are present for cpu and mem
                if('N/A' === $service_stats[$service->name()]['cpu']['percent']){
                    unset($service_stats[$service->name()]['cpu']);
                }
                if('N/A' == $service_stats[$service->name()]['mem']['kb']){
                    unset($service_stats[$service->name()]['mem']);
                }
            }
        }

        return json_encode($service_stats);
    }
    public function service_stats_json()
    {
        echo $this->_service_stats();
    }

    public function dashboard()
    {
        // Set the basic data
        $data['page_summary'] = 'This page displays detailed information about the product components.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-register.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-register.png';
        //$the_product = Safe_get_product();
        $data['page_title'] = $this->_the_product->name() . ' - About';
        $this->load->view("safe_header", $data);

        // Create dashboard
        $dashboard_data = array();
        $dashboard_data['controller_uri'] = $this->router->fetch_class();

        // Get System stats
        $dashboard_data['system'] = $this->_system_stats();
        $dashboard_data['events'] = $this->_system_events();
        $dashboard_data['services'] = $this->_service_stats();
        //safe_var_dump($dashboard_data);
        // Display dashboard
        $this->load->view('sng_dashboard_overview', $dashboard_data);
        $this->load->view('sng_dashboard_service', $dashboard_data);
        $this->load->view("safe_footer", $data);
    }
    public function level_events($level=null)
    {
        $this->events(null, $level);
    }
    public function module_events($module=null)
    {
        $this->events($module);
    }
    public function events($module=null, $level=null)
    {
        // Set the basic data
        $data['page_summary'] = 'This page displays Audit Events Report.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-logs.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-logs.png';
        //$the_product = Safe_get_product();
        $data['page_title'] = $this->_the_product->name() . ' - Audit Events';
        $this->load->view("safe_header", $data);
        $this->load->view("safe_hide_menu");
        $module_obj = $this->_the_app->find_module_by_name($module);
        if($module_obj){
            $event_data['table_title'] = $module_obj->description();
        }else{
            $module = null;
            $event_data['table_title'] = 'All Services';
        }
        if(!in_array($level, $this->_monitor->severity_level_enum())){
            $level = null;
        } 
        $event_data['table_title'] .= ' - Events';
        $event_data['module'] = $module;
        $event_data['level'] = $level;
        // Build up module list
        $event_data['filter']['module']['label'] = 'Module';
        foreach($this->_the_app->node()->modules() as $mod){
            $event_data['filter']['module']['enum'][$mod->description()] = $mod->name();
        }
        $event_data['filter']['level']['label'] = 'Severity';
        $event_data['filter']['level']['enum'] = $this->_monitor->severity_level_enum();
        
        // Get events
        $event_data['events'] = $this->_monitor->events_list($module, $level);
        //safe_var_dump($events);
        // Display eventlist
        $this->load->view('sng_event_list', $event_data);
        $this->load->view("safe_footer", $data);
    }

}
