<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * NSC SIP Security Monitor Service Class
 * @author Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_service_class');
safe_require_class('safe_db_class');
safe_module_require_class('nsc', 'product');
safe_module_require_class('nsc', 'application');
safe_module_require_class('nsc', 'sipsecmon_config');
safe_module_require_class('nsc', 'sipsecmon_rules_config');
class Nsc_sipsecmon_service_class extends Safe_service_class
{
    private $_rules;
    function __construct($node, $software)
    {
        parent::__construct($software, 'sipsecmon');
        $this->_node = $node;
        // Override run_dir for ipd file
        $this->_run_dir = '/usr/local/nsc/run';
    }
    //Information pulled for the object
    public function configure()
    {
        // Create the object
        $cfg = new Nsc_sipsecmon_config_class($this->_node, $this->object_name(), $this->name());
        // Create the fields
        $cfg->configure();
        // Synchronize with persistent DB (safe_object table)
        $cfg->synch();
        // Register config to service
        $this->set_config($cfg);
        // Set service description
        $this->set_description('SIP Security Monitor');
        // Register rule objects
        $this->register_aggregate_object('rules',
           array(
                'name' => 'Rules',
                'dynamic' => true,
                'base_path' => parent::object_name().'/rules',
                'methods' => array(
                           'create' => array(
                                   'name' => 'Create',
                                   'description' => 'Create a rule',
                                   'request' => 'POST',
                           ),
                           'retrieve' => array(
                                   'name' => 'Retrieve',
                                   'description' => 'Retrieve a rule',
                                   'request' => 'GET',
                           ),
                           'update' => array(
                                   'name' => 'Update',
                                   'description' => 'Update a rule',
                                   'request' => 'POST',
                           ),
                           'delete' => array(
                                   'name' => 'Delete',
                                   'description' => 'Delete a rule',
                                   'request' => 'POST',
                           ),
                   ),
            )   
        );  
        return parent::configure();
    }
    function db()
    {
        $tmp_db_cfg = $this->config()->get_data_values_exploded();
        // Filter out db-cfg
        $cfg_db = $tmp_db_cfg['db-cfg'];
        //will return the array needed to create the db connection (key=>value)
        $db = Safe_database_class::factory($cfg_db);
        return $db;
    }
    /**
     * SIPSecmon Unblock Command
     */
    function unblock_ip($argument, &$output = null)
    {
        $cmd = "unblock " . $argument;
        // Invoke service execute
        $rc = $this->execute($cmd, $output);
        return ($rc == 0 ? TRUE : FALSE);
    }
    /**
    *
    * @brief Create a specific aggregate object 
    *
    * @param[in out] $name - Name of object
    *
    * @return 
    */
    public function create_aggregate_object($type,$name){
         $obj = new Nsc_sipsecmon_rules_config_class($this->_node, parent::object_name() . '/rules', $name);
         $obj->configure();
         return $obj;
    }
    /**
     * Returns sip secmon rules in an array
     */
    public function rules()
    {
        $rules = Safe_object_serializer_class::get_serializer()->find_objects(parent::object_name() . '/rules');
        foreach ($rules as $k => $v) {
            $v = new Nsc_sipsecmon_rules_config_class($this->node() , parent::object_name() . '/rules', $k);
            $v->configure();
            $v->synch();
            $this->_rules[$k] = $v;
        }
        return $this->_rules;
    }
    /**
     * Function which returns whether the function is enabled or not
     * @return boolean
     */
    public function is_enabled($mod_name = "")
    {
        return $this->config()->enabled();
    }
    /**
     * @brief Generate SIPSECMON configuration
     *           
     * @param[in out] $config_manager
     *           
     * @return true on success
     */
    public function generate_config(&$config_manager)
    {
        //Generates service configuration files
        if (!$this->_generate_service_config($config_manager)) return false;
        //Generates database configuration
        if (!$this->_generate_db_config($config_manager)) return false;
        // Remove deleted objects
        if (!$this->_handle_deleted_objects($config_manager)) return false;
        return parent::generate_config($config_manager);
    }
    public function _generate_service_config(&$config_manager)
    {
        // Get our configuration data (unresolved)
        $cfg = $this->config()->get_data_values_exploded(false);
        // Remove global config - Used by service control script (application)
        unset($cfg['global']);
        // Create xml document
        $xml_writer = new XMLWriter();
        $xml_writer->openMemory();
        $xml_writer->startDocument('1.0', 'UTF-8');
        // Document container
        $xml_writer->startElement('document');
        $xml_writer->writeAttribute('type', 'sipsecmon/xml');
        // Process database configuration
        $xml_writer->startElement('database');
        // Create connection-sting
        // <param name="connection-string"
        // value="DRIVER={MySQL};DATABASE=nsc;server=localhost;user=root;pwd=sangoma;port=3306"/>
        $connection_string = 'DRIVER={' . $cfg['db-cfg']['dbdriver'] . '};' . 'DATABASE=' . $cfg['db-cfg']['database'] . ';' . 'server=' . $cfg['db-cfg']['hostname'] . ';' . 'user=' . $cfg['db-cfg']['username'] . ';' . 'pwd=' . $cfg['db-cfg']['password'] . ';' . 'port=' . $cfg['db-cfg']['port'] . ';';
        $xml_writer->startElement('param');
        $xml_writer->writeAttribute('name', 'connection-string');
        $xml_writer->writeAttribute('value', $connection_string);
        $xml_writer->endElement();
        foreach ($cfg['database'] as $k => $v) {
            $xml_writer->startElement('param');
            $xml_writer->writeAttribute('name', $k);
            $xml_writer->writeAttribute('value', $v);
            $xml_writer->endElement();
        }
        // Remove database config entries
        $xml_writer->endElement();
        unset($cfg['database']);
        unset($cfg['db-cfg']);
        // Add all parameters
        foreach ($cfg as $category => $cat_cfg) {
            $xml_writer->startElement($category);
            foreach ($cat_cfg as $k => $v) {
                $xml_writer->startElement('param');
                $xml_writer->writeAttribute('name', $k);
                $xml_writer->writeAttribute('value', $v);
                $xml_writer->endElement();
            }
            $xml_writer->endElement();
        }
        // Close settings
        $xml_writer->endElement();
        $xml_writer->endDocument();
        $xmlstr = Safe_format_xml($xml_writer->outputMemory(true));
        $file = $config_manager->directory('base') . '/etc/' . $this->name() . '.xml';
        $config_manager->add_config(new Safe_configuration_class($file, $xmlstr));
        return true;
    }
    public function _generate_db_config(&$config_manager)
    {
        $sip_secmon_rules = $this->rules();
        if (isset($sip_secmon_rules)) {
            foreach ($sip_secmon_rules as $rules) {
                //build data array
                unset($data);
                $db = $this->db();
                $data['db_class'] = $db;
                $data['data'] = $rules->get_data_values(false);
                $data['data']['name'] = $rules->name();
                // process action_expr and action param
                if ('false' == $data['data']['action_expr']) $data['data']['action_expr'] = "";
                else {
                    $data['data']['action_expr'].= "=" . $data['data']['action_param'];
                }
                unset($data['data']['action_param']);
                //Determine whether to update or insert a rule
                $status = $rules->status();
                if ($status == Safe_object_serializer_class::OBJ_STATUS_MODIFIED) {
                    $data['primary_key'] = array(
                        'name'
                    );
                    $config_manager->add_config(new Safe_configuration_class('rules', $data, Safe_configuration_class::CFG_UPDATE, Safe_configuration_class::CFG_SQL));
                } elseif ($status == Safe_object_serializer_class::OBJ_STATUS_NEW) {
                    $config_manager->add_config(new Safe_configuration_class('rules', $data, Safe_configuration_class::CFG_CREATE, Safe_configuration_class::CFG_SQL));
                }
            }
        }
        return true;
    }
    private function _handle_deleted_objects(&$config_manager)
    {
        //Handle deleted SIPsecmon rules
        $deleted_sip_secmon_rules = Safe_object_serializer_class::get_serializer()->find_deleted_objects(parent::object_name() . '/rules');
        foreach ($deleted_sip_secmon_rules as $rules => $value) {
            //build data array
            unset($data);
            $data['db_class'] = $this->db();
            $value['data']['name'] = $rules;
            $data['data'] = $value['data'];
            $data['primary_key'] = array(
                'name'
            );
            $config_manager->add_config(new Safe_configuration_class('rules', $data, Safe_configuration_class::CFG_DELETE, Safe_configuration_class::CFG_SQL));
        }
        return true;
    }
    public function category()
    {
        return 'Security';
    }
    /**
     * @brief
     *         
     * @return
     */
    public function get_data_settings()
    {
        $cfg_manager = $this->node()->configuration_manager();
        $data = array(
            'log' => array(
                'description' => 'Log file',
                'filesystem' => TRUE,
                'pattern' => '/var/log/' . $this->name() . '.log*',
                'global_capabilities' => array(
                    'download'
                ) ,
                'capabilities' => array(
                    'download',
                    'view'
                ) ,
                'methods' => array(
                        'download' => array(
                                'name' => 'Download',
                                'description' => array( 'Download log files.' ),
                                'request' => 'GET',
                        )
                )
            )
        );
        return $data;
    }
    public function support_reload(&$need_reload = null) {
        parent::support_reload($need_reload);
        return true;
    }   
    public function reload_generate_config(&$config_manager, $obj_type=null)
    {   
        if(!$this->generate_config($config_manager)) return false;
        return parent::reload_generate_config($config_manager, $obj_type);
    }   
    public function reload_clear_modified($obj_type=null)
    {
        return $this->clear_configuration_modified();
    }
    public function post_write_config()
    {
        // Is service enabled ?
        $enabled = $this->is_enabled();
        // Check current status
        switch($this->status()){
        case Safe_service_class::STATUS_RUNNING:
            if($enabled){
                $this->restart();
            }else{
                $this->stop();
            }
            break;
        case Safe_service_class::STATUS_STOPPED:
            if($enabled){
                // This service depends on application being started, so check 
                // if application is running
                if($this->node()->software()->application()->status() == STATUS_STOPPED){
                    $this->start();
                }
            }
            break;
        }
    }
    
    /*
    public function rules()
    {
        return $this->get_aggregate_objects('rule');
    }*/
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_create_rules($name, $data=null) {
        $obj = new Nsc_sipsecmon_rules_config_class($this->_node, parent::object_name() . '/rules', $name);
        $obj->configure();
        if($data) {
            $obj->set_data_values($data);
        }
        return $obj;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_retrieve_rules($name, $data=null) {
        $rules = $this->rules();
        return $rules[$name];
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_update_rules($name, $data=null, &$output = null) {
        $rule = $this->api_retrieve_rules($name);
        if($rule) {
            if ($rule->validate($data,$output)) {
                if (true == $rule->save()) {
                    return true;
                }
            }
        }
        return false;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_delete_rules($name, $data=null, &$output = null) {
        $rules = $this->rules();
        if($rules[$name]) {
            if($rules[$name]->can_dispose($output)) {
                return $rules[$name]->dispose();
            }
        }
        return false;
    }
    public function api_download_log($name=null, $data = null, &$output = null){
        $this->download_data('log', $name);
        exit();
    }
    public function can_restore($info, &$reason)
    {
        return true;
    }
}
