Sangoma Appliance Framework Python Interface
----

### Overview

safepy allows accessing webUI build around SAFe framework through Python ;)
safepy is a framework wrapping a SAFe webUI RESTful API in python.

It uses the product RESTful API documentation to create the proper object
classes supported by a specific product/version. Any object/method exposed by a
product RESTful API is accessible through safepy once product data has been
build (see Building product data class section below).

To get an idea of objects and methods accessible for a product/version you can
consult http://safe_doc.sangoma.local/ which document the product RESTful API.

### Installation

safepy installs as any other sng projects:

```
$ sngclone safepy
$ cd safepy
$ sngproj initialize
```

An additional step is required:

```
$ ./setup.sh
```

### Directory structure

- root
  - libs
    - safepy         : Framework class libraries
    - request : the python http library (symlinked from package)
    - one_product:  All safepy data product/version classes
    - another_product
  - data : Product data specific folder
  - packages     : Any additional packages required by safepy
  - bin : Some safepy binaries
  - tools : Various tools


### Building product data class

Product data should be stored in safepy_data repo and use different branch to
be checkout in data directory (see definitions.xml)

Step to create the product safepy object classes:

1. Create product/version directory in data directory
1. Get the product RESTful API documentation
    Use tools/scripts/safe_doc.sh to retrieve product documentation
1. Store REST doc in folder created in 1 as safepy_def.json
1. Run safepy_builder

```
$ mkdir -p data/nsc_master
$ tools/scripts/safe_doc.sh http://mtl-nsc-devel-will.sangoma.local > data/nsc_master/safepy_def.json
$ bin/safepy_builder --name="NetBorder Session Controller" --version="master" --product="nsc"
```

This will create all safepy classes in data/nsc_master directory
Please note that safepy_builder use path based on 'product' and 'version'
stripping out any space or dot. For example using: produtct=nsc and
version=2.0.0 will end up in path data/nsc_2_0_0

When creating a new data/ product you need to run ./setup.sh again to create
symlinks in libs/ directory.

### Using safepy

To use safepy, directories in libs must be accessible (as module)
from command line, please go in libs/ directory and start python (2.7)

You can now import one of product in python:

```
root@mtl-nsc-devel-will libs (master)
# python2.7
Python 2.7.5 (default, Oct  2 2013, 16:35:08)
[GCC 4.1.2 20080704 (Red Hat 4.1.2-54)] on linux2
Type "help", "copyright", "credits" or "license" for more information.
>>> import nsc_master
>>>

```

All safepy product data exposes the 'Product' class.
Instantiate the product:

```
>>> s = nsc_master.Product()
>>> s.name
'nsc'
>>> s.version
'master'
```

By default, safepy will assume you want to communicate with the local server (127.0.0.1), if you want to interact with a remote server, 
you can specify connection setting using the connect() method:

```
>>> s.connect('mtl-nsc-devel-will.sangoma.local', 80)
connect: http://mtl-nsc-devel-will.sangoma.local:80/SAFe/sng_rest/
```

This function doesn't actually connects to the remote server but stores connection info. If you need to change protocol to https, add 3rd argument 'https'.

All safepy objects exposes their inner objects/methods with the 'list()' method.

```
>>> s.list()
['firewall', 'webconfig', 'nsc', 'rest', 'hardware', 'radius', 'cdr', 'watchdog', 'distributor', 'snmpd', 'sip', 'network', 'certificate', 'media', 'system', 'rtcpmon', 'sngms', 'dialplan', 'snortsam', 'auditor', 'core', 'sipsecmon', 'lcr', 'enum', 'update', 'directory', 'mediamon', 'monitor', 'sshd', 'snort', 'cac', 'notifier']
```

This lists all the modules accessible for this product, same goes to list module object/method:

```
>>> s.sip.list()
['profile', 'trunk']
```

safepy uses the following object hierarchy:

- Server
  - Module
    - Object
      - SubObject (optional)

You can issue list() on each level and it will lists either available objtype/method or actual object name.
For example:

```
>>> s.sip.profile.list()
GET: http://mtl-nsc-devel-will.sangoma.local:80/SAFe/sng_rest/api/list/sip/profile
[u'NSC_SIP_Profile1']
```

This lists the SIP profile objects, while:

```
>>> s.sip.profile['NSC_SIP_Profile1'].list()
['retrieve', 'update', 'delete']
```

lists the available methods on the 'NSC_SIP_Profile1' SIP profile object (if this object has subobject, it will be listed as well).

Invoking a method:

```
>>> s.sip.profile['NSC_SIP_Profile1'].retrieve()
GET: http://mtl-nsc-devel-will.sangoma.local:80/SAFe/sng_rest/api/retrieve/sip/profile/NSC_SIP_Profile1
{u'outbound-proxy': u'', u'nat-options-ping': u'false', u'enable-3pcc': u'proxy', u'srtp': {u'crypto-optional-mki-length-string': u'__disable__', ...
>>>
```

Returns the 'NSC_SIP_Profile1' object configuration

you can loop around objects using:

```
>>> for p in s.sip.profile.list():
...     s.sip.profile[p].retrieve()
...
GET: http://mtl-nsc-devel-will.sangoma.local:80/SAFe/sng_rest/api/list/sip/profile
GET: http://mtl-nsc-devel-will.sangoma.local:80/SAFe/sng_rest/api/retrieve/sip/profile/NSC_SIP_Profile1
{u'outbound-proxy': u'', u'nat-options-ping': ....
```

Creating an object:

```
>>> s.sip.profile['NSC_SIP_Profile1'].retrieve()
GET: http://127.0.0.1:81/SAFe/sng_rest/api/retrieve/sip/profile/NSC_SIP_Profile1
{u'outbound-proxy': u'', u'nat-options-ping': u'false', u'enable-3pcc': u'proxy', u'srtp': {u'crypto-optional-mki-length-string': u'__disable__' ...
>>> cfg = s.sip.profile['NSC_SIP_Profile1'].retrieve()
GET: http://127.0.0.1:81/SAFe/sng_rest/api/retrieve/sip/profile/NSC_SIP_Profile1
>>> cfg['sip-port'] = '5062'
>>> s.sip.profile.create('test', cfg)
POST: http://127.0.0.1:81/SAFe/sng_rest/api/create/sip/profile/test
[]
>>> s.sip.profile.list()
GET: http://127.0.0.1:81/SAFe/sng_rest/api/list/sip/profile
[u'NSC_SIP_Profile1', u'test']
```

Handling error:

```
>>> s.sip.profile['not_existing_profile'].retrieve()
GET: http://127.0.0.1:81/SAFe/sng_rest/api/retrieve/sip/profile/not_existing_profile
False
>>> s.last_error
{'status': 404, 'error': u'Not Found'}
```


### F.A.Q.

1. All requests return False

safepy uses the RESTful API of the webserver, thus REST MUST 1/ be enabled and
2/ allowed in IP whitelist/API Key.
Accessing locally (127.0.0.1) to REST interface is granted by default in latest web code base (as
of 2013/10/07)

```
>>> s.connect('mtl-nsc-devel-will.sangoma.local', 80)
connect: http://mtl-nsc-devel-will.sangoma.local:80/SAFe/sng_rest/
>>> s.sip.profile.list()
GET:
http://mtl-nsc-devel-will.sangoma.local:80/SAFe/sng_rest/api/list/sip/profile
False
>>> s.last_error
{'status': 403}
```

2. Does safepy store object data ?

No, safepy is a warpper for REST and is also stateless, the server is always the
reference. So any object returned by a `list()` command are not stored. Any call
to `list()` will issue a new REST API request to the server.

### Requirements

**Python 2.7**
To install on regular appliance ISO (ie. CentOS 5) please install Python 2.7 as altinstall
There's various recipe on the web, here the one I've used:

```
$  wget http://www.python.org/ftp/python/2.7.5/Python-2.7.5.tar.bz2
$  tar xf Python-2.7.5.tar.bz2
$  cd Python-2.7.5
$  ./configure --prefix=/usr/local
$  make
$  make altinstall
```

