<?php
/**
 *  FS SIP Limit Configuration Class
 *  @author: Shaunt Libarian
 */

require_once('application/helpers/safe_helper.php');
safe_require_class('object');
safe_require_class('hardware');

class Fs_sip_request_limit_config_class extends safe_configurable_object_class {

	
	public function __construct($node, $parent_name, $name) {
		// Parent constructor to invoke unserialize if needed
		parent::__construct($parent_name, $name, $node);
	}
	
	public function configure() {
		
		$method_array = array(
				'ANY'=>'ANY',
				'INVITE' => 'INVITE',
				 'REGISTER' => 'REGISTER',
				'ACK'=>'ACK',
				'BYE'=>'BYE',
				'CANCEL'=>'CANCEL',
				'OPTIONS'=>'OPTIONS',
				'PRACK'=>'PRACK',
				'SUBSCRIBE'=>'SUBSCRIBE',
				'NOTIFY' => 'NOTIFY',
				'PUBLISH' => 'PUBLISH',
				'INFO' => 'INFO',
				'REFER' => 'REFER',
				'MESSAGE' => 'MESSAGE',
				'UPDATE' => 'UPDATE',
				'MALFORMED' => 'MALFORMED'
				);
		
		$this->add_enum_field('method','SIP Method','dropdown','ANY',$method_array);
		$this->set_field_rules ('method','required');
		$this->set_field_help('method','SIP messages which will be used in the limitation rule.');
		
		$this->add_field('host','Host','string','ANY',60);
		$this->set_field_rules('host','valid_ip_or_blank_or_any');
		$this->set_field_help('host','Host which will be used in the limitation rule. If this field is left blank, the rule will use any host. The field accepts any IPv4 IP address.');
		
		$this->add_field('limit','Rate Limit','string','',20);
		$this->set_field_rules('limit','required|is_numeric|greater_than[0]');
		$this->set_field_help('limit','Number of SIP messages to limit');
		
		$this->add_field('period','Rate Period','string','',20);
		$this->set_field_rules('period','required|is_numeric|greater_than[0]');
		$this->set_field_help('period','Time period in seconds to limit incoming requests.');
		
		return parent::configure();
	}
	public function description()
	{
	    $cfg = $this->get_data_values(false);
	    return 'Method=' . $cfg['method'] . ' 	Host=' . $cfg['host'] . ' 	Rate Limit=' . $cfg['limit'] . ' 	Period=' . $cfg['period'];
	}
	public function summary($type = 'horizontal' , $long = false){
	    $table_line = parent::summary($type , true);
	    array_shift($table_line['data']);
	    return $table_line;
	}
}

?>
