<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
 */
/*
 * FS CAC module class
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_service_class');
safe_module_require_class('fs', 'application');
safe_module_require_class('fs', 'cac_rule');

class Fs_cac_module_class extends Fs_module_class
{
    protected $_obj_base_path = '';
    /**
     * @brief
     *           
     * @param[in out] $fs_app
     *           
     * @return
     */
    public function __construct($fs_app)
    {
        parent::__construct($fs_app, "cac");
        $this->_obj_base_path = $this->path().'/cac';
    }
    /**
     * @brief
     *         
     * @return
     */
    public function configure()
    {
        // Set the module description
        $this->set_description("Call Admission Control");
        // Expose aggregate obj
        $this->register_aggregate_object('rule', 
            array(
                'name' => 'Rule',
                'dynamic' => true,
                'base_path' => $this->_obj_base_path.'/rule',
                'has_child' => true,
                'methods' => array(
                    'create' => array(
                        'name' => 'Create',
                        'description' => 'Create a CAC Rule',
                        'request' => 'POST',
                        ),
                    'retrieve' => array(
                        'name' => 'Retrieve',
                        'description' => 'Retrieve a CAC Rule',
                        'request' => 'GET',
                        ),
                    'update' => array(
                        'name' => 'Update',
                        'description' => 'Update a CAC Rule',
                        'request' => 'POST',
                        ),
                    'delete' => array(
                        'name' => 'Delete',
                        'description' => 'Delete a CAC Rule',
                        'request' => 'POST',
                        ),
                    ),
            )
        );

        return parent::configure();
    }
    /**
     * Returns Media profiles in an array
     */
    public function rules()
    {
        $this->_rules = $this->get_aggregate_objects('rule');
        return $this->_rules;
    }
    /**
     * @brief Create a media profile
     * Can be overloaded by specialized class to create different type of media 
     * object
     *
     * @param[in out] $name
     *
     * @return 
     */
    public function create_rule($name){
        return new Fs_cac_rule_class($this->node(), $this->_obj_base_path .'/rule', $name);
    }

    /**
     * @brief Create config jobs for dialplan module
     *           
     * @param[in out] $config_manager
     *           
     * @return
     */
    public function reload_generate_config(&$config_manager, $obj_type=null)
    {
        if(!$this->_generate_config($config_manager)) return false;
        return parent::reload_generate_config($config_manager, $obj_type);
    }

    /**
     * @brief 
     *
     * @param[in out] $obj_type
     *
     * @return 
     */
    public function reload_clear_modified($obj_type=null)
    {
        return $this->clear_configuration_modified();
    }

    /**
     * @brief 
     *
     * @param[in out] $config_manager
     *
     * @return 
     */
    public function generate_config(&$config_manager)
    {
        if(!$this->_generate_config($config_manager)) return false;
        return parent::generate_config($config_manager);
    }
    /**
     * @brief 
     *
     * @param[in out] $config_manager
     *
     * @return 
     */
    private function _generate_config(&$config_manager)
    {
        // Cleanup
        $directory = "dialplan/cac-rules/";
        $config_manager->add_config(
            new Safe_configuration_class(
                $directory, '', 
                Safe_configuration_class::CFG_DELETE, 
                Safe_configuration_class::CFG_DIR)
            );
        // Write rules (and build binding array)
        $bindings = array();
        foreach($this->rules() as $rule) {
            // Write the rule with conditions
            if(!$this->_write_rule($config_manager, $rule)){
                return false;
            }
            // Loop around profiles binding
            foreach($rule->profile_binding() as $binding){
                $bindings[$binding][] = $rule->name();
            }
        }
        // Write profile bindings
        foreach($bindings as $profile => $rules) {
            $xml_writer = new XMLWriter();
            $xml_writer->openMemory();
            $xml_writer->startDocument('1.0', 'UTF8');
            $xml_writer->startElement("include");
            foreach($rules as $rule) {
                $xml_writer->startElement('X-PRE-PROCESS');
                $xml_writer->writeAttribute('cmd', 'include');
                $xml_writer->writeAttribute('data', $rule . '.xml');
                $xml_writer->endElement();
            }

            $xml_writer->fullendElement();
            $xml_writer->endDocument();
            $xmlstr = Safe_format_xml($xml_writer->outputMemory(true));
            $file = "dialplan/cac-rules/rules-" . $profile . ".xml";
            $config_manager->add_config(new Safe_configuration_class($file, $xmlstr));
        }

        return true;
    }
    /**
     * Write XML file for CAC Rules
     * @param $config_manager
     * @param object          $cac_rule
     *                                  Contains the CAC Rule object
     */
    private function _write_rule(&$config_manager, $cac_rule)
    {
        $rate = "";
        $cac_rule_cfg = $cac_rule->get_data_values(false);
        $profile_name = $cac_rule->name();
        $xml_writer = new XMLWriter();
        $xml_writer->openMemory();
        $xml_writer->startDocument('1.0', 'UTF8');
        $xml_writer->startElement("include");
        $xml_writer->startElement('extension');
        $xml_writer->writeAttribute('name', $profile_name);
        $xml_writer->writeAttribute('continue', 'true');
        $conditions_def = $cac_rule->get_aggregate_object_definition();
        foreach($conditions_def as $condition_type => $condition_def) {
            $conditions = $cac_rule->get_aggregate_objects($condition_type);
            foreach ($conditions as $condition) {
                $cond = $condition->get_data_values(false);
                if ($cond['rate1'] != "" && $cond['rate2'] != ""){
                    $rate = $cond['rate1'] . '/' . $cond['rate2'];
                }
                if ($cond['condition_type'] == 'ipaddr') {
                    $xml_writer->startElement('condition');
                    $xml_writer->writeAttribute('field', '${sip_received_ip}');
                    $xml_writer->writeAttribute('expression', $cond['sip_received_ip']);
                    $xml_writer->writeAttribute('break', 'on-true');
                } elseif ($cond['condition_type'] == 'user') {
                    $xml_writer->startElement('condition');
                    $xml_writer->writeAttribute('field', '${sip_auth_username}@${sip_auth_realm}');
                    $xml_writer->writeAttribute('expression', $cond['sip_auth_username']);
                    $xml_writer->writeAttribute('break', 'on-true');
                }else{
                    continue;
                }
                $xml_writer->startElement('action');
                $xml_writer->writeAttribute('application', 'set');
                $xml_writer->writeAttribute('data', 'limit_ignore_transfer=true');
                $xml_writer->endElement();
                if ($cond['max'] != "") {
                    $xml_writer->startElement('action');
                    $xml_writer->writeAttribute('application', 'limit');
                    if ($cond['condition_type'] == 'ipaddr') $xml_writer->writeAttribute('data', 'hash ${sip_received_ip} max ' . $cond['max']);
                    elseif ($cond['condition_type'] == 'user') $xml_writer->writeAttribute('data', 'hash ${sip_auth_username}@${sip_auth_realm} max ' . $cond['max']);
                    $xml_writer->endElement();
                }
                if ($rate != "") {
                    $xml_writer->startElement('action');
                    $xml_writer->writeAttribute('application', 'limit');
                    if ($cond['condition_type'] == 'ipaddr') $xml_writer->writeAttribute('data', 'hash ${sip_received_ip} rate ' . $rate);
                    elseif ($cond['condition_type'] == 'user') $xml_writer->writeAttribute('data', 'hash ${sip_auth_username}@${sip_auth_realm} rate ' . $rate);
                    $xml_writer->endElement();
                }
                $xml_writer->fullEndElement();
            }
        }
        $xml_writer->fullendElement();
        $xml_writer->fullendElement();
        $xml_writer->endDocument();
        // Create directory
        $directory = "dialplan/cac-rules/";
        $config_manager->add_config(new Safe_configuration_class($directory, '', Safe_configuration_class::CFG_CREATE, Safe_configuration_class::CFG_DIR));
        $xmlstr = Safe_format_xml($xml_writer->outputMemory(true));
        $file = "dialplan/cac-rules/" . $profile_name . ".xml";
        $config_manager->add_config(new Safe_configuration_class($file, $xmlstr));
        return true;
    }
    /**
     * @brief Invoked after a successfull write_config
     *         
     * @return
     */
    public function post_write_config()
    {
        // Check if FS is running
        if (Safe_service_class::STATUS_RUNNING == $this->fs_app()->status()) {
            $output = array();
            $rc = $this->eslapi_execute("reloadxml", '', $output);
            return $rc;
        }
        return parent::post_write_config();
    }

    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_create_rule($name, $data=null, &$output = null) {
        $rule = new Fs_cac_rule_class($this->node(), $this->_obj_base_path .'/rule', $name);
        $rule->configure();
        if($data) {
            $rule->set_data_values($data);
        }
        return $rule;
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_retrieve_rule($name, $data=null, &$output = null) {
        $rules = $this->rules();
        return $rules[$name];
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_update_rule($name, $data=null, &$output = null) {
        $rule = $this->api_retrieve_rule($name);
        if($rule) {
            if ($rule->validate($data,$output)) {
                if (true == $rule->save()) {
                    return true;
                }
            }
        }
        return false;
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_delete_rule($name, $data=null, &$output = null) {
        $rule = $this->api_retrieve_rule($name);
        if($rule) {
            if($rule->can_dispose($output)) {
                $conditions = $rule->conditions('user');
                if (isset($conditions)) {
                    foreach ($conditions as $condition) $condition->dispose();
                }
                $conditions = $rule->conditions('ipaddr');
                if (isset($conditions)) {
                    foreach ($conditions as $condition) $condition->dispose();
                }
                return $rule->dispose();
            }
        }
        return false;
    }
    
    /*
    public function new_fields(&$config_manager, $type)
    {
        if($type == 'rule'){
            parent::new_fields($config_manager, $type);
            $config_manager->add_field('save', 'Save', 'hidden', 'save', 10);
            $config_manager->add_field('redirect', 'Redirect', 'hidden', 'save', 10);
        }
    }*/
}
/* End of file fs_sip_profile_module_class.php */

