<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * William Adam <wadam@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * RAID Config wrapper page
 *         
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
safe_require_controller('sng','config_manager');

class Sng_raid_status extends Sng_config_manager
{
    public function __construct()
    {
        parent::__construct();
        // Overide some views
        $this->aggregate_object_view['change']['modify'] = 'sng_raid_change';
        //$this->aggregate_object_view['array']['modify'] = 'sng_raid_array';
    }
    public function index()
    {
        return $this->modify('raid');
    }
    // Recover function
    public function recover_change($module_name, $obj_type = null, $obj_name = null, $sub_type = null, $sub_name = null)
    { 
        // Get RAID module
        $module = $this->_the_app->find_module_by_name($module_name);
        $data['page_title'] = 'Configuration Manager';
        $data['page_summary'] = 'This page allows managing System configuration.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        // From this point we will display something for sure, so display header
        $this->load->view("safe_header", $data);
        // Process to adapter detection
        $data['wait_message'] = '<b>Starting Recovery with Device '.$obj_name.'...</b>';
        $this->load->view("safe_confirm_dialog", $data);
        $this->load->view("safe_wait", $data);
        safe_flush_ouput();
        sleep(.1);
        // URL redirect
        $_url = '/SAFe/' . $this->router->fetch_class() . '/modify/'.$module_name;
        // Start recover
        $output = array();
        $rc = $module->api_recover_change($obj_name, null, $output);

        if($rc){
            // All good, redirect to control panel
            Safe_redirect($_url);
        }else{
            // Populate generation result table
            $data['table_title'] = 'Recovery Process Failed to start';
            $table = new Safe_table_class();
            $table->data = $output;
            $table->footer_button = array(
                    array(
                            'url' => $_url,
                            'name' => 'Back'
                    )
            );
            $data['table'] = $table->generate();
        }

        $this->load->view("safe_notifications", $data);
        if (isset($data['table'])) $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    public function details()
    {
        // Get RAID module
        $module = $this->_the_app->find_module_by_name('raid');
        $status = $module->api_retrieve_status();
        $data['page_title'] = 'Configuration Manager';
        $data['page_summary'] = 'This page allows managing System configuration.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $this->load->view("safe_header", $data);

        // Populate generation result table
        $data['table_title'] = 'RAID Details';
        $table = new Safe_table_class();
        $table->apply_data_formatter = false;
        $table->data[] = '<pre>'.$status.'</pre>';
        $_url = '/SAFe/' . $this->router->fetch_class();
        $table->footer_button = array(
                array(
                        'url' => $_url,
                        'name' => 'Back'
                )
        );
        $data['table'] = $table->generate();
        $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
}
