<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * Network Config wrapper page
 * @author William Adam <william.adam@sangoma.com>
 *         
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
safe_require_controller('sng','data_manager');
class Sng_archive_manager extends Sng_data_manager
{
    public function __construct()
    {
        parent::__construct();
    }
    public function index($module_name, $data_name, $offset = NULL)
    {
        return $this->manage('application','archive', $offset);
    }
    public function restore($module_name, $data_name, $data_key)
    {
        // Set the basic data
        $data['page_title'] = 'Application Data Manager';
        $data['page_summary'] = 'This page allows managing application data.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-backup-settings.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-backup-settings.png';
        // From this point we will display something for sure, so display header
        $this->load->view("safe_header", $data);
        // Process to adapter detection
        $data['wait_message'] = '</br><b>Restoring configuration...</b></br>&nbsp;';
        $this->load->view("safe_confirm_dialog", $data);
        $data['timeout_sec'] = 60;
        $this->load->view("safe_wait", $data);
        safe_flush_ouput();
        sleep(0.1);
        // Get archive manager
        $archive_mgr = $this->_cfg_mgr->archive_manager();
        // Prepare back url
        $post = $this->input->post();
        $back_url = $this->input->get_post('back_url');
        if (!$back_url) $back_url = '/SAFe/' . $this->router->fetch_class() . '/manage/' . $module_name . '/' . $data_name;
        
        // First ask application if we can restore archive ?
        $reason = array();
        if(!$this->_the_app->api_restore_archive($data_key, null, $reason)){
            $data['notif_error'][] = 'Fail to Restore Archive ' . $data_key . '.';
            // Populate generation result table
            $data['table_title'] = 'Archive - ' . $data_key;
            $table = new Safe_table_class();
            $table->data = $reason['notif_error'];
            $table->footer_button = array(
                array(
                    'url' => $back_url,
                    'name' => 'Back'
                )
            );
            $data['table'] = $table->generate();
        }else{
            $info = $archive_mgr->info($data_key);
            if('system' == $info['type']){
                $data['notif_warn'][] = ucfirst($info['type']).' archive ' .  $data_key . ' restored successfully.<br/><br/>Please restart the system.' . safe_form_with_submit_button('', '/admin/shutdown.php', 'Restart');
            }else{
                $data['notif_warn'][] = ucfirst($info['type']).' archive ' .  $data_key . ' restored successfully.'. safe_form_with_submit_button('', $back_url, 'Back', 'back', 'get', 'float:left;');;
            }
        }

        // Already done - $this->load->view ( "safe_header", $data );
        $this->load->view("safe_notifications", $data);
        if ($data['table']) $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    /*
     * confirm to restore to one of the backuped settings
    *
    * @param string $module_name being restored
    * @param string $data_name being restored
    * @param string $data_key being restored
    */
    public function restore_confirm($module_name, $data_name, $data_key)
    {
        // Set the basic data
        $data['page_title'] = 'Restore Archive';
        // Get archive manager
        $archive_mgr = $this->_cfg_mgr->archive_manager();
        // Prepare back url
        $post = $this->input->post();
        $back_url = $this->input->get_post('back_url');
        if (!$back_url) $back_url = '/SAFe/' . $this->router->fetch_class() . '/manage/' . $module_name . '/' . $data_name;
        // First ask application if we can restore archive ?
        $reason = array();
        if ($this->_the_product->can_restore($data_key, $reason)) {
            $data['message'] = 'Are you sure you want to restore archive <b>' . $data_key . '</b>?';
            $data['message_type'] = 'notice';
            $data['result'] = true;
            $data['action_url'] = base_url($this->router->fetch_class()). '/restore_action/'.$module_name. '/' . $data_name. '/' . $data_key;
            echo json_encode($data);
        }else {
            $reason_msg='';
              if($reason){
                  $reason_msg =(is_array($reason)) ? implode('<br>',$reason) : $reason;
              }
              $reason_msg = ($reason_msg=='')?'':'<br>'.$reason_msg;
            $data['message'] = 'Restoring archive '.$data_key.' failed'.$reason_msg;
            $data['message_type'] = 'notice';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /*
     * restore to one of the backuped settings
     * 
     * @param string $module_name being restored
     * @param string $data_name being restored
     * @param string $data_key being restored
     */
    public function restore_action($module_name, $data_name, $data_key)
    {
        // Set the basic data
        $data['page_title'] = 'Restore Archive';
        // Get archive manager
        $archive_mgr = $this->_cfg_mgr->archive_manager();
        // Prepare back url
        $post = $this->input->post();
        $back_url = $this->input->get_post('back_url');
        if (!$back_url) $back_url = '/SAFe/' . $this->router->fetch_class() . '/manage/' . $module_name . '/' . $data_name;
        // First ask application if we can restore archive ?
        $data['result'] = true;
        $data['redirect_url'] = base_url($this->router->fetch_class()). '/restore/'.$module_name. '/' . $data_name. '/' . $data_key;
        echo json_encode($data);
    }
    public function backup($module_name, $data_name, $data_type = 'system')
    {
        // Set the basic data
        $data['page_title'] = 'Application Data Manager';
        $data['page_summary'] = 'This page allows managing application data.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-backup-settings.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-backup-settings.png';
        // Prepare back url
        $post = $this->input->post();
        $back_url = $this->input->get_post('back_url');
        if (!$back_url) $back_url = '/SAFe/' . $this->router->fetch_class() . '/manage/' . $module_name . '/' . $data_name;
        
        // Get back the module
        $module = $this->_get_module($module_name);
        // Retrieve file and directories to backup
        $archive_mgr = $this->_cfg_mgr->archive_manager();
        $this->load->view("safe_header", $data);
        // First check if we can backup
        if ($this->_the_product->can_backup($reason = "")) {
            $data['wait_message'] = '</br><b> Creating '.ucfirst($data_type).' Backup ...</b></br>&nbsp;';
            $this->load->view("safe_confirm_dialog", $data);
            $this->load->view("safe_wait", $data);
            safe_flush_ouput();
            sleep(0.2);
            $output = array();
            $archive = $module->api_backup_archive($data_type, null , $output);
            if (FALSE !== $archive) {
                $download_url = '/SAFe/' . $this->router->fetch_class() . '/download/' . $this->_the_app->name() . '/archive/' . $archive['name'];
                $data['notif_warn'][] = 'Archive ' . $archive['name'] . ' successfuly created.' . safe_form_with_submit_button('', $download_url, 'Download', 'download', 'get', 'float:left;') . safe_form_with_submit_button('', $back_url, 'Back', 'back', 'get', 'float:left;');
            } else {
                // Display error
                $data['notif_error'][] = 'Failed to create archive.' . safe_form_with_submit_button('', $back_url, 'Back', 'back', 'get', 'float:left;');
            }
        } else {
            // Display error
            $data['notif_error'][] = 'Failed to create archive. ' . $reason . '.' . safe_form_with_submit_button('', $back_url, 'Back', 'back', 'get', 'float:left;');
        }
        // Display views
        $this->load->view("safe_notifications", $data);
        $this->load->view("safe_footer", $data);
    }
    
    public function backup_form($module_name, $data_name, $reload=false)
    {
        $action_name = 'backup';
        // Check post request
        $post = $this->input->post();
        // Retrieve module to work on
        $module = $this->_get_module($module_name);
        $param = $module->api_backup_archive_parameters();
        $param->configure();
        $config = $param->get_data();
        $this->load->library("safe_form_class", $config);
        
        // Set the basic data
        $data['page_title'] = $module->description() ;
        //Display form with checkboxes
        $data['form_title'] = $module->description() .' : ' . ucfirst($action_name) ;
        $data['form'] = $this->safe_form_class->form_input_array();
        
        $data['form_cfg'] = $this->safe_form_class->config;
        $data['label'] = $this->safe_form_class->form_label_array();
        $data['form_open'] = $this->safe_form_class->form_open();
        $data['buttons'] = array(
                array(
                        'name' => 'backup',
                        'value' => ucfirst($action_name),
                        'type' => 'submit'
                ) ,
                array(
                        'name' => 'cancel',
                        'value' => 'Cancel',
                        'type' => 'submit'
                ) ,
        );
        //******
        //clear the content in page cache and get the view content
        ob_start();
        ob_clean();
        $this->load->view("safe_form_json", $data);
        $data['content'] = ob_get_contents();
        ob_clean();
        //******
        
        $data['page_title'] = $data['form_title'];
        
        $data['result'] = true;
        if($reload === true){
            $data['result'] = false; //user sumbit data did not pass the validation, return false and reload the form with error message
        }
        $data['reload'] = $reload;
        
        $data['action_url'] = base_url($this->router->fetch_class().'/backup_action/'. $module_name. '/' . $data_name);
        $data['action_method'] = 'POST';
        echo json_encode($data);
    }
    public function backup_action($module_name, $data_name)
    {
        $post = $this->input->post();
        // First ask application if we can restore archive ?
        $data['result'] = true;
        $data['redirect_url'] = base_url($this->router->fetch_class()). '/backup/'.$module_name. '/' . $data_name. '/' .$post['backup_type'];
        echo json_encode($data);
    }
}
