<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * NSC Media Profile Class
 * @author Shaunt Libarian
 *         
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('object');
safe_require_class('hardware');
safe_module_require_class('nsc', 'application');
safe_module_require_class('fs', 'media_profile');
safe_module_require_class('sng', 'transcoding_config');
class Nsc_media_profile_class extends Fs_media_profile_class
{
    private $_the_app = "";
    private $_sip_profiles = "";
    /**
     * @brief
     *           
     * @param[in out] $node
     * @param[in out] $parent_name
     * @param[in out] $name
     *           
     * @return
     */
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($node, $parent_name, $name);
    }
    /**
     * @brief
     *         
     * @return
     */
    public function configure()
    {
        if (!parent::configure()) return false;
        if ($this->get_transcoder_status()) {
            // Change codec default values
            $this->set_field_default('codec-1', 'PCMU@20i');
            $this->set_field_default('codec-2', 'PCMA@20i');
            $this->set_field_default('codec-3', 'G729@20i');
            $this->set_field_default('codec-4', 'iLBC@15200b@20i');
            $this->set_field_default('codec-5', 'G722@20i');
        } else {
            $this->set_field_default('codec-1', 'PCMU@20i');
            $this->set_field_default('codec-2', 'PCMA@20i');
            $this->set_field_default('codec-3', 'PCMU@30i');
            $this->set_field_default('codec-4', 'PCMA@30i');
            $this->set_field_default('codec-5', 'none');
        }
        return true;
    }

    /**
        * @brief Override SW codec enum list
        *
        * @return 
     */
    public function sw_codec_enum() 
    {
        return array(
            'none' => '',
            'PCMU@20i' => 'PCMU 20ms, PT=0',
            'PCMU@30i' => 'PCMU 30ms, PT=0',
            'PCMA@20i' => 'PCMA 20ms, PT=8',
            'PCMA@30i' => 'PCMA 30ms, PT=8',
            'G729@20i' => 'G.729 20ms, PT=18',
            'G729@30i' => 'G.729 30ms, PT=18',
            'iLBC@15200b@20i' => 'iLBC 15.20Kbps 20ms, PT=98',
            'iLBC@13330b@30i' => 'iLBC 13.33Kbps 30ms, PT=97',
            'GSM@20i' => 'GSM, PT=3',
            'G722@20i' => 'G.722 20ms, PT=9',
            'G722@30i' => 'G.722 30ms, PT=9',
            'G7221@16000h@32000b@20i' => 'G.722.1 32Kbps 20ms, PT=107',
            'G7221@16000h@24000b@20i' => 'G.722.1 24Kbps 20ms, PT=107',
            'G723@30i' => 'G.723.1 30ms, PT=4',
            'G726-16@20i' => 'G.726 16Kbps 20ms, PT=124',
            'G726-24@20i' => 'G.726 24Kbps 20ms, PT=123',
            'G726-32@20i' => 'G.726 32Kbps 20ms, PT=122',
            'G726-40@20i' => 'G.726 40Kbps 20ms, PT=121',
            'G726-16@30i' => 'G.726 16Kbps 30ms, PT=124',
            'G726-24@30i' => 'G.726 24Kbps 30ms, PT=123',
            'G726-32@30i' => 'G.726 32Kbps 30ms, PT=122',
            'G726-40@30i' => 'G.726 40Kbps 30ms, PT=121',
            // Add Video SW codecs
            'H263' => 'H263, PT=34',
            'H263-1998' => 'H263-1998, PT=115',
            'H263-2000' => 'H263-2000, PT=121',
            'H264' => 'H264, PT=99',
        );

    }
}
?>
