#!/usr/bin/env python2.7
# vim: tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab
"""
* Copyright (C) 2011   Sangoma Technologies Corp.
* All Rights Reserved.
*
* Author(s)
* William Adam <william.adam@sangoma.com>
*
* This code is Sangoma Technologies Confidential Property.
* Use of and access to this code is covered by a previously executed
* non-disclosure agreement between Sangoma Technologies and the Recipient.
* This code is being supplied for evaluation purposes only and is not to be
* used for any other purpose.
"""


def py_header():
    return \
"""#!/usr/bin/env python2.7
# vim: tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab
\"\"\"
* Copyright (C) 2011   Sangoma Technologies Corp.
* All Rights Reserved.
*
* Author(s)
* William Adam <william.adam@sangoma.com>
*
* This code is Sangoma Technologies Confidential Property.
* Use of and access to this code is covered by a previously executed
* non-disclosure agreement between Sangoma Technologies and the Recipient.
* This code is being supplied for evaluation purposes only and is not to be
* used for any other purpose.
\"\"\"
"""

def py_init():
    return \
"""
import safepy
from .product import Product
"""

def py_module_import():
    return \
"""
import sys
from safepy import Module
from safepy import Object
from safepy import Collection
from safepy import Method
"""

def py_module_class(name):
    _py= \
"""
class {Name}(Module):

    def __init__(self, parent):
        super(Module, self).__init__(parent, '{name}', '{Name} Module')
"""
    return _py.format(Name=name.capitalize(), name=name)


def py_module_object_class(name, parent=''):
    _py= \
"""
class {Parent}{Name}(Object):
    def __init__(self, parent, name):
        super({Parent}{Name}, self).__init__(parent, name)
"""
    return _py.format(Name=name.capitalize(), name=name,
            Parent=parent.capitalize(), parent=parent)

def py_module_method_register(name, request):
    _py= \
"""
        self._add_child(Method(self, '{name}', '{request}'))
"""
    return _py.format(Name=name.capitalize(), name=name, request=request)

def py_module_method(name):
    _py= \
"""
    def {name}(self, params=None):
        return self._get_child('{name}').run(params)
"""
    return _py.format(Name=name.capitalize(), name=name)

def py_module_method_create(name):
    _py= \
"""
    def {name}(self, name, params=None):
        return self._get_child('{name}').run(params, name)
"""
    return _py.format(Name=name.capitalize(), name=name)

def py_module_object_register(name, parent=''):
    _py = \
"""
        self._{name} = {Parent}{Name}Collection(self, '{name}', getattr(sys.modules[__name__], '{Parent}{Name}'))
        self._add_child(self._{name})
"""
    return _py.format(Name=name.capitalize(), name=name,
            Parent=parent.capitalize(), parent=parent)

def py_module_object_collection(name, parent=''):
    _py = \
"""
class {Parent}{Name}Collection(Collection):
    def __init__(self, parent, name, object_class):
        super({Parent}{Name}Collection, self).__init__(parent, name, object_class)
"""
    return _py.format(Name=name.capitalize(), name=name,
            Parent=parent.capitalize(), parent=parent)

def py_module_singleton_object_register(name):
    _py = \
"""
        self._add_child({Name}(self, '{name}'))
"""
    return _py.format(Name=name.capitalize(), name=name)


def py_module_object_property(name):
    _py = \
"""
    @property
    def {name}(self):
        return self._{name}
"""
    return _py.format(Name=name.capitalize(), name=name)

def py_module_singleton_object_property(name):
    _py = \
"""
    @property
    def {name}(self):
        return self._get_child('{name}')
"""
    return _py.format(Name=name.capitalize(), name=name)

def py_product_import():
    return \
"""
from safepy import Application
from safepy import Module
"""

def py_product_module_import(name):
    _py = \
"""
from .{name} import {Name}
"""
    return _py.format(Name=name.capitalize(), name=name)


def py_product_class(name, version, full_name):
    _py = \
"""
class Product(Application):
    def __init__(self):
        super(Product, self).__init__('{name}', '{version}', '{full_name}')
"""
    return _py.format(Name=name.capitalize(), name=name, version=version,
            full_name=full_name)
    
def py_product_module_register(name):
    _py = \
"""
        self._add_module({Name}(self))
"""
    return _py.format(Name=name.capitalize(), name=name)

def py_product_module_property(name):
    _py = \
"""
    @property
    def {name}(self):
        return self['{name}']
"""
    return _py.format(Name=name.capitalize(), name=name)



