<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * Network Config wrapper page
 * @author William Adam <william.adam@sangoma.com>
 *         
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
safe_require_controller('sng','data_manager');
class Sng_update_manager extends Sng_data_manager
{
    public function __construct()
    {
        parent::__construct();
    }
    public function index()
    {
        return $this->manage('update','package');
    }
    /*
     * confirm to install update package
    *
    * @param string $module_name being install
    * @param string $data_name being install
    * @param string $data_key being install
    */
    public function install_confirm($module_name, $data_name, $data_key)
    {
        $module = NULL;
        // Get back the module
        $module = $this->_the_app->find_module_by_name($module_name);
        $data_cfg = $module->get_data_settings();
        $data_cfg = $data_cfg[$data_name];
        //check if can install
        $output = array();
        $info = $module->info($data_name, $data_key, $output);
        $the_product = Safe_get_product();
        if($info && $the_product->can_install_data($info, $output)){
            $data['message'] = 'Are you sure you would like to install <b>' . $data_cfg['description'] .' '.$data_key . '</b>?';
            $data['result'] = true;
        }else{
            $data['message'] = "Fail to install ". $data_cfg['description'] .' '.$data_key;
            if($output){
                $data['reason'] = $output;
            }
            $data['result'] = false;
        }
        $data['page_title'] = 'Install ' .$data_cfg['description'];
        $data['message_type'] = 'notice';
        $data['action_url'] = base_url($this->router->fetch_class().'/install_action/'.$module_name.'/'.$data_name.'/'.$data_key);
        $data['action_method'] = 'POST';
        echo json_encode($data);
    }
    /*
     * redirect to install update package
    *
    * @param string $module_name being install
    * @param string $data_name being install
    * @param string $data_key being install
    */
    public function install_action($module_name, $data_name, $data_key)
    {
        // Set the basic data
        $module = NULL;
        // Get back the module
        $module = $this->_the_app->find_module_by_name($module_name);
        $data_cfg = $module->get_data_settings();
        $data_cfg = $data_cfg[$data_name];
        
        $data['page_title'] = 'Install ' .$data_cfg['description'].' '.$data_key;
        $data['result'] = true;
        $data['redirect_url'] = base_url($this->router->fetch_class()). '/install/'.$module_name. '/' . $data_name. '/' . $data_key;
        echo json_encode($data);
    }
    public function install($module_name, $data_name, $data_key = NULL)
    {
        // Set the basic data
        $data['page_title'] = 'Configuration Manager';
        $data['page_summary'] = 'This page allows managing System configuration.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        // Get back the module
        $module = $this->_the_app->find_module_by_name($module_name);
        $data_cfg = $module->get_data_settings();
        // Grab only the data we're interested in
        if (isset($data_cfg[$data_name])) $data_cfg = $data_cfg[$data_name];
        // From this point we will display something for sure, so display header
        $this->load->view("safe_header", $data);
        $data['wait_message'] = '<b>Installing ' .$data_cfg['description'].' '.$data_key.' ...</b>';
        $this->load->view("safe_confirm_dialog", $data);
        $data['timeout_sec'] = 300;
        $this->load->view("safe_wait", $data);
        safe_flush_ouput();
        
        $param = null;
        $output = array();
        if($module->api_install_package($data_name, $param, $output)){
            $data['notif_warn'][] = $data_cfg['description'].' - '.$data_key.' installed successfully. Please Restart System.' . safe_form_with_submit_button('', '/admin/shutdown.php', 'Restart', '', 'get', 'float:left;' ).' '.safe_form_with_submit_button('', '/SAFe/'.$this->router->fetch_class().'/manage/'.$module_name.'/'.$data_name, 'Back');
        }else{
            $data['notif_error'][] =$data_cfg['description'].' - '.$data_key.' install failed.'. safe_form_with_submit_button('', '/SAFe/'.$this->router->fetch_class().'/manage/'.$module_name.'/'.$data_name, 'Back', '', 'get', 'float:left;');
        }
        $data_log['table_size'] = '100%';
        $data_log['table_title'] = $data_cfg['description'] . ' : ' . $data_key .' - Install Log';
        // TODO(wadam) - get those values from somewhere (not hard coded)
        $data_log['width'] = "715px";
        $data_log['height'] = "550px";
        $data_log['min_height'] = "0px";
        $data_log['url_back'] = $_SERVER['HTTP_REFERER'];
        $data_log['editor_data'] = $module->get_data_file_content_by_key($data_name, $data_key, NULL, 4096);
        
        $this->load->view("safe_notifications", $data);
        if (!empty($data_log['editor_data'])) $this->load->view("safe_texteditor", $data_log);
        $this->load->view("safe_footer", $data);
    }
}
