<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * FS module class
*/
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_module_class');
class Fs_module_class extends Safe_module_class
{
    private $_fs_app = null;
    public function __construct($fs_app, $name)
    {
        parent::__construct($fs_app->node()->software() , $name);
        $this->_fs_app = $fs_app;
    }
    public function eslapi_execute($command, $arguments, &$output)
    {
        return $this->_fs_app->eslapi_execute($command, $arguments, $output);
    }
    public function &fs_app()
    {
        return $this->_fs_app;
    }
    /**
     * Returns whether the module is a critical module
     * @return boolean
     */
    public function is_critical($mod_name = "")
    {
        return false;
    }
    /**
     * Returns the fs module name to place in modules_additional.xml
     * @return boolean
     */
    public function get_fs_module_name()
    {
        return 'mod_' . $this->name() . '.so';
    }
    /**
     * Function which returns whether the function is enabled or not
     *  - true or 'load' = Load the module
     *  - false or 'skip' = Do not include module in list
     *  - 'noload' = Explicitely force noload for module
     * @return boolean/string see above
     */
    public function is_enabled($mod_name = "")
    {
        return false;
    }
    /**
     * @brief Freeswitch db
     *
     * @return
     */
    public function db()
    {
        return $this->_fs_app->db();
    }
}
/* End of file fs_module_class.php */
